<?php
require_once 'config/database.php';

$email = 'admin@flashcore.com';
$password = 'password123';

try {
    // 1. Get user ID
    $stmt = $pdo->prepare("SELECT id FROM users WHERE email = ?");
    $stmt->execute([$email]);
    $user = $stmt->fetch();

    if (!$user) {
        die("User not found: $email\n");
    }

    $userId = $user['id'];
    echo "Found user ID: $userId\n";

    // 2. Hash password
    $hash = password_hash($password, PASSWORD_DEFAULT);

    // 3. Update password
    $stmt = $pdo->prepare("UPDATE users SET password_hash = ? WHERE id = ?");
    $stmt->execute([$hash, $userId]);

    echo "Password updated successfully for $email\n";
    echo "New hash: $hash\n";

} catch (PDOException $e) {
    die("Error: " . $e->getMessage() . "\n");
}
?>
