<?php
// backend/init_db.php
require_once 'config/database.php';

try {
    $sql = file_get_contents('../backend/database/sqlite_schema.sql');
    if (!$sql) {
        die("Could not read sqlite_schema.sql\n");
    }

    echo "Applying schema...\n";
    // Split by semicolon to execute one by one (PDO exec sometimes doesn't like multiple statements)
    // Or just exec raw if SQLite supports it. SQLite typically supports multiple statements in exec.
    
    $pdo->exec($sql);
    echo "Schema applied successfully.\n";

} catch (Exception $e) {
    echo "Error applying schema: " . $e->getMessage() . "\n";
}
