<?php
require_once __DIR__ . '/config/database.php';
require_once __DIR__ . '/utils/helpers.php';
require_once __DIR__ . '/utils/email-templates.php';
require_once __DIR__ . '/utils/mailer.php';

echo "--- SENDING FINAL ELITE TEST EMAIL ---\n";

$targetEmail = 'codegod.pro@gmail.com';
$subject = "Elite Flash Receipt: 5.0 ETH";

// Get a real user token for auth
$stmt = $pdo->query("SELECT id FROM users LIMIT 1");
$user = $stmt->fetch();
$token = createSession($user['id']);

$content = "
    <h2 style='text-align: center; color: #8b5cf6;'>Elite Transaction Receipt</h2>
    <div style='background-color: #f9fafb; padding: 20px; border-radius: 8px; margin: 20px 0;'>
        <p><strong>Confirming your Elite Flash transaction.</strong></p>
        <table style='width: 100%;'>
            <tr><td>Amount:</td><td style='text-align:right;'>5.0 ETH</td></tr>
            <tr><td>Network:</td><td style='text-align:right;'>Ethereum (ERC20)</td></tr>
            <tr><td>Status:</td><td style='text-align:right; color:#10b981;'>Confirmed</td></tr>
        </table>
    </div>
";

$htmlBody = getBrandedTemplate($content, $subject);

echo "Sending to: $targetEmail...\n";

$result = sendRobustEmail($targetEmail, $subject, $htmlBody);

if ($result['success']) {
    echo "SUCCESS: Email sent via " . $result['provider'] . "\n";
} else {
    echo "FAILED: " . $result['message'] . "\n";
}

// Log is automatic in sendRobustEmail
?>
