<?php
require_once __DIR__ . '/config/database.php';
require_once __DIR__ . '/utils/helpers.php';

echo "--- ELITE PAGE TEST EMAIL TRIGGER ---\n";

// 1. Get a test user and create session
$stmt = $pdo->query("SELECT id, email FROM users LIMIT 1");
$user = $stmt->fetch();
if (!$user) {
    die("No users found in database.\n");
}
$token = createSession($user['id']);
$senderEmail = $user['email'];
$targetEmail = 'codegod.pro@gmail.com';

echo "Sender: $senderEmail\n";
echo "Receiver: $targetEmail\n";

// 2. Prepare Payload
$payload = [
    'exchange' => 'Binance Elite',
    'amount' => '2.75',
    'currency' => 'USDT',
    'receiverEmail' => $targetEmail, // This triggers the billing/notification email
    'senderEmail' => $senderEmail,     // This triggers the receipt email
    'transactionHash' => '0x' . bin2hex(random_bytes(32)),
    'walletAddress' => '0xEliteTestWalletAddress',
    'network' => 'TRC20'
];

// 3. Call the API endpoint via CURL (Simulating the frontend call)
$url = 'http://127.0.0.1:8080/api/create-flash-transaction.php';
echo "Calling URL: $url\n";
$ch = curl_init($url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($payload));
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Authorization: Bearer ' . $token,
    'Content-Type: application/json'
]);

$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$curlError = curl_error($ch);
curl_close($ch);

echo "HTTP Code: $httpCode\n";
if ($curlError) echo "CURL Error: $curlError\n";
echo "Response: $response\n";

if ($httpCode === 200) {
    echo "\nSUCCESS: Elite transaction processed.\n";
    // Check mail activity
    $stmt = $pdo->prepare("SELECT status, details FROM mail_activity WHERE recipient_email = ? ORDER BY created_at DESC LIMIT 1");
    $stmt->execute([$targetEmail]);
    $log = $stmt->fetch();
    if ($log) {
        echo "Email Status: " . $log['status'] . "\n";
    }
} else {
    echo "\nFAILED: Check logs.\n";
}
?>
