<?php
require_once 'config/database.php';
require_once 'utils/helpers.php';

function checkTable($pdo, $tableName) {
    try {
        $result = $pdo->query("SELECT name FROM sqlite_master WHERE type='table' AND name='$tableName'");
        if ($result->fetch()) {
            echo "Table '$tableName' exists.\n";
            $schema = $pdo->query("PRAGMA table_info($tableName)")->fetchAll();
            echo "Schema for '$tableName':\n";
            foreach ($schema as $col) {
                echo " - {$col['name']} ({$col['type']})\n";
            }
        } else {
            echo "Table '$tableName' DOES NOT exist.\n";
        }
    } catch (Exception $e) {
        echo "Error checking table '$tableName': " . $e->getMessage() . "\n";
    }
    echo "\n";
}

checkTable($pdo, 'mail_activity');
checkTable($pdo, 'user_progress');

// Check if any users exist in user_progress
try {
    $count = $pdo->query("SELECT COUNT(*) FROM user_progress")->fetchColumn();
    echo "Total records in user_progress: $count\n";
    
    $sample = $pdo->query("SELECT * FROM user_progress LIMIT 5")->fetchAll();
    if ($sample) {
        echo "Sample records from user_progress:\n";
        print_r($sample);
    }
} catch (Exception $e) {
    echo "Error querying user_progress: " . $e->getMessage() . "\n";
}
?>
