<?php
require_once 'config/database.php';

try {
    echo "Checking users...\n";
    $stmt = $pdo->query("SELECT id, email FROM users LIMIT 1");
    $user = $stmt->fetch();
    
    if ($user) {
        echo "User found: " . $user['email'] . " (ID: " . $user['id'] . ")\n";
        
        echo "Checking profile for user...\n";
        $sql = "SELECT r.name as role FROM profiles p JOIN user_roles r ON p.role_id = r.id WHERE p.user_id = ?";
        echo "Query: $sql\n";
        
        $stmt = $pdo->prepare($sql);
        $stmt->execute([$user['id']]);
        $profile = $stmt->fetch();
        
        if ($profile) {
            echo "Profile found. Role: " . $profile['role'] . "\n";
        } else {
            echo "Profile NOT found for user.\n";
            // Check if profile exists at all
            $stmt = $pdo->prepare("SELECT * FROM profiles WHERE user_id = ?");
            $stmt->execute([$user['id']]);
            $p = $stmt->fetch();
            if ($p) {
                echo "Profile row exists but join failed. Role ID: " . $p['role_id'] . "\n";
            } else {
                echo "No profile row for user.\n";
            }
        }
    } else {
        echo "No users found.\n";
    }
} catch (PDOException $e) {
    echo "Error: " . $e->getMessage();
}
?>
