<?php
require_once __DIR__ . '/../../config/database.php';

try {
    // 1. Staking Pools table
    $pdo->exec("CREATE TABLE IF NOT EXISTS staking_pools (
        id VARCHAR(36) PRIMARY KEY,
        symbol VARCHAR(10) NOT NULL,
        name VARCHAR(100) NOT NULL,
        apr DECIMAL(10, 4) DEFAULT 0,
        min_stake DECIMAL(20, 8) DEFAULT 0,
        lock_period_days INTEGER DEFAULT 0,
        total_staked DECIMAL(20, 8) DEFAULT 0,
        icon VARCHAR(255),
        color VARCHAR(50),
        status TEXT DEFAULT 'active',
        created_at DATETIME DEFAULT CURRENT_TIMESTAMP,
        updated_at DATETIME DEFAULT CURRENT_TIMESTAMP
    )");
    echo "Created table: staking_pools\n";

    // 2. User Stakes table
    $pdo->exec("CREATE TABLE IF NOT EXISTS user_stakes (
        id VARCHAR(36) PRIMARY KEY,
        user_id VARCHAR(36) NOT NULL,
        pool_id VARCHAR(36) NOT NULL,
        amount DECIMAL(20, 8) DEFAULT 0,
        claimed_rewards DECIMAL(20, 8) DEFAULT 0,
        last_claim_at DATETIME DEFAULT CURRENT_TIMESTAMP,
        unlock_at DATETIME,
        status TEXT DEFAULT 'staked',
        created_at DATETIME DEFAULT CURRENT_TIMESTAMP,
        updated_at DATETIME DEFAULT CURRENT_TIMESTAMP,
        FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE,
        FOREIGN KEY (pool_id) REFERENCES staking_pools(id) ON DELETE CASCADE
    )");
    echo "Created table: user_stakes\n";

    // 3. Seed initial pools
    $pools = [
        [
            'id' => 'p1', 
            'symbol' => 'BTC', 
            'name' => 'Bitcoin Core Stake', 
            'apr' => 0.085, 
            'min_stake' => 0.001, 
            'lock_period_days' => 30,
            'icon' => 'Bitcoin', 
            'color' => 'from-orange-500 to-orange-600'
        ],
        [
            'id' => 'p2', 
            'symbol' => 'ETH', 
            'name' => 'Ethereum 2.0 Vault', 
            'apr' => 0.124, 
            'min_stake' => 0.01, 
            'lock_period_days' => 14,
            'icon' => 'Zap', 
            'color' => 'from-blue-500 to-indigo-600'
        ],
        [
            'id' => 'p3', 
            'symbol' => 'USDT', 
            'name' => 'Tether Yield Pool', 
            'apr' => 0.152, 
            'min_stake' => 10, 
            'lock_period_days' => 7,
            'icon' => 'DollarSign', 
            'color' => 'from-green-500 to-emerald-600'
        ],
        [
            'id' => 'p4', 
            'symbol' => 'SOL', 
            'name' => 'Solana Superstake', 
            'apr' => 0.185, 
            'min_stake' => 1, 
            'lock_period_days' => 30,
            'icon' => 'Ghost', 
            'color' => 'from-purple-500 to-indigo-500'
        ],
    ];

    $stmt = $pdo->prepare("INSERT OR IGNORE INTO staking_pools (id, symbol, name, apr, min_stake, lock_period_days, icon, color) VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
    foreach ($pools as $pool) {
        $stmt->execute([
            $pool['id'], 
            $pool['symbol'], 
            $pool['name'], 
            $pool['apr'], 
            $pool['min_stake'], 
            $pool['lock_period_days'], 
            $pool['icon'], 
            $pool['color']
        ]);
    }
    echo "Seeded staking pools\n";

} catch (PDOException $e) {
    die("Migration failed: " . $e->getMessage());
}
?>
