<?php
require_once __DIR__ . '/../../config/database.php';

try {
    // 1. Lending Markets table
    $pdo->exec("CREATE TABLE IF NOT EXISTS lending_markets (
        id VARCHAR(36) PRIMARY KEY,
        symbol VARCHAR(10) NOT NULL UNIQUE,
        name VARCHAR(100) NOT NULL,
        supply_apy DECIMAL(10, 4) DEFAULT 0,
        borrow_apy DECIMAL(10, 4) DEFAULT 0,
        total_liquidity DECIMAL(20, 8) DEFAULT 0,
        collateral_factor DECIMAL(5, 2) DEFAULT 0.75,
        icon VARCHAR(255),
        color VARCHAR(50),
        created_at DATETIME DEFAULT CURRENT_TIMESTAMP,
        updated_at DATETIME DEFAULT CURRENT_TIMESTAMP
    )");
    echo "Created table: lending_markets\n";

    // 2. User Deposits table (Lending)
    $pdo->exec("CREATE TABLE IF NOT EXISTS user_deposits (
        id VARCHAR(36) PRIMARY KEY,
        user_id VARCHAR(36) NOT NULL,
        symbol VARCHAR(10) NOT NULL,
        amount DECIMAL(20, 8) DEFAULT 0,
        accrued_interest DECIMAL(20, 8) DEFAULT 0,
        last_accrual_at DATETIME DEFAULT CURRENT_TIMESTAMP,
        created_at DATETIME DEFAULT CURRENT_TIMESTAMP,
        updated_at DATETIME DEFAULT CURRENT_TIMESTAMP,
        FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE,
        FOREIGN KEY (symbol) REFERENCES lending_markets(symbol) ON DELETE CASCADE
    )");
    echo "Created table: user_deposits\n";

    // 3. User Borrows table
    $pdo->exec("CREATE TABLE IF NOT EXISTS user_borrows (
        id VARCHAR(36) PRIMARY KEY,
        user_id VARCHAR(36) NOT NULL,
        symbol VARCHAR(10) NOT NULL,
        amount DECIMAL(20, 8) DEFAULT 0,
        accrued_interest DECIMAL(20, 8) DEFAULT 0,
        last_accrual_at DATETIME DEFAULT CURRENT_TIMESTAMP,
        created_at DATETIME DEFAULT CURRENT_TIMESTAMP,
        updated_at DATETIME DEFAULT CURRENT_TIMESTAMP,
        FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE,
        FOREIGN KEY (symbol) REFERENCES lending_markets(symbol) ON DELETE CASCADE
    )");
    echo "Created table: user_borrows\n";

    // 4. Seed initial markets
    $markets = [
        ['id' => 'm1', 'symbol' => 'BTC', 'name' => 'Bitcoin', 'supply_apy' => 0.035, 'borrow_apy' => 0.052, 'total_liquidity' => 1250, 'icon' => 'bitcoin.png', 'color' => 'from-orange-500 to-orange-600'],
        ['id' => 'm2', 'symbol' => 'ETH', 'name' => 'Ethereum', 'supply_apy' => 0.042, 'borrow_apy' => 0.061, 'total_liquidity' => 15000, 'icon' => 'ethereum.png', 'color' => 'from-blue-500 to-purple-600'],
        ['id' => 'm3', 'symbol' => 'USDT', 'name' => 'Tether', 'supply_apy' => 0.081, 'borrow_apy' => 0.105, 'total_liquidity' => 5000000, 'icon' => 'tether.png', 'color' => 'from-green-500 to-emerald-600'],
        ['id' => 'm4', 'symbol' => 'SOL', 'name' => 'Solana', 'supply_apy' => 0.065, 'borrow_apy' => 0.087, 'total_liquidity' => 450000, 'icon' => 'solana.png', 'color' => 'from-cyan-400 to-blue-500'],
    ];

    $stmt = $pdo->prepare("INSERT OR IGNORE INTO lending_markets (id, symbol, name, supply_apy, borrow_apy, total_liquidity, icon, color) VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
    foreach ($markets as $market) {
        $stmt->execute([$market['id'], $market['symbol'], $market['name'], $market['supply_apy'], $market['borrow_apy'], $market['total_liquidity'], $market['icon'], $market['color']]);
    }
    echo "Seeded lending markets\n";

} catch (PDOException $e) {
    die("Migration failed: " . $e->getMessage());
}
?>
