<?php
// Database configuration
require_once __DIR__ . '/env.php';
loadEnv(__DIR__ . '/../.env');

$dbPath = getenv('DB_PATH') ?: '../database.db';
define('DB_PATH', __DIR__ . '/' . $dbPath);

try {
    $pdo = new PDO(
        "sqlite:" . DB_PATH,
        null,
        null,
        [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
            PDO::ATTR_EMULATE_PREPARES => false
        ]
    );
    // Enable foreign keys for SQLite
    $pdo->exec("PRAGMA foreign_keys = ON;");
    // Enable WAL mode for better concurrency
    $pdo->exec("PRAGMA journal_mode = WAL;");
} catch (PDOException $e) {
    die("Database connection failed: " . $e->getMessage());
}
?>