<?php
// CORS headers - Updated for security and multi-platform support
$allowed_origins = [
    "http://localhost:5173",  // Vite Dev
    "http://localhost:8080",  // PHP Local
    "capacitor://localhost",   // Capacitor iOS/Android
    "http://localhost",        // Capacitor Android fallback
];

$origin = isset($_SERVER['HTTP_ORIGIN']) ? $_SERVER['HTTP_ORIGIN'] : '';

if (in_array($origin, $allowed_origins)) {
    header("Access-Control-Allow-Origin: $origin");
} else {
    // Fallback for requests without Origin header (like local PHP calls)
    header("Access-Control-Allow-Origin: *");
}

header("Access-Control-Allow-Headers: authorization, x-client-info, apikey, content-type, x-requested-with");
header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS");
header("Access-Control-Allow-Credentials: true");
header("Content-Type: application/json");

// Handle preflight requests
if (isset($_SERVER['REQUEST_METHOD']) && $_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}
?>