<?php
require_once __DIR__ . '/config/database.php';

try {
    // Check if transactions table exists
    $stmt = $pdo->query("SELECT name FROM sqlite_master WHERE type='table' AND name='transactions'");
    $transactionsExists = $stmt->fetchColumn() ? 'Yes' : 'No';
    echo "Transactions table exists: $transactionsExists" . PHP_EOL;

    // Check users table columns
    $stmt = $pdo->query("PRAGMA table_info(users)");
    $cols = $stmt->fetchAll(PDO::FETCH_COLUMN, 1);
    
    $hasWalletAddress = in_array('wallet_address', $cols) ? 'Yes' : 'No';
    echo "Users has wallet_address: $hasWalletAddress" . PHP_EOL;
    
} catch (PDOException $e) {
    echo "Error: " . $e->getMessage() . PHP_EOL;
}
