<?php
require_once __DIR__ . '/config/database.php';

try {
    $stmt = $pdo->query("SELECT * FROM smtp_settings");
    $settings = $stmt->fetchAll();
    
    if (empty($settings)) {
        echo "No SMTP settings found in database.\n";
    } else {
        echo "Found " . count($settings) . " SMTP setting(s):\n\n";
        foreach ($settings as $index => $row) {
            echo "--- Setting #" . ($index + 1) . " ---\n";
            foreach ($row as $key => $value) {
                if ($key === 'password') $value = '********';
                echo "$key: $value\n";
            }
            echo "\n";
        }
    }
} catch (Exception $e) {
    echo "Error querying database: " . $e->getMessage() . "\n";
}
