<?php
require_once __DIR__ . '/config/database.php';

try {
    echo "Checking 'transactions' table schema...\n";
    $stmt = $pdo->query("PRAGMA table_info(transactions)");
    $columns = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    foreach ($columns as $col) {
        echo "Column: " . $col['name'] . " | Type: " . $col['type'] . " | NotNull: " . $col['notnull'] . " | Dflt: " . $col['dflt_value'] . "\n";
    }

} catch (PDOException $e) {
    echo "Error: " . $e->getMessage() . "\n";
}
?>
