<?php
require_once __DIR__ . '/config/database.php';
require_once __DIR__ . '/utils/helpers.php';

// Simulate API call context
// We need to fetch transactions for a known user. 
// In test_transfer_logic.php we used ID 1 (Admin) and seeded some transactions.
// Let's reuse ID 1.

echo "--- Testing History API Logic ---\n";
$userId = 1;

try {
    // 1. Fetch Transactions
    $stmt = $pdo->prepare("
        SELECT t.*, 
               s.email as sender_email, s.wallet_address as sender_address,
               r.email as receiver_email, r.wallet_address as receiver_address
        FROM transactions t
        LEFT JOIN users s ON t.sender_id = s.id
        LEFT JOIN users r ON t.receiver_id = r.id
        WHERE t.sender_id = ? OR t.receiver_id = ?
        ORDER BY t.created_at DESC
        LIMIT 5
    ");
    $stmt->execute([$userId, $userId]);
    $transactions = $stmt->fetchAll(PDO::FETCH_ASSOC);

    echo "Found " . count($transactions) . " transactions.\n";

    foreach ($transactions as $tx) {
        $isSender = $tx['sender_id'] == $userId;
        $type = $isSender ? 'send' : 'receive';
        $otherAddress = $isSender ? ($tx['receiver_address'] ?? 'Unknown') : ($tx['sender_address'] ?? 'Unknown');
        
        echo "Validating TX [{$tx['id']}]: Type=$type, Amount={$tx['amount']} {$tx['symbol']}, Counterparty=$otherAddress\n";
    }

    // 2. Fetch Wallet Address (Check wallet.php logic)
    $stmtUser = $pdo->prepare("SELECT wallet_address FROM users WHERE id = ?");
    $stmtUser->execute([$userId]);
    $addr = $stmtUser->fetchColumn();
    echo "Wallet Address: $addr\n";

} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
}
