<?php
require_once '../config/cors.php';
require_once '../config/database.php';
require_once '../utils/helpers.php';

// Extract authorization token
$token = getAuthToken();

// Validate token
$user = getUserFromToken($token);
if (!$user) {
    errorResponse('User not authenticated', 401);
}

try {
    // Check subscription status
    debugLog("Checking subscription for user: " . $user['email']);
    $stmt = $pdo->prepare("SELECT subscribed, subscription_end, st.name as subscription_tier FROM subscribers s LEFT JOIN subscription_tiers st ON s.subscription_tier_id = st.id WHERE s.email = ?");
    $stmt->execute([$user['email']]);
    $subscription = $stmt->fetch();
    
    if ($subscription) {
        debugLog("Subscription found: " . json_encode($subscription));
    } else {
        debugLog("No subscription record found for email: " . $user['email']);
        // Debug: check user_id as well
        $stmt = $pdo->prepare("SELECT * FROM subscribers WHERE user_id = ?");
        $stmt->execute([$user['id']]);
        $subById = $stmt->fetch();
        if ($subById) {
             debugLog("BUT found subscription by ID: " . json_encode($subById));
        }
    }
    
    if (!$subscription) {
        jsonResponse([
            'subscribed' => false,
            'subscription_tier' => null,
            'subscription_end' => null
        ], 200);
    }
    
    $isActive = $subscription['subscribed'] && 
        (!$subscription['subscription_end'] || new DateTime($subscription['subscription_end']) > new DateTime());
    
    jsonResponse([
        'subscribed' => $isActive,
        'subscription_tier' => $subscription['subscription_tier'],
        'subscription_end' => $subscription['subscription_end']
    ], 200);
} catch (Exception $e) {
    errorResponse('Error checking subscription status: ' . $e->getMessage(), 500);
}
?>