<?php
require_once '../config/cors.php';
require_once '../config/database.php';
require_once '../utils/helpers.php';

try {
    // Get total users (base 500 + real)
    $stmt = $pdo->query("SELECT COUNT(*) as count FROM users");
    $realUsers = $stmt->fetchColumn();
    $totalUsers = 500 + $realUsers; 

    // Get total emails sent (base 100000 + real)
    $stmt = $pdo->query("SELECT SUM(mails_sent) as count FROM user_progress");
    $realEmails = $stmt->fetchColumn() ?: 0;
    $totalEmails = 100000 + $realEmails;

    // Fixed or simulated uptime
    $uptime = "99.9%";

    // Get total active campaigns (distinct active subscribers count in last 30 days)
    $stmt = $pdo->query("SELECT COUNT(DISTINCT recipient_email) FROM mail_activity WHERE created_at > date('now', '-30 days')");
    $activeCampaigns = $stmt->fetchColumn();

    jsonResponse([
        'total_users' => (int)$totalUsers,
        'total_emails' => (int)$totalEmails,
        'uptime' => $uptime,
        'active_campaigns' => (int)$activeCampaigns
    ], 200);

} catch (Exception $e) {
    errorResponse('Error fetching public stats: ' . $e->getMessage(), 500);
}
