<?php
require_once '../config/cors.php';
require_once '../config/database.php';
require_once '../utils/helpers.php';

// Public endpoint to fetch pricing plans
try {
    $stmt = $pdo->query("SELECT * FROM pricing_plans ORDER BY order_index ASC");
    $plans = $stmt->fetchAll();

    // Decode JSON fields
    foreach ($plans as &$plan) {
        $plan['features'] = json_decode($plan['features_json'] ?? '[]') ?: [];
        $plan['notIncluded'] = json_decode($plan['not_included_json'] ?? '[]') ?: [];
        // Map snake_case to camelCase for frontend consistency
        $plan['popular'] = (bool)$plan['is_popular'];
        $plan['buttonText'] = $plan['button_text'];
        $plan['color'] = $plan['color_gradient'];
    }

    jsonResponse($plans);
} catch (PDOException $e) {
    errorResponse('Failed to fetch plans: ' . $e->getMessage(), 500);
}
