import { u as useQuery } from "./useQuery-Dd6y2plw.js";
import { a8 as useQueryClient, a as apiService } from "./index-Jllr8cp4.js";
const useSubscriptionStatusPhp = () => {
  const queryClient = useQueryClient();
  const { data, isLoading, refetch } = useQuery({
    queryKey: ["subscriptionStatus"],
    queryFn: async () => {
      const response = await apiService.getSubscriptionStatus();
      if (response.error) {
        throw new Error(response.error);
      }
      return response.data;
    },
    staleTime: 1e3 * 60 * 5
    // 5 minutes
  });
  const isActivated = !!(data == null ? void 0 : data.subscribed);
  const refreshStatus = () => {
    return queryClient.invalidateQueries({ queryKey: ["subscriptionStatus"] });
  };
  return {
    isActivated,
    loading: isLoading,
    subscriptionData: data,
    refetch,
    refreshStatus
  };
};
export {
  useSubscriptionStatusPhp as u
};
//# sourceMappingURL=useSubscriptionStatusPhp-CKWKu6wV.js.map
