import { r as reactExports, b as useToast, j as jsxRuntimeExports, D as Dialog, E as DialogContent, F as DialogHeader, G as DialogTitle, t as Label, I as Input, J as DialogFooter, B as Button } from "./index-GlGoHQS3.js";
const LendingActionModal = ({
  isOpen,
  onClose,
  market,
  action,
  onSuccess
}) => {
  const [amount, setAmount] = reactExports.useState("");
  const [loading, setLoading] = reactExports.useState(false);
  const { toast } = useToast();
  if (!market) return null;
  const actionIcons = {
    supply: "📥",
    withdraw: "📤",
    borrow: "💸",
    repay: "💰"
  };
  const actionText = action.charAt(0).toUpperCase() + action.slice(1);
  const handleSubmit = async () => {
    if (!amount || parseFloat(amount) <= 0) {
      toast({
        title: "Invalid Amount",
        description: "Please enter a valid amount greater than 0",
        variant: "destructive"
      });
      return;
    }
    try {
      setLoading(true);
      const response = await fetch("/backend/api/lending.php", {
        method: "POST",
        headers: {
          "Content-Type": "application/json",
          "Authorization": `Bearer ${localStorage.getItem("token")}`
        },
        body: JSON.stringify({
          action,
          symbol: market.symbol,
          amount: parseFloat(amount)
        })
      });
      const result = await response.json();
      if (result.status === "success") {
        toast({
          title: "Success",
          description: result.message
        });
        onSuccess();
        onClose();
      } else {
        toast({
          title: "Error",
          description: result.message,
          variant: "destructive"
        });
      }
    } catch (error) {
      toast({
        title: "Error",
        description: "Failed to process transaction",
        variant: "destructive"
      });
    } finally {
      setLoading(false);
    }
  };
  return /* @__PURE__ */ jsxRuntimeExports.jsx(Dialog, { open: isOpen, onOpenChange: onClose, children: /* @__PURE__ */ jsxRuntimeExports.jsxs(DialogContent, { className: "sm:max-w-md bg-background/95 backdrop-blur-xl border-border/50", children: [
    /* @__PURE__ */ jsxRuntimeExports.jsx(DialogHeader, { children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center gap-3 mb-2", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: `w-12 h-12 rounded-2xl bg-gradient-to-br ${market.color} flex items-center justify-center text-2xl shadow-lg`, children: actionIcons[action] }),
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { children: [
        /* @__PURE__ */ jsxRuntimeExports.jsxs(DialogTitle, { className: "text-xl font-bold", children: [
          actionText,
          " ",
          market.symbol
        ] }),
        /* @__PURE__ */ jsxRuntimeExports.jsxs("p", { className: "text-sm text-muted-foreground", children: [
          market.name,
          " Market"
        ] })
      ] })
    ] }) }),
    /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "space-y-4 py-4", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "space-y-2", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsxs(Label, { htmlFor: "amount", children: [
          "Amount to ",
          action
        ] }),
        /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "relative", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx(
            Input,
            {
              id: "amount",
              type: "number",
              placeholder: "0.00",
              value: amount,
              onChange: (e) => setAmount(e.target.value),
              className: "pr-16 h-12 text-lg font-medium"
            }
          ),
          /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "absolute right-3 top-1/2 -translate-y-1/2 font-bold text-muted-foreground", children: market.symbol })
        ] })
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "p-4 rounded-xl bg-muted/50 border border-border/30 space-y-2", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex justify-between text-sm", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx("span", { className: "text-muted-foreground", children: "Market APY" }),
          /* @__PURE__ */ jsxRuntimeExports.jsxs("span", { className: action === "supply" ? "text-flashcore-green font-bold" : "text-orange-500 font-bold", children: [
            (market[action === "supply" || action === "withdraw" ? "supply_apy" : "borrow_apy"] * 100).toFixed(2),
            "%"
          ] })
        ] }),
        /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex justify-between text-sm", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx("span", { className: "text-muted-foreground", children: "Health Factor Impact" }),
          /* @__PURE__ */ jsxRuntimeExports.jsx("span", { className: "text-flashcore-green", children: "Stable" })
        ] })
      ] })
    ] }),
    /* @__PURE__ */ jsxRuntimeExports.jsxs(DialogFooter, { className: "gap-2 sm:gap-0", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsx(Button, { variant: "ghost", onClick: onClose, disabled: loading, children: "Cancel" }),
      /* @__PURE__ */ jsxRuntimeExports.jsx(
        Button,
        {
          onClick: handleSubmit,
          disabled: loading,
          className: `bg-gradient-to-r ${market.color} text-white border-0 hover:opacity-90`,
          children: loading ? "Processing..." : `${actionText} ${market.symbol}`
        }
      )
    ] })
  ] }) });
};
const useLendingData = () => {
  const [markets, setMarkets] = reactExports.useState([]);
  const [deposits, setDeposits] = reactExports.useState([]);
  const [borrows, setBorrows] = reactExports.useState([]);
  const [loading, setLoading] = reactExports.useState(true);
  const fetchLendingData = async () => {
    try {
      setLoading(true);
      const response = await fetch("/backend/api/lending.php", {
        headers: {
          "Authorization": `Bearer ${localStorage.getItem("token")}`
        }
      });
      const result = await response.json();
      if (result.status === "success") {
        setMarkets(result.data.markets);
        setDeposits(result.data.deposits);
        setBorrows(result.data.borrows);
      }
    } catch (error) {
      console.error("Failed to fetch lending data", error);
    } finally {
      setLoading(false);
    }
  };
  reactExports.useEffect(() => {
    fetchLendingData();
  }, []);
  return { markets, deposits, borrows, loading, refresh: fetchLendingData };
};
export {
  LendingActionModal as L,
  useLendingData as u
};
//# sourceMappingURL=useLendingData-3IgjSCRv.js.map
