import { c as createLucideIcon, r as reactExports, j as jsxRuntimeExports, L as Layout, O as Globe, d as Card, e as CardContent, T as TrendingUp, g as CardHeader, h as CardTitle, i as CardDescription, B as Button, J as Avatar, N as AvatarFallback, I as Input } from "./index-lF0PjX8A.js";
import { B as Badge } from "./badge-CAfH9bmo.js";
import { U as Users } from "./users-D_atNPk8.js";
import { M as MessageSquare } from "./message-square-CeIgt3MN.js";
import { S as Search } from "./search-BgCHtjsa.js";
import { F as Filter } from "./filter-DdZ7hs3u.js";
import { H as Heart } from "./heart-BHti_dow.js";
import { S as Share2 } from "./share-2-Bav-nUIs.js";
import { E as Ellipsis } from "./ellipsis-CbSqJ1YA.js";
import { S as Send } from "./send-Ck4tlUfv.js";
import { Z as Zap } from "./zap-Bal8zz-e.js";
/**
 * @license lucide-react v0.462.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */
const Mic = createLucideIcon("Mic", [
  ["path", { d: "M12 2a3 3 0 0 0-3 3v7a3 3 0 0 0 6 0V5a3 3 0 0 0-3-3Z", key: "131961" }],
  ["path", { d: "M19 10v2a7 7 0 0 1-14 0v-2", key: "1vc78b" }],
  ["line", { x1: "12", x2: "12", y1: "19", y2: "22", key: "x3vr5v" }]
]);
/**
 * @license lucide-react v0.462.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */
const Paperclip = createLucideIcon("Paperclip", [
  [
    "path",
    {
      d: "m21.44 11.05-9.19 9.19a6 6 0 0 1-8.49-8.49l8.57-8.57A4 4 0 1 1 18 8.84l-8.59 8.57a2 2 0 0 1-2.83-2.83l8.49-8.48",
      key: "1u3ebp"
    }
  ]
]);
/**
 * @license lucide-react v0.462.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */
const Smile = createLucideIcon("Smile", [
  ["circle", { cx: "12", cy: "12", r: "10", key: "1mglay" }],
  ["path", { d: "M8 14s1.5 2 4 2 4-2 4-2", key: "1y1vjs" }],
  ["line", { x1: "9", x2: "9.01", y1: "9", y2: "9", key: "yxxnd0" }],
  ["line", { x1: "15", x2: "15.01", y1: "9", y2: "9", key: "1p4y9e" }]
]);
const WorldChatPage = () => {
  const [message, setMessage] = reactExports.useState("");
  reactExports.useState("global");
  const chatData = {
    onlineUsers: 1247,
    totalMessages: 45620,
    activeChannels: 8,
    messages: [
      {
        id: 1,
        user: "Sarah Johnson",
        avatar: "SJ",
        message: "Just discovered this amazing platform! The features are incredible 🔥",
        timestamp: "2 min ago",
        likes: 12,
        isLiked: false,
        country: "🇺🇸"
      },
      {
        id: 2,
        user: "Alex Chen",
        avatar: "AC",
        message: "Anyone tried the new automation features? They're game-changing!",
        timestamp: "5 min ago",
        likes: 8,
        isLiked: true,
        country: "🇨🇦"
      },
      {
        id: 3,
        user: "Emma Davis",
        avatar: "ED",
        message: "The referral program is fantastic. Already earned $50 this month! 💰",
        timestamp: "8 min ago",
        likes: 15,
        isLiked: false,
        country: "🇬🇧"
      },
      {
        id: 4,
        user: "Mike Thompson",
        avatar: "MT",
        message: "Looking for tips on email marketing strategies. Any experts here?",
        timestamp: "12 min ago",
        likes: 6,
        isLiked: false,
        country: "🇦🇺"
      }
    ],
    channels: [
      { name: "General", users: 1247, active: true },
      { name: "Marketing", users: 456, active: false },
      { name: "Automation", users: 234, active: false },
      { name: "Tips & Tricks", users: 789, active: false }
    ]
  };
  const handleSendMessage = () => {
    if (message.trim()) {
      setMessage("");
    }
  };
  const handleLike = (messageId) => {
  };
  return /* @__PURE__ */ jsxRuntimeExports.jsx(Layout, { children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "space-y-6", children: [
    /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center gap-3", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "w-8 h-8 bg-gradient-to-r from-flashcore-purple to-flashcore-green rounded-lg flex items-center justify-center", children: /* @__PURE__ */ jsxRuntimeExports.jsx(Globe, { className: "w-5 h-5 text-white" }) }),
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx("h1", { className: "text-3xl font-bold", children: "World Chat" }),
        /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-muted-foreground", children: "Connect with the global FlashCore community" })
      ] })
    ] }),
    /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "grid grid-cols-1 md:grid-cols-3 gap-6", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsx(Card, { className: "hover:shadow-lg transition-shadow", children: /* @__PURE__ */ jsxRuntimeExports.jsx(CardContent, { className: "p-6", children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center justify-between", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-sm font-medium text-muted-foreground", children: "Online Users" }),
          /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-2xl font-bold", children: chatData.onlineUsers.toLocaleString() }),
          /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center mt-2", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx(TrendingUp, { className: "w-4 h-4 text-green-500 mr-1" }),
            /* @__PURE__ */ jsxRuntimeExports.jsx("span", { className: "text-sm text-green-500", children: "+23 today" })
          ] })
        ] }),
        /* @__PURE__ */ jsxRuntimeExports.jsx(Users, { className: "w-8 h-8 text-flashcore-purple" })
      ] }) }) }),
      /* @__PURE__ */ jsxRuntimeExports.jsx(Card, { className: "hover:shadow-lg transition-shadow", children: /* @__PURE__ */ jsxRuntimeExports.jsx(CardContent, { className: "p-6", children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center justify-between", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-sm font-medium text-muted-foreground", children: "Total Messages" }),
          /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-2xl font-bold", children: chatData.totalMessages.toLocaleString() }),
          /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-sm text-muted-foreground mt-2", children: "This month" })
        ] }),
        /* @__PURE__ */ jsxRuntimeExports.jsx(MessageSquare, { className: "w-8 h-8 text-flashcore-green" })
      ] }) }) }),
      /* @__PURE__ */ jsxRuntimeExports.jsx(Card, { className: "hover:shadow-lg transition-shadow", children: /* @__PURE__ */ jsxRuntimeExports.jsx(CardContent, { className: "p-6", children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center justify-between", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-sm font-medium text-muted-foreground", children: "Active Channels" }),
          /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-2xl font-bold", children: chatData.activeChannels }),
          /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-sm text-muted-foreground mt-2", children: "Available now" })
        ] }),
        /* @__PURE__ */ jsxRuntimeExports.jsx(Globe, { className: "w-8 h-8 text-flashcore-orange" })
      ] }) }) })
    ] }),
    /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "grid grid-cols-1 lg:grid-cols-4 gap-6", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsxs(Card, { className: "lg:col-span-1 border-white/10 bg-black/5 backdrop-blur-sm", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx(CardHeader, { children: /* @__PURE__ */ jsxRuntimeExports.jsxs(CardTitle, { className: "flex items-center gap-2", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx(MessageSquare, { className: "w-5 h-5 text-flashcore-purple" }),
          "Channels"
        ] }) }),
        /* @__PURE__ */ jsxRuntimeExports.jsx(CardContent, { children: /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "space-y-2", children: chatData.channels.map((channel) => /* @__PURE__ */ jsxRuntimeExports.jsx(
          "button",
          {
            className: `w-full p-3 rounded-xl text-left transition-all duration-300 group ${channel.active ? "bg-gradient-to-r from-flashcore-purple to-flashcore-green text-white shadow-lg" : "hover:bg-muted/50 text-muted-foreground hover:text-foreground"}`,
            children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center justify-between", children: [
              /* @__PURE__ */ jsxRuntimeExports.jsxs("span", { className: "font-semibold text-sm", children: [
                "#",
                channel.name
              ] }),
              /* @__PURE__ */ jsxRuntimeExports.jsx(Badge, { variant: "secondary", className: `${channel.active ? "bg-white/20 text-white" : "bg-muted"} text-[10px]`, children: channel.users })
            ] })
          },
          channel.name
        )) }) })
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsxs(Card, { className: "lg:col-span-3 border-white/10 bg-black/5 backdrop-blur-sm overflow-hidden flex flex-col h-[600px]", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx(CardHeader, { className: "border-b border-white/10", children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center justify-between", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { children: [
            /* @__PURE__ */ jsxRuntimeExports.jsxs(CardTitle, { className: "flex items-center gap-2", children: [
              /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "relative", children: [
                /* @__PURE__ */ jsxRuntimeExports.jsx(Globe, { className: "w-5 h-5 text-flashcore-purple" }),
                /* @__PURE__ */ jsxRuntimeExports.jsx("span", { className: "absolute -top-1 -right-1 w-2 h-2 bg-flashcore-green rounded-full animate-pulse shadow-[0_0_8px_rgba(34,211,238,0.8)]" })
              ] }),
              "Global Chat"
            ] }),
            /* @__PURE__ */ jsxRuntimeExports.jsxs(CardDescription, { className: "flex items-center gap-2", children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx("span", { className: "w-1.5 h-1.5 bg-flashcore-green rounded-full" }),
              chatData.onlineUsers.toLocaleString(),
              " users online"
            ] })
          ] }),
          /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center gap-2", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsxs(Button, { variant: "outline", size: "sm", className: "bg-background/50", children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx(Search, { className: "w-4 h-4 mr-2" }),
              "Search"
            ] }),
            /* @__PURE__ */ jsxRuntimeExports.jsxs(Button, { variant: "outline", size: "sm", className: "bg-background/50", children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx(Filter, { className: "w-4 h-4 mr-2" }),
              "Filter"
            ] })
          ] })
        ] }) }),
        /* @__PURE__ */ jsxRuntimeExports.jsx(CardContent, { className: "flex-1 overflow-hidden p-0 relative", children: /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "h-full overflow-y-auto p-6 space-y-4 custom-scrollbar", children: chatData.messages.map((msg) => /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "group flex gap-4 p-4 hover:bg-white/5 rounded-2xl transition-all duration-300 border border-transparent hover:border-white/10", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx(Avatar, { className: "w-10 h-10 border-2 border-white/10", children: /* @__PURE__ */ jsxRuntimeExports.jsx(AvatarFallback, { className: "bg-gradient-to-br from-flashcore-purple to-flashcore-green text-white font-bold", children: msg.avatar }) }),
          /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex-1", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center gap-2 mb-1", children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx("span", { className: "font-bold text-sm hover:underline cursor-pointer", children: msg.user }),
              /* @__PURE__ */ jsxRuntimeExports.jsx("span", { className: "text-xs opacity-80", title: "Country", children: msg.country }),
              /* @__PURE__ */ jsxRuntimeExports.jsx("span", { className: "text-[10px] text-muted-foreground uppercase font-medium", children: msg.timestamp })
            ] }),
            /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "bg-white/5 backdrop-blur-sm p-3 rounded-2xl rounded-tl-none border border-white/5 inline-block min-w-[100px] max-w-full", children: /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-sm leading-relaxed", children: msg.message }) }),
            /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center gap-4 mt-2", children: [
              /* @__PURE__ */ jsxRuntimeExports.jsxs(
                "button",
                {
                  onClick: () => handleLike(msg.id),
                  className: `flex items-center gap-1.5 text-[10px] font-bold uppercase tracking-wider transition-all ${msg.isLiked ? "text-red-500" : "text-muted-foreground hover:text-red-500"}`,
                  children: [
                    /* @__PURE__ */ jsxRuntimeExports.jsx(Heart, { className: `w-3.5 h-3.5 ${msg.isLiked ? "fill-current" : ""}` }),
                    msg.likes
                  ]
                }
              ),
              /* @__PURE__ */ jsxRuntimeExports.jsxs("button", { className: "flex items-center gap-1.5 text-[10px] font-bold uppercase tracking-wider text-muted-foreground hover:text-foreground transition-all", children: [
                /* @__PURE__ */ jsxRuntimeExports.jsx(Share2, { className: "w-3.5 h-3.5" }),
                "Share"
              ] }),
              /* @__PURE__ */ jsxRuntimeExports.jsx("button", { className: "opacity-0 group-hover:opacity-100 flex items-center gap-1.5 text-[10px] font-bold uppercase tracking-wider text-muted-foreground hover:text-foreground transition-all", children: /* @__PURE__ */ jsxRuntimeExports.jsx(Ellipsis, { className: "w-3.5 h-3.5" }) })
            ] })
          ] })
        ] }, msg.id)) }) }),
        /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "p-4 border-t border-white/10 bg-background/30 backdrop-blur-md", children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center gap-2 bg-background/50 border border-white/10 rounded-2xl p-2 focus-within:ring-2 focus-within:ring-flashcore-purple/30 transition-all", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx(Button, { variant: "ghost", size: "icon", className: "h-9 w-9 rounded-xl hover:bg-white/10", children: /* @__PURE__ */ jsxRuntimeExports.jsx(Paperclip, { className: "w-4 h-4 text-muted-foreground" }) }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(
            Input,
            {
              value: message,
              onChange: (e) => setMessage(e.target.value),
              placeholder: "Share your thoughts with the community...",
              className: "flex-1 border-none bg-transparent focus-visible:ring-0 placeholder:text-muted-foreground/50 h-10",
              onKeyPress: (e) => e.key === "Enter" && handleSendMessage()
            }
          ),
          /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center gap-1", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx(Button, { variant: "ghost", size: "icon", className: "h-9 w-9 rounded-xl hover:bg-white/10 hidden sm:flex", children: /* @__PURE__ */ jsxRuntimeExports.jsx(Smile, { className: "w-4 h-4 text-muted-foreground" }) }),
            /* @__PURE__ */ jsxRuntimeExports.jsx(Button, { variant: "ghost", size: "icon", className: "h-9 w-9 rounded-xl hover:bg-white/10 hidden sm:flex", children: /* @__PURE__ */ jsxRuntimeExports.jsx(Mic, { className: "w-4 h-4 text-muted-foreground" }) }),
            /* @__PURE__ */ jsxRuntimeExports.jsx(
              Button,
              {
                onClick: handleSendMessage,
                size: "icon",
                className: "h-9 w-9 rounded-xl bg-gradient-to-r from-flashcore-purple to-flashcore-green hover:shadow-lg hover:shadow-flashcore-purple/20 transition-all",
                children: /* @__PURE__ */ jsxRuntimeExports.jsx(Send, { className: "w-4 h-4" })
              }
            )
          ] })
        ] }) })
      ] })
    ] }),
    /* @__PURE__ */ jsxRuntimeExports.jsxs(Card, { className: "border-none bg-gradient-to-br from-flashcore-purple/5 via-transparent to-flashcore-green/5", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsx(CardHeader, { children: /* @__PURE__ */ jsxRuntimeExports.jsxs(CardTitle, { className: "flex items-center gap-2", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx(Zap, { className: "w-5 h-5 text-flashcore-purple" }),
        "Community Guidelines"
      ] }) }),
      /* @__PURE__ */ jsxRuntimeExports.jsx(CardContent, { children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "grid grid-cols-1 md:grid-cols-3 gap-6", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "group text-center p-6 bg-white/5 backdrop-blur-sm rounded-2xl border border-white/5 hover:border-flashcore-green/30 transition-all duration-500", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "w-10 h-10 bg-green-500/20 rounded-xl flex items-center justify-center mx-auto mb-4 border border-green-500/30 group-hover:scale-110 transition-transform", children: /* @__PURE__ */ jsxRuntimeExports.jsx("span", { className: "text-green-500 text-sm font-bold", children: "✓" }) }),
          /* @__PURE__ */ jsxRuntimeExports.jsx("h3", { className: "font-bold mb-2", children: "Be Respectful" }),
          /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-sm text-muted-foreground leading-relaxed", children: "Treat everyone with kindness. We're building a supportive global community." })
        ] }),
        /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "group text-center p-6 bg-white/5 backdrop-blur-sm rounded-2xl border border-white/5 hover:border-flashcore-purple/30 transition-all duration-500", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "w-10 h-10 bg-blue-500/20 rounded-xl flex items-center justify-center mx-auto mb-4 border border-blue-500/30 group-hover:scale-110 transition-transform", children: /* @__PURE__ */ jsxRuntimeExports.jsx("span", { className: "text-blue-500 text-sm font-bold", children: "💡" }) }),
          /* @__PURE__ */ jsxRuntimeExports.jsx("h3", { className: "font-bold mb-2", children: "Share Knowledge" }),
          /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-sm text-muted-foreground leading-relaxed", children: "Help others learn. Sharing insights makes the platform better for everyone." })
        ] }),
        /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "group text-center p-6 bg-white/5 backdrop-blur-sm rounded-2xl border border-white/5 hover:border-flashcore-orange/30 transition-all duration-500", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "w-10 h-10 bg-orange-500/20 rounded-xl flex items-center justify-center mx-auto mb-4 border border-orange-500/30 group-hover:scale-110 transition-transform", children: /* @__PURE__ */ jsxRuntimeExports.jsx("span", { className: "text-orange-500 text-sm font-bold", children: "🚫" }) }),
          /* @__PURE__ */ jsxRuntimeExports.jsx("h3", { className: "font-bold mb-2", children: "No Spam" }),
          /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-sm text-muted-foreground leading-relaxed", children: "Keep it clean and relevant. No self-promotion or unsolicited links." })
        ] })
      ] }) })
    ] })
  ] }) });
};
export {
  WorldChatPage as default
};
//# sourceMappingURL=WorldChatPage-Ck9mzOhQ.js.map
