import { c as createLucideIcon, j as jsxRuntimeExports, L as Layout, d as Card, B as Button, g as CardHeader, h as CardTitle, i as CardDescription, e as CardContent, p as CardFooter } from "./index-Jllr8cp4.js";
import { T as Tabs, a as TabsList, b as TabsTrigger, c as TabsContent } from "./tabs-BvfypMGT.js";
import { B as Badge } from "./badge-DvUYI4c1.js";
import { P as Play } from "./play-nBHS3Tm5.js";
import { Z as Zap } from "./zap-BQUPSBEk.js";
import { C as CircleCheckBig } from "./circle-check-big-B5mpuuCI.js";
import { C as Clock } from "./clock-CgdakvGQ.js";
import { S as Star } from "./star-CHNvCwQo.js";
/**
 * @license lucide-react v0.462.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */
const Book = createLucideIcon("Book", [
  [
    "path",
    {
      d: "M4 19.5v-15A2.5 2.5 0 0 1 6.5 2H19a1 1 0 0 1 1 1v18a1 1 0 0 1-1 1H6.5a1 1 0 0 1 0-5H20",
      key: "k3hazp"
    }
  ]
]);
const TutorialPage = () => {
  return /* @__PURE__ */ jsxRuntimeExports.jsx(Layout, { children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "space-y-6", children: [
    /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex flex-col space-y-1", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsx("h1", { className: "text-3xl font-bold", children: "Tutorials & Guides" }),
      /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-muted-foreground", children: "Master the FlashCore platform with our comprehensive resources" })
    ] }),
    /* @__PURE__ */ jsxRuntimeExports.jsxs(Tabs, { defaultValue: "all", className: "w-full", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsxs(TabsList, { className: "bg-muted/50 p-1 rounded-xl", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx(TabsTrigger, { value: "all", className: "rounded-lg data-[state=active]:bg-background data-[state=active]:shadow-sm", children: "All Resources" }),
        /* @__PURE__ */ jsxRuntimeExports.jsx(TabsTrigger, { value: "beginner", className: "rounded-lg data-[state=active]:bg-background data-[state=active]:shadow-sm", children: "Beginner" }),
        /* @__PURE__ */ jsxRuntimeExports.jsx(TabsTrigger, { value: "intermediate", className: "rounded-lg data-[state=active]:bg-background data-[state=active]:shadow-sm", children: "Intermediate" }),
        /* @__PURE__ */ jsxRuntimeExports.jsx(TabsTrigger, { value: "advanced", className: "rounded-lg data-[state=active]:bg-background data-[state=active]:shadow-sm", children: "Advanced" })
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsx(TabsContent, { value: "all", className: "mt-6", children: /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6", children: [
        {
          title: "Getting Started Guide",
          description: "Learn the basics of using the dashboard and setting up your account",
          category: "Beginner",
          duration: "10 min",
          isNew: true,
          completed: false
        },
        {
          title: "Setting Up Your First Child Panel",
          description: "Create and configure your first reseller panel step by step",
          category: "Beginner",
          duration: "15 min",
          isNew: false,
          completed: false
        },
        {
          title: "Creating Service Packages",
          description: "Learn how to build and price service packages for your clients",
          category: "Intermediate",
          duration: "12 min",
          isNew: false,
          completed: true
        },
        {
          title: "API Integration Guide",
          description: "Connect external services using our robust API endpoints",
          category: "Advanced",
          duration: "20 min",
          isNew: false,
          completed: false
        },
        {
          title: "White Label Configuration",
          description: "Customize your panels with your own branding and design",
          category: "Intermediate",
          duration: "18 min",
          isNew: true,
          completed: false
        },
        {
          title: "Advanced User Management",
          description: "Set up roles, permissions and manage user accounts",
          category: "Advanced",
          duration: "25 min",
          isNew: false,
          completed: false
        }
      ].map((tutorial, index) => /* @__PURE__ */ jsxRuntimeExports.jsxs(Card, { className: "overflow-hidden flex flex-col group hover:shadow-xl transition-all duration-300 border-none bg-card", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "relative h-44 bg-gradient-to-br from-flashcore-purple/20 to-flashcore-green/20 overflow-hidden", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "absolute inset-0 flex items-center justify-center opacity-0 group-hover:opacity-100 transition-opacity bg-black/20 backdrop-blur-[2px]", children: /* @__PURE__ */ jsxRuntimeExports.jsx(Button, { size: "icon", className: "h-14 w-14 rounded-full bg-white text-flashcore-purple hover:scale-110 transition-transform", children: /* @__PURE__ */ jsxRuntimeExports.jsx(Play, { className: "h-6 w-6 fill-current" }) }) }),
          /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "absolute inset-0 flex items-center justify-center pointer-events-none", children: /* @__PURE__ */ jsxRuntimeExports.jsx(Zap, { className: "h-12 w-12 text-flashcore-purple/20 group-hover:scale-125 transition-transform duration-500" }) }),
          tutorial.isNew && /* @__PURE__ */ jsxRuntimeExports.jsx(Badge, { className: "absolute top-3 right-3 bg-flashcore-purple text-white border-none text-[10px] font-bold uppercase py-1", children: "New" }),
          tutorial.completed && /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "absolute bottom-3 right-3 bg-flashcore-green text-white rounded-full p-1 shadow-lg", children: /* @__PURE__ */ jsxRuntimeExports.jsx(CircleCheckBig, { className: "h-4 w-4" }) })
        ] }),
        /* @__PURE__ */ jsxRuntimeExports.jsxs(CardHeader, { className: "pb-2 space-y-1", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex justify-between items-center mb-1", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx(Badge, { variant: "outline", className: `border-none text-[10px] font-bold uppercase py-0.5 px-2 rounded-full ${tutorial.category === "Beginner" ? "bg-green-100 text-green-700" : tutorial.category === "Intermediate" ? "bg-blue-100 text-blue-700" : "bg-purple-100 text-purple-700"}`, children: tutorial.category }),
            /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center text-muted-foreground text-[10px] font-bold uppercase", children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx(Clock, { className: "h-3 w-3 mr-1" }),
              tutorial.duration
            ] })
          ] }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(CardTitle, { className: "text-lg group-hover:text-flashcore-purple transition-colors", children: tutorial.title }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(CardDescription, { className: "text-sm line-clamp-2", children: tutorial.description })
        ] }),
        /* @__PURE__ */ jsxRuntimeExports.jsx(CardContent, { className: "pb-4 flex-grow", children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center text-xs text-amber-500 font-bold", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx(Star, { className: "h-3 w-3 mr-1 fill-current" }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(Star, { className: "h-3 w-3 mr-1 fill-current" }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(Star, { className: "h-3 w-3 mr-1 fill-current" }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(Star, { className: "h-3 w-3 mr-1 fill-current" }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(Star, { className: "h-3 w-3 mr-1 text-muted fill-current" }),
          /* @__PURE__ */ jsxRuntimeExports.jsx("span", { className: "ml-1 text-muted-foreground", children: "(24)" })
        ] }) }),
        /* @__PURE__ */ jsxRuntimeExports.jsx(CardFooter, { className: "pt-0 border-t bg-muted/20", children: /* @__PURE__ */ jsxRuntimeExports.jsx(Button, { className: `w-full h-10 font-bold uppercase text-xs tracking-wider transition-all mt-4 ${tutorial.completed ? "variant-outline border-flashcore-green text-flashcore-green" : "bg-gradient-to-r from-flashcore-purple to-flashcore-green"}`, children: tutorial.completed ? "Watch Again" : "Start Learning" }) })
      ] }, index)) }) })
    ] }),
    /* @__PURE__ */ jsxRuntimeExports.jsxs(Card, { className: "border-none shadow-xl bg-gradient-to-r from-slate-900 to-slate-800 text-white overflow-hidden", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsxs(CardHeader, { children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx(CardTitle, { className: "text-white", children: "Educational Resources" }),
        /* @__PURE__ */ jsxRuntimeExports.jsx(CardDescription, { className: "text-slate-400", children: "Deep dive into our documentation and reference materials" })
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsx(CardContent, { children: /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "grid grid-cols-1 md:grid-cols-2 gap-4", children: [
        { title: "Developer API", desc: "Complete reference and guides", icon: Book },
        { title: "User Guides", desc: "Step-by-step instructions", icon: Book },
        { title: "Best Practices", desc: "Optimal platform usage tips", icon: Book },
        { title: "FAQ", desc: "Common questions answered", icon: Book }
      ].map((res, i) => /* @__PURE__ */ jsxRuntimeExports.jsxs(Button, { variant: "ghost", className: "h-auto py-4 px-4 justify-start text-left bg-white/5 hover:bg-white/10 hover:text-white border border-white/5 group transition-all", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "mr-4 p-2 rounded-lg bg-flashcore-purple/20 group-hover:bg-flashcore-purple/40 transition-colors", children: /* @__PURE__ */ jsxRuntimeExports.jsx(res.icon, { className: "h-6 w-6 text-flashcore-purple" }) }),
        /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx("h3", { className: "font-bold text-sm tracking-tight", children: res.title }),
          /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-xs text-slate-400", children: res.desc })
        ] })
      ] }, i)) }) })
    ] })
  ] }) });
};
export {
  TutorialPage as default
};
//# sourceMappingURL=TutorialPage-C2q9qtl4.js.map
