import { r as reactExports, j as jsxRuntimeExports, I as Input, d as Card, g as CardHeader, h as CardTitle, i as CardDescription, e as CardContent, B as Button, m as Link, A as ArrowRight } from "./index-lF0PjX8A.js";
import { B as Badge } from "./badge-CAfH9bmo.js";
import { S as Select, a as SelectTrigger, b as SelectValue, c as SelectContent, d as SelectItem } from "./select-CxkNd6H7.js";
import { M as Mail } from "./mail-CiX6a04S.js";
import { S as Search } from "./search-BgCHtjsa.js";
import { F as Filter } from "./filter-DdZ7hs3u.js";
import { S as Star } from "./star-Dge1E5KC.js";
import { E as Eye } from "./eye-9xkahhb0.js";
import { D as Download } from "./download-DW8bLCXu.js";
import { U as Users } from "./users-D_atNPk8.js";
import { C as CreditCard } from "./credit-card-BJbZzXe3.js";
import { R as Receipt } from "./receipt-D6P5JfGh.js";
import { C as Calendar } from "./calendar-B_h22Gsl.js";
import "./index-C18CCgT2.js";
const TemplatesPage = () => {
  const [searchTerm, setSearchTerm] = reactExports.useState("");
  const [selectedCategory, setSelectedCategory] = reactExports.useState("all");
  const categories = [
    { value: "all", label: "All Templates" },
    { value: "welcome", label: "Welcome Emails" },
    { value: "billing", label: "Billing & Invoices" },
    { value: "receipts", label: "Receipts" },
    { value: "marketing", label: "Marketing" },
    { value: "support", label: "Support" },
    { value: "transactional", label: "Transactional" }
  ];
  const templates = [
    {
      id: 1,
      name: "Welcome Email",
      category: "welcome",
      description: "Professional welcome email for new customers",
      preview: "Welcome to FlashCore! We're excited to have you on board...",
      rating: 4.8,
      downloads: 1247,
      tags: ["welcome", "onboarding", "professional"],
      color: "from-flashcore-purple to-flashcore-green"
    },
    {
      id: 2,
      name: "Invoice Template",
      category: "billing",
      description: "Clean and professional invoice email template",
      preview: "Your invoice for services rendered is now ready...",
      rating: 4.9,
      downloads: 2156,
      tags: ["billing", "invoice", "professional"],
      color: "from-flashcore-green to-flashcore-purple"
    },
    {
      id: 3,
      name: "Payment Receipt",
      category: "receipts",
      description: "Detailed payment receipt with transaction details",
      preview: "Thank you for your payment. Here's your receipt...",
      rating: 4.7,
      downloads: 1893,
      tags: ["receipt", "payment", "confirmation"],
      color: "from-flashcore-orange to-flashcore-purple"
    },
    {
      id: 4,
      name: "Newsletter Template",
      category: "marketing",
      description: "Engaging newsletter template for marketing campaigns",
      preview: "Stay updated with our latest news and insights...",
      rating: 4.6,
      downloads: 987,
      tags: ["newsletter", "marketing", "engagement"],
      color: "from-blue-500 to-purple-500"
    },
    {
      id: 5,
      name: "Support Ticket Confirmation",
      category: "support",
      description: "Professional support ticket confirmation email",
      preview: "We've received your support request and will respond shortly...",
      rating: 4.8,
      downloads: 756,
      tags: ["support", "confirmation", "professional"],
      color: "from-green-500 to-blue-500"
    },
    {
      id: 6,
      name: "Order Confirmation",
      category: "transactional",
      description: "Complete order confirmation with tracking details",
      preview: "Your order has been confirmed and is being processed...",
      rating: 4.9,
      downloads: 1432,
      tags: ["order", "confirmation", "tracking"],
      color: "from-purple-500 to-pink-500"
    },
    {
      id: 7,
      name: "Password Reset",
      category: "support",
      description: "Secure password reset email template",
      preview: "We received a request to reset your password...",
      rating: 4.7,
      downloads: 654,
      tags: ["security", "password", "reset"],
      color: "from-red-500 to-orange-500"
    },
    {
      id: 8,
      name: "Account Verification",
      category: "welcome",
      description: "Email verification template for new accounts",
      preview: "Please verify your email address to complete registration...",
      rating: 4.8,
      downloads: 892,
      tags: ["verification", "security", "onboarding"],
      color: "from-indigo-500 to-purple-500"
    }
  ];
  const filteredTemplates = templates.filter((template) => {
    const matchesSearch = template.name.toLowerCase().includes(searchTerm.toLowerCase()) || template.description.toLowerCase().includes(searchTerm.toLowerCase()) || template.tags.some((tag) => tag.toLowerCase().includes(searchTerm.toLowerCase()));
    const matchesCategory = selectedCategory === "all" || template.category === selectedCategory;
    return matchesSearch && matchesCategory;
  });
  return /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "min-h-screen bg-background", children: [
    /* @__PURE__ */ jsxRuntimeExports.jsx("section", { className: "container mx-auto px-4 py-12 md:py-20 text-center", children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "max-w-4xl mx-auto", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsxs(Badge, { variant: "secondary", className: "mb-4", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx(Mail, { className: "w-3 h-3 mr-1" }),
        "Professional Templates"
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsx("h1", { className: "text-3xl md:text-4xl lg:text-5xl font-bold mb-6 bg-gradient-to-r from-flashcore-purple to-flashcore-green bg-clip-text text-transparent", children: "Email Templates" }),
      /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-lg md:text-xl text-muted-foreground mb-8 max-w-2xl mx-auto", children: "Choose from our library of professional email templates designed to help you communicate effectively with your customers." })
    ] }) }),
    /* @__PURE__ */ jsxRuntimeExports.jsx("section", { className: "container mx-auto px-4 py-8", children: /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "max-w-4xl mx-auto", children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex flex-col md:flex-row gap-4", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex-1 relative", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx(Search, { className: "absolute left-3 top-1/2 transform -translate-y-1/2 w-4 h-4 text-muted-foreground" }),
        /* @__PURE__ */ jsxRuntimeExports.jsx(
          Input,
          {
            placeholder: "Search templates...",
            value: searchTerm,
            onChange: (e) => setSearchTerm(e.target.value),
            className: "pl-10"
          }
        )
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsxs(Select, { value: selectedCategory, onValueChange: setSelectedCategory, children: [
        /* @__PURE__ */ jsxRuntimeExports.jsxs(SelectTrigger, { className: "w-full md:w-48", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx(Filter, { className: "w-4 h-4 mr-2" }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(SelectValue, { placeholder: "Filter by category" })
        ] }),
        /* @__PURE__ */ jsxRuntimeExports.jsx(SelectContent, { children: categories.map((category) => /* @__PURE__ */ jsxRuntimeExports.jsx(SelectItem, { value: category.value, children: category.label }, category.value)) })
      ] })
    ] }) }) }),
    /* @__PURE__ */ jsxRuntimeExports.jsxs("section", { className: "container mx-auto px-4 py-12 md:py-20", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6 md:gap-8", children: filteredTemplates.map((template) => /* @__PURE__ */ jsxRuntimeExports.jsxs(Card, { className: "hover:shadow-lg transition-shadow group", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsxs(CardHeader, { children: [
          /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center justify-between mb-4", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: `w-10 h-10 bg-gradient-to-r ${template.color} rounded-lg flex items-center justify-center`, children: /* @__PURE__ */ jsxRuntimeExports.jsx(Mail, { className: "w-5 h-5 text-white" }) }),
            /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center space-x-2", children: [
              /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center", children: [
                /* @__PURE__ */ jsxRuntimeExports.jsx(Star, { className: "w-4 h-4 text-yellow-400 fill-current" }),
                /* @__PURE__ */ jsxRuntimeExports.jsx("span", { className: "text-sm font-medium ml-1", children: template.rating })
              ] }),
              /* @__PURE__ */ jsxRuntimeExports.jsxs(Badge, { variant: "secondary", className: "text-xs", children: [
                template.downloads,
                " downloads"
              ] })
            ] })
          ] }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(CardTitle, { className: "text-lg md:text-xl", children: template.name }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(CardDescription, { className: "text-sm md:text-base", children: template.description })
        ] }),
        /* @__PURE__ */ jsxRuntimeExports.jsxs(CardContent, { className: "space-y-4", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "bg-muted/50 rounded-lg p-3", children: /* @__PURE__ */ jsxRuntimeExports.jsxs("p", { className: "text-sm text-muted-foreground italic", children: [
            '"',
            template.preview,
            '..."'
          ] }) }),
          /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "flex flex-wrap gap-2", children: template.tags.map((tag, index) => /* @__PURE__ */ jsxRuntimeExports.jsx(Badge, { variant: "outline", className: "text-xs", children: tag }, index)) }),
          /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex space-x-2", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsxs(Button, { variant: "outline", size: "sm", className: "flex-1", children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx(Eye, { className: "w-4 h-4 mr-2" }),
              "Preview"
            ] }),
            /* @__PURE__ */ jsxRuntimeExports.jsxs(Button, { size: "sm", className: "flex-1 bg-gradient-to-r from-flashcore-purple to-flashcore-green", children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx(Download, { className: "w-4 h-4 mr-2" }),
              "Use Template"
            ] })
          ] })
        ] })
      ] }, template.id)) }),
      filteredTemplates.length === 0 && /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "text-center py-12", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx(Mail, { className: "w-16 h-16 text-muted-foreground mx-auto mb-4" }),
        /* @__PURE__ */ jsxRuntimeExports.jsx("h3", { className: "text-xl font-semibold mb-2", children: "No templates found" }),
        /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-muted-foreground", children: "Try adjusting your search terms or filter criteria." })
      ] })
    ] }),
    /* @__PURE__ */ jsxRuntimeExports.jsxs("section", { className: "container mx-auto px-4 py-12 md:py-20 bg-muted/20", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "text-center mb-12 md:mb-16", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx("h2", { className: "text-2xl md:text-3xl font-bold mb-4", children: "Template Categories" }),
        /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-muted-foreground max-w-2xl mx-auto", children: "Find the perfect template for every type of communication." })
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 md:gap-8 max-w-6xl mx-auto", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsxs(Card, { className: "text-center hover:shadow-lg transition-shadow", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsxs(CardHeader, { children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "w-12 h-12 bg-gradient-to-r from-flashcore-purple to-flashcore-green rounded-lg flex items-center justify-center mx-auto mb-4", children: /* @__PURE__ */ jsxRuntimeExports.jsx(Users, { className: "w-6 h-6 text-white" }) }),
            /* @__PURE__ */ jsxRuntimeExports.jsx(CardTitle, { className: "text-lg", children: "Welcome Emails" })
          ] }),
          /* @__PURE__ */ jsxRuntimeExports.jsxs(CardContent, { children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-sm text-muted-foreground mb-4", children: "Onboard new customers with professional welcome emails." }),
            /* @__PURE__ */ jsxRuntimeExports.jsx(Badge, { variant: "secondary", children: "24 templates" })
          ] })
        ] }),
        /* @__PURE__ */ jsxRuntimeExports.jsxs(Card, { className: "text-center hover:shadow-lg transition-shadow", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsxs(CardHeader, { children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "w-12 h-12 bg-gradient-to-r from-flashcore-green to-flashcore-purple rounded-lg flex items-center justify-center mx-auto mb-4", children: /* @__PURE__ */ jsxRuntimeExports.jsx(CreditCard, { className: "w-6 h-6 text-white" }) }),
            /* @__PURE__ */ jsxRuntimeExports.jsx(CardTitle, { className: "text-lg", children: "Billing & Invoices" })
          ] }),
          /* @__PURE__ */ jsxRuntimeExports.jsxs(CardContent, { children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-sm text-muted-foreground mb-4", children: "Professional billing and invoice email templates." }),
            /* @__PURE__ */ jsxRuntimeExports.jsx(Badge, { variant: "secondary", children: "18 templates" })
          ] })
        ] }),
        /* @__PURE__ */ jsxRuntimeExports.jsxs(Card, { className: "text-center hover:shadow-lg transition-shadow", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsxs(CardHeader, { children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "w-12 h-12 bg-gradient-to-r from-flashcore-orange to-flashcore-purple rounded-lg flex items-center justify-center mx-auto mb-4", children: /* @__PURE__ */ jsxRuntimeExports.jsx(Receipt, { className: "w-6 h-6 text-white" }) }),
            /* @__PURE__ */ jsxRuntimeExports.jsx(CardTitle, { className: "text-lg", children: "Receipts" })
          ] }),
          /* @__PURE__ */ jsxRuntimeExports.jsxs(CardContent, { children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-sm text-muted-foreground mb-4", children: "Clear and detailed payment receipt templates." }),
            /* @__PURE__ */ jsxRuntimeExports.jsx(Badge, { variant: "secondary", children: "15 templates" })
          ] })
        ] }),
        /* @__PURE__ */ jsxRuntimeExports.jsxs(Card, { className: "text-center hover:shadow-lg transition-shadow", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsxs(CardHeader, { children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "w-12 h-12 bg-gradient-to-r from-blue-500 to-purple-500 rounded-lg flex items-center justify-center mx-auto mb-4", children: /* @__PURE__ */ jsxRuntimeExports.jsx(Calendar, { className: "w-6 h-6 text-white" }) }),
            /* @__PURE__ */ jsxRuntimeExports.jsx(CardTitle, { className: "text-lg", children: "Marketing" })
          ] }),
          /* @__PURE__ */ jsxRuntimeExports.jsxs(CardContent, { children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-sm text-muted-foreground mb-4", children: "Engaging marketing and newsletter templates." }),
            /* @__PURE__ */ jsxRuntimeExports.jsx(Badge, { variant: "secondary", children: "32 templates" })
          ] })
        ] })
      ] })
    ] }),
    /* @__PURE__ */ jsxRuntimeExports.jsx("section", { className: "container mx-auto px-4 py-12 md:py-20", children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "bg-gradient-to-r from-flashcore-purple to-flashcore-green rounded-2xl p-6 md:p-8 lg:p-12 text-center text-white", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsx("h2", { className: "text-2xl md:text-3xl font-bold mb-4", children: "Ready to Get Started?" }),
      /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-lg md:text-xl mb-6 md:mb-8 opacity-90", children: "Start using professional email templates to improve your communications." }),
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex flex-col sm:flex-row gap-4 justify-center", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx(Link, { to: "/register", children: /* @__PURE__ */ jsxRuntimeExports.jsxs(Button, { size: "lg", variant: "secondary", className: "bg-white text-flashcore-purple hover:bg-gray-100", children: [
          "Start Free Trial",
          /* @__PURE__ */ jsxRuntimeExports.jsx(ArrowRight, { className: "w-4 h-4 ml-2" })
        ] }) }),
        /* @__PURE__ */ jsxRuntimeExports.jsx(Link, { to: "/contact", children: /* @__PURE__ */ jsxRuntimeExports.jsx(Button, { size: "lg", variant: "outline", className: "border-white text-white hover:bg-white hover:text-flashcore-purple", children: "Contact Sales" }) })
      ] })
    ] }) })
  ] });
};
export {
  TemplatesPage as default
};
//# sourceMappingURL=TemplatesPage-BU15W6sZ.js.map
