import { r as reactExports, j as jsxRuntimeExports, L as Layout, d as Card, g as CardHeader, h as CardTitle, i as CardDescription, e as CardContent, C as Check, X, B as Button, A as ArrowRight, a as apiService } from "./index-lF0PjX8A.js";
import { u as useSubscriptionStatusPhp } from "./useSubscriptionStatusPhp-S14wlnu4.js";
import "./useQuery-C4AinbRC.js";
const SubscriptionPage = () => {
  useSubscriptionStatusPhp();
  const [plans, setPlans] = reactExports.useState([]);
  const [loading, setLoading] = reactExports.useState(true);
  reactExports.useEffect(() => {
    const loadPlans = async () => {
      try {
        const response = await apiService.getPricingPlans();
        if (response.data) {
          setPlans(response.data);
        }
      } catch (error) {
        console.error("Failed to load pricing plans", error);
      } finally {
        setLoading(false);
      }
    };
    loadPlans();
  }, []);
  if (loading) {
    return /* @__PURE__ */ jsxRuntimeExports.jsx(Layout, { children: /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "flex justify-center items-center h-[50vh]", children: /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "animate-spin rounded-full h-12 w-12 border-t-2 border-b-2 border-primary" }) }) });
  }
  return /* @__PURE__ */ jsxRuntimeExports.jsx(Layout, { children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "space-y-6", children: [
    /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "flex flex-col sm:flex-row sm:items-center sm:justify-between gap-4", children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { children: [
      /* @__PURE__ */ jsxRuntimeExports.jsx("h1", { className: "text-3xl font-bold", children: "Subscription Plans" }),
      /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-muted-foreground", children: "Manage your subscription and billing details." })
    ] }) }),
    /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "grid grid-cols-1 md:grid-cols-3 gap-8 max-w-6xl mx-auto pt-8", children: plans.map((plan, index) => /* @__PURE__ */ jsxRuntimeExports.jsxs(
      Card,
      {
        className: `relative overflow-hidden transition-all duration-300 hover:shadow-2xl hover:-translate-y-1 ${plan.popular ? "border-2 border-flashcore-purple bg-gradient-to-b from-background to-flashcore-purple/5" : "border border-border/50 bg-card/50 backdrop-blur-sm"}`,
        children: [
          plan.popular && /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "absolute top-0 right-0", children: /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "bg-gradient-to-l from-flashcore-purple to-flashcore-pink text-white text-xs font-bold px-3 py-1 rounded-bl-lg shadow-md", children: "MOST POPULAR" }) }),
          /* @__PURE__ */ jsxRuntimeExports.jsxs(CardHeader, { className: "text-left pb-4", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx(CardTitle, { className: "text-2xl font-bold", children: plan.name }),
            /* @__PURE__ */ jsxRuntimeExports.jsx(CardDescription, { className: "text-base mt-2 mb-4", children: plan.description }),
            /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-baseline", children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx("span", { className: `text-4xl font-extrabold bg-clip-text text-transparent bg-gradient-to-r ${plan.color}`, children: plan.price }),
              /* @__PURE__ */ jsxRuntimeExports.jsx("span", { className: "ml-2 text-muted-foreground", children: "/month" })
            ] })
          ] }),
          /* @__PURE__ */ jsxRuntimeExports.jsxs(CardContent, { className: "space-y-6", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "space-y-4", children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "text-sm font-semibold text-foreground/80 uppercase tracking-wider", children: "Features" }),
              plan.features.map((feature, featureIndex) => /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-start gap-3", children: [
                /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "mt-1", children: /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: `p-0.5 rounded-full bg-gradient-to-r ${plan.color} bg-opacity-10`, children: /* @__PURE__ */ jsxRuntimeExports.jsx(Check, { className: "w-3 h-3 text-white" }) }) }),
                /* @__PURE__ */ jsxRuntimeExports.jsx("span", { className: "text-sm text-muted-foreground leading-tight", children: feature })
              ] }, featureIndex)),
              plan.notIncluded && plan.notIncluded.length > 0 && /* @__PURE__ */ jsxRuntimeExports.jsxs(jsxRuntimeExports.Fragment, { children: [
                /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "my-4 border-t border-border/50" }),
                plan.notIncluded.map((feature, featureIndex) => /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center gap-3 opacity-60", children: [
                  /* @__PURE__ */ jsxRuntimeExports.jsx(X, { className: "w-4 h-4 text-muted-foreground flex-shrink-0" }),
                  /* @__PURE__ */ jsxRuntimeExports.jsx("span", { className: "text-sm text-muted-foreground", children: feature })
                ] }, featureIndex))
              ] })
            ] }),
            /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "pt-4", children: /* @__PURE__ */ jsxRuntimeExports.jsxs(
              Button,
              {
                className: `w-full font-semibold shadow-lg transition-all duration-300 ${plan.popular ? "bg-gradient-to-r from-flashcore-purple to-flashcore-pink hover:opacity-90 text-white" : "hover:bg-primary/90"}`,
                variant: plan.popular ? "default" : "outline",
                onClick: () => {
                  if (plan.buttonText !== "Current Plan") {
                    window.location.hash = `#/checkout?plan=${plan.name.toLowerCase()}`;
                  }
                },
                disabled: plan.buttonText === "Current Plan",
                children: [
                  plan.buttonText === "Contact Sales" ? "Contact Sales" : plan.buttonText === "Current Plan" ? "Current Plan" : `Get ${plan.name}`,
                  plan.buttonText !== "Current Plan" && /* @__PURE__ */ jsxRuntimeExports.jsx(ArrowRight, { className: "w-4 h-4 ml-2" })
                ]
              }
            ) })
          ] })
        ]
      },
      index
    )) })
  ] }) });
};
export {
  SubscriptionPage as default
};
//# sourceMappingURL=SubscriptionPage-DTgQdZnw.js.map
