import { j as jsxRuntimeExports, L as Layout, d as Card, g as CardHeader, h as CardTitle, i as CardDescription, e as CardContent, C as Check, X, B as Button, A as ArrowRight } from "./index-D2CUDDtA.js";
import { B as Badge } from "./badge-CnK8C-4m.js";
import { u as useSubscriptionStatusPhp } from "./useSubscriptionStatusPhp-Bg-x-LWr.js";
import { S as Star } from "./star-CoBm8OrW.js";
import "./useQuery-CEkjPZZe.js";
const SubscriptionPage = () => {
  useSubscriptionStatusPhp();
  const plans = [
    {
      name: "Basic",
      price: "$9.99",
      description: "Perfect for small businesses",
      features: [
        "1,000 emails per month",
        "Basic email templates",
        "Email analytics",
        "24/7 support",
        "Standard delivery",
        "Basic reporting"
      ],
      notIncluded: [
        "Advanced templates",
        "Custom branding",
        "API access",
        "Priority support"
      ],
      color: "from-flashcore-purple to-flashcore-green",
      popular: false,
      buttonText: "Current Plan"
      // Assuming basic is not free, logic might differ
    },
    {
      name: "Pro",
      price: "$29.99",
      description: "For growing businesses",
      features: [
        "10,000 emails per month",
        "Advanced email templates",
        "Advanced analytics",
        "Priority support",
        "Custom branding",
        "Advanced reporting",
        "A/B testing",
        "Automation workflows"
      ],
      notIncluded: [
        "Unlimited emails",
        "Dedicated support",
        "Custom integrations"
      ],
      color: "from-flashcore-green to-flashcore-purple",
      popular: true,
      buttonText: "Upgrade to Pro"
    },
    {
      name: "Enterprise",
      price: "$99.99",
      description: "For large organizations",
      features: [
        "Unlimited emails",
        "Custom email templates",
        "Advanced reporting",
        "Dedicated support",
        "API access",
        "Custom integrations",
        "White-label options",
        "Advanced security"
      ],
      notIncluded: [],
      color: "from-flashcore-orange to-flashcore-purple",
      popular: false,
      buttonText: "Contact Sales"
    }
  ];
  return /* @__PURE__ */ jsxRuntimeExports.jsx(Layout, { children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "space-y-6", children: [
    /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "flex flex-col sm:flex-row sm:items-center sm:justify-between gap-4", children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { children: [
      /* @__PURE__ */ jsxRuntimeExports.jsx("h1", { className: "text-3xl font-bold", children: "Subscription Plans" }),
      /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-muted-foreground", children: "Manage your subscription and billing details." })
    ] }) }),
    /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "grid grid-cols-1 md:grid-cols-3 gap-6 md:gap-8 max-w-6xl mx-auto pt-4", children: plans.map((plan, index) => /* @__PURE__ */ jsxRuntimeExports.jsxs(Card, { className: `relative ${plan.popular ? "border-2 border-flashcore-purple scale-105" : ""}`, children: [
      plan.popular && /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "absolute -top-3 left-1/2 transform -translate-x-1/2", children: /* @__PURE__ */ jsxRuntimeExports.jsxs(Badge, { className: "bg-flashcore-purple text-white", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx(Star, { className: "w-3 h-3 mr-1" }),
        "Most Popular"
      ] }) }),
      /* @__PURE__ */ jsxRuntimeExports.jsxs(CardHeader, { className: "text-center", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx(CardTitle, { className: "text-xl md:text-2xl", children: plan.name }),
        /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "text-3xl md:text-4xl font-bold bg-gradient-to-r bg-clip-text text-transparent", style: { backgroundImage: `linear-gradient(to right, var(--tw-gradient-stops))` }, children: [
          plan.price,
          /* @__PURE__ */ jsxRuntimeExports.jsx("span", { className: "text-base md:text-lg text-muted-foreground", children: "/month" })
        ] }),
        /* @__PURE__ */ jsxRuntimeExports.jsx(CardDescription, { children: plan.description })
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsxs(CardContent, { className: "space-y-6", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "space-y-3", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx("h4", { className: "font-semibold text-sm text-muted-foreground uppercase tracking-wide", children: "What's included:" }),
          plan.features.map((feature, featureIndex) => /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx(Check, { className: "w-4 h-4 text-green-500 mr-3 flex-shrink-0" }),
            /* @__PURE__ */ jsxRuntimeExports.jsx("span", { className: "text-sm md:text-base", children: feature })
          ] }, featureIndex))
        ] }),
        plan.notIncluded.length > 0 && /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "space-y-3", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx("h4", { className: "font-semibold text-sm text-muted-foreground uppercase tracking-wide", children: "Not included:" }),
          plan.notIncluded.map((feature, featureIndex) => /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx(X, { className: "w-4 h-4 text-red-500 mr-3 flex-shrink-0" }),
            /* @__PURE__ */ jsxRuntimeExports.jsx("span", { className: "text-sm md:text-base text-muted-foreground", children: feature })
          ] }, featureIndex))
        ] }),
        /* @__PURE__ */ jsxRuntimeExports.jsxs(
          Button,
          {
            className: `w-full bg-gradient-to-r ${plan.color}`,
            variant: plan.popular ? "default" : "outline",
            children: [
              plan.buttonText,
              plan.popular && /* @__PURE__ */ jsxRuntimeExports.jsx(ArrowRight, { className: "w-4 h-4 ml-2" })
            ]
          }
        )
      ] })
    ] }, index)) })
  ] }) });
};
export {
  SubscriptionPage as default
};
//# sourceMappingURL=SubscriptionPage-BHBgSoXd.js.map
