import { c as createLucideIcon, r as reactExports, b as useToast, j as jsxRuntimeExports, L as Layout, i as Card, l as CardHeader, m as CardTitle, k as CardContent, B as Button, T as TrendingUp, w as Lock, b1 as Info, D as Dialog, E as DialogContent, F as DialogHeader, G as DialogTitle, t as Label, I as Input, J as DialogFooter } from "./index-GlGoHQS3.js";
import { C as Coins } from "./coins-oiIje05R.js";
import { Z as Zap } from "./zap-DzaCSTJR.js";
import { S as Share2 } from "./share-2-Vth6To96.js";
import { S as ShieldCheck } from "./shield-check-0Xl-UF83.js";
/**
 * @license lucide-react v0.462.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */
const Timer = createLucideIcon("Timer", [
  ["line", { x1: "10", x2: "14", y1: "2", y2: "2", key: "14vaq8" }],
  ["line", { x1: "12", x2: "15", y1: "14", y2: "11", key: "17fdiu" }],
  ["circle", { cx: "12", cy: "14", r: "8", key: "1e1u0o" }]
]);
const StakingPage = () => {
  const [pools, setPools] = reactExports.useState([]);
  const [stakes, setStakes] = reactExports.useState([]);
  const [loading, setLoading] = reactExports.useState(true);
  const { toast } = useToast();
  const [modalOpen, setModalOpen] = reactExports.useState(false);
  const [selectedPool, setSelectedPool] = reactExports.useState(null);
  const [amount, setAmount] = reactExports.useState("");
  const [actionLoading, setActionLoading] = reactExports.useState(false);
  const fetchData = async () => {
    try {
      setLoading(true);
      const response = await fetch("/backend/api/staking.php", {
        headers: {
          "Authorization": `Bearer ${localStorage.getItem("token")}`
        }
      });
      const result = await response.json();
      if (result.status === "success") {
        setPools(result.data.pools);
        setStakes(result.data.stakes);
      }
    } catch (error) {
      console.error("Failed to fetch staking data", error);
    } finally {
      setLoading(false);
    }
  };
  reactExports.useEffect(() => {
    fetchData();
  }, []);
  const handleStake = async () => {
    if (!amount || parseFloat(amount) <= 0) {
      toast({ title: "Invalid Amount", variant: "destructive" });
      return;
    }
    try {
      setActionLoading(true);
      const response = await fetch("/backend/api/staking.php", {
        method: "POST",
        headers: {
          "Content-Type": "application/json",
          "Authorization": `Bearer ${localStorage.getItem("token")}`
        },
        body: JSON.stringify({
          action: "stake",
          pool_id: selectedPool.id,
          amount: parseFloat(amount)
        })
      });
      const result = await response.json();
      if (result.status === "success") {
        toast({ title: "Success", description: result.message });
        setModalOpen(false);
        setAmount("");
        fetchData();
      } else {
        toast({ title: "Error", description: result.message, variant: "destructive" });
      }
    } catch (error) {
      toast({ title: "Error", description: "Transaction failed", variant: "destructive" });
    } finally {
      setActionLoading(false);
    }
  };
  const handleClaim = async (stakeId) => {
    try {
      const response = await fetch("/backend/api/staking.php", {
        method: "POST",
        headers: {
          "Content-Type": "application/json",
          "Authorization": `Bearer ${localStorage.getItem("token")}`
        },
        body: JSON.stringify({
          action: "claim",
          stake_id: stakeId
        })
      });
      const result = await response.json();
      if (result.status === "success") {
        toast({ title: "Success", description: "Rewards claimed!" });
        fetchData();
      }
    } catch (error) {
      toast({ title: "Error", description: "Claim failed", variant: "destructive" });
    }
  };
  const handleUnstake = async (stakeId) => {
    try {
      const response = await fetch("/backend/api/staking.php", {
        method: "POST",
        headers: {
          "Content-Type": "application/json",
          "Authorization": `Bearer ${localStorage.getItem("token")}`
        },
        body: JSON.stringify({
          action: "unstake",
          stake_id: stakeId
        })
      });
      const result = await response.json();
      if (result.status === "success") {
        toast({ title: "Success", description: result.message });
        fetchData();
      } else {
        toast({ title: "Error", description: result.message, variant: "destructive" });
      }
    } catch (error) {
      toast({ title: "Error", description: "Unstake failed", variant: "destructive" });
    }
  };
  const totalRewards = stakes.reduce((acc, curr) => acc + (curr.pending_reward || 0), 0);
  const totalStakedValue = stakes.reduce((acc, curr) => acc + parseFloat(curr.amount), 0);
  return /* @__PURE__ */ jsxRuntimeExports.jsxs(Layout, { children: [
    /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "space-y-8 animate-in fade-in duration-500 pb-12", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "flex flex-col md:flex-row justify-between items-start md:items-center gap-4", children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx("h1", { className: "text-3xl font-bold bg-gradient-to-r from-flashcore-purple to-flashcore-green bg-clip-text text-transparent italic", children: "Elite Staking" }),
        /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-muted-foreground", children: "Premium yield pools for high-octane growth" })
      ] }) }),
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "grid grid-cols-1 md:grid-cols-3 gap-6", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsxs(Card, { className: "bg-gradient-to-br from-background to-flashcore-purple/10 border-border/50 shadow-sm transition-all hover:shadow-flashcore-purple/10", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx(CardHeader, { className: "pb-2", children: /* @__PURE__ */ jsxRuntimeExports.jsx(CardTitle, { className: "text-xs font-black text-muted-foreground uppercase tracking-widest", children: "Total Staked" }) }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(CardContent, { children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "text-3xl font-bold flex items-center gap-2", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx(Coins, { className: "w-6 h-6 text-flashcore-purple" }),
            totalStakedValue.toFixed(4),
            " ",
            /* @__PURE__ */ jsxRuntimeExports.jsx("span", { className: "text-sm font-normal text-muted-foreground", children: "Assets" })
          ] }) })
        ] }),
        /* @__PURE__ */ jsxRuntimeExports.jsxs(Card, { className: "bg-gradient-to-br from-background to-flashcore-green/10 border-border/50 shadow-sm transition-all hover:shadow-flashcore-green/10", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx(CardHeader, { className: "pb-2", children: /* @__PURE__ */ jsxRuntimeExports.jsx(CardTitle, { className: "text-xs font-black text-muted-foreground uppercase tracking-widest", children: "Earned Rewards" }) }),
          /* @__PURE__ */ jsxRuntimeExports.jsxs(CardContent, { className: "space-y-2", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "text-3xl font-bold text-flashcore-green", children: [
              "$",
              totalRewards.toFixed(6)
            ] }),
            /* @__PURE__ */ jsxRuntimeExports.jsxs(Button, { onClick: () => {
              var _a;
              return handleClaim((_a = stakes[0]) == null ? void 0 : _a.id);
            }, disabled: !stakes.length || totalRewards === 0, size: "sm", className: "w-full bg-flashcore-green/20 text-flashcore-green hover:bg-flashcore-green/30 border-flashcore-green/20 transition-all", children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx(Zap, { className: "w-4 h-4 mr-2" }),
              " Claim All Rewards"
            ] })
          ] })
        ] }),
        /* @__PURE__ */ jsxRuntimeExports.jsxs(Card, { className: "bg-gradient-to-br from-background to-orange-500/10 border-border/50 shadow-sm transition-all hover:shadow-orange-500/10", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx(CardHeader, { className: "pb-2", children: /* @__PURE__ */ jsxRuntimeExports.jsx(CardTitle, { className: "text-xs font-black text-muted-foreground uppercase tracking-widest", children: "Avg. Network APR" }) }),
          /* @__PURE__ */ jsxRuntimeExports.jsxs(CardContent, { children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "text-3xl font-bold text-orange-500", children: "14.65%" }),
            /* @__PURE__ */ jsxRuntimeExports.jsxs("p", { className: "text-xs text-muted-foreground mt-1 flex items-center gap-1", children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx(TrendingUp, { className: "w-3 h-3" }),
              " Real-time network health"
            ] })
          ] })
        ] })
      ] }),
      stakes.length > 0 && /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "space-y-4", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsxs("h2", { className: "text-lg font-bold flex items-center gap-2", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx(Lock, { className: "w-5 h-5 text-flashcore-purple" }),
          " My Staked Positions"
        ] }),
        /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "grid grid-cols-1 md:grid-cols-2 gap-4", children: stakes.map((stake) => /* @__PURE__ */ jsxRuntimeExports.jsx(Card, { className: "border-border/30 bg-muted/20 backdrop-blur-sm group hover:border-flashcore-purple/50 transition-all", children: /* @__PURE__ */ jsxRuntimeExports.jsxs(CardContent, { className: "p-4", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex justify-between items-start mb-4", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center gap-3", children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: `w-10 h-10 rounded-xl bg-gradient-to-br ${stake.color} flex items-center justify-center text-white shadow-lg`, children: stake.symbol[0] }),
              /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { children: [
                /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "font-bold", children: [
                  stake.amount,
                  " ",
                  stake.symbol
                ] }),
                /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "text-xs text-muted-foreground uppercase font-black tracking-tight", children: stake.pool_name })
              ] })
            ] }),
            /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "text-right", children: [
              /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "text-xs font-bold text-flashcore-green", children: [
                (stake.apr * 100).toFixed(2),
                "% APR"
              ] }),
              /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "text-[10px] text-muted-foreground uppercase", children: "Rate Locked" })
            ] })
          ] }),
          /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "space-y-3", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex justify-between text-xs items-center", children: [
              /* @__PURE__ */ jsxRuntimeExports.jsxs("span", { className: "text-muted-foreground italic flex items-center gap-1", children: [
                /* @__PURE__ */ jsxRuntimeExports.jsx(Timer, { className: "w-3 h-3" }),
                " Unlocks in:"
              ] }),
              /* @__PURE__ */ jsxRuntimeExports.jsx("span", { className: "font-mono font-bold text-orange-400", children: new Date(stake.unlock_at).toLocaleDateString() })
            ] }),
            /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex gap-2", children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx(Button, { onClick: () => handleClaim(stake.id), size: "sm", variant: "outline", className: "flex-1 border-flashcore-green/50 text-flashcore-green hover:bg-flashcore-green/10", children: "Claim Rewards" }),
              /* @__PURE__ */ jsxRuntimeExports.jsx(Button, { onClick: () => handleUnstake(stake.id), size: "sm", variant: "ghost", className: "flex-1 text-red-400 hover:bg-red-400/10", children: "Unstake" })
            ] })
          ] })
        ] }) }, stake.id)) })
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsxs(Card, { className: "border-border/50 bg-background/50 backdrop-blur-sm shadow-xl overflow-hidden", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsxs(CardHeader, { className: "flex flex-row items-center justify-between border-b border-border/10 bg-muted/30", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsxs(CardTitle, { className: "flex items-center gap-2 text-lg", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx(Share2, { className: "w-5 h-5 text-flashcore-green" }),
            "Live Staking Pools"
          ] }),
          /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "text-[10px] font-black text-flashcore-purple uppercase tracking-widest animate-pulse", children: "Network Active" })
        ] }),
        /* @__PURE__ */ jsxRuntimeExports.jsx(CardContent, { className: "p-0", children: /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "overflow-x-auto", children: /* @__PURE__ */ jsxRuntimeExports.jsxs("table", { className: "w-full text-left border-collapse", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx("thead", { children: /* @__PURE__ */ jsxRuntimeExports.jsxs("tr", { className: "bg-muted/10 text-[10px] font-black text-muted-foreground uppercase tracking-widest border-b border-border/10", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx("th", { className: "px-6 py-4", children: "Validator / Pool" }),
            /* @__PURE__ */ jsxRuntimeExports.jsx("th", { className: "px-6 py-4 text-right", children: "Yield (APR)" }),
            /* @__PURE__ */ jsxRuntimeExports.jsx("th", { className: "px-6 py-4 text-right", children: "Lock Period" }),
            /* @__PURE__ */ jsxRuntimeExports.jsx("th", { className: "px-6 py-4 text-right", children: "TVL" }),
            /* @__PURE__ */ jsxRuntimeExports.jsx("th", { className: "px-6 py-4 text-center", children: "Action" })
          ] }) }),
          /* @__PURE__ */ jsxRuntimeExports.jsx("tbody", { className: "divide-y divide-border/20", children: pools.map((pool) => /* @__PURE__ */ jsxRuntimeExports.jsxs("tr", { className: "hover:bg-muted/10 transition-colors group", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx("td", { className: "px-6 py-5", children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center gap-3", children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: `w-10 h-10 rounded-2xl bg-gradient-to-br ${pool.color} flex items-center justify-center shadow-lg text-white font-bold text-lg`, children: pool.symbol[0] }),
              /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { children: [
                /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "font-bold text-base", children: pool.name }),
                /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "text-xs text-muted-foreground font-mono italic", children: [
                  pool.symbol,
                  " Primary Pool"
                ] })
              ] })
            ] }) }),
            /* @__PURE__ */ jsxRuntimeExports.jsxs("td", { className: "px-6 py-5 text-right", children: [
              /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "font-black text-xl text-flashcore-green", children: [
                (pool.apr * 100).toFixed(2),
                "%"
              ] }),
              /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "text-[10px] text-muted-foreground uppercase tracking-widest font-bold", children: "Auto-Compounding" })
            ] }),
            /* @__PURE__ */ jsxRuntimeExports.jsxs("td", { className: "px-6 py-5 text-right", children: [
              /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "font-bold text-orange-400", children: [
                pool.lock_period_days,
                " Days"
              ] }),
              /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "text-[10px] text-muted-foreground uppercase tracking-tight", children: "Hard-Lock Duration" })
            ] }),
            /* @__PURE__ */ jsxRuntimeExports.jsxs("td", { className: "px-6 py-5 text-right font-mono", children: [
              /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "text-sm font-medium", children: [
                parseFloat(pool.total_staked).toLocaleString(),
                " ",
                pool.symbol
              ] }),
              /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "text-[10px] text-muted-foreground uppercase tracking-tight", children: "Total Volume" })
            ] }),
            /* @__PURE__ */ jsxRuntimeExports.jsx("td", { className: "px-6 py-5 text-center", children: /* @__PURE__ */ jsxRuntimeExports.jsx(
              Button,
              {
                className: `h-10 px-6 bg-gradient-to-r ${pool.color} text-white border-0 hover:opacity-90 font-bold shadow-md shadow-primary/20 scale-100 group-hover:scale-105 transition-all`,
                onClick: () => {
                  setSelectedPool(pool);
                  setModalOpen(true);
                },
                children: "Stake Assets"
              }
            ) })
          ] }, pool.id)) })
        ] }) }) })
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "grid grid-cols-1 md:grid-cols-2 gap-6", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx(Card, { className: "border-border/30 bg-background/20 backdrop-blur-sm p-4", children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex gap-4", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx(ShieldCheck, { className: "w-8 h-8 text-flashcore-purple shrink-0" }),
          /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "space-y-1", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx("h4", { className: "text-sm font-bold uppercase tracking-widest", children: "Protocol Protection" }),
            /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-xs text-muted-foreground leading-relaxed", children: "FlashCORE staking uses non-custodial smart contract logic. Your principal is secured by multi-sig validator nodes with 99.99% uptime guarantee." })
          ] })
        ] }) }),
        /* @__PURE__ */ jsxRuntimeExports.jsx(Card, { className: "border-border/30 bg-background/20 backdrop-blur-sm p-4", children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex gap-4", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx(Info, { className: "w-8 h-8 text-flashcore-green shrink-0" }),
          /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "space-y-1", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx("h4", { className: "text-sm font-bold uppercase tracking-widest", children: "Dynamic APR" }),
            /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-xs text-muted-foreground leading-relaxed", children: "Yield rates are algorithmically adjusted every 24 hours based on pool utilization and network congestion to ensure long-term sustainability." })
          ] })
        ] }) })
      ] })
    ] }),
    /* @__PURE__ */ jsxRuntimeExports.jsx(Dialog, { open: modalOpen, onOpenChange: setModalOpen, children: /* @__PURE__ */ jsxRuntimeExports.jsxs(DialogContent, { className: "sm:max-w-md bg-background/95 backdrop-blur-2xl border-border/50 shadow-2xl", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsx(DialogHeader, { children: selectedPool && /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center gap-3 mb-2", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: `w-12 h-12 rounded-2xl bg-gradient-to-br ${selectedPool.color} flex items-center justify-center text-2xl shadow-xl text-white`, children: /* @__PURE__ */ jsxRuntimeExports.jsx(Lock, {}) }),
        /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { children: [
          /* @__PURE__ */ jsxRuntimeExports.jsxs(DialogTitle, { className: "text-xl font-bold", children: [
            "Stake ",
            selectedPool.symbol
          ] }),
          /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-sm text-muted-foreground", children: selectedPool.name })
        ] })
      ] }) }),
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "space-y-6 py-6", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "space-y-2", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx(Label, { htmlFor: "stake-amount", className: "text-xs font-black uppercase tracking-widest text-muted-foreground", children: "Amount to Lock" }),
          /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "relative", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx(
              Input,
              {
                id: "stake-amount",
                type: "number",
                placeholder: "0.00",
                value: amount,
                onChange: (e) => setAmount(e.target.value),
                className: "pr-20 h-14 text-xl font-bold bg-muted/30 border-border/50"
              }
            ),
            /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "absolute right-4 top-1/2 -translate-y-1/2 font-black text-flashcore-purple", children: selectedPool == null ? void 0 : selectedPool.symbol })
          ] }),
          /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex justify-between text-[10px] font-bold text-muted-foreground uppercase px-1", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsxs("span", { children: [
              "Min: ",
              selectedPool == null ? void 0 : selectedPool.min_stake
            ] }),
            /* @__PURE__ */ jsxRuntimeExports.jsx("span", { className: "text-flashcore-green", children: "Balance: Fetching..." })
          ] })
        ] }),
        /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "p-4 rounded-2xl bg-muted/50 border border-border/30 space-y-3", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex justify-between text-sm", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx("span", { className: "text-muted-foreground font-medium italic", children: "Estimated Yearly Return" }),
            /* @__PURE__ */ jsxRuntimeExports.jsxs("span", { className: "text-flashcore-green font-black", children: [
              selectedPool ? (selectedPool.apr * 100).toFixed(2) : 0,
              "%"
            ] })
          ] }),
          /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex justify-between text-sm", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx("span", { className: "text-muted-foreground font-medium italic", children: "Lock Duration" }),
            /* @__PURE__ */ jsxRuntimeExports.jsxs("span", { className: "text-orange-500 font-black", children: [
              selectedPool == null ? void 0 : selectedPool.lock_period_days,
              " Days"
            ] })
          ] })
        ] })
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsxs(DialogFooter, { children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx(Button, { variant: "ghost", onClick: () => setModalOpen(false), disabled: actionLoading, className: "font-bold", children: "Cancel" }),
        /* @__PURE__ */ jsxRuntimeExports.jsx(
          Button,
          {
            onClick: handleStake,
            disabled: actionLoading,
            className: `flex-1 h-12 bg-gradient-to-r ${selectedPool == null ? void 0 : selectedPool.color} text-white border-0 hover:opacity-90 font-black italic tracking-widest uppercase shadow-xl`,
            children: actionLoading ? "Confirming..." : "Confirm Staking"
          }
        )
      ] })
    ] }) })
  ] });
};
export {
  StakingPage as default
};
//# sourceMappingURL=StakingPage-BZSu-dg8.js.map
