import { j as jsxRuntimeExports, d as Card, g as CardHeader, h as CardTitle, i as CardDescription, e as CardContent, C as Check, m as Link, B as Button, T as TrendingUp, S as Shield, A as ArrowRight } from "./index-lF0PjX8A.js";
import { B as Badge } from "./badge-CAfH9bmo.js";
import { T as Target } from "./target-CXCKIqjp.js";
import { S as Star } from "./star-Dge1E5KC.js";
import { Z as Zap } from "./zap-Bal8zz-e.js";
import { C as Clock } from "./clock-CBomnXQd.js";
import { U as Users } from "./users-D_atNPk8.js";
import { B as Building } from "./building-D0I4cV15.js";
import { S as ShoppingCart } from "./shopping-cart-BzsAtFlB.js";
import { R as Rocket } from "./rocket-BFA2Od7k.js";
const SolutionsPage = () => {
  const solutions = [
    {
      id: "small-business",
      title: "Small Business",
      description: "Perfect for growing businesses that need professional email automation",
      icon: Users,
      color: "from-blue-500 to-blue-600",
      features: [
        "Easy-to-use email templates",
        "Basic analytics and reporting",
        "Customer support",
        "Up to 10,000 emails/month",
        "Integration with popular tools"
      ],
      price: "Starting at $29/month",
      badge: "Most Popular",
      stats: {
        customers: "5,000+",
        emails: "1M+",
        satisfaction: "98%"
      }
    },
    {
      id: "enterprise",
      title: "Enterprise",
      description: "Advanced features for large organizations with complex email needs",
      icon: Building,
      color: "from-purple-500 to-purple-600",
      features: [
        "Advanced automation workflows",
        "Custom integrations",
        "Dedicated account manager",
        "Unlimited emails",
        "Advanced security features",
        "Custom reporting"
      ],
      price: "Custom pricing",
      badge: "Enterprise",
      stats: {
        customers: "500+",
        emails: "100M+",
        satisfaction: "99%"
      }
    },
    {
      id: "agencies",
      title: "Agencies",
      description: "Built for marketing agencies managing multiple client campaigns",
      icon: Target,
      color: "from-green-500 to-green-600",
      features: [
        "Multi-client management",
        "White-label solutions",
        "Advanced campaign tools",
        "Client reporting",
        "Team collaboration",
        "API access"
      ],
      price: "Starting at $99/month",
      badge: "Agency Focused",
      stats: {
        customers: "1,000+",
        emails: "50M+",
        satisfaction: "97%"
      }
    },
    {
      id: "ecommerce",
      title: "E-commerce",
      description: "Specialized email automation for online stores and retail",
      icon: ShoppingCart,
      color: "from-orange-500 to-orange-600",
      features: [
        "Abandoned cart recovery",
        "Product recommendations",
        "Order confirmation emails",
        "Customer segmentation",
        "Revenue tracking",
        "Shopify integration"
      ],
      price: "Starting at $49/month",
      badge: "E-commerce",
      stats: {
        customers: "2,000+",
        emails: "25M+",
        satisfaction: "96%"
      }
    },
    {
      id: "startups",
      title: "Startups",
      description: "Scalable solution for fast-growing startups and tech companies",
      icon: Rocket,
      color: "from-pink-500 to-pink-600",
      features: [
        "Rapid onboarding",
        "Scalable infrastructure",
        "Developer-friendly API",
        "Growth analytics",
        "A/B testing tools",
        "Startup-friendly pricing"
      ],
      price: "Starting at $19/month",
      badge: "Startup Ready",
      stats: {
        customers: "3,000+",
        emails: "15M+",
        satisfaction: "98%"
      }
    }
  ];
  const testimonials = [
    {
      name: "Sarah Johnson",
      role: "Marketing Director",
      company: "TechStart Inc.",
      solution: "Small Business",
      content: "FlashCore transformed our email marketing. We've seen a 300% increase in engagement and 150% more conversions.",
      rating: 5
    },
    {
      name: "Michael Chen",
      role: "CEO",
      company: "Global Retail Corp",
      solution: "Enterprise",
      content: "The enterprise features and dedicated support have been game-changing for our international operations.",
      rating: 5
    },
    {
      name: "Emily Rodriguez",
      role: "Agency Owner",
      company: "Digital Marketing Pro",
      solution: "Agencies",
      content: "Managing multiple clients has never been easier. The white-label features are exactly what we needed.",
      rating: 5
    }
  ];
  return /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "min-h-screen bg-background", children: [
    /* @__PURE__ */ jsxRuntimeExports.jsx("section", { className: "container mx-auto px-4 py-12 md:py-20 text-center", children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "max-w-4xl mx-auto", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsxs(Badge, { variant: "secondary", className: "mb-4", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx(Target, { className: "w-3 h-3 mr-1" }),
        "Business Solutions"
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsx("h1", { className: "text-3xl md:text-4xl lg:text-5xl font-bold mb-6 bg-gradient-to-r from-flashcore-purple to-flashcore-green bg-clip-text text-transparent", children: "Solutions for Every Business" }),
      /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-lg md:text-xl text-muted-foreground mb-8 max-w-2xl mx-auto", children: "From startups to enterprise, we have the perfect email automation solution to help your business grow and succeed." })
    ] }) }),
    /* @__PURE__ */ jsxRuntimeExports.jsx("section", { className: "container mx-auto px-4 py-12 md:py-20", children: /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6 md:gap-8", children: solutions.map((solution) => /* @__PURE__ */ jsxRuntimeExports.jsxs(Card, { className: "hover:shadow-lg transition-shadow group", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsxs(CardHeader, { children: [
        /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center justify-between mb-4", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: `w-12 h-12 bg-gradient-to-r ${solution.color} rounded-lg flex items-center justify-center`, children: /* @__PURE__ */ jsxRuntimeExports.jsx(solution.icon, { className: "w-6 h-6 text-white" }) }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(Badge, { className: "bg-flashcore-purple text-white text-xs", children: solution.badge })
        ] }),
        /* @__PURE__ */ jsxRuntimeExports.jsx(CardTitle, { className: "text-xl md:text-2xl", children: solution.title }),
        /* @__PURE__ */ jsxRuntimeExports.jsx(CardDescription, { className: "text-base", children: solution.description })
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsxs(CardContent, { className: "space-y-6", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "space-y-3", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx("h4", { className: "font-semibold text-sm", children: "Key Features:" }),
          /* @__PURE__ */ jsxRuntimeExports.jsx("ul", { className: "space-y-2", children: solution.features.map((feature, index) => /* @__PURE__ */ jsxRuntimeExports.jsxs("li", { className: "flex items-center text-sm text-muted-foreground", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx(Check, { className: "w-4 h-4 text-green-500 mr-2 flex-shrink-0" }),
            feature
          ] }, index)) })
        ] }),
        /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "space-y-3", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "text-lg font-bold text-flashcore-purple", children: solution.price }),
          /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "grid grid-cols-3 gap-4 text-center", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "text-lg font-bold", children: solution.stats.customers }),
              /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "text-xs text-muted-foreground", children: "Customers" })
            ] }),
            /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "text-lg font-bold", children: solution.stats.emails }),
              /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "text-xs text-muted-foreground", children: "Emails Sent" })
            ] }),
            /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "text-lg font-bold", children: solution.stats.satisfaction }),
              /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "text-xs text-muted-foreground", children: "Satisfaction" })
            ] })
          ] })
        ] }),
        /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex space-x-2", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx(Link, { to: `/solutions/${solution.id}`, className: "flex-1", children: /* @__PURE__ */ jsxRuntimeExports.jsx(Button, { variant: "outline", size: "sm", className: "w-full", children: "Learn More" }) }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(Link, { to: "/register", className: "flex-1", children: /* @__PURE__ */ jsxRuntimeExports.jsx(Button, { size: "sm", className: "w-full bg-gradient-to-r from-flashcore-purple to-flashcore-green", children: "Get Started" }) })
        ] })
      ] })
    ] }, solution.id)) }) }),
    /* @__PURE__ */ jsxRuntimeExports.jsx("section", { className: "container mx-auto px-4 py-12 md:py-20 bg-muted/20", children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "max-w-6xl mx-auto", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "text-center mb-12", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx("h2", { className: "text-2xl md:text-3xl font-bold mb-4", children: "Compare Solutions" }),
        /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-muted-foreground", children: "Find the perfect plan for your business needs." })
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "overflow-x-auto", children: /* @__PURE__ */ jsxRuntimeExports.jsxs("table", { className: "w-full bg-background rounded-lg shadow-lg", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx("thead", { children: /* @__PURE__ */ jsxRuntimeExports.jsxs("tr", { className: "border-b", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx("th", { className: "p-4 text-left font-semibold", children: "Features" }),
          /* @__PURE__ */ jsxRuntimeExports.jsx("th", { className: "p-4 text-center font-semibold", children: "Small Business" }),
          /* @__PURE__ */ jsxRuntimeExports.jsx("th", { className: "p-4 text-center font-semibold", children: "Enterprise" }),
          /* @__PURE__ */ jsxRuntimeExports.jsx("th", { className: "p-4 text-center font-semibold", children: "Agencies" }),
          /* @__PURE__ */ jsxRuntimeExports.jsx("th", { className: "p-4 text-center font-semibold", children: "E-commerce" }),
          /* @__PURE__ */ jsxRuntimeExports.jsx("th", { className: "p-4 text-center font-semibold", children: "Startups" })
        ] }) }),
        /* @__PURE__ */ jsxRuntimeExports.jsxs("tbody", { children: [
          /* @__PURE__ */ jsxRuntimeExports.jsxs("tr", { className: "border-b", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx("td", { className: "p-4 font-medium", children: "Monthly Emails" }),
            /* @__PURE__ */ jsxRuntimeExports.jsx("td", { className: "p-4 text-center", children: "10,000" }),
            /* @__PURE__ */ jsxRuntimeExports.jsx("td", { className: "p-4 text-center", children: "Unlimited" }),
            /* @__PURE__ */ jsxRuntimeExports.jsx("td", { className: "p-4 text-center", children: "100,000" }),
            /* @__PURE__ */ jsxRuntimeExports.jsx("td", { className: "p-4 text-center", children: "50,000" }),
            /* @__PURE__ */ jsxRuntimeExports.jsx("td", { className: "p-4 text-center", children: "25,000" })
          ] }),
          /* @__PURE__ */ jsxRuntimeExports.jsxs("tr", { className: "border-b", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx("td", { className: "p-4 font-medium", children: "Templates" }),
            /* @__PURE__ */ jsxRuntimeExports.jsx("td", { className: "p-4 text-center", children: "50+" }),
            /* @__PURE__ */ jsxRuntimeExports.jsx("td", { className: "p-4 text-center", children: "Unlimited" }),
            /* @__PURE__ */ jsxRuntimeExports.jsx("td", { className: "p-4 text-center", children: "200+" }),
            /* @__PURE__ */ jsxRuntimeExports.jsx("td", { className: "p-4 text-center", children: "100+" }),
            /* @__PURE__ */ jsxRuntimeExports.jsx("td", { className: "p-4 text-center", children: "75+" })
          ] }),
          /* @__PURE__ */ jsxRuntimeExports.jsxs("tr", { className: "border-b", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx("td", { className: "p-4 font-medium", children: "Integrations" }),
            /* @__PURE__ */ jsxRuntimeExports.jsx("td", { className: "p-4 text-center", children: "10" }),
            /* @__PURE__ */ jsxRuntimeExports.jsx("td", { className: "p-4 text-center", children: "Unlimited" }),
            /* @__PURE__ */ jsxRuntimeExports.jsx("td", { className: "p-4 text-center", children: "25" }),
            /* @__PURE__ */ jsxRuntimeExports.jsx("td", { className: "p-4 text-center", children: "15" }),
            /* @__PURE__ */ jsxRuntimeExports.jsx("td", { className: "p-4 text-center", children: "20" })
          ] }),
          /* @__PURE__ */ jsxRuntimeExports.jsxs("tr", { className: "border-b", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx("td", { className: "p-4 font-medium", children: "Support" }),
            /* @__PURE__ */ jsxRuntimeExports.jsx("td", { className: "p-4 text-center", children: "Email" }),
            /* @__PURE__ */ jsxRuntimeExports.jsx("td", { className: "p-4 text-center", children: "24/7 Phone" }),
            /* @__PURE__ */ jsxRuntimeExports.jsx("td", { className: "p-4 text-center", children: "Priority" }),
            /* @__PURE__ */ jsxRuntimeExports.jsx("td", { className: "p-4 text-center", children: "Email + Chat" }),
            /* @__PURE__ */ jsxRuntimeExports.jsx("td", { className: "p-4 text-center", children: "Email" })
          ] }),
          /* @__PURE__ */ jsxRuntimeExports.jsxs("tr", { children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx("td", { className: "p-4 font-medium", children: "Starting Price" }),
            /* @__PURE__ */ jsxRuntimeExports.jsx("td", { className: "p-4 text-center font-bold text-flashcore-purple", children: "$29/mo" }),
            /* @__PURE__ */ jsxRuntimeExports.jsx("td", { className: "p-4 text-center font-bold text-flashcore-purple", children: "Custom" }),
            /* @__PURE__ */ jsxRuntimeExports.jsx("td", { className: "p-4 text-center font-bold text-flashcore-purple", children: "$99/mo" }),
            /* @__PURE__ */ jsxRuntimeExports.jsx("td", { className: "p-4 text-center font-bold text-flashcore-purple", children: "$49/mo" }),
            /* @__PURE__ */ jsxRuntimeExports.jsx("td", { className: "p-4 text-center font-bold text-flashcore-purple", children: "$19/mo" })
          ] })
        ] })
      ] }) })
    ] }) }),
    /* @__PURE__ */ jsxRuntimeExports.jsx("section", { className: "container mx-auto px-4 py-12 md:py-20", children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "max-w-6xl mx-auto", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "text-center mb-12", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx("h2", { className: "text-2xl md:text-3xl font-bold mb-4", children: "What Our Customers Say" }),
        /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-muted-foreground", children: "See how businesses are transforming their email marketing with FlashCore." })
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "grid grid-cols-1 md:grid-cols-3 gap-6 md:gap-8", children: testimonials.map((testimonial, index) => /* @__PURE__ */ jsxRuntimeExports.jsx(Card, { className: "hover:shadow-lg transition-shadow", children: /* @__PURE__ */ jsxRuntimeExports.jsxs(CardContent, { className: "p-6", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "flex items-center mb-4", children: [...Array(testimonial.rating)].map((_, i) => /* @__PURE__ */ jsxRuntimeExports.jsx(Star, { className: "w-4 h-4 text-yellow-400 fill-current" }, i)) }),
        /* @__PURE__ */ jsxRuntimeExports.jsxs("p", { className: "text-sm md:text-base text-muted-foreground mb-4", children: [
          '"',
          testimonial.content,
          '"'
        ] }),
        /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center justify-between", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "font-semibold", children: testimonial.name }),
            /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "text-sm text-muted-foreground", children: [
              testimonial.role,
              " at ",
              testimonial.company
            ] })
          ] }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(Badge, { variant: "outline", className: "text-xs", children: testimonial.solution })
        ] })
      ] }) }, index)) })
    ] }) }),
    /* @__PURE__ */ jsxRuntimeExports.jsx("section", { className: "container mx-auto px-4 py-12 md:py-20 bg-muted/20", children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "max-w-4xl mx-auto", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "text-center mb-12", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx("h2", { className: "text-2xl md:text-3xl font-bold mb-4", children: "Why Choose FlashCore?" }),
        /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-muted-foreground", children: "Powerful features that help businesses of all sizes succeed." })
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6 md:gap-8", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "text-center", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "w-12 h-12 bg-gradient-to-r from-flashcore-purple to-flashcore-green rounded-lg flex items-center justify-center mx-auto mb-4", children: /* @__PURE__ */ jsxRuntimeExports.jsx(Zap, { className: "w-6 h-6 text-white" }) }),
          /* @__PURE__ */ jsxRuntimeExports.jsx("h3", { className: "text-lg font-semibold mb-2", children: "Easy to Use" }),
          /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-sm text-muted-foreground", children: "Intuitive interface that makes email marketing simple and effective." })
        ] }),
        /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "text-center", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "w-12 h-12 bg-gradient-to-r from-flashcore-purple to-flashcore-green rounded-lg flex items-center justify-center mx-auto mb-4", children: /* @__PURE__ */ jsxRuntimeExports.jsx(TrendingUp, { className: "w-6 h-6 text-white" }) }),
          /* @__PURE__ */ jsxRuntimeExports.jsx("h3", { className: "text-lg font-semibold mb-2", children: "Proven Results" }),
          /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-sm text-muted-foreground", children: "Increase engagement and conversions with data-driven insights." })
        ] }),
        /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "text-center", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "w-12 h-12 bg-gradient-to-r from-flashcore-purple to-flashcore-green rounded-lg flex items-center justify-center mx-auto mb-4", children: /* @__PURE__ */ jsxRuntimeExports.jsx(Shield, { className: "w-6 h-6 text-white" }) }),
          /* @__PURE__ */ jsxRuntimeExports.jsx("h3", { className: "text-lg font-semibold mb-2", children: "Enterprise Security" }),
          /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-sm text-muted-foreground", children: "Bank-level security to protect your data and customer information." })
        ] }),
        /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "text-center", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "w-12 h-12 bg-gradient-to-r from-flashcore-purple to-flashcore-green rounded-lg flex items-center justify-center mx-auto mb-4", children: /* @__PURE__ */ jsxRuntimeExports.jsx(Clock, { className: "w-6 h-6 text-white" }) }),
          /* @__PURE__ */ jsxRuntimeExports.jsx("h3", { className: "text-lg font-semibold mb-2", children: "24/7 Support" }),
          /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-sm text-muted-foreground", children: "Round-the-clock support to help you succeed at any time." })
        ] }),
        /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "text-center", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "w-12 h-12 bg-gradient-to-r from-flashcore-purple to-flashcore-green rounded-lg flex items-center justify-center mx-auto mb-4", children: /* @__PURE__ */ jsxRuntimeExports.jsx(Target, { className: "w-6 h-6 text-white" }) }),
          /* @__PURE__ */ jsxRuntimeExports.jsx("h3", { className: "text-lg font-semibold mb-2", children: "Advanced Targeting" }),
          /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-sm text-muted-foreground", children: "Reach the right audience with sophisticated segmentation tools." })
        ] }),
        /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "text-center", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "w-12 h-12 bg-gradient-to-r from-flashcore-purple to-flashcore-green rounded-lg flex items-center justify-center mx-auto mb-4", children: /* @__PURE__ */ jsxRuntimeExports.jsx(Users, { className: "w-6 h-6 text-white" }) }),
          /* @__PURE__ */ jsxRuntimeExports.jsx("h3", { className: "text-lg font-semibold mb-2", children: "Team Collaboration" }),
          /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-sm text-muted-foreground", children: "Work together seamlessly with team management features." })
        ] })
      ] })
    ] }) }),
    /* @__PURE__ */ jsxRuntimeExports.jsx("section", { className: "container mx-auto px-4 py-12 md:py-20", children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "bg-gradient-to-r from-flashcore-purple to-flashcore-green rounded-2xl p-6 md:p-8 lg:p-12 text-center text-white", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsx("h2", { className: "text-2xl md:text-3xl font-bold mb-4", children: "Ready to Get Started?" }),
      /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-lg md:text-xl mb-6 md:mb-8 opacity-90", children: "Choose the perfect solution for your business and start growing today." }),
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex flex-col sm:flex-row gap-4 justify-center", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx(Link, { to: "/register", children: /* @__PURE__ */ jsxRuntimeExports.jsxs(Button, { size: "lg", variant: "secondary", className: "bg-white text-flashcore-purple hover:bg-gray-100", children: [
          "Start Free Trial",
          /* @__PURE__ */ jsxRuntimeExports.jsx(ArrowRight, { className: "w-4 h-4 ml-2" })
        ] }) }),
        /* @__PURE__ */ jsxRuntimeExports.jsx(Link, { to: "/contact", children: /* @__PURE__ */ jsxRuntimeExports.jsx(Button, { size: "lg", variant: "outline", className: "border-white text-white hover:bg-white hover:text-flashcore-purple", children: "Talk to Sales" }) })
      ] })
    ] }) })
  ] });
};
export {
  SolutionsPage as default
};
//# sourceMappingURL=SolutionsPage-Di8x51Mb.js.map
