import { r as reactExports, l as useNavigate, u as useToast, j as jsxRuntimeExports, m as Link, n as Logo, d as Card, g as CardHeader, h as CardTitle, i as CardDescription, e as CardContent, B as Button, S as Shield, a7 as TriangleAlert, I as Input, a as apiService } from "./index-D2CUDDtA.js";
import { L as Label } from "./label-un0P9fjF.js";
import { C as CircleCheckBig } from "./circle-check-big-CzDEsGWP.js";
import { U as UserPlus } from "./user-plus-CLVhtS6Y.js";
const SetupAdminPage = () => {
  const [formData, setFormData] = reactExports.useState({
    email: "admin@flashcore.com",
    password: "Admin123!",
    firstName: "System",
    lastName: "Administrator"
  });
  const [loading, setLoading] = reactExports.useState(false);
  const [success, setSuccess] = reactExports.useState(false);
  const navigate = useNavigate();
  const { toast } = useToast();
  const handleSubmit = async (e) => {
    var _a, _b;
    e.preventDefault();
    setLoading(true);
    try {
      const response = await apiService.adminManageUsers("create", {
        userData: {
          ...formData,
          role: "admin"
        }
      });
      if (response.error) {
        toast({
          title: "Error",
          description: response.error,
          variant: "destructive"
        });
        return;
      }
      if ((_a = response.data) == null ? void 0 : _a.success) {
        setSuccess(true);
        toast({
          title: "Success!",
          description: `Admin user created successfully for ${response.data.email}`
        });
      } else {
        throw new Error(((_b = response.data) == null ? void 0 : _b.error) || "Failed to create admin user");
      }
    } catch (error) {
      toast({
        title: "Error",
        description: error instanceof Error ? error.message : "Failed to create admin user",
        variant: "destructive"
      });
    } finally {
      setLoading(false);
    }
  };
  const handleInputChange = (e) => {
    setFormData({
      ...formData,
      [e.target.name]: e.target.value
    });
  };
  if (success) {
    return /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "min-h-screen flex items-center justify-center bg-gradient-to-br from-slate-900 via-purple-900 to-slate-900 p-4", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "absolute top-8 left-8", children: /* @__PURE__ */ jsxRuntimeExports.jsxs(Link, { to: "/", className: "flex items-center", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx(Logo, { className: "w-12 h-12" }),
        /* @__PURE__ */ jsxRuntimeExports.jsx("h1", { className: "text-2xl font-bold bg-gradient-to-r from-flashcore-purple via-flashcore-green to-flashcore-orange bg-clip-text text-transparent -ml-1", children: "FLASHCORE" })
      ] }) }),
      /* @__PURE__ */ jsxRuntimeExports.jsxs(Card, { className: "w-full max-w-md border-2 border-green-500/20 bg-black/20 backdrop-blur-sm", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsxs(CardHeader, { className: "text-center", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "mx-auto mb-4 w-16 h-16 bg-gradient-to-r from-green-600 to-emerald-600 rounded-full flex items-center justify-center", children: /* @__PURE__ */ jsxRuntimeExports.jsx(CircleCheckBig, { className: "w-8 h-8 text-white" }) }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(CardTitle, { className: "text-2xl font-bold text-white", children: "Admin Created Successfully!" }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(CardDescription, { className: "text-gray-300", children: "Your administrator account has been set up" })
        ] }),
        /* @__PURE__ */ jsxRuntimeExports.jsxs(CardContent, { className: "space-y-4", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "bg-green-500/10 border border-green-500/20 rounded-lg p-4", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx("h3", { className: "font-semibold text-green-400 mb-2", children: "Login Credentials:" }),
            /* @__PURE__ */ jsxRuntimeExports.jsxs("p", { className: "text-sm text-gray-300", children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx("strong", { children: "Email:" }),
              " ",
              formData.email,
              /* @__PURE__ */ jsxRuntimeExports.jsx("br", {}),
              /* @__PURE__ */ jsxRuntimeExports.jsx("strong", { children: "Password:" }),
              " ",
              formData.password
            ] })
          ] }),
          /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "space-y-2", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsxs(
              Button,
              {
                onClick: () => navigate("/admin-login"),
                className: "w-full bg-gradient-to-r from-green-600 to-emerald-600 hover:from-green-700 hover:to-emerald-700",
                children: [
                  /* @__PURE__ */ jsxRuntimeExports.jsx(Shield, { className: "mr-2 h-4 w-4" }),
                  "Go to Admin Login"
                ]
              }
            ),
            /* @__PURE__ */ jsxRuntimeExports.jsxs(
              Button,
              {
                variant: "outline",
                onClick: () => navigate("/"),
                className: "w-full border-gray-600 text-gray-300 hover:bg-gray-800",
                children: [
                  /* @__PURE__ */ jsxRuntimeExports.jsx(TriangleAlert, { className: "mr-2 h-4 w-4" }),
                  "Return to Homepage"
                ]
              }
            )
          ] })
        ] })
      ] })
    ] });
  }
  return /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "min-h-screen flex items-center justify-center bg-gradient-to-br from-slate-900 via-purple-900 to-slate-900 p-4", children: [
    /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "absolute top-8 left-8", children: /* @__PURE__ */ jsxRuntimeExports.jsxs(Link, { to: "/", className: "flex items-center", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsx(Logo, { className: "w-12 h-12" }),
      /* @__PURE__ */ jsxRuntimeExports.jsx("h1", { className: "text-2xl font-bold bg-gradient-to-r from-flashcore-purple via-flashcore-green to-flashcore-orange bg-clip-text text-transparent -ml-1", children: "FLASHCORE" })
    ] }) }),
    /* @__PURE__ */ jsxRuntimeExports.jsxs(Card, { className: "w-full max-w-md border-2 border-purple-500/20 bg-black/20 backdrop-blur-sm", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsxs(CardHeader, { className: "text-center", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "mx-auto mb-4 w-16 h-16 bg-gradient-to-r from-flashcore-purple to-flashcore-green rounded-full flex items-center justify-center", children: /* @__PURE__ */ jsxRuntimeExports.jsx(Shield, { className: "w-8 h-8 text-white" }) }),
        /* @__PURE__ */ jsxRuntimeExports.jsx(CardTitle, { className: "text-2xl font-bold text-white", children: "Setup Administrator" }),
        /* @__PURE__ */ jsxRuntimeExports.jsx(CardDescription, { className: "text-gray-300", children: "Create your first administrator account" })
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsx(CardContent, { children: /* @__PURE__ */ jsxRuntimeExports.jsxs("form", { onSubmit: handleSubmit, className: "space-y-4", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "space-y-2", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx(Label, { htmlFor: "email", className: "text-gray-300", children: "Email" }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(
            Input,
            {
              id: "email",
              name: "email",
              type: "email",
              placeholder: "admin@flashcore.com",
              value: formData.email,
              onChange: handleInputChange,
              className: "bg-gray-800 border-gray-700 text-white placeholder-gray-400",
              required: true
            }
          )
        ] }),
        /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "space-y-2", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx(Label, { htmlFor: "password", className: "text-gray-300", children: "Password" }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(
            Input,
            {
              id: "password",
              name: "password",
              type: "password",
              placeholder: "Secure password",
              value: formData.password,
              onChange: handleInputChange,
              className: "bg-gray-800 border-gray-700 text-white placeholder-gray-400",
              required: true
            }
          )
        ] }),
        /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "grid grid-cols-2 gap-4", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "space-y-2", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx(Label, { htmlFor: "firstName", className: "text-gray-300", children: "First Name" }),
            /* @__PURE__ */ jsxRuntimeExports.jsx(
              Input,
              {
                id: "firstName",
                name: "firstName",
                placeholder: "System",
                value: formData.firstName,
                onChange: handleInputChange,
                className: "bg-gray-800 border-gray-700 text-white placeholder-gray-400",
                required: true
              }
            )
          ] }),
          /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "space-y-2", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx(Label, { htmlFor: "lastName", className: "text-gray-300", children: "Last Name" }),
            /* @__PURE__ */ jsxRuntimeExports.jsx(
              Input,
              {
                id: "lastName",
                name: "lastName",
                placeholder: "Administrator",
                value: formData.lastName,
                onChange: handleInputChange,
                className: "bg-gray-800 border-gray-700 text-white placeholder-gray-400",
                required: true
              }
            )
          ] })
        ] }),
        /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "bg-yellow-500/10 border border-yellow-500/20 rounded-lg p-3 mt-4", children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-start", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx(TriangleAlert, { className: "w-5 h-5 text-yellow-500 mt-0.5 mr-2 flex-shrink-0" }),
          /* @__PURE__ */ jsxRuntimeExports.jsxs("p", { className: "text-sm text-yellow-300", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx("strong", { children: "Important:" }),
            " Make sure to save these credentials in a secure location. You'll need them to access the admin panel."
          ] })
        ] }) }),
        /* @__PURE__ */ jsxRuntimeExports.jsx(
          Button,
          {
            type: "submit",
            disabled: loading,
            className: "w-full bg-gradient-to-r from-flashcore-purple to-flashcore-green hover:from-purple-700 hover:to-green-700",
            children: loading ? /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center", children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "w-4 h-4 border-2 border-t-transparent border-white rounded-full animate-spin mr-2" }),
              "Creating Admin..."
            ] }) : /* @__PURE__ */ jsxRuntimeExports.jsxs(jsxRuntimeExports.Fragment, { children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx(UserPlus, { className: "mr-2 h-4 w-4" }),
              "Create Administrator"
            ] })
          }
        )
      ] }) })
    ] })
  ] });
};
export {
  SetupAdminPage as default
};
//# sourceMappingURL=SetupAdminPage-CJbem46T.js.map
