import { r as reactExports, j as jsxRuntimeExports, i as Card, l as CardHeader, v as Mail, m as CardTitle, n as CardDescription, k as CardContent, t as Label, I as Input, B as Button, O as LoaderCircle, a2 as Send, a as apiService, ag as toast, e as useAuthPhp, L as Layout, S as Shield } from "./index-GlGoHQS3.js";
import { S as Switch } from "./switch-CdVUw5Ru.js";
import { S as Select, a as SelectTrigger, b as SelectValue, c as SelectContent, d as SelectItem } from "./select-B0DdrR_V.js";
import { T as Tabs, a as TabsList, b as TabsTrigger, c as TabsContent } from "./tabs-jrC1WfMe.js";
import { C as CircleCheck } from "./circle-check-00p8zBHl.js";
import { Z as Zap } from "./zap-DzaCSTJR.js";
import { U as User } from "./user-D9v4i0U9.js";
import { B as Bell } from "./bell-Cjo9wTHb.js";
import { P as Palette } from "./palette-D3vNgBlh.js";
import { C as Camera } from "./camera-BrUtVOyA.js";
import { S as Smartphone } from "./smartphone-QIzEXRuk.js";
import { K as Key } from "./key-D11V0gzH.js";
import { E as EyeOff } from "./eye-off-CHGLVTbv.js";
import { E as Eye } from "./eye-CJ16PVGC.js";
import { T as Trash2 } from "./trash-2-B9sMlXbp.js";
import { S as Save } from "./save-4BfVtzf4.js";
import "./index-CRzR833T.js";
import "./chevron-down-CfVNtG1C.js";
const UserEmailTestSection = () => {
  const [sender, setSender] = reactExports.useState(null);
  const [testEmail, setTestEmail] = reactExports.useState("");
  const [sending, setSending] = reactExports.useState(false);
  reactExports.useEffect(() => {
    const fetchPublicConfig = async () => {
      var _a;
      try {
        const res = await apiService.getPublicEmailConfig();
        if ((_a = res.data) == null ? void 0 : _a.sender) {
          setSender(res.data.sender);
        }
      } catch (e) {
        console.error("Failed to fetch public email config");
      }
    };
    fetchPublicConfig();
  }, []);
  const handleSendTest = async (e) => {
    e.preventDefault();
    if (!testEmail) {
      toast({ title: "Error", description: "Please enter an email address", variant: "destructive" });
      return;
    }
    setSending(true);
    try {
      const res = await apiService.sendTestEmail(testEmail);
      if (res.error) throw new Error(res.error);
      toast({
        title: "Email Sent!",
        description: `Test email successfully sent to ${testEmail}. Please check your inbox.`
      });
      setTestEmail("");
    } catch (error) {
      toast({
        title: "Delivery Failed",
        description: error instanceof Error ? error.message : "Could not send test email",
        variant: "destructive"
      });
    } finally {
      setSending(false);
    }
  };
  if (!sender) return null;
  return /* @__PURE__ */ jsxRuntimeExports.jsxs(Card, { className: "border-l-4 border-l-green-500", children: [
    /* @__PURE__ */ jsxRuntimeExports.jsxs(CardHeader, { children: [
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center gap-2", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx(Mail, { className: "w-5 h-5 text-green-600" }),
        /* @__PURE__ */ jsxRuntimeExports.jsx(CardTitle, { children: "Email Services" })
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsx(CardDescription, { children: "Verify that you can receive emails from the system." })
    ] }),
    /* @__PURE__ */ jsxRuntimeExports.jsxs(CardContent, { className: "space-y-4", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "bg-muted/50 p-3 rounded-md flex items-center justify-between", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-sm font-medium text-muted-foreground", children: "Active Sender Identity" }),
          /* @__PURE__ */ jsxRuntimeExports.jsxs("p", { className: "font-semibold text-foreground", children: [
            sender.name,
            " <",
            sender.email,
            ">"
          ] })
        ] }),
        /* @__PURE__ */ jsxRuntimeExports.jsx(CircleCheck, { className: "w-5 h-5 text-green-500" })
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsxs("form", { onSubmit: handleSendTest, className: "flex flex-col sm:flex-row gap-3 items-end", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "w-full space-y-2", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx(Label, { htmlFor: "test-email", children: "Test Destination Email" }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(
            Input,
            {
              id: "test-email",
              type: "email",
              placeholder: "Enter your email address",
              value: testEmail,
              onChange: (e) => setTestEmail(e.target.value)
            }
          )
        ] }),
        /* @__PURE__ */ jsxRuntimeExports.jsxs(Button, { type: "submit", disabled: sending, className: "w-full sm:w-auto", children: [
          sending ? /* @__PURE__ */ jsxRuntimeExports.jsx(LoaderCircle, { className: "w-4 h-4 mr-2 animate-spin" }) : /* @__PURE__ */ jsxRuntimeExports.jsx(Send, { className: "w-4 h-4 mr-2" }),
          "Send Test"
        ] })
      ] })
    ] })
  ] });
};
const SettingsPage = () => {
  const { user, profile: authProfile } = useAuthPhp();
  const [loading, setLoading] = reactExports.useState(true);
  const [saving, setSaving] = reactExports.useState(false);
  const [settings, setSettings] = reactExports.useState({
    profile: {
      firstName: "",
      lastName: "",
      email: "",
      phone: "",
      timezone: "America/New_York",
      language: "en",
      avatar_url: ""
    },
    notifications: {
      email: true,
      push: true,
      sms: false,
      marketing: false,
      security: true,
      updates: true
    },
    security: {
      twoFactor: false,
      sessionTimeout: "30",
      passwordExpiry: "90",
      loginAlerts: true
    },
    appearance: {
      theme: "system",
      compactMode: false,
      showAnimations: true,
      fontSize: "medium"
    }
  });
  const [showPassword, setShowPassword] = reactExports.useState(false);
  const [currentPassword, setCurrentPassword] = reactExports.useState("");
  const [newPassword, setNewPassword] = reactExports.useState("");
  const [confirmPassword, setConfirmPassword] = reactExports.useState("");
  reactExports.useEffect(() => {
    const fetchSettings = async () => {
      var _a, _b, _c, _d, _e, _f, _g, _h, _i, _j, _k, _l, _m, _n, _o, _p, _q, _r;
      try {
        const response = await apiService.getUserProfile();
        if (response.error) throw new Error(response.error);
        const data = response.data;
        setSettings({
          profile: {
            firstName: ((_a = data.profile) == null ? void 0 : _a.first_name) || (authProfile == null ? void 0 : authProfile.first_name) || "",
            lastName: ((_b = data.profile) == null ? void 0 : _b.last_name) || (authProfile == null ? void 0 : authProfile.last_name) || "",
            email: (user == null ? void 0 : user.email) || "",
            phone: ((_c = data.profile) == null ? void 0 : _c.phone) || "",
            timezone: "America/New_York",
            language: "en",
            avatar_url: ((_d = data.profile) == null ? void 0 : _d.avatar_url) || ""
          },
          notifications: {
            email: !!((_e = data.settings) == null ? void 0 : _e.email_notifications),
            push: !!((_f = data.settings) == null ? void 0 : _f.push_notifications),
            sms: !!((_g = data.settings) == null ? void 0 : _g.sms_notifications),
            marketing: !!((_h = data.settings) == null ? void 0 : _h.marketing_notifications),
            security: !!((_i = data.settings) == null ? void 0 : _i.security_alerts),
            updates: !!((_j = data.settings) == null ? void 0 : _j.update_alerts)
          },
          security: {
            twoFactor: !!((_k = data.settings) == null ? void 0 : _k.two_factor_auth),
            sessionTimeout: ((_l = data.settings) == null ? void 0 : _l.session_timeout) || "30",
            passwordExpiry: ((_m = data.settings) == null ? void 0 : _m.password_expiry) || "90",
            loginAlerts: !!((_n = data.settings) == null ? void 0 : _n.login_alerts)
          },
          appearance: {
            theme: ((_o = data.settings) == null ? void 0 : _o.theme) || "system",
            compactMode: !!((_p = data.settings) == null ? void 0 : _p.compact_mode),
            showAnimations: !!((_q = data.settings) == null ? void 0 : _q.show_animations),
            fontSize: ((_r = data.settings) == null ? void 0 : _r.font_size) || "medium"
          }
        });
      } catch (error) {
        console.error("Failed to fetch settings:", error);
      } finally {
        setLoading(false);
      }
    };
    fetchSettings();
  }, [user == null ? void 0 : user.email, authProfile == null ? void 0 : authProfile.first_name, authProfile == null ? void 0 : authProfile.last_name]);
  const handleSave = async () => {
    setSaving(true);
    try {
      await apiService.updateUserProfile({
        first_name: settings.profile.firstName,
        last_name: settings.profile.lastName,
        phone: settings.profile.phone
      });
      await apiService.updateUserSettings({
        email_notifications: settings.notifications.email ? 1 : 0,
        push_notifications: settings.notifications.push ? 1 : 0,
        sms_notifications: settings.notifications.sms ? 1 : 0,
        marketing_notifications: settings.notifications.marketing ? 1 : 0,
        security_alerts: settings.notifications.security ? 1 : 0,
        update_alerts: settings.notifications.updates ? 1 : 0,
        two_factor_auth: settings.security.twoFactor ? 1 : 0,
        session_timeout: settings.security.sessionTimeout,
        password_expiry: settings.security.passwordExpiry,
        login_alerts: settings.security.loginAlerts ? 1 : 0,
        theme: settings.appearance.theme,
        compact_mode: settings.appearance.compactMode ? 1 : 0,
        show_animations: settings.appearance.showAnimations ? 1 : 0,
        font_size: settings.appearance.fontSize
      });
      toast({
        title: "Success",
        description: "Settings saved successfully"
      });
    } catch (error) {
      toast({
        title: "Error",
        description: "Failed to save settings",
        variant: "destructive"
      });
    } finally {
      setSaving(false);
    }
  };
  const handlePasswordChange = async () => {
    if (newPassword !== confirmPassword) {
      toast({
        title: "Error",
        description: "Passwords do not match",
        variant: "destructive"
      });
      return;
    }
    try {
      const response = await apiService.changePassword({
        current_password: currentPassword,
        new_password: newPassword
      });
      if (response.error) throw new Error(response.error);
      toast({
        title: "Success",
        description: "Password changed successfully"
      });
      setCurrentPassword("");
      setNewPassword("");
      setConfirmPassword("");
    } catch (error) {
      toast({
        title: "Error",
        description: error instanceof Error ? error.message : "Failed to change password",
        variant: "destructive"
      });
    }
  };
  const handleAvatarUpload = async (event) => {
    var _a;
    const file = (_a = event.target.files) == null ? void 0 : _a[0];
    if (!file) return;
    if (!file.type.startsWith("image/")) {
      toast({ title: "Error", description: "Please upload an image file", variant: "destructive" });
      return;
    }
    if (file.size > 5 * 1024 * 1024) {
      toast({ title: "Error", description: "Image must be smaller than 5MB", variant: "destructive" });
      return;
    }
    setLoading(true);
    try {
      const result = await apiService.uploadAvatar(file);
      if (result.error) throw new Error(result.error);
      setSettings({
        ...settings,
        profile: { ...settings.profile, avatar_url: result.avatar_url }
      });
      toast({ title: "Success", description: "Avatar updated successfully" });
    } catch (error) {
      toast({
        title: "Error",
        description: error instanceof Error ? error.message : "Failed to upload avatar",
        variant: "destructive"
      });
    } finally {
      setLoading(false);
    }
  };
  if (loading) {
    return /* @__PURE__ */ jsxRuntimeExports.jsx(Layout, { children: /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "flex items-center justify-center min-h-[60vh]", children: /* @__PURE__ */ jsxRuntimeExports.jsx(LoaderCircle, { className: "w-8 h-8 animate-spin text-flashcore-purple" }) }) });
  }
  return /* @__PURE__ */ jsxRuntimeExports.jsx(Layout, { children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "space-y-6", children: [
    /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center gap-3", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "w-8 h-8 bg-gradient-to-r from-flashcore-purple to-flashcore-green rounded-lg flex items-center justify-center", children: /* @__PURE__ */ jsxRuntimeExports.jsx(Zap, { className: "w-5 h-5 text-white" }) }),
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx("h1", { className: "text-3xl font-bold", children: "Settings" }),
        /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-muted-foreground", children: "Manage your account settings and preferences" })
      ] })
    ] }),
    /* @__PURE__ */ jsxRuntimeExports.jsxs(Tabs, { defaultValue: "profile", className: "space-y-6", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsxs(TabsList, { className: "grid w-full grid-cols-4", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsxs(TabsTrigger, { value: "profile", className: "flex items-center gap-2", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx(User, { className: "w-4 h-4" }),
          "Profile"
        ] }),
        /* @__PURE__ */ jsxRuntimeExports.jsxs(TabsTrigger, { value: "notifications", className: "flex items-center gap-2", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx(Bell, { className: "w-4 h-4" }),
          "Notifications"
        ] }),
        /* @__PURE__ */ jsxRuntimeExports.jsxs(TabsTrigger, { value: "security", className: "flex items-center gap-2", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx(Shield, { className: "w-4 h-4" }),
          "Security"
        ] }),
        /* @__PURE__ */ jsxRuntimeExports.jsxs(TabsTrigger, { value: "appearance", className: "flex items-center gap-2", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx(Palette, { className: "w-4 h-4" }),
          "Appearance"
        ] })
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsx(TabsContent, { value: "profile", className: "space-y-6", children: /* @__PURE__ */ jsxRuntimeExports.jsxs(Card, { children: [
        /* @__PURE__ */ jsxRuntimeExports.jsxs(CardHeader, { children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx(CardTitle, { children: "Personal Information" }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(CardDescription, { children: "Update your personal details and contact information" })
        ] }),
        /* @__PURE__ */ jsxRuntimeExports.jsxs(CardContent, { className: "space-y-6", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex flex-col items-center sm:flex-row gap-6 pb-6 border-b", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "relative group", children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "w-24 h-24 rounded-full overflow-hidden border-2 border-muted bg-muted flex items-center justify-center", children: settings.profile.avatar_url || (authProfile == null ? void 0 : authProfile.avatar_url) ? /* @__PURE__ */ jsxRuntimeExports.jsx(
                "img",
                {
                  src: `${"http://localhost:8080"}${settings.profile.avatar_url || (authProfile == null ? void 0 : authProfile.avatar_url)}`,
                  alt: "Avatar",
                  className: "w-full h-full object-cover",
                  onError: (e) => {
                    e.target.src = "images/default-avatar.png";
                  }
                }
              ) : /* @__PURE__ */ jsxRuntimeExports.jsx("img", { src: "images/default-avatar.png", alt: "Default Avatar", className: "w-full h-full object-cover" }) }),
              /* @__PURE__ */ jsxRuntimeExports.jsxs(
                "label",
                {
                  htmlFor: "avatar-upload",
                  className: "absolute bottom-0 right-0 p-1.5 bg-primary text-primary-foreground rounded-full shadow-lg cursor-pointer hover:bg-primary/90 transition-colors",
                  children: [
                    /* @__PURE__ */ jsxRuntimeExports.jsx(Camera, { className: "w-4 h-4" }),
                    /* @__PURE__ */ jsxRuntimeExports.jsx("span", { className: "sr-only", children: "Upload avatar" })
                  ]
                }
              ),
              /* @__PURE__ */ jsxRuntimeExports.jsx(
                "input",
                {
                  id: "avatar-upload",
                  type: "file",
                  accept: "image/*",
                  className: "hidden",
                  onChange: handleAvatarUpload,
                  disabled: loading
                }
              )
            ] }),
            /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "space-y-1 text-center sm:text-left", children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx("h3", { className: "font-medium text-lg", children: "Profile Picture" }),
              /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-sm text-muted-foreground max-w-xs", children: "Upload a custom avatar to personalize your profile. Recommended size: 500x500px. Max 5MB." })
            ] })
          ] }),
          /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "grid grid-cols-1 sm:grid-cols-2 gap-4", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx(Label, { htmlFor: "firstName", children: "First Name" }),
              /* @__PURE__ */ jsxRuntimeExports.jsx(
                Input,
                {
                  id: "firstName",
                  value: settings.profile.firstName,
                  onChange: (e) => setSettings({
                    ...settings,
                    profile: { ...settings.profile, firstName: e.target.value }
                  })
                }
              )
            ] }),
            /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx(Label, { htmlFor: "lastName", children: "Last Name" }),
              /* @__PURE__ */ jsxRuntimeExports.jsx(
                Input,
                {
                  id: "lastName",
                  value: settings.profile.lastName,
                  onChange: (e) => setSettings({
                    ...settings,
                    profile: { ...settings.profile, lastName: e.target.value }
                  })
                }
              )
            ] })
          ] }),
          /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx(Label, { htmlFor: "email", children: "Email Address" }),
            /* @__PURE__ */ jsxRuntimeExports.jsx(
              Input,
              {
                id: "email",
                type: "email",
                value: settings.profile.email,
                onChange: (e) => setSettings({
                  ...settings,
                  profile: { ...settings.profile, email: e.target.value }
                })
              }
            )
          ] }),
          /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx(Label, { htmlFor: "phone", children: "Phone Number" }),
            /* @__PURE__ */ jsxRuntimeExports.jsx(
              Input,
              {
                id: "phone",
                value: settings.profile.phone,
                onChange: (e) => setSettings({
                  ...settings,
                  profile: { ...settings.profile, phone: e.target.value }
                })
              }
            )
          ] }),
          /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "grid grid-cols-1 sm:grid-cols-2 gap-4", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx(Label, { htmlFor: "timezone", children: "Timezone" }),
              /* @__PURE__ */ jsxRuntimeExports.jsxs(
                Select,
                {
                  value: settings.profile.timezone,
                  onValueChange: (value) => setSettings({
                    ...settings,
                    profile: { ...settings.profile, timezone: value }
                  }),
                  children: [
                    /* @__PURE__ */ jsxRuntimeExports.jsx(SelectTrigger, { children: /* @__PURE__ */ jsxRuntimeExports.jsx(SelectValue, {}) }),
                    /* @__PURE__ */ jsxRuntimeExports.jsxs(SelectContent, { children: [
                      /* @__PURE__ */ jsxRuntimeExports.jsx(SelectItem, { value: "America/New_York", children: "Eastern Time" }),
                      /* @__PURE__ */ jsxRuntimeExports.jsx(SelectItem, { value: "America/Chicago", children: "Central Time" }),
                      /* @__PURE__ */ jsxRuntimeExports.jsx(SelectItem, { value: "America/Denver", children: "Mountain Time" }),
                      /* @__PURE__ */ jsxRuntimeExports.jsx(SelectItem, { value: "America/Los_Angeles", children: "Pacific Time" })
                    ] })
                  ]
                }
              )
            ] }),
            /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx(Label, { htmlFor: "language", children: "Language" }),
              /* @__PURE__ */ jsxRuntimeExports.jsxs(
                Select,
                {
                  value: settings.profile.language,
                  onValueChange: (value) => setSettings({
                    ...settings,
                    profile: { ...settings.profile, language: value }
                  }),
                  children: [
                    /* @__PURE__ */ jsxRuntimeExports.jsx(SelectTrigger, { children: /* @__PURE__ */ jsxRuntimeExports.jsx(SelectValue, {}) }),
                    /* @__PURE__ */ jsxRuntimeExports.jsxs(SelectContent, { children: [
                      /* @__PURE__ */ jsxRuntimeExports.jsx(SelectItem, { value: "en", children: "English" }),
                      /* @__PURE__ */ jsxRuntimeExports.jsx(SelectItem, { value: "es", children: "Spanish" }),
                      /* @__PURE__ */ jsxRuntimeExports.jsx(SelectItem, { value: "fr", children: "French" }),
                      /* @__PURE__ */ jsxRuntimeExports.jsx(SelectItem, { value: "de", children: "German" })
                    ] })
                  ]
                }
              )
            ] })
          ] })
        ] })
      ] }) }),
      /* @__PURE__ */ jsxRuntimeExports.jsx(TabsContent, { value: "notifications", className: "space-y-6", children: /* @__PURE__ */ jsxRuntimeExports.jsxs(Card, { children: [
        /* @__PURE__ */ jsxRuntimeExports.jsxs(CardHeader, { children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx(CardTitle, { children: "Notification Preferences" }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(CardDescription, { children: "Choose how you want to receive notifications" })
        ] }),
        /* @__PURE__ */ jsxRuntimeExports.jsxs(CardContent, { className: "space-y-6", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx(UserEmailTestSection, {}),
          /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "space-y-4 pt-4 border-t", children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "space-y-4", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center justify-between", children: [
              /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center gap-3", children: [
                /* @__PURE__ */ jsxRuntimeExports.jsx(Mail, { className: "w-5 h-5 text-blue-500" }),
                /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { children: [
                  /* @__PURE__ */ jsxRuntimeExports.jsx(Label, { className: "font-medium", children: "Email Notifications" }),
                  /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-sm text-muted-foreground", children: "Receive notifications via email" })
                ] })
              ] }),
              /* @__PURE__ */ jsxRuntimeExports.jsx(
                Switch,
                {
                  checked: settings.notifications.email,
                  onCheckedChange: (checked) => setSettings({
                    ...settings,
                    notifications: { ...settings.notifications, email: checked }
                  })
                }
              )
            ] }),
            /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center justify-between", children: [
              /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center gap-3", children: [
                /* @__PURE__ */ jsxRuntimeExports.jsx(Smartphone, { className: "w-5 h-5 text-green-500" }),
                /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { children: [
                  /* @__PURE__ */ jsxRuntimeExports.jsx(Label, { className: "font-medium", children: "Push Notifications" }),
                  /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-sm text-muted-foreground", children: "Receive push notifications" })
                ] })
              ] }),
              /* @__PURE__ */ jsxRuntimeExports.jsx(
                Switch,
                {
                  checked: settings.notifications.push,
                  onCheckedChange: (checked) => setSettings({
                    ...settings,
                    notifications: { ...settings.notifications, push: checked }
                  })
                }
              )
            ] }),
            /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center justify-between", children: [
              /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center gap-3", children: [
                /* @__PURE__ */ jsxRuntimeExports.jsx(Bell, { className: "w-5 h-5 text-orange-500" }),
                /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { children: [
                  /* @__PURE__ */ jsxRuntimeExports.jsx(Label, { className: "font-medium", children: "Security Alerts" }),
                  /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-sm text-muted-foreground", children: "Get notified about security events" })
                ] })
              ] }),
              /* @__PURE__ */ jsxRuntimeExports.jsx(
                Switch,
                {
                  checked: settings.notifications.security,
                  onCheckedChange: (checked) => setSettings({
                    ...settings,
                    notifications: { ...settings.notifications, security: checked }
                  })
                }
              )
            ] })
          ] }) })
        ] })
      ] }) }),
      /* @__PURE__ */ jsxRuntimeExports.jsx(TabsContent, { value: "security", className: "space-y-6", children: /* @__PURE__ */ jsxRuntimeExports.jsxs(Card, { children: [
        /* @__PURE__ */ jsxRuntimeExports.jsxs(CardHeader, { children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx(CardTitle, { children: "Security Settings" }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(CardDescription, { children: "Manage your account security and privacy" })
        ] }),
        /* @__PURE__ */ jsxRuntimeExports.jsxs(CardContent, { className: "space-y-6", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "space-y-4", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center justify-between", children: [
              /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center gap-3", children: [
                /* @__PURE__ */ jsxRuntimeExports.jsx(Key, { className: "w-5 h-5 text-purple-500" }),
                /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { children: [
                  /* @__PURE__ */ jsxRuntimeExports.jsx(Label, { className: "font-medium", children: "Two-Factor Authentication" }),
                  /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-sm text-muted-foreground", children: "Add an extra layer of security" })
                ] })
              ] }),
              /* @__PURE__ */ jsxRuntimeExports.jsx(
                Switch,
                {
                  checked: settings.security.twoFactor,
                  onCheckedChange: (checked) => setSettings({
                    ...settings,
                    security: { ...settings.security, twoFactor: checked }
                  })
                }
              )
            ] }),
            /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center justify-between", children: [
              /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center gap-3", children: [
                /* @__PURE__ */ jsxRuntimeExports.jsx(Shield, { className: "w-5 h-5 text-red-500" }),
                /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { children: [
                  /* @__PURE__ */ jsxRuntimeExports.jsx(Label, { className: "font-medium", children: "Login Alerts" }),
                  /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-sm text-muted-foreground", children: "Get notified of new login attempts" })
                ] })
              ] }),
              /* @__PURE__ */ jsxRuntimeExports.jsx(
                Switch,
                {
                  checked: settings.security.loginAlerts,
                  onCheckedChange: (checked) => setSettings({
                    ...settings,
                    security: { ...settings.security, loginAlerts: checked }
                  })
                }
              )
            ] })
          ] }),
          /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "space-y-4", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx("h3", { className: "font-medium", children: "Change Password" }),
            /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "space-y-4", children: [
              /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { children: [
                /* @__PURE__ */ jsxRuntimeExports.jsx(Label, { htmlFor: "currentPassword", children: "Current Password" }),
                /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "relative", children: [
                  /* @__PURE__ */ jsxRuntimeExports.jsx(
                    Input,
                    {
                      id: "currentPassword",
                      type: showPassword ? "text" : "password",
                      value: currentPassword,
                      onChange: (e) => setCurrentPassword(e.target.value)
                    }
                  ),
                  /* @__PURE__ */ jsxRuntimeExports.jsx(
                    Button,
                    {
                      type: "button",
                      variant: "ghost",
                      size: "sm",
                      className: "absolute right-0 top-0 h-full px-3 py-2 hover:bg-transparent",
                      onClick: () => setShowPassword(!showPassword),
                      children: showPassword ? /* @__PURE__ */ jsxRuntimeExports.jsx(EyeOff, { className: "h-4 w-4" }) : /* @__PURE__ */ jsxRuntimeExports.jsx(Eye, { className: "h-4 w-4" })
                    }
                  )
                ] })
              ] }),
              /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { children: [
                /* @__PURE__ */ jsxRuntimeExports.jsx(Label, { htmlFor: "newPassword", children: "New Password" }),
                /* @__PURE__ */ jsxRuntimeExports.jsx(
                  Input,
                  {
                    id: "newPassword",
                    type: "password",
                    value: newPassword,
                    onChange: (e) => setNewPassword(e.target.value)
                  }
                )
              ] }),
              /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { children: [
                /* @__PURE__ */ jsxRuntimeExports.jsx(Label, { htmlFor: "confirmPassword", children: "Confirm New Password" }),
                /* @__PURE__ */ jsxRuntimeExports.jsx(
                  Input,
                  {
                    id: "confirmPassword",
                    type: "password",
                    value: confirmPassword,
                    onChange: (e) => setConfirmPassword(e.target.value)
                  }
                )
              ] }),
              /* @__PURE__ */ jsxRuntimeExports.jsxs(
                Button,
                {
                  onClick: handlePasswordChange,
                  className: "bg-gradient-to-r from-flashcore-purple to-flashcore-green",
                  disabled: saving,
                  children: [
                    saving ? /* @__PURE__ */ jsxRuntimeExports.jsx(LoaderCircle, { className: "w-4 h-4 mr-2 animate-spin" }) : /* @__PURE__ */ jsxRuntimeExports.jsx(Key, { className: "w-4 h-4 mr-2" }),
                    "Change Password"
                  ]
                }
              )
            ] })
          ] })
        ] })
      ] }) }),
      /* @__PURE__ */ jsxRuntimeExports.jsx(TabsContent, { value: "appearance", className: "space-y-6", children: /* @__PURE__ */ jsxRuntimeExports.jsxs(Card, { children: [
        /* @__PURE__ */ jsxRuntimeExports.jsxs(CardHeader, { children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx(CardTitle, { children: "Appearance Settings" }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(CardDescription, { children: "Customize the look and feel of your dashboard" })
        ] }),
        /* @__PURE__ */ jsxRuntimeExports.jsx(CardContent, { className: "space-y-6", children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "space-y-4", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx(Label, { htmlFor: "theme", children: "Theme" }),
            /* @__PURE__ */ jsxRuntimeExports.jsxs(
              Select,
              {
                value: settings.appearance.theme,
                onValueChange: (value) => setSettings({
                  ...settings,
                  appearance: { ...settings.appearance, theme: value }
                }),
                children: [
                  /* @__PURE__ */ jsxRuntimeExports.jsx(SelectTrigger, { children: /* @__PURE__ */ jsxRuntimeExports.jsx(SelectValue, {}) }),
                  /* @__PURE__ */ jsxRuntimeExports.jsxs(SelectContent, { children: [
                    /* @__PURE__ */ jsxRuntimeExports.jsx(SelectItem, { value: "light", children: "Light" }),
                    /* @__PURE__ */ jsxRuntimeExports.jsx(SelectItem, { value: "dark", children: "Dark" }),
                    /* @__PURE__ */ jsxRuntimeExports.jsx(SelectItem, { value: "system", children: "System" })
                  ] })
                ]
              }
            )
          ] }),
          /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center justify-between", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx(Label, { className: "font-medium", children: "Compact Mode" }),
              /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-sm text-muted-foreground", children: "Reduce spacing for more content" })
            ] }),
            /* @__PURE__ */ jsxRuntimeExports.jsx(
              Switch,
              {
                checked: settings.appearance.compactMode,
                onCheckedChange: (checked) => setSettings({
                  ...settings,
                  appearance: { ...settings.appearance, compactMode: checked }
                })
              }
            )
          ] }),
          /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center justify-between", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx(Label, { className: "font-medium", children: "Show Animations" }),
              /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-sm text-muted-foreground", children: "Enable smooth transitions and animations" })
            ] }),
            /* @__PURE__ */ jsxRuntimeExports.jsx(
              Switch,
              {
                checked: settings.appearance.showAnimations,
                onCheckedChange: (checked) => setSettings({
                  ...settings,
                  appearance: { ...settings.appearance, showAnimations: checked }
                })
              }
            )
          ] })
        ] }) })
      ] }) })
    ] }),
    /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex justify-between items-center", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsxs(Button, { variant: "outline", className: "text-red-600 hover:text-red-700", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx(Trash2, { className: "w-4 h-4 mr-2" }),
        "Delete Account"
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsxs(
        Button,
        {
          onClick: handleSave,
          className: "bg-gradient-to-r from-flashcore-purple to-flashcore-green",
          disabled: saving,
          children: [
            saving ? /* @__PURE__ */ jsxRuntimeExports.jsx(LoaderCircle, { className: "w-4 h-4 mr-2 animate-spin" }) : /* @__PURE__ */ jsxRuntimeExports.jsx(Save, { className: "w-4 h-4 mr-2" }),
            saving ? "Saving..." : "Save Changes"
          ]
        }
      )
    ] })
  ] }) });
};
export {
  SettingsPage as default
};
//# sourceMappingURL=SettingsPage-DEZmkTaE.js.map
