import { j as jsxRuntimeExports, L as Layout, d as Card, g as CardHeader, h as CardTitle, e as CardContent, i as CardDescription, I as Input, B as Button, K as ChevronRight } from "./index-1cza7qiv.js";
import { T as Table, a as TableHeader, b as TableRow, c as TableHead, d as TableBody, e as TableCell } from "./table-DbVMRtWq.js";
import { B as Badge } from "./badge-C3TB_ojI.js";
import { S as Select, a as SelectTrigger, b as SelectValue, c as SelectContent, d as SelectItem } from "./select-CMvw-xcc.js";
import { F as Filter } from "./filter-QSWFlXVr.js";
import { D as Download } from "./download-CwgUoo59.js";
import { F as FileText } from "./file-text-Dv-bRh8J.js";
import { C as ChevronLeft } from "./chevron-left-BV3zosnb.js";
import "./index-CkSL-0B1.js";
const PaymentHistoryPage = () => {
  const paymentData = [
    { id: "INV-2023-001", description: "Premium Subscription", date: "May 1, 2023", amount: "$49.99", status: "Paid", method: "Credit Card" },
    { id: "INV-2023-002", description: "API Credits", date: "Apr 15, 2023", amount: "$19.99", status: "Paid", method: "PayPal" },
    { id: "INV-2023-003", description: "Premium Subscription", date: "Apr 1, 2023", amount: "$49.99", status: "Paid", method: "Credit Card" },
    { id: "INV-2023-004", description: "Child Panel Setup", date: "Mar 25, 2023", amount: "$99.99", status: "Paid", method: "Bank Transfer" },
    { id: "INV-2023-005", description: "Storage Upgrade", date: "Mar 18, 2023", amount: "$29.99", status: "Paid", method: "Credit Card" },
    { id: "INV-2023-006", description: "Premium Subscription", date: "Mar 1, 2023", amount: "$49.99", status: "Paid", method: "Credit Card" },
    { id: "INV-2023-007", description: "Support Extension", date: "Feb 22, 2023", amount: "$39.99", status: "Paid", method: "PayPal" },
    { id: "INV-2023-008", description: "Premium Subscription", date: "Feb 1, 2023", amount: "$49.99", status: "Paid", method: "Credit Card" },
    { id: "INV-2023-009", description: "White Label Add-on", date: "Jan 15, 2023", amount: "$79.99", status: "Paid", method: "Credit Card" },
    { id: "INV-2023-010", description: "Premium Subscription", date: "Jan 1, 2023", amount: "$49.99", status: "Paid", method: "Credit Card" }
  ];
  const methodBadgeColor = (method) => {
    switch (method) {
      case "Credit Card":
        return "bg-blue-100 text-blue-800";
      case "PayPal":
        return "bg-purple-100 text-purple-800";
      case "Bank Transfer":
        return "bg-green-100 text-green-800";
      default:
        return "bg-gray-100 text-gray-800";
    }
  };
  return /* @__PURE__ */ jsxRuntimeExports.jsx(Layout, { children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "space-y-6", children: [
    /* @__PURE__ */ jsxRuntimeExports.jsx("h1", { className: "text-3xl font-bold", children: "Payment History" }),
    /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "grid grid-cols-1 md:grid-cols-4 gap-6", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsxs(Card, { className: "hover:shadow-md transition-shadow", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx(CardHeader, { className: "pb-2", children: /* @__PURE__ */ jsxRuntimeExports.jsx(CardTitle, { className: "text-sm font-medium text-muted-foreground", children: "Total Spent" }) }),
        /* @__PURE__ */ jsxRuntimeExports.jsx(CardContent, { className: "text-2xl font-bold", children: "$519.90" })
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsxs(Card, { className: "hover:shadow-md transition-shadow", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx(CardHeader, { className: "pb-2", children: /* @__PURE__ */ jsxRuntimeExports.jsx(CardTitle, { className: "text-sm font-medium text-muted-foreground", children: "Subscriptions" }) }),
        /* @__PURE__ */ jsxRuntimeExports.jsx(CardContent, { className: "text-2xl font-bold", children: "$349.93" })
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsxs(Card, { className: "hover:shadow-md transition-shadow", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx(CardHeader, { className: "pb-2", children: /* @__PURE__ */ jsxRuntimeExports.jsx(CardTitle, { className: "text-sm font-medium text-muted-foreground", children: "Add-ons" }) }),
        /* @__PURE__ */ jsxRuntimeExports.jsx(CardContent, { className: "text-2xl font-bold", children: "$169.97" })
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsxs(Card, { className: "hover:shadow-md transition-shadow border-flashcore-purple/30", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx(CardHeader, { className: "pb-2", children: /* @__PURE__ */ jsxRuntimeExports.jsx(CardTitle, { className: "text-sm font-medium text-muted-foreground", children: "Next Billing" }) }),
        /* @__PURE__ */ jsxRuntimeExports.jsxs(CardContent, { children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx("span", { className: "text-xl font-bold text-flashcore-purple", children: "Jun 1, 2023" }),
          /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-xs text-muted-foreground mt-1", children: "$49.99 - Premium Plan" })
        ] })
      ] })
    ] }),
    /* @__PURE__ */ jsxRuntimeExports.jsxs(Card, { className: "border-none shadow-lg", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsx(CardHeader, { className: "bg-gradient-to-r from-flashcore-purple to-flashcore-green text-white rounded-t-xl", children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex flex-col md:flex-row md:items-center md:justify-between gap-4", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx(CardTitle, { className: "text-white", children: "Transaction Logs" }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(CardDescription, { className: "text-white/80", children: "View your past transactions and invoices" })
        ] }),
        /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex flex-col sm:flex-row gap-2", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx(
            Input,
            {
              placeholder: "Search invoices...",
              className: "w-full sm:w-[220px] bg-white/10 border-white/20 text-white placeholder:text-white/40 focus:bg-white/20"
            }
          ),
          /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex gap-2", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsxs(Select, { defaultValue: "all", children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx(SelectTrigger, { className: "w-[130px] bg-white/10 border-white/20 text-white", children: /* @__PURE__ */ jsxRuntimeExports.jsx(SelectValue, { placeholder: "Method" }) }),
              /* @__PURE__ */ jsxRuntimeExports.jsxs(SelectContent, { children: [
                /* @__PURE__ */ jsxRuntimeExports.jsx(SelectItem, { value: "all", children: "All Methods" }),
                /* @__PURE__ */ jsxRuntimeExports.jsx(SelectItem, { value: "card", children: "Credit Card" }),
                /* @__PURE__ */ jsxRuntimeExports.jsx(SelectItem, { value: "paypal", children: "PayPal" }),
                /* @__PURE__ */ jsxRuntimeExports.jsx(SelectItem, { value: "bank", children: "Bank Transfer" })
              ] })
            ] }),
            /* @__PURE__ */ jsxRuntimeExports.jsx(Button, { variant: "ghost", size: "icon", className: "bg-white/10 hover:bg-white/20 text-white", children: /* @__PURE__ */ jsxRuntimeExports.jsx(Filter, { className: "h-4 w-4" }) }),
            /* @__PURE__ */ jsxRuntimeExports.jsx(Button, { variant: "ghost", size: "icon", className: "bg-white/10 hover:bg-white/20 text-white", children: /* @__PURE__ */ jsxRuntimeExports.jsx(Download, { className: "h-4 w-4" }) })
          ] })
        ] })
      ] }) }),
      /* @__PURE__ */ jsxRuntimeExports.jsxs(CardContent, { className: "p-0", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsxs(Table, { children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx(TableHeader, { children: /* @__PURE__ */ jsxRuntimeExports.jsxs(TableRow, { className: "bg-muted/50", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx(TableHead, { children: "Invoice" }),
            /* @__PURE__ */ jsxRuntimeExports.jsx(TableHead, { children: "Description" }),
            /* @__PURE__ */ jsxRuntimeExports.jsx(TableHead, { children: "Date" }),
            /* @__PURE__ */ jsxRuntimeExports.jsx(TableHead, { children: "Amount" }),
            /* @__PURE__ */ jsxRuntimeExports.jsx(TableHead, { children: "Method" }),
            /* @__PURE__ */ jsxRuntimeExports.jsx(TableHead, { className: "text-right", children: "Actions" })
          ] }) }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(TableBody, { children: paymentData.map((payment) => /* @__PURE__ */ jsxRuntimeExports.jsxs(TableRow, { className: "hover:bg-muted/30 transition-colors", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx(TableCell, { className: "font-medium text-xs font-mono", children: payment.id }),
            /* @__PURE__ */ jsxRuntimeExports.jsx(TableCell, { className: "text-sm", children: payment.description }),
            /* @__PURE__ */ jsxRuntimeExports.jsx(TableCell, { className: "text-xs text-muted-foreground", children: payment.date }),
            /* @__PURE__ */ jsxRuntimeExports.jsx(TableCell, { className: "font-bold text-sm", children: payment.amount }),
            /* @__PURE__ */ jsxRuntimeExports.jsx(TableCell, { children: /* @__PURE__ */ jsxRuntimeExports.jsx(Badge, { variant: "outline", className: `${methodBadgeColor(payment.method)} border-none text-[10px] font-bold uppercase py-0.5 px-2 rounded-full`, children: payment.method }) }),
            /* @__PURE__ */ jsxRuntimeExports.jsx(TableCell, { className: "text-right", children: /* @__PURE__ */ jsxRuntimeExports.jsxs(Button, { variant: "ghost", size: "sm", className: "h-8 hover:text-flashcore-purple", children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx(FileText, { className: "h-3.5 w-3.5 mr-1" }),
              " View"
            ] }) })
          ] }, payment.id)) })
        ] }),
        /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center justify-between p-4 border-t bg-muted/20", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-xs text-muted-foreground", children: "Showing 1 to 10 of 24 entries" }),
          /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center space-x-1", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx(Button, { variant: "outline", size: "icon", className: "h-8 w-8", children: /* @__PURE__ */ jsxRuntimeExports.jsx(ChevronLeft, { className: "h-4 w-4" }) }),
            /* @__PURE__ */ jsxRuntimeExports.jsx(Button, { variant: "default", size: "sm", className: "h-8 w-8 bg-flashcore-purple hover:bg-flashcore-purple/90", children: "1" }),
            /* @__PURE__ */ jsxRuntimeExports.jsx(Button, { variant: "ghost", size: "sm", className: "h-8 w-8", children: "2" }),
            /* @__PURE__ */ jsxRuntimeExports.jsx(Button, { variant: "ghost", size: "sm", className: "h-8 w-8", children: "3" }),
            /* @__PURE__ */ jsxRuntimeExports.jsx(Button, { variant: "outline", size: "icon", className: "h-8 w-8", children: /* @__PURE__ */ jsxRuntimeExports.jsx(ChevronRight, { className: "h-4 w-4" }) })
          ] })
        ] })
      ] })
    ] })
  ] }) });
};
export {
  PaymentHistoryPage as default
};
//# sourceMappingURL=PaymentHistoryPage-C91Asj3S.js.map
