import { r as reactExports, j as jsxRuntimeExports, L as Layout, d as Card, g as CardHeader, h as CardTitle, i as CardDescription, I as Input, B as Button, R as RefreshCw, e as CardContent, a7 as ChevronRight } from "./index-Jllr8cp4.js";
import { T as Table, a as TableHeader, b as TableRow, c as TableHead, d as TableBody, e as TableCell } from "./table-DZlLbgtm.js";
import { B as Badge } from "./badge-DvUYI4c1.js";
import { S as Search } from "./search-Dez-rO7p.js";
import { F as Filter } from "./filter-D_V56oiF.js";
import { D as Download } from "./download-B_ybu3-h.js";
import { C as ChevronLeft } from "./chevron-left-sbhjSdsl.js";
const MailHistoryPage = () => {
  const [searchQuery, setSearchQuery] = reactExports.useState("");
  const emailData = [
    { id: 1, recipient: "john.doe@example.com", subject: "Your monthly report is ready", date: "May 15, 2023", status: "Delivered" },
    { id: 2, recipient: "jane.smith@example.com", subject: "Account verification", date: "May 10, 2023", status: "Opened" },
    { id: 3, recipient: "robert.johnson@example.com", subject: "Welcome to FlashCore", date: "May 5, 2023", status: "Clicked" },
    { id: 4, recipient: "sarah.williams@example.com", subject: "Your subscription is expiring soon", date: "May 3, 2023", status: "Delivered" },
    { id: 5, recipient: "michael.brown@example.com", subject: "Security alert: New login", date: "May 1, 2023", status: "Opened" },
    { id: 6, recipient: "emily.davis@example.com", subject: "Invoice for April 2023", date: "Apr 30, 2023", status: "Clicked" },
    { id: 7, recipient: "david.miller@example.com", subject: "Your feature request update", date: "Apr 28, 2023", status: "Bounced" },
    { id: 8, recipient: "lisa.wilson@example.com", subject: "API usage summary", date: "Apr 25, 2023", status: "Delivered" },
    { id: 9, recipient: "james.taylor@example.com", subject: "Scheduled maintenance notification", date: "Apr 22, 2023", status: "Opened" },
    { id: 10, recipient: "emma.anderson@example.com", subject: "Your support ticket has been resolved", date: "Apr 20, 2023", status: "Delivered" }
  ];
  const statusBadgeColor = (status) => {
    switch (status) {
      case "Delivered":
        return "bg-blue-100 text-blue-800";
      case "Opened":
        return "bg-green-100 text-green-800";
      case "Clicked":
        return "bg-purple-100 text-purple-800";
      case "Bounced":
        return "bg-red-100 text-red-800";
      default:
        return "bg-gray-100 text-gray-800";
    }
  };
  return /* @__PURE__ */ jsxRuntimeExports.jsx(Layout, { children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "space-y-6", children: [
    /* @__PURE__ */ jsxRuntimeExports.jsx("h1", { className: "text-3xl font-bold", children: "Mail History" }),
    /* @__PURE__ */ jsxRuntimeExports.jsxs(Card, { className: "overflow-hidden border-none shadow-lg", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsx(CardHeader, { className: "bg-gradient-to-r from-flashcore-purple to-flashcore-green text-white", children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex flex-col md:flex-row md:items-center md:justify-between gap-4", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx(CardTitle, { className: "text-white", children: "Email Communications" }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(CardDescription, { className: "text-white/80", children: "View and track all sent emails" })
        ] }),
        /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex flex-col sm:flex-row gap-2", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "relative", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx(Search, { className: "absolute left-2.5 top-2.5 h-4 w-4 text-white/60" }),
            /* @__PURE__ */ jsxRuntimeExports.jsx(
              Input,
              {
                placeholder: "Search emails...",
                className: "pl-8 w-full sm:w-[220px] bg-white/10 border-white/20 text-white placeholder:text-white/40 focus:bg-white/20 transition-all",
                value: searchQuery,
                onChange: (e) => setSearchQuery(e.target.value)
              }
            )
          ] }),
          /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex gap-2", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx(Button, { variant: "ghost", size: "icon", className: "bg-white/10 hover:bg-white/20 text-white", children: /* @__PURE__ */ jsxRuntimeExports.jsx(Filter, { className: "h-4 w-4" }) }),
            /* @__PURE__ */ jsxRuntimeExports.jsx(Button, { variant: "ghost", size: "icon", className: "bg-white/10 hover:bg-white/20 text-white", children: /* @__PURE__ */ jsxRuntimeExports.jsx(RefreshCw, { className: "h-4 w-4" }) }),
            /* @__PURE__ */ jsxRuntimeExports.jsx(Button, { variant: "ghost", size: "icon", className: "bg-white/10 hover:bg-white/20 text-white", children: /* @__PURE__ */ jsxRuntimeExports.jsx(Download, { className: "h-4 w-4" }) })
          ] })
        ] })
      ] }) }),
      /* @__PURE__ */ jsxRuntimeExports.jsxs(CardContent, { className: "p-0", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsxs(Table, { children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx(TableHeader, { children: /* @__PURE__ */ jsxRuntimeExports.jsxs(TableRow, { className: "bg-muted/50", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx(TableHead, { className: "w-[80px]", children: "ID" }),
            /* @__PURE__ */ jsxRuntimeExports.jsx(TableHead, { children: "Recipient" }),
            /* @__PURE__ */ jsxRuntimeExports.jsx(TableHead, { children: "Subject" }),
            /* @__PURE__ */ jsxRuntimeExports.jsx(TableHead, { children: "Date" }),
            /* @__PURE__ */ jsxRuntimeExports.jsx(TableHead, { children: "Status" })
          ] }) }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(TableBody, { children: emailData.map((email) => /* @__PURE__ */ jsxRuntimeExports.jsxs(TableRow, { className: "hover:bg-muted/30 transition-colors", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx(TableCell, { className: "font-mono text-xs", children: email.id.toString().padStart(3, "0") }),
            /* @__PURE__ */ jsxRuntimeExports.jsx(TableCell, { className: "font-medium text-sm", children: email.recipient }),
            /* @__PURE__ */ jsxRuntimeExports.jsx(TableCell, { className: "text-sm", children: email.subject }),
            /* @__PURE__ */ jsxRuntimeExports.jsx(TableCell, { className: "text-xs text-muted-foreground", children: email.date }),
            /* @__PURE__ */ jsxRuntimeExports.jsx(TableCell, { children: /* @__PURE__ */ jsxRuntimeExports.jsx(Badge, { variant: "outline", className: `${statusBadgeColor(email.status)} border-none text-[10px] font-bold uppercase py-0.5 px-2 rounded-full`, children: email.status }) })
          ] }, email.id)) })
        ] }),
        /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center justify-between p-4 border-t bg-muted/20", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-xs text-muted-foreground", children: "Showing 1 to 10 of 54 entries" }),
          /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center space-x-1", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx(Button, { variant: "outline", size: "icon", className: "h-8 w-8", children: /* @__PURE__ */ jsxRuntimeExports.jsx(ChevronLeft, { className: "h-4 w-4" }) }),
            /* @__PURE__ */ jsxRuntimeExports.jsx(Button, { variant: "default", size: "sm", className: "h-8 w-8 bg-flashcore-purple hover:bg-flashcore-purple/90", children: "1" }),
            /* @__PURE__ */ jsxRuntimeExports.jsx(Button, { variant: "ghost", size: "sm", className: "h-8 w-8", children: "2" }),
            /* @__PURE__ */ jsxRuntimeExports.jsx(Button, { variant: "ghost", size: "sm", className: "h-8 w-8", children: "3" }),
            /* @__PURE__ */ jsxRuntimeExports.jsx(Button, { variant: "outline", size: "icon", className: "h-8 w-8", children: /* @__PURE__ */ jsxRuntimeExports.jsx(ChevronRight, { className: "h-4 w-4" }) })
          ] })
        ] })
      ] })
    ] })
  ] }) });
};
export {
  MailHistoryPage as default
};
//# sourceMappingURL=MailHistoryPage-B7q-c_BC.js.map
