import { j as jsxRuntimeExports, m as Link, n as Logo, l as useNavigate, u as useToast, b as useAuthPhp, d as Card, g as CardHeader, h as CardTitle, i as CardDescription, e as CardContent, p as CardFooter, B as Button } from "./index-Jllr8cp4.js";
import { L as LogOut } from "./log-out-DHIDgsyx.js";
import { A as ArrowLeft } from "./arrow-left-TQ-3U3rC.js";
const AuthLayout = ({ children }) => {
  return /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "min-h-screen flex flex-col items-center justify-center bg-gradient-to-br from-slate-900 via-purple-900 to-slate-900 p-4 relative overflow-hidden", children: [
    /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "absolute top-[-10%] left-[-10%] w-[40%] h-[40%] bg-flashcore-purple/10 rounded-full blur-[120px] pointer-events-none" }),
    /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "absolute bottom-[-10%] right-[-10%] w-[40%] h-[40%] bg-flashcore-green/10 rounded-full blur-[120px] pointer-events-none" }),
    /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "absolute top-8 left-8 z-20", children: /* @__PURE__ */ jsxRuntimeExports.jsxs(Link, { to: "/", className: "flex items-center group transition-all", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsx(Logo, { className: "w-12 h-12 group-hover:scale-110 transition-transform" }),
      /* @__PURE__ */ jsxRuntimeExports.jsx("h1", { className: "text-2xl font-bold bg-gradient-to-r from-flashcore-purple via-flashcore-green to-flashcore-orange bg-clip-text text-transparent -ml-1", children: "FlashCore" })
    ] }) }),
    /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "w-full max-w-md z-10 animate-in fade-in slide-in-from-bottom-4 duration-700", children }),
    /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "mt-8 text-center text-slate-500 text-xs z-10", children: [
      "© ",
      (/* @__PURE__ */ new Date()).getFullYear(),
      " FlashCore Engine. All rights reserved."
    ] })
  ] });
};
const LogoutPage = () => {
  const navigate = useNavigate();
  const { toast } = useToast();
  const { logout } = useAuthPhp();
  const handleLogout = async () => {
    try {
      await logout();
      toast({
        title: "Logged Out",
        description: "You have been successfully logged out."
      });
      navigate("/");
    } catch (error) {
      toast({
        title: "Logout Error",
        description: "An error occurred during logout.",
        variant: "destructive"
      });
    }
  };
  return /* @__PURE__ */ jsxRuntimeExports.jsx(AuthLayout, { children: /* @__PURE__ */ jsxRuntimeExports.jsxs(Card, { className: "border-none shadow-2xl bg-white/95 dark:bg-slate-900/95 backdrop-blur-sm", children: [
    /* @__PURE__ */ jsxRuntimeExports.jsxs(CardHeader, { className: "text-center", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "flex items-center justify-center mb-4", children: /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "bg-red-100 dark:bg-red-900/30 p-3 rounded-full", children: /* @__PURE__ */ jsxRuntimeExports.jsx(LogOut, { className: "w-6 h-6 text-red-600" }) }) }),
      /* @__PURE__ */ jsxRuntimeExports.jsx(CardTitle, { className: "text-2xl", children: "Logout Confirmation" }),
      /* @__PURE__ */ jsxRuntimeExports.jsx(CardDescription, { children: "Are you sure you want to log out?" })
    ] }),
    /* @__PURE__ */ jsxRuntimeExports.jsx(CardContent, { children: /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "text-center text-muted-foreground", children: /* @__PURE__ */ jsxRuntimeExports.jsx("p", { children: "You will need to login again to access your dashboard and secure tools." }) }) }),
    /* @__PURE__ */ jsxRuntimeExports.jsxs(CardFooter, { className: "flex flex-col gap-3", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsxs(Button, { variant: "destructive", className: "w-full font-bold uppercase tracking-wider h-11", onClick: handleLogout, children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx(LogOut, { className: "mr-2 h-4 w-4" }),
        " Yes, Log me out"
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsx(Button, { variant: "ghost", className: "w-full text-slate-500", asChild: true, children: /* @__PURE__ */ jsxRuntimeExports.jsxs(Link, { to: "/dashboard", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx(ArrowLeft, { className: "mr-2 h-4 w-4" }),
        " Cancel and Return"
      ] }) })
    ] })
  ] }) });
};
export {
  LogoutPage as default
};
//# sourceMappingURL=LogoutPage-BdIrTT_0.js.map
