import { r as reactExports, l as useNavigate, u as useToast, b as useAuthPhp, j as jsxRuntimeExports, m as Link, n as Logo, S as Shield, d as Card, g as CardHeader, h as CardTitle, e as CardContent, I as Input, o as Lock, B as Button, A as ArrowRight, p as CardFooter } from "./index-lF0PjX8A.js";
import { L as Label } from "./label-DlbB9OQ3.js";
import { S as Sparkles } from "./sparkles-CI8wD0yV.js";
import { U as User } from "./user-Dn054T1A.js";
import { M as Mail } from "./mail-CiX6a04S.js";
import { E as EyeOff } from "./eye-off-Dp5Xm-V_.js";
import { E as Eye } from "./eye-9xkahhb0.js";
import { L as LogIn } from "./log-in-BR4wvwhC.js";
const tips = [
  "Keep your password secure and never share it",
  "Use a strong password with mixed characters",
  "Enable notifications to stay updated",
  "Check your dashboard regularly for updates",
  "Contact support if you need any help"
];
const LoginPage = () => {
  const [email, setEmail] = reactExports.useState("");
  const [password, setPassword] = reactExports.useState("");
  const [showPassword, setShowPassword] = reactExports.useState(false);
  const [loading, setLoading] = reactExports.useState(false);
  const [tipIndex, setTipIndex] = reactExports.useState(0);
  const navigate = useNavigate();
  const { toast } = useToast();
  const { login } = useAuthPhp();
  reactExports.useEffect(() => {
    const interval = setInterval(() => {
      setTipIndex((prev) => (prev + 1) % tips.length);
    }, 4e3);
    return () => clearInterval(interval);
  }, []);
  const handleSubmit = async (e) => {
    e.preventDefault();
    setLoading(true);
    try {
      const response = await login(email, password);
      if (!response.success) {
        toast({
          title: "Login Error",
          description: response.error,
          variant: "destructive"
        });
        return;
      }
      if (response.success) {
        toast({
          title: "Success!",
          description: "Logged in successfully."
        });
        navigate("/dashboard");
      }
    } catch (error) {
      toast({
        title: "Login Error",
        description: "An unexpected error occurred during login.",
        variant: "destructive"
      });
    } finally {
      setLoading(false);
    }
  };
  return /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "min-h-screen flex overflow-hidden bg-background", children: [
    /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "hidden lg:flex lg:w-1/2 relative bg-gradient-to-br from-flashcore-purple via-flashcore-green to-flashcore-orange p-12 flex-col justify-between overflow-hidden", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "absolute inset-0 opacity-10", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "absolute top-0 left-0 w-96 h-96 bg-white rounded-full blur-3xl animate-pulse-glow", style: { animationDelay: "0s" } }),
        /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "absolute bottom-0 right-0 w-96 h-96 bg-white rounded-full blur-3xl animate-pulse-glow", style: { animationDelay: "1s" } }),
        /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "absolute top-1/2 left-1/2 -translate-x-1/2 -translate-y-1/2 w-96 h-96 bg-white rounded-full blur-3xl animate-pulse-glow", style: { animationDelay: "2s" } })
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "relative z-10", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsxs(Link, { to: "/", className: "flex items-center gap-3 group", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx(Logo, { className: "w-16 h-16 drop-shadow-2xl transition-transform group-hover:scale-110 duration-300" }),
          /* @__PURE__ */ jsxRuntimeExports.jsx("h1", { className: "text-5xl font-bold text-white drop-shadow-lg", children: "FLASHCORE" })
        ] }),
        /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-white/90 text-lg mt-6 max-w-md leading-relaxed", children: "Secure, fast, and reliable license management platform for modern businesses." })
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "relative z-10 space-y-6", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "bg-white/10 backdrop-blur-md border border-white/20 rounded-2xl p-6 transition-all duration-500 hover:bg-white/15", children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-start gap-4", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "bg-white/20 p-3 rounded-xl", children: /* @__PURE__ */ jsxRuntimeExports.jsx(Sparkles, { className: "w-6 h-6 text-white" }) }),
          /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex-1", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx("h3", { className: "text-white font-semibold text-lg mb-2", children: "Security Tip" }),
            /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-white/80 text-sm leading-relaxed transition-all duration-500", children: tips[tipIndex] })
          ] })
        ] }) }),
        /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "grid grid-cols-2 gap-4", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "bg-white/10 backdrop-blur-md border border-white/20 rounded-xl p-4 hover:bg-white/15 transition-all", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx(Shield, { className: "w-8 h-8 text-white mb-2" }),
            /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-white/90 text-sm font-medium", children: "Enterprise Security" })
          ] }),
          /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "bg-white/10 backdrop-blur-md border border-white/20 rounded-xl p-4 hover:bg-white/15 transition-all", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx(Sparkles, { className: "w-8 h-8 text-white mb-2" }),
            /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-white/90 text-sm font-medium", children: "24/7 Support" })
          ] })
        ] })
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "absolute bottom-0 left-0 w-full h-32 bg-gradient-to-t from-black/20 to-transparent pointer-events-none" })
    ] }),
    /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex-1 flex items-center justify-center p-4 lg:p-12 relative", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "absolute top-6 left-6 lg:hidden", children: /* @__PURE__ */ jsxRuntimeExports.jsxs(Link, { to: "/", className: "flex items-center gap-2", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx(Logo, { className: "w-10 h-10 drop-shadow-lg" }),
        /* @__PURE__ */ jsxRuntimeExports.jsx("h1", { className: "text-2xl font-bold bg-gradient-to-r from-flashcore-purple via-flashcore-green to-flashcore-orange bg-clip-text text-transparent", children: "FLASHCORE" })
      ] }) }),
      /* @__PURE__ */ jsxRuntimeExports.jsxs(Card, { className: "w-full max-w-md border-0 shadow-2xl bg-card/50 backdrop-blur-sm", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsxs(CardHeader, { className: "space-y-3 pb-6", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "flex items-center justify-center", children: /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "bg-gradient-to-br from-flashcore-purple to-flashcore-green p-4 rounded-2xl shadow-lg", children: /* @__PURE__ */ jsxRuntimeExports.jsx(User, { className: "w-8 h-8 text-white" }) }) }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(CardTitle, { className: "text-3xl font-bold text-center", children: "Welcome Back" }),
          /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-center text-muted-foreground text-sm", children: "Sign in to your account to continue" })
        ] }),
        /* @__PURE__ */ jsxRuntimeExports.jsxs(CardContent, { children: [
          /* @__PURE__ */ jsxRuntimeExports.jsxs("form", { onSubmit: handleSubmit, className: "space-y-5", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "space-y-2", children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx(Label, { htmlFor: "email", className: "text-sm font-medium", children: "Email Address" }),
              /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "relative group", children: [
                /* @__PURE__ */ jsxRuntimeExports.jsx(Mail, { className: "absolute left-3 top-1/2 -translate-y-1/2 w-5 h-5 text-muted-foreground group-focus-within:text-flashcore-purple transition-colors" }),
                /* @__PURE__ */ jsxRuntimeExports.jsx(
                  Input,
                  {
                    id: "email",
                    type: "email",
                    placeholder: "name@example.com",
                    required: true,
                    value: email,
                    onChange: (e) => setEmail(e.target.value),
                    autoFocus: true,
                    autoComplete: "username",
                    className: "pl-10 h-12 bg-background/50 border-border/50 focus:border-flashcore-purple focus:ring-flashcore-purple/20 transition-all"
                  }
                )
              ] })
            ] }),
            /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "space-y-2", children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx(Label, { htmlFor: "password", className: "text-sm font-medium", children: "Password" }),
              /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "relative group", children: [
                /* @__PURE__ */ jsxRuntimeExports.jsx(Lock, { className: "absolute left-3 top-1/2 -translate-y-1/2 w-5 h-5 text-muted-foreground group-focus-within:text-flashcore-purple transition-colors" }),
                /* @__PURE__ */ jsxRuntimeExports.jsx(
                  Input,
                  {
                    id: "password",
                    type: showPassword ? "text" : "password",
                    placeholder: "••••••••",
                    required: true,
                    value: password,
                    onChange: (e) => setPassword(e.target.value),
                    autoComplete: "current-password",
                    className: "pl-10 pr-12 h-12 bg-background/50 border-border/50 focus:border-flashcore-purple focus:ring-flashcore-purple/20 transition-all"
                  }
                ),
                /* @__PURE__ */ jsxRuntimeExports.jsx(
                  "button",
                  {
                    type: "button",
                    tabIndex: -1,
                    className: "absolute right-3 top-1/2 -translate-y-1/2 text-muted-foreground hover:text-flashcore-purple transition-colors p-1",
                    onClick: () => setShowPassword((v) => !v),
                    "aria-label": showPassword ? "Hide password" : "Show password",
                    children: showPassword ? /* @__PURE__ */ jsxRuntimeExports.jsx(EyeOff, { className: "w-5 h-5" }) : /* @__PURE__ */ jsxRuntimeExports.jsx(Eye, { className: "w-5 h-5" })
                  }
                )
              ] })
            ] }),
            /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "flex items-center justify-between text-sm", children: /* @__PURE__ */ jsxRuntimeExports.jsx(
              Link,
              {
                to: "/forgot-password",
                className: "text-flashcore-purple hover:text-flashcore-green font-medium transition-colors hover:underline",
                children: "Forgot password?"
              }
            ) }),
            /* @__PURE__ */ jsxRuntimeExports.jsx(
              Button,
              {
                type: "submit",
                className: "w-full h-12 bg-gradient-to-r from-flashcore-purple via-flashcore-green to-flashcore-orange hover:opacity-90 transition-all duration-300 hover:scale-[1.02] active:scale-95 shadow-lg text-white font-semibold text-base",
                disabled: loading,
                children: loading ? /* @__PURE__ */ jsxRuntimeExports.jsxs("span", { className: "flex items-center gap-2", children: [
                  /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "w-5 h-5 border-2 border-white/30 border-t-white rounded-full animate-spin" }),
                  "Signing In..."
                ] }) : /* @__PURE__ */ jsxRuntimeExports.jsxs("span", { className: "flex items-center gap-2", children: [
                  /* @__PURE__ */ jsxRuntimeExports.jsx(LogIn, { className: "w-5 h-5" }),
                  "Sign In",
                  /* @__PURE__ */ jsxRuntimeExports.jsx(ArrowRight, { className: "w-5 h-5" })
                ] })
              }
            )
          ] }),
          /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "mt-6 text-center", children: /* @__PURE__ */ jsxRuntimeExports.jsxs("p", { className: "text-sm text-muted-foreground", children: [
            "Need help?",
            " ",
            /* @__PURE__ */ jsxRuntimeExports.jsx(
              Link,
              {
                to: "/contact",
                className: "text-flashcore-purple hover:text-flashcore-green font-medium transition-colors hover:underline",
                children: "Contact support"
              }
            )
          ] }) })
        ] }),
        /* @__PURE__ */ jsxRuntimeExports.jsxs(CardFooter, { className: "flex flex-col gap-4 border-t border-border/50 pt-6", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsxs("p", { className: "text-sm text-center text-muted-foreground", children: [
            "Don't have an account?",
            " ",
            /* @__PURE__ */ jsxRuntimeExports.jsx(
              Link,
              {
                to: "/register",
                className: "text-flashcore-green font-semibold hover:text-flashcore-purple transition-colors hover:underline",
                children: "Create an account"
              }
            )
          ] }),
          /* @__PURE__ */ jsxRuntimeExports.jsxs(
            Link,
            {
              to: "/admin-login",
              className: "text-xs text-center text-muted-foreground hover:text-flashcore-purple transition-colors hover:underline flex items-center justify-center gap-1",
              children: [
                /* @__PURE__ */ jsxRuntimeExports.jsx(Shield, { className: "w-3 h-3" }),
                "Admin Login"
              ]
            }
          )
        ] })
      ] })
    ] }),
    /* @__PURE__ */ jsxRuntimeExports.jsx("style", { children: `
        @keyframes pulse-glow {
          0%, 100% { 
            opacity: 0.1;
            transform: scale(1);
          }
          50% { 
            opacity: 0.2;
            transform: scale(1.1);
          }
        }
      ` })
  ] });
};
export {
  LoginPage as default
};
//# sourceMappingURL=LoginPage-DaH2I4gt.js.map
