import { c as createLucideIcon, r as reactExports, j as jsxRuntimeExports, L as Layout, B as Button, i as Card, l as CardHeader, m as CardTitle, k as CardContent, T as TrendingUp, b1 as Info } from "./index-GlGoHQS3.js";
import { P as Progress } from "./progress-j_YCQ-Bf.js";
import { u as useLendingData, L as LendingActionModal } from "./useLendingData-3IgjSCRv.js";
import { A as Activity } from "./activity-CDR2ngcI.js";
import { S as ShieldCheck } from "./shield-check-0Xl-UF83.js";
/**
 * @license lucide-react v0.462.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */
const CircleArrowDown = createLucideIcon("CircleArrowDown", [
  ["circle", { cx: "12", cy: "12", r: "10", key: "1mglay" }],
  ["path", { d: "M12 8v8", key: "napkw2" }],
  ["path", { d: "m8 12 4 4 4-4", key: "k98ssh" }]
]);
/**
 * @license lucide-react v0.462.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */
const CircleArrowUp = createLucideIcon("CircleArrowUp", [
  ["circle", { cx: "12", cy: "12", r: "10", key: "1mglay" }],
  ["path", { d: "m16 12-4-4-4 4", key: "177agl" }],
  ["path", { d: "M12 16V8", key: "1sbj14" }]
]);
const LendingPage = () => {
  const { markets, deposits, borrows, loading, refresh } = useLendingData();
  const [modalOpen, setModalOpen] = reactExports.useState(false);
  const [selectedMarket, setSelectedMarket] = reactExports.useState(null);
  const [selectedAction, setSelectedAction] = reactExports.useState("supply");
  const handleAction = (market, action) => {
    setSelectedMarket(market);
    setSelectedAction(action);
    setModalOpen(true);
  };
  const totalSupplied = deposits.reduce((acc, curr) => acc + parseFloat(curr.amount), 0);
  const totalBorrowed = borrows.reduce((acc, curr) => acc + parseFloat(curr.amount), 0);
  const healthFactor = totalBorrowed === 0 ? 100 : Math.min(100, totalSupplied * 0.75 / totalBorrowed * 20);
  return /* @__PURE__ */ jsxRuntimeExports.jsxs(Layout, { children: [
    /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "space-y-8 animate-in fade-in duration-500", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "flex flex-col md:flex-row justify-between items-start md:items-center gap-4", children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx("h1", { className: "text-3xl font-bold bg-gradient-to-r from-flashcore-purple to-flashcore-green bg-clip-text text-transparent", children: "Lending Platform" }),
        /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-muted-foreground", children: "Supply assets to earn interest or borrow against your collateral" })
      ] }) }),
      /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "flex flex-wrap gap-4 p-4 rounded-2xl bg-muted/20 border border-border/50 backdrop-blur-sm", children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex flex-col gap-1", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx("span", { className: "text-xs font-semibold text-muted-foreground uppercase ml-1", children: "Quick Actions" }),
        /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex gap-2", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsxs(Button, { onClick: () => handleAction(markets[0], "supply"), variant: "secondary", className: "bg-flashcore-green/20 text-flashcore-green hover:bg-flashcore-green/30 border-flashcore-green/20", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx(CircleArrowUp, { className: "w-4 h-4 mr-2" }),
            " Supply"
          ] }),
          /* @__PURE__ */ jsxRuntimeExports.jsxs(Button, { onClick: () => handleAction(markets[0], "borrow"), variant: "secondary", className: "bg-orange-500/20 text-orange-500 hover:bg-orange-500/30 border-orange-500/20", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx(CircleArrowDown, { className: "w-4 h-4 mr-2" }),
            " Borrow"
          ] })
        ] })
      ] }) }),
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "grid grid-cols-1 md:grid-cols-3 gap-6", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsxs(Card, { className: "bg-gradient-to-br from-background to-flashcore-purple/10 border-border/50 shadow-sm transition-all hover:shadow-flashcore-purple/5", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx(CardHeader, { className: "pb-2", children: /* @__PURE__ */ jsxRuntimeExports.jsx(CardTitle, { className: "text-sm font-medium text-muted-foreground uppercase", children: "Net APY" }) }),
          /* @__PURE__ */ jsxRuntimeExports.jsxs(CardContent, { children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "text-3xl font-bold text-flashcore-green", children: "+4.25%" }),
            /* @__PURE__ */ jsxRuntimeExports.jsxs("p", { className: "text-xs text-muted-foreground mt-1 flex items-center gap-1", children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx(TrendingUp, { className: "w-3 h-3" }),
              " Average market yield"
            ] })
          ] })
        ] }),
        /* @__PURE__ */ jsxRuntimeExports.jsxs(Card, { className: "bg-gradient-to-br from-background to-orange-500/10 border-border/50 shadow-sm", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx(CardHeader, { className: "pb-2", children: /* @__PURE__ */ jsxRuntimeExports.jsx(CardTitle, { className: "text-sm font-medium text-muted-foreground uppercase", children: "Health Factor" }) }),
          /* @__PURE__ */ jsxRuntimeExports.jsxs(CardContent, { className: "space-y-3", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex justify-between items-end", children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "text-3xl font-bold text-primary", children: totalBorrowed === 0 ? "∞" : healthFactor.toFixed(2) }),
              /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "text-xs font-medium text-muted-foreground mb-1", children: "Limit: 1.0" })
            ] }),
            /* @__PURE__ */ jsxRuntimeExports.jsx(Progress, { value: totalBorrowed === 0 ? 100 : healthFactor, className: "h-2 bg-muted-foreground/20" })
          ] })
        ] }),
        /* @__PURE__ */ jsxRuntimeExports.jsxs(Card, { className: "bg-gradient-to-br from-background to-flashcore-green/10 border-border/50 shadow-sm", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx(CardHeader, { className: "pb-2", children: /* @__PURE__ */ jsxRuntimeExports.jsx(CardTitle, { className: "text-sm font-medium text-muted-foreground uppercase", children: "Total Position" }) }),
          /* @__PURE__ */ jsxRuntimeExports.jsxs(CardContent, { children: [
            /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "text-3xl font-bold", children: [
              "$",
              (totalSupplied - totalBorrowed).toFixed(2)
            ] }),
            /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-xs text-muted-foreground mt-1", children: "Equity (Supply - Borrow)" })
          ] })
        ] })
      ] }),
      (deposits.length > 0 || borrows.length > 0) && /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "grid grid-cols-1 md:grid-cols-2 gap-6", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsxs(Card, { className: "border-border/50 bg-background/50 backdrop-blur-sm", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx(CardHeader, { className: "pb-3 border-b border-border/10", children: /* @__PURE__ */ jsxRuntimeExports.jsxs(CardTitle, { className: "text-sm flex items-center gap-2", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "p-1 px-2 rounded-md bg-flashcore-green/10 text-flashcore-green text-[10px] font-black uppercase", children: "Active" }),
            "My Supplies"
          ] }) }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(CardContent, { className: "space-y-3 pt-4 text-center py-8", children: deposits.length === 0 ? /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "text-muted-foreground text-sm italic", children: "No active supplies" }) : deposits.map((dep) => {
            const market = markets.find((m) => m.symbol === dep.symbol);
            return /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex justify-between items-center p-3 rounded-xl bg-muted/30 border border-border/20 transition-all hover:bg-muted/50", children: [
              /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center gap-2", children: [
                /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: `w-8 h-8 rounded-full bg-gradient-to-br ${market == null ? void 0 : market.color} flex items-center justify-center text-xs text-white shadow-sm font-bold`, children: dep.symbol[0] }),
                /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "text-sm font-bold", children: [
                  parseFloat(dep.amount).toFixed(4),
                  " ",
                  dep.symbol
                ] })
              ] }),
              /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex gap-2", children: [
                /* @__PURE__ */ jsxRuntimeExports.jsx(Button, { size: "sm", variant: "ghost", className: "text-flashcore-green hover:bg-flashcore-green/10", onClick: () => handleAction(market, "supply"), children: "Supply" }),
                /* @__PURE__ */ jsxRuntimeExports.jsx(Button, { size: "sm", variant: "ghost", className: "text-red-400 hover:bg-red-400/10", onClick: () => handleAction(market, "withdraw"), children: "Withdraw" })
              ] })
            ] }, dep.id);
          }) })
        ] }),
        /* @__PURE__ */ jsxRuntimeExports.jsxs(Card, { className: "border-border/50 bg-background/50 backdrop-blur-sm", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx(CardHeader, { className: "pb-3 border-b border-border/10", children: /* @__PURE__ */ jsxRuntimeExports.jsxs(CardTitle, { className: "text-sm flex items-center gap-2", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "p-1 px-2 rounded-md bg-orange-500/10 text-orange-500 text-[10px] font-black uppercase", children: "Active" }),
            "My Borrows"
          ] }) }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(CardContent, { className: "space-y-3 pt-4 text-center py-8", children: borrows.length === 0 ? /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "text-muted-foreground text-sm italic", children: "No active borrows" }) : borrows.map((bor) => {
            const market = markets.find((m) => m.symbol === bor.symbol);
            return /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex justify-between items-center p-3 rounded-xl bg-muted/30 border border-border/20 transition-all hover:bg-muted/50", children: [
              /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center gap-2", children: [
                /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: `w-8 h-8 rounded-full bg-gradient-to-br ${market == null ? void 0 : market.color} flex items-center justify-center text-xs text-white shadow-sm font-bold`, children: bor.symbol[0] }),
                /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "text-sm font-bold", children: [
                  parseFloat(bor.amount).toFixed(4),
                  " ",
                  bor.symbol
                ] })
              ] }),
              /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex gap-2", children: [
                /* @__PURE__ */ jsxRuntimeExports.jsx(Button, { size: "sm", variant: "ghost", className: "text-primary hover:bg-primary/10", onClick: () => handleAction(market, "borrow"), children: "Borrow" }),
                /* @__PURE__ */ jsxRuntimeExports.jsx(Button, { size: "sm", variant: "ghost", className: "text-flashcore-green hover:bg-flashcore-green/10", onClick: () => handleAction(market, "repay"), children: "Repay" })
              ] })
            ] }, bor.id);
          }) })
        ] })
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsxs(Card, { className: "border-border/50 bg-background/50 backdrop-blur-sm shadow-xl", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsxs(CardHeader, { className: "flex flex-row items-center justify-between border-b border-border/10", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsxs(CardTitle, { className: "flex items-center gap-2 text-lg", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx(Activity, { className: "w-5 h-5 text-flashcore-purple" }),
            "Global Markets"
          ] }),
          /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "text-xs text-muted-foreground italic", children: "Live Rates" })
        ] }),
        /* @__PURE__ */ jsxRuntimeExports.jsx(CardContent, { className: "p-0", children: /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "overflow-x-auto", children: /* @__PURE__ */ jsxRuntimeExports.jsxs("table", { className: "w-full text-left border-collapse", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx("thead", { children: /* @__PURE__ */ jsxRuntimeExports.jsxs("tr", { className: "bg-muted/30 text-[10px] font-black text-muted-foreground uppercase tracking-widest", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx("th", { className: "px-6 py-4", children: "Financial Asset" }),
            /* @__PURE__ */ jsxRuntimeExports.jsx("th", { className: "px-6 py-4 text-right", children: "Supply APY" }),
            /* @__PURE__ */ jsxRuntimeExports.jsx("th", { className: "px-6 py-4 text-right", children: "Borrow APY" }),
            /* @__PURE__ */ jsxRuntimeExports.jsx("th", { className: "px-6 py-4 text-right", children: "Liquidity" }),
            /* @__PURE__ */ jsxRuntimeExports.jsx("th", { className: "px-6 py-4 text-right", children: "Action" })
          ] }) }),
          /* @__PURE__ */ jsxRuntimeExports.jsx("tbody", { className: "divide-y divide-border/20", children: markets.map((market) => /* @__PURE__ */ jsxRuntimeExports.jsxs("tr", { className: "hover:bg-muted/10 transition-colors group", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx("td", { className: "px-6 py-5", children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center gap-3", children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: `w-10 h-10 rounded-2xl bg-gradient-to-br ${market.color} flex items-center justify-center shadow-lg text-white font-bold text-lg`, children: market.symbol[0] }),
              /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { children: [
                /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "font-bold text-base", children: market.name }),
                /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "text-xs text-muted-foreground font-mono", children: market.symbol })
              ] })
            ] }) }),
            /* @__PURE__ */ jsxRuntimeExports.jsxs("td", { className: "px-6 py-5 text-right", children: [
              /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "font-black text-lg text-flashcore-green", children: [
                (market.supply_apy * 100).toFixed(2),
                "%"
              ] }),
              /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "text-[10px] text-muted-foreground uppercase", children: "Stable" })
            ] }),
            /* @__PURE__ */ jsxRuntimeExports.jsxs("td", { className: "px-6 py-5 text-right", children: [
              /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "font-black text-lg text-orange-500", children: [
                (market.borrow_apy * 100).toFixed(2),
                "%"
              ] }),
              /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "text-[10px] text-muted-foreground uppercase", children: "Variable" })
            ] }),
            /* @__PURE__ */ jsxRuntimeExports.jsxs("td", { className: "px-6 py-5 text-right font-mono", children: [
              /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "text-sm font-medium", children: [
                market.total_liquidity.toLocaleString(),
                " ",
                market.symbol
              ] }),
              /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "text-[10px] text-muted-foreground uppercase tracking-tight", children: "Available" })
            ] }),
            /* @__PURE__ */ jsxRuntimeExports.jsx("td", { className: "px-6 py-5 text-right", children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex justify-end gap-2", children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx(
                Button,
                {
                  variant: "ghost",
                  size: "sm",
                  className: "h-10 px-4 bg-flashcore-green/5 text-flashcore-green border border-flashcore-green/20 hover:bg-flashcore-green/20 font-bold",
                  onClick: () => handleAction(market, "supply"),
                  children: "Supply"
                }
              ),
              /* @__PURE__ */ jsxRuntimeExports.jsx(
                Button,
                {
                  variant: "ghost",
                  size: "sm",
                  className: "h-10 px-4 bg-primary/5 text-primary border border-primary/20 hover:bg-primary/20 font-bold",
                  onClick: () => handleAction(market, "borrow"),
                  children: "Borrow"
                }
              )
            ] }) })
          ] }, market.symbol)) })
        ] }) }) })
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "grid grid-cols-1 md:grid-cols-2 gap-6 pb-12", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsxs(Card, { className: "border-border/50 bg-background/30 backdrop-blur-sm", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx(CardHeader, { children: /* @__PURE__ */ jsxRuntimeExports.jsxs(CardTitle, { className: "text-xs font-bold uppercase tracking-widest flex items-center gap-2 text-flashcore-purple", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx(ShieldCheck, { className: "w-4 h-4" }),
            "Collateral Protection"
          ] }) }),
          /* @__PURE__ */ jsxRuntimeExports.jsxs(CardContent, { className: "text-sm text-muted-foreground space-y-2 leading-relaxed", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsxs("p", { children: [
              "Assets supplied to FlashCORE act as global collateral. We maintain a ",
              /* @__PURE__ */ jsxRuntimeExports.jsx("span", { className: "text-foreground font-bold italic", children: "75% Loan-to-Value (LTV)" }),
              " ratio across all markets to ensure platform stability."
            ] }),
            /* @__PURE__ */ jsxRuntimeExports.jsx("p", { children: "Real-time liquidation bots monitor the Health Factor. Maintain a score above 1.0 to keep your positions safe." })
          ] })
        ] }),
        /* @__PURE__ */ jsxRuntimeExports.jsxs(Card, { className: "border-border/50 bg-background/30 backdrop-blur-sm", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx(CardHeader, { children: /* @__PURE__ */ jsxRuntimeExports.jsxs(CardTitle, { className: "text-xs font-bold uppercase tracking-widest flex items-center gap-2 text-flashcore-green", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx(Info, { className: "w-4 h-4" }),
            "Algorithmic APY"
          ] }) }),
          /* @__PURE__ */ jsxRuntimeExports.jsxs(CardContent, { className: "text-sm text-muted-foreground space-y-2 leading-relaxed", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx("p", { children: "Interest rates are calculated per-block based on market utilization. High demand for an asset automatically increases the return for suppliers." }),
            /* @__PURE__ */ jsxRuntimeExports.jsx("p", { children: "Yield is auto-compounded and reflected in your balance every 15 seconds." })
          ] })
        ] })
      ] })
    ] }),
    /* @__PURE__ */ jsxRuntimeExports.jsx(
      LendingActionModal,
      {
        isOpen: modalOpen,
        onClose: () => setModalOpen(false),
        market: selectedMarket,
        action: selectedAction,
        onSuccess: refresh
      }
    )
  ] });
};
export {
  LendingPage as default
};
//# sourceMappingURL=LendingPage-DBkIFwS4.js.map
