import { q as React, j as jsxRuntimeExports, m as Link, B as Button, A as ArrowRight, d as Card, g as CardHeader, h as CardTitle, i as CardDescription, S as Shield, e as CardContent, C as Check, a as apiService } from "./index-BzIW3X45.js";
import { B as Badge } from "./badge-BVgALWId.js";
import { C as CryptoImageSlider } from "./CryptoImageSlider-CzMgcj_N.js";
import { Z as Zap } from "./zap-FPHo0ZvJ.js";
import { P as Play } from "./play-DB4MA2Ul.js";
import { M as Mail } from "./mail-DzNoCzbV.js";
import { C as CreditCard } from "./credit-card-BmfWlcHN.js";
import { R as Receipt } from "./receipt-CtuoYWWa.js";
import { F as FileText } from "./file-text-Cyvb-s8D.js";
import { C as ChartColumn } from "./chart-column-CSBmz-pk.js";
import { S as Star } from "./star-Dd-JSO6t.js";
import "./arrow-left-w1ImBORf.js";
const LandingPage = () => {
  const [stats, setStats] = React.useState({
    total_users: 1e4,
    total_emails: 1e6,
    uptime: "99.9%",
    active_campaigns: 247
  });
  React.useEffect(() => {
    const fetchStats = async () => {
      try {
        const response = await apiService.getPublicStats();
        if (response.data) {
          setStats(response.data);
        }
      } catch (error) {
        console.error("Failed to fetch landing stats:", error);
      }
    };
    fetchStats();
  }, []);
  const formatNumber = (num) => {
    if (num >= 1e6) return (num / 1e6).toFixed(1) + "M+";
    if (num >= 1e3) return (num / 1e3).toFixed(0) + "K+";
    return num.toString();
  };
  return /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex flex-col", children: [
    /* @__PURE__ */ jsxRuntimeExports.jsx("section", { className: "container mx-auto px-4 py-12 md:py-20 text-center", children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "max-w-4xl mx-auto", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsxs(Badge, { variant: "secondary", className: "mb-4", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx(Zap, { className: "w-3 h-3 mr-1" }),
        "Professional Email Automation"
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsx("h1", { className: "text-4xl md:text-5xl lg:text-6xl font-bold mb-6 bg-gradient-to-r from-flashcore-purple via-flashcore-green to-flashcore-orange bg-clip-text text-transparent", children: "FlashCore Pulse Dashboard" }),
      /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-lg md:text-xl text-muted-foreground mb-8 max-w-2xl mx-auto", children: "Streamline your business communications with AI-powered email automation, professional templates, and comprehensive analytics." }),
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex flex-col sm:flex-row gap-4 justify-center mb-12", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx(Link, { to: "/register", children: /* @__PURE__ */ jsxRuntimeExports.jsxs(Button, { size: "lg", className: "bg-gradient-to-r from-flashcore-purple to-flashcore-green", children: [
          "Start Free Trial",
          /* @__PURE__ */ jsxRuntimeExports.jsx(ArrowRight, { className: "w-4 h-4 ml-2" })
        ] }) }),
        /* @__PURE__ */ jsxRuntimeExports.jsx(Link, { to: "/flash", children: /* @__PURE__ */ jsxRuntimeExports.jsxs(Button, { size: "lg", variant: "outline", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx(Play, { className: "w-4 h-4 mr-2" }),
          "View Demo"
        ] }) })
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "mt-12 w-full animate-in fade-in zoom-in duration-700 delay-300", children: /* @__PURE__ */ jsxRuntimeExports.jsx(CryptoImageSlider, {}) }),
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "grid grid-cols-2 md:grid-cols-4 gap-6 md:gap-8 mt-12 md:mt-16", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "text-center", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "text-2xl md:text-3xl font-bold text-flashcore-purple mb-2", children: formatNumber(stats.total_users) }),
          /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "text-xs md:text-sm text-muted-foreground", children: "Active Users" })
        ] }),
        /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "text-center", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "text-2xl md:text-3xl font-bold text-flashcore-green mb-2", children: formatNumber(stats.total_emails) }),
          /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "text-xs md:text-sm text-muted-foreground", children: "Emails Sent" })
        ] }),
        /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "text-center", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "text-2xl md:text-3xl font-bold text-flashcore-orange mb-2", children: stats.uptime }),
          /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "text-xs md:text-sm text-muted-foreground", children: "Uptime" })
        ] }),
        /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "text-center", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "text-2xl md:text-3xl font-bold text-blue-500 mb-2", children: "24/7" }),
          /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "text-xs md:text-sm text-muted-foreground", children: "Support" })
        ] })
      ] })
    ] }) }),
    /* @__PURE__ */ jsxRuntimeExports.jsxs("section", { className: "container mx-auto px-4 py-12 md:py-20 bg-muted/20", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "text-center mb-12 md:mb-16", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx("h2", { className: "text-2xl md:text-3xl font-bold mb-4", children: "How It Works" }),
        /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-muted-foreground max-w-2xl mx-auto", children: "Get started with FlashCore in just three simple steps" })
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "grid grid-cols-1 md:grid-cols-3 gap-8", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "text-center", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "w-12 h-12 md:w-16 md:h-16 bg-gradient-to-r from-flashcore-purple to-flashcore-green rounded-full flex items-center justify-center mx-auto mb-4 md:mb-6", children: /* @__PURE__ */ jsxRuntimeExports.jsx("span", { className: "text-xl md:text-2xl font-bold text-white", children: "1" }) }),
          /* @__PURE__ */ jsxRuntimeExports.jsx("h3", { className: "text-lg md:text-xl font-semibold mb-3 md:mb-4", children: "Connect Your Account" }),
          /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-sm md:text-base text-muted-foreground", children: "Sign up and connect your email accounts. We support all major email providers." })
        ] }),
        /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "text-center", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "w-12 h-12 md:w-16 md:h-16 bg-gradient-to-r from-flashcore-green to-flashcore-purple rounded-full flex items-center justify-center mx-auto mb-4 md:mb-6", children: /* @__PURE__ */ jsxRuntimeExports.jsx("span", { className: "text-xl md:text-2xl font-bold text-white", children: "2" }) }),
          /* @__PURE__ */ jsxRuntimeExports.jsx("h3", { className: "text-lg md:text-xl font-semibold mb-3 md:mb-4", children: "Choose Templates" }),
          /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-sm md:text-base text-muted-foreground", children: "Select from our library of professional templates or create your own custom designs." })
        ] }),
        /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "text-center", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "w-12 h-12 md:w-16 md:h-16 bg-gradient-to-r from-flashcore-orange to-flashcore-purple rounded-full flex items-center justify-center mx-auto mb-4 md:mb-6", children: /* @__PURE__ */ jsxRuntimeExports.jsx("span", { className: "text-xl md:text-2xl font-bold text-white", children: "3" }) }),
          /* @__PURE__ */ jsxRuntimeExports.jsx("h3", { className: "text-lg md:text-xl font-semibold mb-3 md:mb-4", children: "Automate & Scale" }),
          /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-sm md:text-base text-muted-foreground", children: "Set up automated workflows and watch your business communications scale effortlessly." })
        ] })
      ] })
    ] }),
    /* @__PURE__ */ jsxRuntimeExports.jsxs("section", { className: "container mx-auto px-4 py-12 md:py-20", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "text-center mb-12 md:mb-16", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx("h2", { className: "text-2xl md:text-3xl font-bold mb-4", children: "Powerful Features" }),
        /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-muted-foreground max-w-2xl mx-auto", children: "Everything you need to automate your business communications and grow your revenue." })
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6 md:gap-8", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx(Card, { className: "hover:shadow-lg transition-shadow", children: /* @__PURE__ */ jsxRuntimeExports.jsxs(CardHeader, { children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "w-10 h-10 md:w-12 md:h-12 bg-gradient-to-r from-flashcore-purple to-flashcore-green rounded-lg flex items-center justify-center mb-4", children: /* @__PURE__ */ jsxRuntimeExports.jsx(Mail, { className: "w-5 h-5 md:w-6 md:h-6 text-white" }) }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(CardTitle, { className: "text-lg md:text-xl", children: "Email Automation" }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(CardDescription, { children: "Automate your email workflows with professional templates and smart scheduling." })
        ] }) }),
        /* @__PURE__ */ jsxRuntimeExports.jsx(Card, { className: "hover:shadow-lg transition-shadow", children: /* @__PURE__ */ jsxRuntimeExports.jsxs(CardHeader, { children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "w-10 h-10 md:w-12 md:h-12 bg-gradient-to-r from-flashcore-green to-flashcore-purple rounded-lg flex items-center justify-center mb-4", children: /* @__PURE__ */ jsxRuntimeExports.jsx(CreditCard, { className: "w-5 h-5 md:w-6 md:h-6 text-white" }) }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(CardTitle, { className: "text-lg md:text-xl", children: "Billing & Invoices" }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(CardDescription, { children: "Generate professional billing emails and invoices with automated follow-ups." })
        ] }) }),
        /* @__PURE__ */ jsxRuntimeExports.jsx(Card, { className: "hover:shadow-lg transition-shadow", children: /* @__PURE__ */ jsxRuntimeExports.jsxs(CardHeader, { children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "w-10 h-10 md:w-12 md:h-12 bg-gradient-to-r from-blue-500 to-purple-500 rounded-lg flex items-center justify-center mb-4", children: /* @__PURE__ */ jsxRuntimeExports.jsx(Receipt, { className: "w-5 h-5 md:w-6 md:h-6 text-white" }) }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(CardTitle, { className: "text-lg md:text-xl", children: "Receipt Generation" }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(CardDescription, { children: "Create and send professional receipts with customizable templates." })
        ] }) }),
        /* @__PURE__ */ jsxRuntimeExports.jsx(Card, { className: "hover:shadow-lg transition-shadow", children: /* @__PURE__ */ jsxRuntimeExports.jsxs(CardHeader, { children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "w-10 h-10 md:w-12 md:h-12 bg-gradient-to-r from-purple-500 to-pink-500 rounded-lg flex items-center justify-center mb-4", children: /* @__PURE__ */ jsxRuntimeExports.jsx(FileText, { className: "w-5 h-5 md:w-6 md:h-6 text-white" }) }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(CardTitle, { className: "text-lg md:text-xl", children: "Transaction Management" }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(CardDescription, { children: "Handle transaction confirmations and statements with ease." })
        ] }) }),
        /* @__PURE__ */ jsxRuntimeExports.jsx(Card, { className: "hover:shadow-lg transition-shadow", children: /* @__PURE__ */ jsxRuntimeExports.jsxs(CardHeader, { children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "w-10 h-10 md:w-12 md:h-12 bg-gradient-to-r from-orange-500 to-red-500 rounded-lg flex items-center justify-center mb-4", children: /* @__PURE__ */ jsxRuntimeExports.jsx(ChartColumn, { className: "w-5 h-5 md:w-6 md:h-6 text-white" }) }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(CardTitle, { className: "text-lg md:text-xl", children: "Analytics & Insights" }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(CardDescription, { children: "Track email performance and get detailed analytics on your campaigns." })
        ] }) }),
        /* @__PURE__ */ jsxRuntimeExports.jsx(Card, { className: "hover:shadow-lg transition-shadow", children: /* @__PURE__ */ jsxRuntimeExports.jsxs(CardHeader, { children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "w-10 h-10 md:w-12 md:h-12 bg-gradient-to-r from-green-500 to-blue-500 rounded-lg flex items-center justify-center mb-4", children: /* @__PURE__ */ jsxRuntimeExports.jsx(Shield, { className: "w-5 h-5 md:w-6 md:h-6 text-white" }) }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(CardTitle, { className: "text-lg md:text-xl", children: "Enterprise Security" }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(CardDescription, { children: "Bank-level security with encryption and compliance standards." })
        ] }) })
      ] })
    ] }),
    /* @__PURE__ */ jsxRuntimeExports.jsxs("section", { className: "container mx-auto px-4 py-12 md:py-20 bg-muted/20", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "text-center mb-12 md:mb-16", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx("h2", { className: "text-2xl md:text-3xl font-bold mb-4", children: "Simple, Transparent Pricing" }),
        /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-muted-foreground max-w-2xl mx-auto", children: "Choose the plan that fits your business needs. All plans include our core features." })
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "grid grid-cols-1 md:grid-cols-3 gap-6 md:gap-8 max-w-5xl mx-auto", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsxs(Card, { className: "relative", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsxs(CardHeader, { className: "text-center", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx(CardTitle, { className: "text-xl md:text-2xl", children: "Basic" }),
            /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "text-3xl md:text-4xl font-bold text-flashcore-purple", children: [
              "$9.99",
              /* @__PURE__ */ jsxRuntimeExports.jsx("span", { className: "text-base md:text-lg text-muted-foreground", children: "/month" })
            ] }),
            /* @__PURE__ */ jsxRuntimeExports.jsx(CardDescription, { children: "Perfect for small businesses" })
          ] }),
          /* @__PURE__ */ jsxRuntimeExports.jsxs(CardContent, { className: "space-y-4", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "space-y-2", children: [
              /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center", children: [
                /* @__PURE__ */ jsxRuntimeExports.jsx(Check, { className: "w-4 h-4 text-green-500 mr-2" }),
                /* @__PURE__ */ jsxRuntimeExports.jsx("span", { className: "text-sm md:text-base", children: "1,000 emails per month" })
              ] }),
              /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center", children: [
                /* @__PURE__ */ jsxRuntimeExports.jsx(Check, { className: "w-4 h-4 text-green-500 mr-2" }),
                /* @__PURE__ */ jsxRuntimeExports.jsx("span", { className: "text-sm md:text-base", children: "Basic templates" })
              ] }),
              /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center", children: [
                /* @__PURE__ */ jsxRuntimeExports.jsx(Check, { className: "w-4 h-4 text-green-500 mr-2" }),
                /* @__PURE__ */ jsxRuntimeExports.jsx("span", { className: "text-sm md:text-base", children: "Email analytics" })
              ] }),
              /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center", children: [
                /* @__PURE__ */ jsxRuntimeExports.jsx(Check, { className: "w-4 h-4 text-green-500 mr-2" }),
                /* @__PURE__ */ jsxRuntimeExports.jsx("span", { className: "text-sm md:text-base", children: "24/7 support" })
              ] })
            ] }),
            /* @__PURE__ */ jsxRuntimeExports.jsx(Link, { to: "/register", children: /* @__PURE__ */ jsxRuntimeExports.jsx(Button, { className: "w-full bg-gradient-to-r from-flashcore-purple to-flashcore-green", children: "Get Started" }) })
          ] })
        ] }),
        /* @__PURE__ */ jsxRuntimeExports.jsxs(Card, { className: "relative border-2 border-flashcore-purple", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "absolute -top-3 left-1/2 transform -translate-x-1/2", children: /* @__PURE__ */ jsxRuntimeExports.jsx(Badge, { className: "bg-flashcore-purple text-white", children: "Most Popular" }) }),
          /* @__PURE__ */ jsxRuntimeExports.jsxs(CardHeader, { className: "text-center", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx(CardTitle, { className: "text-xl md:text-2xl", children: "Pro" }),
            /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "text-3xl md:text-4xl font-bold text-flashcore-green", children: [
              "$29.99",
              /* @__PURE__ */ jsxRuntimeExports.jsx("span", { className: "text-base md:text-lg text-muted-foreground", children: "/month" })
            ] }),
            /* @__PURE__ */ jsxRuntimeExports.jsx(CardDescription, { children: "For growing businesses" })
          ] }),
          /* @__PURE__ */ jsxRuntimeExports.jsxs(CardContent, { className: "space-y-4", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "space-y-2", children: [
              /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center", children: [
                /* @__PURE__ */ jsxRuntimeExports.jsx(Check, { className: "w-4 h-4 text-green-500 mr-2" }),
                /* @__PURE__ */ jsxRuntimeExports.jsx("span", { className: "text-sm md:text-base", children: "10,000 emails per month" })
              ] }),
              /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center", children: [
                /* @__PURE__ */ jsxRuntimeExports.jsx(Check, { className: "w-4 h-4 text-green-500 mr-2" }),
                /* @__PURE__ */ jsxRuntimeExports.jsx("span", { className: "text-sm md:text-base", children: "Advanced templates" })
              ] }),
              /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center", children: [
                /* @__PURE__ */ jsxRuntimeExports.jsx(Check, { className: "w-4 h-4 text-green-500 mr-2" }),
                /* @__PURE__ */ jsxRuntimeExports.jsx("span", { className: "text-sm md:text-base", children: "Advanced analytics" })
              ] }),
              /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center", children: [
                /* @__PURE__ */ jsxRuntimeExports.jsx(Check, { className: "w-4 h-4 text-green-500 mr-2" }),
                /* @__PURE__ */ jsxRuntimeExports.jsx("span", { className: "text-sm md:text-base", children: "Priority support" })
              ] }),
              /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center", children: [
                /* @__PURE__ */ jsxRuntimeExports.jsx(Check, { className: "w-4 h-4 text-green-500 mr-2" }),
                /* @__PURE__ */ jsxRuntimeExports.jsx("span", { className: "text-sm md:text-base", children: "Custom branding" })
              ] })
            ] }),
            /* @__PURE__ */ jsxRuntimeExports.jsx(Link, { to: "/register", children: /* @__PURE__ */ jsxRuntimeExports.jsx(Button, { className: "w-full bg-gradient-to-r from-flashcore-green to-flashcore-purple", children: "Get Started" }) })
          ] })
        ] }),
        /* @__PURE__ */ jsxRuntimeExports.jsxs(Card, { className: "relative", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsxs(CardHeader, { className: "text-center", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx(CardTitle, { className: "text-xl md:text-2xl", children: "Enterprise" }),
            /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "text-3xl md:text-4xl font-bold text-flashcore-orange", children: [
              "$99.99",
              /* @__PURE__ */ jsxRuntimeExports.jsx("span", { className: "text-base md:text-lg text-muted-foreground", children: "/month" })
            ] }),
            /* @__PURE__ */ jsxRuntimeExports.jsx(CardDescription, { children: "For large organizations" })
          ] }),
          /* @__PURE__ */ jsxRuntimeExports.jsxs(CardContent, { className: "space-y-4", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "space-y-2", children: [
              /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center", children: [
                /* @__PURE__ */ jsxRuntimeExports.jsx(Check, { className: "w-4 h-4 text-green-500 mr-2" }),
                /* @__PURE__ */ jsxRuntimeExports.jsx("span", { className: "text-sm md:text-base", children: "Unlimited emails" })
              ] }),
              /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center", children: [
                /* @__PURE__ */ jsxRuntimeExports.jsx(Check, { className: "w-4 h-4 text-green-500 mr-2" }),
                /* @__PURE__ */ jsxRuntimeExports.jsx("span", { className: "text-sm md:text-base", children: "Custom templates" })
              ] }),
              /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center", children: [
                /* @__PURE__ */ jsxRuntimeExports.jsx(Check, { className: "w-4 h-4 text-green-500 mr-2" }),
                /* @__PURE__ */ jsxRuntimeExports.jsx("span", { className: "text-sm md:text-base", children: "Advanced reporting" })
              ] }),
              /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center", children: [
                /* @__PURE__ */ jsxRuntimeExports.jsx(Check, { className: "w-4 h-4 text-green-500 mr-2" }),
                /* @__PURE__ */ jsxRuntimeExports.jsx("span", { className: "text-sm md:text-base", children: "Dedicated support" })
              ] }),
              /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center", children: [
                /* @__PURE__ */ jsxRuntimeExports.jsx(Check, { className: "w-4 h-4 text-green-500 mr-2" }),
                /* @__PURE__ */ jsxRuntimeExports.jsx("span", { className: "text-sm md:text-base", children: "API access" })
              ] })
            ] }),
            /* @__PURE__ */ jsxRuntimeExports.jsx(Link, { to: "/register", children: /* @__PURE__ */ jsxRuntimeExports.jsx(Button, { className: "w-full bg-gradient-to-r from-flashcore-orange to-flashcore-purple", children: "Get Started" }) })
          ] })
        ] })
      ] })
    ] }),
    /* @__PURE__ */ jsxRuntimeExports.jsxs("section", { className: "container mx-auto px-4 py-12 md:py-20", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "text-center mb-12 md:mb-16", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx("h2", { className: "text-2xl md:text-3xl font-bold mb-4", children: "What Our Customers Say" }),
        /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-muted-foreground max-w-2xl mx-auto", children: "Join thousands of satisfied customers who trust FlashCore for their business communications." })
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "grid grid-cols-1 md:grid-cols-3 gap-6 md:gap-8", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsxs(Card, { className: "p-4 md:p-6", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "flex items-center mb-4", children: [...Array(5)].map((_, i) => /* @__PURE__ */ jsxRuntimeExports.jsx(Star, { className: "w-4 h-4 text-yellow-400 fill-current" }, i)) }),
          /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-sm md:text-base text-muted-foreground mb-4", children: '"FlashCore has transformed how we handle customer communications. The automation features save us hours every week."' }),
          /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "w-8 h-8 md:w-10 md:h-10 bg-gradient-to-r from-flashcore-purple to-flashcore-green rounded-full flex items-center justify-center mr-3", children: /* @__PURE__ */ jsxRuntimeExports.jsx("span", { className: "text-white font-semibold text-sm md:text-base", children: "S" }) }),
            /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "font-semibold text-sm md:text-base", children: "Sarah Johnson" }),
              /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "text-xs md:text-sm text-muted-foreground", children: "Marketing Director, TechCorp" })
            ] })
          ] })
        ] }),
        /* @__PURE__ */ jsxRuntimeExports.jsxs(Card, { className: "p-4 md:p-6", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "flex items-center mb-4", children: [...Array(5)].map((_, i) => /* @__PURE__ */ jsxRuntimeExports.jsx(Star, { className: "w-4 h-4 text-yellow-400 fill-current" }, i)) }),
          /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-sm md:text-base text-muted-foreground mb-4", children: '"The billing automation feature alone has increased our revenue by 30%. Highly recommended!"' }),
          /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "w-8 h-8 md:w-10 md:h-10 bg-gradient-to-r from-flashcore-green to-flashcore-purple rounded-full flex items-center justify-center mr-3", children: /* @__PURE__ */ jsxRuntimeExports.jsx("span", { className: "text-white font-semibold text-sm md:text-base", children: "M" }) }),
            /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "font-semibold text-sm md:text-base", children: "Mike Chen" }),
              /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "text-xs md:text-sm text-muted-foreground", children: "CEO, StartupXYZ" })
            ] })
          ] })
        ] }),
        /* @__PURE__ */ jsxRuntimeExports.jsxs(Card, { className: "p-4 md:p-6", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "flex items-center mb-4", children: [...Array(5)].map((_, i) => /* @__PURE__ */ jsxRuntimeExports.jsx(Star, { className: "w-4 h-4 text-yellow-400 fill-current" }, i)) }),
          /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-sm md:text-base text-muted-foreground mb-4", children: '"Professional templates and reliable delivery. FlashCore has become an essential part of our business."' }),
          /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "w-8 h-8 md:w-10 md:h-10 bg-gradient-to-r from-flashcore-orange to-flashcore-purple rounded-full flex items-center justify-center mr-3", children: /* @__PURE__ */ jsxRuntimeExports.jsx("span", { className: "text-white font-semibold text-sm md:text-base", children: "E" }) }),
            /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "font-semibold text-sm md:text-base", children: "Emily Rodriguez" }),
              /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "text-xs md:text-sm text-muted-foreground", children: "Operations Manager, RetailPlus" })
            ] })
          ] })
        ] })
      ] })
    ] }),
    /* @__PURE__ */ jsxRuntimeExports.jsx("section", { className: "container mx-auto px-4 py-12 md:py-20", children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "bg-gradient-to-r from-flashcore-purple to-flashcore-green rounded-2xl p-6 md:p-8 lg:p-12 text-center text-white", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsx("h2", { className: "text-2xl md:text-3xl font-bold mb-4", children: "Ready to Transform Your Business?" }),
      /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-lg md:text-xl mb-6 md:mb-8 opacity-90", children: "Join thousands of businesses using FlashCore to automate their communications." }),
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex flex-col sm:flex-row gap-4 justify-center", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx(Link, { to: "/register", children: /* @__PURE__ */ jsxRuntimeExports.jsxs(Button, { size: "lg", variant: "secondary", className: "bg-white text-flashcore-purple hover:bg-gray-100", children: [
          "Get Started Free",
          /* @__PURE__ */ jsxRuntimeExports.jsx(ArrowRight, { className: "w-4 h-4 ml-2" })
        ] }) }),
        /* @__PURE__ */ jsxRuntimeExports.jsx(Link, { to: "/login", children: /* @__PURE__ */ jsxRuntimeExports.jsx(Button, { size: "lg", variant: "outline", className: "border-white text-white hover:bg-white hover:text-flashcore-purple", children: "Sign In" }) })
      ] })
    ] }) })
  ] });
};
export {
  LandingPage as default
};
//# sourceMappingURL=LandingPage-CVyL5EkB.js.map
