import { j as jsxRuntimeExports, L as Layout, d as Card, g as CardHeader, h as CardTitle, i as CardDescription, B as Button, m as Link, A as ArrowRight, e as CardContent } from "./index-D2CUDDtA.js";
import { M as Mail } from "./mail-Gt8-jms6.js";
import { C as CreditCard } from "./credit-card-Dq2eHGxV.js";
import { C as Calendar } from "./calendar-D9sWuVPJ.js";
const HistoryPage = () => {
  return /* @__PURE__ */ jsxRuntimeExports.jsx(Layout, { children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "space-y-6", children: [
    /* @__PURE__ */ jsxRuntimeExports.jsx("h1", { className: "text-3xl font-bold", children: "Account History" }),
    /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "grid grid-cols-1 md:grid-cols-2 gap-6", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsxs(Card, { className: "overflow-hidden hover:shadow-lg transition-shadow", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx(CardHeader, { className: "bg-gradient-to-r from-flashcore-purple/10 to-transparent border-b", children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center justify-between", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { children: [
            /* @__PURE__ */ jsxRuntimeExports.jsxs(CardTitle, { className: "flex items-center text-flashcore-purple", children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx(Mail, { className: "mr-2 h-5 w-5" }),
              " Mail History"
            ] }),
            /* @__PURE__ */ jsxRuntimeExports.jsx(CardDescription, { children: "Track all your email communications" })
          ] }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(Button, { variant: "ghost", size: "sm", asChild: true, className: "hover:text-flashcore-purple", children: /* @__PURE__ */ jsxRuntimeExports.jsxs(Link, { to: "/history/mail", children: [
            "View All ",
            /* @__PURE__ */ jsxRuntimeExports.jsx(ArrowRight, { className: "ml-2 h-4 w-4" })
          ] }) })
        ] }) }),
        /* @__PURE__ */ jsxRuntimeExports.jsx(CardContent, { className: "pt-6", children: /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "space-y-4", children: [
          { subject: "Your monthly report is ready", date: "May 15, 2023", status: "Delivered" },
          { subject: "Account verification", date: "May 10, 2023", status: "Opened" },
          { subject: "Welcome to FlashCore", date: "May 5, 2023", status: "Clicked" }
        ].map((item, index) => /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center justify-between pb-3 border-b last:border-0 hover:bg-muted/50 p-2 rounded-lg transition-colors", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx("h4", { className: "font-medium text-sm", children: item.subject }),
            /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-xs text-muted-foreground", children: item.date })
          ] }),
          /* @__PURE__ */ jsxRuntimeExports.jsx("span", { className: `text-[10px] font-bold uppercase px-2 py-1 rounded-full ${item.status === "Delivered" ? "bg-blue-100 text-blue-800" : item.status === "Opened" ? "bg-green-100 text-green-800" : "bg-purple-100 text-purple-800"}`, children: item.status })
        ] }, index)) }) })
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsxs(Card, { className: "overflow-hidden hover:shadow-lg transition-shadow", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx(CardHeader, { className: "bg-gradient-to-r from-flashcore-green/10 to-transparent border-b", children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center justify-between", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { children: [
            /* @__PURE__ */ jsxRuntimeExports.jsxs(CardTitle, { className: "flex items-center text-flashcore-green", children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx(CreditCard, { className: "mr-2 h-5 w-5" }),
              " Payment History"
            ] }),
            /* @__PURE__ */ jsxRuntimeExports.jsx(CardDescription, { children: "View your billing history" })
          ] }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(Button, { variant: "ghost", size: "sm", asChild: true, className: "hover:text-flashcore-green", children: /* @__PURE__ */ jsxRuntimeExports.jsxs(Link, { to: "/history/payment", children: [
            "View All ",
            /* @__PURE__ */ jsxRuntimeExports.jsx(ArrowRight, { className: "ml-2 h-4 w-4" })
          ] }) })
        ] }) }),
        /* @__PURE__ */ jsxRuntimeExports.jsx(CardContent, { className: "pt-6", children: /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "space-y-4", children: [
          { description: "Premium Subscription", date: "May 1, 2023", amount: "$49.99" },
          { description: "API Credits", date: "Apr 15, 2023", amount: "$19.99" },
          { description: "Premium Subscription", date: "Apr 1, 2023", amount: "$49.99" }
        ].map((item, index) => /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center justify-between pb-3 border-b last:border-0 hover:bg-muted/50 p-2 rounded-lg transition-colors", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx("h4", { className: "font-medium text-sm", children: item.description }),
            /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-xs text-muted-foreground", children: item.date })
          ] }),
          /* @__PURE__ */ jsxRuntimeExports.jsx("span", { className: "font-bold text-flashcore-green", children: item.amount })
        ] }, index)) }) })
      ] })
    ] }),
    /* @__PURE__ */ jsxRuntimeExports.jsxs(Card, { className: "overflow-hidden", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsx(CardHeader, { className: "bg-gradient-to-r from-flashcore-orange/10 to-transparent border-b", children: /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "flex items-center justify-between", children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { children: [
        /* @__PURE__ */ jsxRuntimeExports.jsxs(CardTitle, { className: "flex items-center text-flashcore-orange", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx(Calendar, { className: "mr-2 h-5 w-5" }),
          " Activity Timeline"
        ] }),
        /* @__PURE__ */ jsxRuntimeExports.jsx(CardDescription, { children: "Recent account activities" })
      ] }) }) }),
      /* @__PURE__ */ jsxRuntimeExports.jsx(CardContent, { className: "pt-6", children: /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "relative pl-8 border-l border-muted-foreground/20 space-y-8 ml-4", children: [
        { action: "Logged in from new device", date: "May 16, 2023", time: "09:45 AM", device: "iPhone 12, iOS 15.5" },
        { action: "Changed password", date: "May 14, 2023", time: "02:30 PM", device: "Chrome, Windows 10" },
        { action: "Updated profile information", date: "May 12, 2023", time: "11:20 AM", device: "Firefox, macOS" },
        { action: "Added new API key", date: "May 10, 2023", time: "04:15 PM", device: "Chrome, Windows 10" },
        { action: "Created child panel", date: "May 8, 2023", time: "10:05 AM", device: "Safari, macOS" }
      ].map((item, index) => /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "relative", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "absolute -left-[41px] mt-1.5 h-5 w-5 rounded-full border-4 border-background bg-flashcore-orange shadow-sm" }),
        /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx("h4", { className: "font-bold text-sm", children: item.action }),
          /* @__PURE__ */ jsxRuntimeExports.jsxs("p", { className: "text-xs text-muted-foreground", children: [
            item.date,
            " at ",
            item.time
          ] }),
          /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-[10px] text-muted-foreground mt-1 px-2 py-0.5 bg-muted rounded inline-block", children: item.device })
        ] })
      ] }, index)) }) })
    ] })
  ] }) });
};
export {
  HistoryPage as default
};
//# sourceMappingURL=HistoryPage-CdalYnl1.js.map
