import { c as createLucideIcon, r as reactExports, j as jsxRuntimeExports, I as Input, d as Card, e as CardContent, m as Link, B as Button, A as ArrowRight, g as CardHeader, h as CardTitle, i as CardDescription, O as Globe, S as Shield } from "./index-BzIW3X45.js";
import { B as Badge } from "./badge-BVgALWId.js";
import { S as Search } from "./search-CRvV5j7o.js";
import { S as Star } from "./star-Dd-JSO6t.js";
import { Z as Zap } from "./zap-FPHo0ZvJ.js";
import { S as Settings } from "./settings-g5ScwIYW.js";
import { T as Target } from "./target-Bevk9gAS.js";
import { U as Users } from "./users-BVADBbVm.js";
import { B as BookOpen } from "./book-open-D5vblNr0.js";
import { V as Video } from "./video-DHjgIv6E.js";
import { M as MessageSquare } from "./message-square-Cki7KYe_.js";
import { M as Mail } from "./mail-DzNoCzbV.js";
import { H as Headphones } from "./headphones-DfhUAMff.js";
/**
 * @license lucide-react v0.462.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */
const CircleHelp = createLucideIcon("CircleHelp", [
  ["circle", { cx: "12", cy: "12", r: "10", key: "1mglay" }],
  ["path", { d: "M9.09 9a3 3 0 0 1 5.83 1c0 2-3 3-3 3", key: "1u773s" }],
  ["path", { d: "M12 17h.01", key: "p32p05" }]
]);
const HelpCenterPage = () => {
  const [searchQuery, setSearchQuery] = reactExports.useState("");
  const categories = [
    {
      icon: Zap,
      title: "Getting Started",
      description: "Quick setup guides and tutorials for new users",
      color: "from-blue-500 to-blue-600",
      articles: [
        "How to create your first email campaign",
        "Setting up your account and preferences",
        "Importing your contact list",
        "Understanding the dashboard"
      ]
    },
    {
      icon: Settings,
      title: "Account & Billing",
      description: "Manage your account, billing, and subscription",
      color: "from-green-500 to-green-600",
      articles: [
        "Updating your account information",
        "Managing your subscription",
        "Understanding your billing cycle",
        "Adding team members"
      ]
    },
    {
      icon: Target,
      title: "Campaigns & Automation",
      description: "Create and manage email campaigns and workflows",
      color: "from-purple-500 to-purple-600",
      articles: [
        "Creating email campaigns",
        "Setting up automation workflows",
        "A/B testing your emails",
        "Campaign analytics and reporting"
      ]
    },
    {
      icon: Users,
      title: "Contacts & Lists",
      description: "Manage your contact lists and segmentation",
      color: "from-orange-500 to-orange-600",
      articles: [
        "Importing and managing contacts",
        "Creating contact segments",
        "Understanding contact scoring",
        "GDPR compliance and data management"
      ]
    },
    {
      icon: Globe,
      title: "Integrations",
      description: "Connect FlashCore with your favorite tools",
      color: "from-pink-500 to-pink-600",
      articles: [
        "Shopify integration setup",
        "WooCommerce connection",
        "API documentation and usage",
        "Third-party integrations"
      ]
    },
    {
      icon: Shield,
      title: "Security & Compliance",
      description: "Security features and compliance information",
      color: "from-red-500 to-red-600",
      articles: [
        "Data security and encryption",
        "GDPR compliance guide",
        "Email authentication (SPF, DKIM)",
        "Privacy and data protection"
      ]
    }
  ];
  const popularArticles = [
    {
      title: "How to create your first email campaign",
      category: "Getting Started",
      views: "15,234",
      rating: 4.8
    },
    {
      title: "Setting up Shopify integration",
      category: "Integrations",
      views: "12,891",
      rating: 4.9
    },
    {
      title: "Understanding email deliverability",
      category: "Campaigns & Automation",
      views: "11,567",
      rating: 4.7
    },
    {
      title: "Managing your subscription and billing",
      category: "Account & Billing",
      views: "9,843",
      rating: 4.6
    },
    {
      title: "Creating effective email templates",
      category: "Campaigns & Automation",
      views: "8,921",
      rating: 4.8
    },
    {
      title: "GDPR compliance checklist",
      category: "Security & Compliance",
      views: "7,654",
      rating: 4.9
    }
  ];
  const supportOptions = [
    {
      icon: BookOpen,
      title: "Knowledge Base",
      description: "Browse our comprehensive documentation and guides",
      action: "Browse Articles",
      link: "/docs"
    },
    {
      icon: Video,
      title: "Video Tutorials",
      description: "Watch step-by-step video guides and tutorials",
      action: "Watch Videos",
      link: "/tutorials"
    },
    {
      icon: MessageSquare,
      title: "Live Chat",
      description: "Get instant help from our support team",
      action: "Start Chat",
      link: "/contact"
    },
    {
      icon: Mail,
      title: "Email Support",
      description: "Send us a detailed message and we'll respond within 24 hours",
      action: "Send Email",
      link: "/contact"
    },
    {
      icon: Headphones,
      title: "Phone Support",
      description: "Call us directly for immediate assistance (Enterprise customers)",
      action: "Call Now",
      link: "/contact"
    },
    {
      icon: Users,
      title: "Community Forum",
      description: "Connect with other FlashCore users and share tips",
      action: "Join Community",
      link: "/community"
    }
  ];
  const faqs = [
    {
      question: "How do I get started with FlashCore?",
      answer: "Getting started is easy! Simply sign up for a free trial, verify your email, and follow our step-by-step onboarding guide. You'll be sending your first campaign within minutes."
    },
    {
      question: "What email marketing features does FlashCore offer?",
      answer: "FlashCore offers comprehensive email marketing features including campaign creation, automation workflows, A/B testing, advanced analytics, contact segmentation, and integrations with popular platforms."
    },
    {
      question: "How much does FlashCore cost?",
      answer: "FlashCore offers flexible pricing starting at $19/month for startups, $29/month for small businesses, $49/month for e-commerce, $99/month for agencies, and custom pricing for enterprise customers."
    },
    {
      question: "Can I import my existing contact list?",
      answer: "Yes! You can import contacts from CSV files, or connect directly with platforms like Shopify, WooCommerce, and other popular integrations. We also provide tools to clean and validate your data."
    },
    {
      question: "What kind of support do you provide?",
      answer: "We offer comprehensive support including a knowledge base, video tutorials, live chat, email support, and phone support for enterprise customers. Our team typically responds within 24 hours."
    },
    {
      question: "Is my data secure with FlashCore?",
      answer: "Absolutely! We use bank-level encryption, SOC 2 compliance, and enterprise-grade security measures to protect your data. We're also GDPR compliant and take data privacy seriously."
    }
  ];
  return /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "min-h-screen bg-background", children: [
    /* @__PURE__ */ jsxRuntimeExports.jsx("section", { className: "container mx-auto px-4 py-12 md:py-20", children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "max-w-4xl mx-auto text-center", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsxs(Badge, { variant: "secondary", className: "mb-4", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx(CircleHelp, { className: "w-3 h-3 mr-1" }),
        "Help Center"
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsx("h1", { className: "text-3xl md:text-4xl lg:text-5xl font-bold mb-6 bg-gradient-to-r from-flashcore-purple to-flashcore-green bg-clip-text text-transparent", children: "How Can We Help You?" }),
      /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-lg md:text-xl text-muted-foreground mb-8 max-w-2xl mx-auto", children: "Find answers to your questions, learn new features, and get the support you need to make the most of FlashCore." }),
      /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "max-w-2xl mx-auto mb-8", children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "relative", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx(Search, { className: "absolute left-3 top-1/2 transform -translate-y-1/2 text-muted-foreground w-5 h-5" }),
        /* @__PURE__ */ jsxRuntimeExports.jsx(
          Input,
          {
            type: "text",
            placeholder: "Search for help articles, tutorials, or features...",
            value: searchQuery,
            onChange: (e) => setSearchQuery(e.target.value),
            className: "pl-10 pr-4 py-3 text-lg"
          }
        )
      ] }) })
    ] }) }),
    /* @__PURE__ */ jsxRuntimeExports.jsx("section", { className: "container mx-auto px-4 py-12 md:py-20 bg-muted/20", children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "max-w-6xl mx-auto", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "text-center mb-12", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx("h2", { className: "text-2xl md:text-3xl font-bold mb-4", children: "Get the Help You Need" }),
        /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-muted-foreground", children: "Multiple ways to get support and find answers to your questions." })
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6 md:gap-8", children: supportOptions.map((option, index) => /* @__PURE__ */ jsxRuntimeExports.jsx(Card, { className: "hover:shadow-lg transition-shadow", children: /* @__PURE__ */ jsxRuntimeExports.jsxs(CardContent, { className: "p-6", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "w-12 h-12 bg-gradient-to-r from-flashcore-purple to-flashcore-green rounded-lg flex items-center justify-center mb-4", children: /* @__PURE__ */ jsxRuntimeExports.jsx(option.icon, { className: "w-6 h-6 text-white" }) }),
        /* @__PURE__ */ jsxRuntimeExports.jsx("h3", { className: "text-lg font-semibold mb-2", children: option.title }),
        /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-sm text-muted-foreground mb-4", children: option.description }),
        /* @__PURE__ */ jsxRuntimeExports.jsx(Link, { to: option.link, children: /* @__PURE__ */ jsxRuntimeExports.jsxs(Button, { variant: "outline", size: "sm", className: "w-full", children: [
          option.action,
          /* @__PURE__ */ jsxRuntimeExports.jsx(ArrowRight, { className: "w-4 h-4 ml-2" })
        ] }) })
      ] }) }, index)) })
    ] }) }),
    /* @__PURE__ */ jsxRuntimeExports.jsx("section", { className: "container mx-auto px-4 py-12 md:py-20", children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "max-w-6xl mx-auto", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "text-center mb-12", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx("h2", { className: "text-2xl md:text-3xl font-bold mb-4", children: "Browse by Category" }),
        /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-muted-foreground", children: "Find help articles organized by topic and feature." })
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6 md:gap-8", children: categories.map((category, index) => /* @__PURE__ */ jsxRuntimeExports.jsxs(Card, { className: "hover:shadow-lg transition-shadow", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx(CardHeader, { children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center space-x-3", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: `w-10 h-10 bg-gradient-to-r ${category.color} rounded-lg flex items-center justify-center`, children: /* @__PURE__ */ jsxRuntimeExports.jsx(category.icon, { className: "w-5 h-5 text-white" }) }),
          /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx(CardTitle, { className: "text-lg", children: category.title }),
            /* @__PURE__ */ jsxRuntimeExports.jsx(CardDescription, { className: "text-sm", children: category.description })
          ] })
        ] }) }),
        /* @__PURE__ */ jsxRuntimeExports.jsxs(CardContent, { children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx("ul", { className: "space-y-2", children: category.articles.map((article, articleIndex) => /* @__PURE__ */ jsxRuntimeExports.jsx("li", { className: "text-sm text-muted-foreground hover:text-foreground cursor-pointer", children: article }, articleIndex)) }),
          /* @__PURE__ */ jsxRuntimeExports.jsxs(Button, { variant: "outline", size: "sm", className: "w-full mt-4", children: [
            "View All Articles",
            /* @__PURE__ */ jsxRuntimeExports.jsx(ArrowRight, { className: "w-4 h-4 ml-2" })
          ] })
        ] })
      ] }, index)) })
    ] }) }),
    /* @__PURE__ */ jsxRuntimeExports.jsx("section", { className: "container mx-auto px-4 py-12 md:py-20 bg-muted/20", children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "max-w-4xl mx-auto", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "text-center mb-12", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx("h2", { className: "text-2xl md:text-3xl font-bold mb-4", children: "Popular Articles" }),
        /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-muted-foreground", children: "Most viewed and highest-rated help articles." })
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "space-y-4", children: popularArticles.map((article, index) => /* @__PURE__ */ jsxRuntimeExports.jsx(Card, { className: "hover:shadow-lg transition-shadow cursor-pointer", children: /* @__PURE__ */ jsxRuntimeExports.jsx(CardContent, { className: "p-6", children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center justify-between", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex-1", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx("h3", { className: "font-semibold mb-1", children: article.title }),
          /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center space-x-4 text-sm text-muted-foreground", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx("span", { children: article.category }),
            /* @__PURE__ */ jsxRuntimeExports.jsx("span", { children: "•" }),
            /* @__PURE__ */ jsxRuntimeExports.jsxs("span", { children: [
              article.views,
              " views"
            ] }),
            /* @__PURE__ */ jsxRuntimeExports.jsx("span", { children: "•" }),
            /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center", children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx(Star, { className: "w-4 h-4 text-yellow-400 fill-current mr-1" }),
              /* @__PURE__ */ jsxRuntimeExports.jsx("span", { children: article.rating })
            ] })
          ] })
        ] }),
        /* @__PURE__ */ jsxRuntimeExports.jsx(ArrowRight, { className: "w-5 h-5 text-muted-foreground" })
      ] }) }) }, index)) })
    ] }) }),
    /* @__PURE__ */ jsxRuntimeExports.jsx("section", { className: "container mx-auto px-4 py-12 md:py-20", children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "max-w-4xl mx-auto", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "text-center mb-12", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx("h2", { className: "text-2xl md:text-3xl font-bold mb-4", children: "Frequently Asked Questions" }),
        /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-muted-foreground", children: "Quick answers to the most common questions about FlashCore." })
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "space-y-6", children: faqs.map((faq, index) => /* @__PURE__ */ jsxRuntimeExports.jsx(Card, { children: /* @__PURE__ */ jsxRuntimeExports.jsxs(CardContent, { className: "p-6", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx("h3", { className: "text-lg font-semibold mb-3", children: faq.question }),
        /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-sm text-muted-foreground", children: faq.answer })
      ] }) }, index)) })
    ] }) }),
    /* @__PURE__ */ jsxRuntimeExports.jsx("section", { className: "container mx-auto px-4 py-12 md:py-20 bg-muted/20", children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "max-w-4xl mx-auto text-center", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsx("h2", { className: "text-2xl md:text-3xl font-bold mb-4", children: "Still Need Help?" }),
      /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-lg text-muted-foreground mb-8", children: "Can't find what you're looking for? Our support team is here to help." }),
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex flex-col sm:flex-row gap-4 justify-center", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx(Link, { to: "/contact", children: /* @__PURE__ */ jsxRuntimeExports.jsxs(Button, { size: "lg", className: "bg-gradient-to-r from-flashcore-purple to-flashcore-green text-white", children: [
          "Contact Support",
          /* @__PURE__ */ jsxRuntimeExports.jsx(ArrowRight, { className: "w-4 h-4 ml-2" })
        ] }) }),
        /* @__PURE__ */ jsxRuntimeExports.jsx(Link, { to: "/docs", children: /* @__PURE__ */ jsxRuntimeExports.jsx(Button, { size: "lg", variant: "outline", children: "Browse Documentation" }) })
      ] })
    ] }) })
  ] });
};
export {
  HelpCenterPage as default
};
//# sourceMappingURL=HelpCenterPage-0PRQqL-y.js.map
