import { c as createLucideIcon, r as reactExports, j as jsxRuntimeExports, L as Layout, B as Button, I as Input, d as Card, g as CardHeader, h as CardTitle, i as CardDescription, p as CardFooter, e as CardContent } from "./index-D2CUDDtA.js";
import { T as Textarea } from "./textarea-2vAlnlSP.js";
import { B as Badge } from "./badge-CnK8C-4m.js";
import { T as Tabs, a as TabsList, b as TabsTrigger, c as TabsContent } from "./tabs-clwVusLv.js";
import { S as Search } from "./search-C-0aFC71.js";
import { M as MessageCircle } from "./message-circle-BZOdpJLR.js";
import { Z as Zap } from "./zap-B7w9_awj.js";
/**
 * @license lucide-react v0.462.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */
const CirclePlus = createLucideIcon("CirclePlus", [
  ["circle", { cx: "12", cy: "12", r: "10", key: "1mglay" }],
  ["path", { d: "M8 12h8", key: "1wcyev" }],
  ["path", { d: "M12 8v8", key: "napkw2" }]
]);
/**
 * @license lucide-react v0.462.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */
const ThumbsUp = createLucideIcon("ThumbsUp", [
  ["path", { d: "M7 10v12", key: "1qc93n" }],
  [
    "path",
    {
      d: "M15 5.88 14 10h5.83a2 2 0 0 1 1.92 2.56l-2.33 8A2 2 0 0 1 17.5 22H4a2 2 0 0 1-2-2v-8a2 2 0 0 1 2-2h2.76a2 2 0 0 0 1.79-1.11L12 2a3.13 3.13 0 0 1 3 3.88Z",
      key: "emmmcr"
    }
  ]
]);
const FeatureRequestPage = () => {
  const [activeTab, setActiveTab] = reactExports.useState("all");
  return /* @__PURE__ */ jsxRuntimeExports.jsx(Layout, { children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "space-y-6", children: [
    /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex flex-col md:flex-row md:items-center justify-between gap-4", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex flex-col space-y-1", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx("h1", { className: "text-3xl font-bold", children: "Feature Requests" }),
        /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-muted-foreground", children: "Suggest new features and vote on the future of FlashCore" })
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsxs(Button, { className: "bg-gradient-to-r from-flashcore-purple to-flashcore-green hover:scale-105 transition-transform font-bold uppercase text-xs tracking-wider", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx(CirclePlus, { className: "mr-2 h-4 w-4" }),
        " New Request"
      ] })
    ] }),
    /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "space-y-6", children: /* @__PURE__ */ jsxRuntimeExports.jsxs(Tabs, { defaultValue: "all", onValueChange: setActiveTab, className: "w-full", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex flex-col sm:flex-row justify-between items-start sm:items-center gap-4", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsxs(TabsList, { className: "bg-muted/50 p-1 rounded-xl", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx(TabsTrigger, { value: "all", className: "rounded-lg", children: "All" }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(TabsTrigger, { value: "popular", className: "rounded-lg", children: "Popular" }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(TabsTrigger, { value: "my", className: "rounded-lg", children: "My Submissions" }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(TabsTrigger, { value: "planned", className: "rounded-lg", children: "Roadmap" })
        ] }),
        /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "relative w-full sm:w-auto", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx(Search, { className: "absolute left-2.5 top-2.5 h-4 w-4 text-muted-foreground" }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(Input, { placeholder: "Filter requests...", className: "pl-8 w-full sm:w-[250px] bg-muted/20 border-none rounded-xl" })
        ] })
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsx(TabsContent, { value: "all", className: "mt-6", children: /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "grid grid-cols-1 md:grid-cols-2 gap-4", children: [
        {
          title: "Dark Mode Support",
          description: "Add a toggle for dark mode across all panels and dashboards",
          status: "Planned",
          votes: 124,
          comments: 15,
          isNew: true
        },
        {
          title: "Mobile App Integration",
          description: "Create a mobile app to manage services on the go",
          status: "Under Review",
          votes: 98,
          comments: 23
        },
        {
          title: "Bulk Import/Export",
          description: "Allow bulk operations for user management and service configuration",
          status: "Implemented",
          votes: 86,
          comments: 8
        },
        {
          title: "Enhanced Analytics Dashboard",
          description: "More detailed analytics with custom date ranges and export options",
          status: "Planned",
          votes: 75,
          comments: 12
        },
        {
          title: "Multiple Payment Gateways",
          description: "Support for more payment providers like Stripe, PayPal, and crypto",
          status: "Under Review",
          votes: 62,
          comments: 19,
          isNew: true
        }
      ].map((feature, index) => /* @__PURE__ */ jsxRuntimeExports.jsxs(Card, { className: "overflow-hidden group hover:shadow-lg transition-all border-none bg-card/50 backdrop-blur-sm", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx(CardHeader, { className: "pb-3", children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex justify-between items-start", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "space-y-1", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsxs(CardTitle, { className: "flex items-center text-lg group-hover:text-flashcore-purple transition-colors", children: [
              feature.title,
              feature.isNew && /* @__PURE__ */ jsxRuntimeExports.jsx(Badge, { className: "ml-2 bg-flashcore-purple hover:bg-flashcore-purple text-white border-none text-[10px] py-0 px-2 rounded-full font-bold uppercase", children: "New" })
            ] }),
            /* @__PURE__ */ jsxRuntimeExports.jsx(CardDescription, { className: "text-sm line-clamp-2", children: feature.description })
          ] }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(
            Badge,
            {
              className: `border-none text-[10px] font-bold uppercase py-0.5 px-2 rounded-full ${feature.status === "Implemented" ? "bg-green-100 text-green-700 font-bold" : feature.status === "Planned" ? "bg-purple-100 text-flashcore-purple font-bold" : "bg-orange-100 text-orange-700 font-bold"}`,
              children: feature.status
            }
          )
        ] }) }),
        /* @__PURE__ */ jsxRuntimeExports.jsx(CardFooter, { className: "pt-2 border-t bg-muted/10", children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center justify-between w-full", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center gap-4 text-xs font-bold text-muted-foreground uppercase", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsxs(Button, { variant: "ghost", size: "sm", className: "h-8 gap-1.5 hover:text-flashcore-purple hover:bg-flashcore-purple/10", children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx(ThumbsUp, { className: "h-3.5 w-3.5" }),
              /* @__PURE__ */ jsxRuntimeExports.jsx("span", { children: feature.votes })
            ] }),
            /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center gap-1.5 px-3 py-1 bg-muted/20 rounded-lg", children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx(MessageCircle, { className: "h-3.5 w-3.5" }),
              /* @__PURE__ */ jsxRuntimeExports.jsx("span", { children: feature.comments })
            ] })
          ] }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(Button, { variant: "link", size: "sm", className: "h-8 text-[10px] font-bold uppercase tracking-widest text-muted-foreground hover:text-flashcore-purple", children: "Learn More" })
        ] }) })
      ] }, index)) }) })
    ] }) }),
    /* @__PURE__ */ jsxRuntimeExports.jsxs(Card, { className: "overflow-hidden border-none shadow-2xl", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsxs(CardHeader, { className: "bg-gradient-to-r from-slate-900 to-slate-800 text-white pb-8", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center gap-3 mb-2", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "p-2 bg-flashcore-purple/20 rounded-lg", children: /* @__PURE__ */ jsxRuntimeExports.jsx(Zap, { className: "h-5 w-5 text-flashcore-purple" }) }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(CardTitle, { className: "text-white", children: "Submit a Feature Request" })
        ] }),
        /* @__PURE__ */ jsxRuntimeExports.jsx(CardDescription, { className: "text-slate-400", children: "Your ideas fuel the future of FlashCore. Please be as detailed as possible." })
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsx(CardContent, { className: "-mt-4 bg-background pt-6", children: /* @__PURE__ */ jsxRuntimeExports.jsxs("form", { className: "space-y-6", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "grid grid-cols-1 md:grid-cols-2 gap-6", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "space-y-2", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx("label", { htmlFor: "title", className: "text-xs font-bold uppercase tracking-wider text-muted-foreground", children: "Feature Title" }),
            /* @__PURE__ */ jsxRuntimeExports.jsx(Input, { id: "title", placeholder: "The core idea in 5-10 words", className: "rounded-xl border-muted/20 focus:border-flashcore-purple transition-all" })
          ] }),
          /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "space-y-2", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx("label", { htmlFor: "category", className: "text-xs font-bold uppercase tracking-wider text-muted-foreground", children: "Category" }),
            /* @__PURE__ */ jsxRuntimeExports.jsx(Input, { id: "category", placeholder: "UI, Performance, Billing, etc.", className: "rounded-xl border-muted/20 focus:border-flashcore-purple transition-all" })
          ] })
        ] }),
        /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "space-y-2", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx("label", { htmlFor: "description", className: "text-xs font-bold uppercase tracking-wider text-muted-foreground", children: "Full Description" }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(
            Textarea,
            {
              id: "description",
              placeholder: "Describe the feature and how it would improve your workflow...",
              rows: 4,
              className: "rounded-xl border-muted/20 focus:border-flashcore-purple transition-all resize-none"
            }
          )
        ] }),
        /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "space-y-2", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx("label", { htmlFor: "useCase", className: "text-xs font-bold uppercase tracking-wider text-muted-foreground", children: "Real-world Use Case" }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(
            Textarea,
            {
              id: "useCase",
              placeholder: "Tell us about a specific situation where this would be helpful...",
              rows: 2,
              className: "rounded-xl border-muted/20 focus:border-flashcore-purple transition-all resize-none"
            }
          )
        ] })
      ] }) }),
      /* @__PURE__ */ jsxRuntimeExports.jsxs(CardFooter, { className: "flex justify-between py-6 border-t bg-muted/20 px-6", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx(Button, { variant: "ghost", className: "font-bold uppercase text-xs tracking-wider", children: "Cancel" }),
        /* @__PURE__ */ jsxRuntimeExports.jsx(Button, { className: "bg-slate-900 text-white hover:bg-slate-800 font-bold uppercase text-xs tracking-widest px-8", children: "Submit Request" })
      ] })
    ] })
  ] }) });
};
export {
  FeatureRequestPage as default
};
//# sourceMappingURL=FeatureRequestPage-U5vch8dE.js.map
