import { r as reactExports, j as jsxRuntimeExports, I as Input, m as Link, d as Card, e as CardContent, g as CardHeader, h as CardTitle, i as CardDescription, A as ArrowRight, B as Button, S as Shield } from "./index-D2CUDDtA.js";
import { B as Badge } from "./badge-CnK8C-4m.js";
import { B as BookOpen } from "./book-open-DBBPIN8r.js";
import { S as Search } from "./search-C-0aFC71.js";
import { C as Code } from "./code-p0LkS3Wr.js";
import { F as FileText } from "./file-text-DafaU1n7.js";
import { D as Database } from "./database-D_G6YwOX.js";
import { U as Users } from "./users-Ck38nNzE.js";
import { C as Clock } from "./clock-DUn2OqpW.js";
import { P as Play } from "./play-CZNbN3rf.js";
import { E as ExternalLink } from "./external-link-D_ERIYGV.js";
import { C as CircleCheckBig } from "./circle-check-big-CzDEsGWP.js";
import { Z as Zap } from "./zap-B7w9_awj.js";
const DocsPage = () => {
  const [searchTerm, setSearchTerm] = reactExports.useState("");
  const categories = [
    {
      id: "getting-started",
      title: "Getting Started",
      description: "Quick start guides and tutorials",
      icon: Play,
      color: "from-blue-500 to-blue-600",
      articles: [
        { title: "Quick Start Guide", time: "5 min read", difficulty: "Beginner" },
        { title: "Setting Up Your Account", time: "3 min read", difficulty: "Beginner" },
        { title: "Your First Email Campaign", time: "8 min read", difficulty: "Beginner" },
        { title: "Understanding the Dashboard", time: "6 min read", difficulty: "Beginner" }
      ]
    },
    {
      id: "templates",
      title: "Email Templates",
      description: "Create and customize email templates",
      icon: FileText,
      color: "from-green-500 to-green-600",
      articles: [
        { title: "Template Editor Guide", time: "10 min read", difficulty: "Intermediate" },
        { title: "Creating Custom Templates", time: "12 min read", difficulty: "Intermediate" },
        { title: "Template Variables", time: "8 min read", difficulty: "Intermediate" },
        { title: "Responsive Design Tips", time: "15 min read", difficulty: "Advanced" }
      ]
    },
    {
      id: "automation",
      title: "Automation",
      description: "Set up automated email workflows",
      icon: Zap,
      color: "from-purple-500 to-purple-600",
      articles: [
        { title: "Welcome Series Setup", time: "12 min read", difficulty: "Intermediate" },
        { title: "Abandoned Cart Recovery", time: "15 min read", difficulty: "Intermediate" },
        { title: "Advanced Workflow Rules", time: "20 min read", difficulty: "Advanced" },
        { title: "A/B Testing Automation", time: "18 min read", difficulty: "Advanced" }
      ]
    },
    {
      id: "integrations",
      title: "Integrations",
      description: "Connect with third-party tools",
      icon: Database,
      color: "from-orange-500 to-orange-600",
      articles: [
        { title: "Shopify Integration", time: "8 min read", difficulty: "Intermediate" },
        { title: "Salesforce Setup", time: "10 min read", difficulty: "Intermediate" },
        { title: "Zapier Automation", time: "12 min read", difficulty: "Intermediate" },
        { title: "Custom API Integration", time: "25 min read", difficulty: "Advanced" }
      ]
    },
    {
      id: "analytics",
      title: "Analytics & Reporting",
      description: "Track performance and insights",
      icon: Shield,
      color: "from-red-500 to-red-600",
      articles: [
        { title: "Understanding Email Metrics", time: "8 min read", difficulty: "Beginner" },
        { title: "Creating Custom Reports", time: "12 min read", difficulty: "Intermediate" },
        { title: "Advanced Analytics", time: "15 min read", difficulty: "Advanced" },
        { title: "Exporting Data", time: "6 min read", difficulty: "Intermediate" }
      ]
    },
    {
      id: "api",
      title: "API Reference",
      description: "Developer documentation and guides",
      icon: Code,
      color: "from-pink-500 to-pink-600",
      articles: [
        { title: "API Authentication", time: "10 min read", difficulty: "Intermediate" },
        { title: "Sending Emails via API", time: "12 min read", difficulty: "Intermediate" },
        { title: "Webhook Setup", time: "15 min read", difficulty: "Advanced" },
        { title: "SDK Documentation", time: "20 min read", difficulty: "Advanced" }
      ]
    }
  ];
  const popularArticles = [
    {
      title: "How to Increase Email Open Rates",
      category: "Best Practices",
      views: "12.5k",
      time: "8 min read"
    },
    {
      title: "Setting Up Email Authentication",
      category: "Security",
      views: "8.2k",
      time: "10 min read"
    },
    {
      title: "Creating Effective Subject Lines",
      category: "Templates",
      views: "15.7k",
      time: "6 min read"
    },
    {
      title: "GDPR Compliance Guide",
      category: "Legal",
      views: "6.8k",
      time: "12 min read"
    }
  ];
  const tutorials = [
    {
      title: "Build Your First Email Campaign",
      description: "Step-by-step guide to creating and sending your first email campaign",
      duration: "15 minutes",
      level: "Beginner",
      thumbnail: "🎯"
    },
    {
      title: "Advanced Segmentation Strategies",
      description: "Learn how to segment your audience for better engagement",
      duration: "25 minutes",
      level: "Intermediate",
      thumbnail: "📊"
    },
    {
      title: "Automation Workflow Mastery",
      description: "Master the art of email automation and workflows",
      duration: "35 minutes",
      level: "Advanced",
      thumbnail: "⚡"
    }
  ];
  const filteredCategories = categories.filter(
    (category) => category.title.toLowerCase().includes(searchTerm.toLowerCase()) || category.description.toLowerCase().includes(searchTerm.toLowerCase()) || category.articles.some(
      (article) => article.title.toLowerCase().includes(searchTerm.toLowerCase())
    )
  );
  return /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex flex-col", children: [
    /* @__PURE__ */ jsxRuntimeExports.jsx("section", { className: "container mx-auto px-4 py-12 md:py-20 text-center", children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "max-w-4xl mx-auto", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsxs(Badge, { variant: "secondary", className: "mb-4", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx(BookOpen, { className: "w-3 h-3 mr-1" }),
        "Documentation"
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsx("h1", { className: "text-3xl md:text-4xl lg:text-5xl font-bold mb-6 bg-gradient-to-r from-flashcore-purple to-flashcore-green bg-clip-text text-transparent", children: "Documentation & Help" }),
      /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-lg md:text-xl text-muted-foreground mb-8 max-w-2xl mx-auto", children: "Everything you need to know about FlashCore. From getting started to advanced features." }),
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "max-w-md mx-auto relative", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx(Search, { className: "absolute left-3 top-1/2 transform -translate-y-1/2 w-4 h-4 text-muted-foreground" }),
        /* @__PURE__ */ jsxRuntimeExports.jsx(
          Input,
          {
            placeholder: "Search documentation...",
            value: searchTerm,
            onChange: (e) => setSearchTerm(e.target.value),
            className: "pl-10"
          }
        )
      ] })
    ] }) }),
    /* @__PURE__ */ jsxRuntimeExports.jsx("section", { className: "container mx-auto px-4 py-8", children: /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "max-w-6xl mx-auto", children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "grid grid-cols-2 md:grid-cols-4 gap-4", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsx(Link, { to: "/api", children: /* @__PURE__ */ jsxRuntimeExports.jsx(Card, { className: "hover:shadow-lg transition-shadow cursor-pointer", children: /* @__PURE__ */ jsxRuntimeExports.jsxs(CardContent, { className: "p-4 text-center", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx(Code, { className: "w-8 h-8 mx-auto mb-2 text-flashcore-purple" }),
        /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "text-sm font-medium", children: "API Docs" })
      ] }) }) }),
      /* @__PURE__ */ jsxRuntimeExports.jsx(Link, { to: "/templates", children: /* @__PURE__ */ jsxRuntimeExports.jsx(Card, { className: "hover:shadow-lg transition-shadow cursor-pointer", children: /* @__PURE__ */ jsxRuntimeExports.jsxs(CardContent, { className: "p-4 text-center", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx(FileText, { className: "w-8 h-8 mx-auto mb-2 text-flashcore-purple" }),
        /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "text-sm font-medium", children: "Templates" })
      ] }) }) }),
      /* @__PURE__ */ jsxRuntimeExports.jsx(Link, { to: "/integrations", children: /* @__PURE__ */ jsxRuntimeExports.jsx(Card, { className: "hover:shadow-lg transition-shadow cursor-pointer", children: /* @__PURE__ */ jsxRuntimeExports.jsxs(CardContent, { className: "p-4 text-center", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx(Database, { className: "w-8 h-8 mx-auto mb-2 text-flashcore-purple" }),
        /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "text-sm font-medium", children: "Integrations" })
      ] }) }) }),
      /* @__PURE__ */ jsxRuntimeExports.jsx(Link, { to: "/contact", children: /* @__PURE__ */ jsxRuntimeExports.jsx(Card, { className: "hover:shadow-lg transition-shadow cursor-pointer", children: /* @__PURE__ */ jsxRuntimeExports.jsxs(CardContent, { className: "p-4 text-center", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx(Users, { className: "w-8 h-8 mx-auto mb-2 text-flashcore-purple" }),
        /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "text-sm font-medium", children: "Support" })
      ] }) }) })
    ] }) }) }),
    /* @__PURE__ */ jsxRuntimeExports.jsx("section", { className: "container mx-auto px-4 py-12 md:py-20", children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "max-w-6xl mx-auto", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "text-center mb-12", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx("h2", { className: "text-2xl md:text-3xl font-bold mb-4", children: "Popular Articles" }),
        /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-muted-foreground", children: "Most viewed and helpful articles from our community." })
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "grid grid-cols-1 md:grid-cols-2 gap-6", children: popularArticles.map((article, index) => /* @__PURE__ */ jsxRuntimeExports.jsx(Card, { className: "hover:shadow-lg transition-shadow cursor-pointer", children: /* @__PURE__ */ jsxRuntimeExports.jsxs(CardContent, { className: "p-6", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-start justify-between mb-3", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx(Badge, { variant: "outline", className: "text-xs", children: article.category }),
          /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center text-xs text-muted-foreground", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx(Clock, { className: "w-3 h-3 mr-1" }),
            article.time
          ] })
        ] }),
        /* @__PURE__ */ jsxRuntimeExports.jsx("h3", { className: "font-semibold mb-2", children: article.title }),
        /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center text-xs text-muted-foreground", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx(Users, { className: "w-3 h-3 mr-1" }),
          article.views,
          " views"
        ] })
      ] }) }, index)) })
    ] }) }),
    /* @__PURE__ */ jsxRuntimeExports.jsx("section", { className: "container mx-auto px-4 py-12 md:py-20 bg-muted/20", children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "max-w-6xl mx-auto", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "text-center mb-12", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx("h2", { className: "text-2xl md:text-3xl font-bold mb-4", children: "Documentation Categories" }),
        /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-muted-foreground", children: "Browse our comprehensive documentation by category." })
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6", children: filteredCategories.map((category) => /* @__PURE__ */ jsxRuntimeExports.jsxs(Card, { className: "hover:shadow-lg transition-shadow", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx(CardHeader, { children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center mb-4", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: `w-10 h-10 bg-gradient-to-r ${category.color} rounded-lg flex items-center justify-center mr-3`, children: /* @__PURE__ */ jsxRuntimeExports.jsx(category.icon, { className: "w-5 h-5 text-white" }) }),
          /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx(CardTitle, { className: "text-lg", children: category.title }),
            /* @__PURE__ */ jsxRuntimeExports.jsx(CardDescription, { className: "text-sm", children: category.description })
          ] })
        ] }) }),
        /* @__PURE__ */ jsxRuntimeExports.jsx(CardContent, { children: /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "space-y-3", children: category.articles.map((article, index) => /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center justify-between p-2 hover:bg-muted rounded cursor-pointer", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex-1", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "text-sm font-medium", children: article.title }),
            /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center text-xs text-muted-foreground", children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx(Clock, { className: "w-3 h-3 mr-1" }),
              article.time,
              /* @__PURE__ */ jsxRuntimeExports.jsx(Badge, { variant: "secondary", className: "ml-2 text-xs", children: article.difficulty })
            ] })
          ] }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(ArrowRight, { className: "w-4 h-4 text-muted-foreground" })
        ] }, index)) }) })
      ] }, category.id)) }),
      filteredCategories.length === 0 && /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "text-center py-12", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx(Search, { className: "w-16 h-16 text-muted-foreground mx-auto mb-4" }),
        /* @__PURE__ */ jsxRuntimeExports.jsx("h3", { className: "text-xl font-semibold mb-2", children: "No results found" }),
        /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-muted-foreground", children: "Try adjusting your search terms or browse all categories." })
      ] })
    ] }) }),
    /* @__PURE__ */ jsxRuntimeExports.jsx("section", { className: "container mx-auto px-4 py-12 md:py-20", children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "max-w-6xl mx-auto", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "text-center mb-12", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx("h2", { className: "text-2xl md:text-3xl font-bold mb-4", children: "Video Tutorials" }),
        /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-muted-foreground", children: "Learn FlashCore with our step-by-step video tutorials." })
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "grid grid-cols-1 md:grid-cols-3 gap-6", children: tutorials.map((tutorial, index) => /* @__PURE__ */ jsxRuntimeExports.jsxs(Card, { className: "hover:shadow-lg transition-shadow cursor-pointer", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsxs(CardHeader, { children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "text-4xl mb-4", children: tutorial.thumbnail }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(CardTitle, { className: "text-lg", children: tutorial.title }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(CardDescription, { className: "text-sm", children: tutorial.description })
        ] }),
        /* @__PURE__ */ jsxRuntimeExports.jsxs(CardContent, { children: [
          /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center justify-between", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center text-sm text-muted-foreground", children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx(Clock, { className: "w-4 h-4 mr-1" }),
              tutorial.duration
            ] }),
            /* @__PURE__ */ jsxRuntimeExports.jsx(Badge, { variant: "outline", className: "text-xs", children: tutorial.level })
          ] }),
          /* @__PURE__ */ jsxRuntimeExports.jsxs(Button, { className: "w-full mt-4 bg-gradient-to-r from-flashcore-purple to-flashcore-green", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx(Play, { className: "w-4 h-4 mr-2" }),
            "Watch Tutorial"
          ] })
        ] })
      ] }, index)) })
    ] }) }),
    /* @__PURE__ */ jsxRuntimeExports.jsx("section", { className: "container mx-auto px-4 py-12 md:py-20 bg-muted/20", children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "max-w-4xl mx-auto", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "text-center mb-12", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx("h2", { className: "text-2xl md:text-3xl font-bold mb-4", children: "Need More Help?" }),
        /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-muted-foreground", children: "Can't find what you're looking for? We're here to help." })
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "grid grid-cols-1 md:grid-cols-2 gap-6", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsxs(Card, { className: "hover:shadow-lg transition-shadow", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsxs(CardHeader, { children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "w-12 h-12 bg-gradient-to-r from-flashcore-purple to-flashcore-green rounded-lg flex items-center justify-center mb-4", children: /* @__PURE__ */ jsxRuntimeExports.jsx(Users, { className: "w-6 h-6 text-white" }) }),
            /* @__PURE__ */ jsxRuntimeExports.jsx(CardTitle, { children: "Community Forum" }),
            /* @__PURE__ */ jsxRuntimeExports.jsx(CardDescription, { children: "Connect with other users and share tips and tricks." })
          ] }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(CardContent, { children: /* @__PURE__ */ jsxRuntimeExports.jsxs(Button, { variant: "outline", className: "w-full", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx(ExternalLink, { className: "w-4 h-4 mr-2" }),
            "Join Community"
          ] }) })
        ] }),
        /* @__PURE__ */ jsxRuntimeExports.jsxs(Card, { className: "hover:shadow-lg transition-shadow", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsxs(CardHeader, { children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "w-12 h-12 bg-gradient-to-r from-flashcore-purple to-flashcore-green rounded-lg flex items-center justify-center mb-4", children: /* @__PURE__ */ jsxRuntimeExports.jsx(CircleCheckBig, { className: "w-6 h-6 text-white" }) }),
            /* @__PURE__ */ jsxRuntimeExports.jsx(CardTitle, { children: "Contact Support" }),
            /* @__PURE__ */ jsxRuntimeExports.jsx(CardDescription, { children: "Get help from our expert support team." })
          ] }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(CardContent, { children: /* @__PURE__ */ jsxRuntimeExports.jsx(Link, { to: "/contact", children: /* @__PURE__ */ jsxRuntimeExports.jsxs(Button, { variant: "outline", className: "w-full", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx(ExternalLink, { className: "w-4 h-4 mr-2" }),
            "Contact Us"
          ] }) }) })
        ] })
      ] })
    ] }) }),
    /* @__PURE__ */ jsxRuntimeExports.jsx("section", { className: "container mx-auto px-4 py-12 md:py-20", children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "bg-gradient-to-r from-flashcore-purple to-flashcore-green rounded-2xl p-6 md:p-8 lg:p-12 text-center text-white", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsx("h2", { className: "text-2xl md:text-3xl font-bold mb-4", children: "Ready to Get Started?" }),
      /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-lg md:text-xl mb-6 md:mb-8 opacity-90", children: "Start building amazing email campaigns with FlashCore today." }),
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex flex-col sm:flex-row gap-4 justify-center", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx(Link, { to: "/register", children: /* @__PURE__ */ jsxRuntimeExports.jsxs(Button, { size: "lg", variant: "secondary", className: "bg-white text-flashcore-purple hover:bg-gray-100", children: [
          "Start Free Trial",
          /* @__PURE__ */ jsxRuntimeExports.jsx(ArrowRight, { className: "w-4 h-4 ml-2" })
        ] }) }),
        /* @__PURE__ */ jsxRuntimeExports.jsx(Link, { to: "/contact", children: /* @__PURE__ */ jsxRuntimeExports.jsx(Button, { size: "lg", variant: "outline", className: "border-white text-white hover:bg-white hover:text-flashcore-purple", children: "Get Help" }) })
      ] })
    ] }) })
  ] });
};
export {
  DocsPage as default
};
//# sourceMappingURL=DocsPage-BkPd5Fq5.js.map
