import { c as createLucideIcon, a as apiService, r as reactExports, u as useToast, j as jsxRuntimeExports, I as Input, B as Button, M as Modal, f as fetchDashboardData, C as Check, b as useAuthPhp, L as Layout, R as RefreshCw, d as Card, e as CardContent, T as TrendingUp, g as CardHeader, h as CardTitle, i as CardDescription, k as MotivationPopup } from "./index-1cza7qiv.js";
import { u as useRealDashboardDataPhp } from "./useRealDashboardDataPhp-Bg4GVncc.js";
import { u as useSubscriptionStatusPhp } from "./useSubscriptionStatusPhp-Bx-6RS91.js";
import { u as useAuth, a as useAnalyticsData } from "./useAuth-DtnrggNE.js";
import { B as Badge } from "./badge-C3TB_ojI.js";
import { T as Tabs, a as TabsList, b as TabsTrigger, c as TabsContent } from "./tabs-ACnnwSh0.js";
import { P as Progress } from "./progress-BBHYtt-s.js";
import { D as Dialog, a as DialogContent, b as DialogHeader, c as DialogTitle } from "./dialog-DJ6T3jIg.js";
import { T as Textarea } from "./textarea-Dyf3-tZG.js";
import { L as Label } from "./label-L_DOj-jP.js";
import { M as Mail } from "./mail-RnbdU7yX.js";
import { L as LoaderCircle } from "./loader-circle-B-kSsWW8.js";
import { S as Send } from "./send-DfSQWuaV.js";
import { C as CircleAlert } from "./circle-alert-EQk3LqgR.js";
import { C as CircleCheckBig } from "./circle-check-big-DUn1Erqx.js";
import { u as useQuery } from "./useQuery-CgZ3oED4.js";
import { C as Copy } from "./copy-DdaLLP3W.js";
import { E as ExternalLink } from "./external-link-CPhF_XwV.js";
import { M as MessageCircle } from "./message-circle-Dh18tDHG.js";
import { D as Download } from "./download-CwgUoo59.js";
import { U as Users } from "./users-ry-FvBVN.js";
import { T as Target } from "./target-CXwQgime.js";
import { E as Eye } from "./eye-BXfXXuHn.js";
import { C as ChartColumn } from "./chart-column-BlCmXDSE.js";
import { P as Plus } from "./plus-B3W1Cvoo.js";
import { Z as Zap } from "./zap-DJzuSPNM.js";
import { P as Palette } from "./palette-D_i_HCob.js";
import { S as SquarePen } from "./square-pen-CKaOkCaj.js";
import { E as Ellipsis } from "./ellipsis-BArQlyzp.js";
import { A as ArrowUpRight } from "./arrow-up-right-zhLeAuFS.js";
import { S as Smartphone } from "./smartphone-BpCd9bb_.js";
/**
 * @license lucide-react v0.462.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */
const Gift = createLucideIcon("Gift", [
  ["rect", { x: "3", y: "8", width: "18", height: "4", rx: "1", key: "bkv52" }],
  ["path", { d: "M12 8v13", key: "1c76mn" }],
  ["path", { d: "M19 12v7a2 2 0 0 1-2 2H7a2 2 0 0 1-2-2v-7", key: "6wjy6b" }],
  [
    "path",
    {
      d: "M7.5 8a2.5 2.5 0 0 1 0-5A4.8 8 0 0 1 12 8a4.8 8 0 0 1 4.5-5 2.5 2.5 0 0 1 0 5",
      key: "1ihvrl"
    }
  ]
]);
const useDashboardLoggerPhp = () => {
  const logActivity = async (action, details) => {
    try {
      await apiService.logActivity(action, details);
    } catch (error) {
      console.error("Failed to log dashboard activity:", error);
    }
  };
  return { logActivity };
};
const EmailComposer = ({ isOpen, onClose }) => {
  const [formData, setFormData] = reactExports.useState({
    to: "",
    subject: "",
    message: ""
  });
  const [isLoading, setIsLoading] = reactExports.useState(false);
  const [status, setStatus] = reactExports.useState("idle");
  const { toast } = useToast();
  const { user } = useAuth();
  const handleSubmit = async (e) => {
    e.preventDefault();
    if (!user) return;
    setIsLoading(true);
    setStatus("sending");
    try {
      const response = await apiService.sendEmail({
        to: formData.to,
        subject: formData.subject,
        message: formData.message,
        from: user.email
      });
      if (response.error) throw new Error(response.error);
      setStatus("success");
      toast({
        title: "Email Sent Successfully!",
        description: "Your email has been delivered."
      });
      setTimeout(() => {
        onClose();
        setFormData({ to: "", subject: "", message: "" });
        setStatus("idle");
      }, 2e3);
    } catch (error) {
      console.error("Email sending failed:", error);
      setStatus("error");
      toast({
        title: "Failed to Send Email",
        description: "Please try again later.",
        variant: "destructive"
      });
    } finally {
      setIsLoading(false);
    }
  };
  const getStatusIcon = () => {
    switch (status) {
      case "sending":
        return /* @__PURE__ */ jsxRuntimeExports.jsx(LoaderCircle, { className: "w-6 h-6 animate-spin text-blue-500" });
      case "success":
        return /* @__PURE__ */ jsxRuntimeExports.jsx(CircleCheckBig, { className: "w-6 h-6 text-green-500" });
      case "error":
        return /* @__PURE__ */ jsxRuntimeExports.jsx(CircleAlert, { className: "w-6 h-6 text-red-500" });
      default:
        return /* @__PURE__ */ jsxRuntimeExports.jsx(Mail, { className: "w-6 h-6 text-flashcore-purple" });
    }
  };
  return /* @__PURE__ */ jsxRuntimeExports.jsx(Dialog, { open: isOpen, onOpenChange: onClose, children: /* @__PURE__ */ jsxRuntimeExports.jsxs(DialogContent, { className: "max-w-2xl", children: [
    /* @__PURE__ */ jsxRuntimeExports.jsx(DialogHeader, { children: /* @__PURE__ */ jsxRuntimeExports.jsxs(DialogTitle, { className: "flex items-center gap-2", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsx(Mail, { className: "w-5 h-5" }),
      "Compose Email"
    ] }) }),
    /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex flex-col items-center justify-center py-8", style: { display: status === "idle" ? "none" : "flex" }, children: [
      getStatusIcon(),
      /* @__PURE__ */ jsxRuntimeExports.jsxs("p", { className: "mt-4 text-center text-muted-foreground", children: [
        status === "sending" && "Sending your email...",
        status === "success" && "Email sent successfully!",
        status === "error" && "Failed to send email. Please try again."
      ] })
    ] }),
    /* @__PURE__ */ jsxRuntimeExports.jsx("form", { onSubmit: handleSubmit, style: { display: status === "idle" ? "block" : "none" }, children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "space-y-4", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx(Label, { htmlFor: "to", children: "To" }),
        /* @__PURE__ */ jsxRuntimeExports.jsx(
          Input,
          {
            id: "to",
            type: "email",
            placeholder: "recipient@example.com",
            value: formData.to,
            onChange: (e) => setFormData({ ...formData, to: e.target.value }),
            required: true
          }
        )
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx(Label, { htmlFor: "subject", children: "Subject" }),
        /* @__PURE__ */ jsxRuntimeExports.jsx(
          Input,
          {
            id: "subject",
            placeholder: "Email subject",
            value: formData.subject,
            onChange: (e) => setFormData({ ...formData, subject: e.target.value }),
            required: true
          }
        )
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx(Label, { htmlFor: "message", children: "Message" }),
        /* @__PURE__ */ jsxRuntimeExports.jsx(
          Textarea,
          {
            id: "message",
            placeholder: "Write your message here...",
            rows: 8,
            value: formData.message,
            onChange: (e) => setFormData({ ...formData, message: e.target.value }),
            required: true
          }
        )
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex justify-end space-x-2", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx(Button, { type: "button", variant: "outline", onClick: onClose, children: "Cancel" }),
        /* @__PURE__ */ jsxRuntimeExports.jsx(Button, { type: "submit", disabled: isLoading, children: isLoading ? /* @__PURE__ */ jsxRuntimeExports.jsxs(jsxRuntimeExports.Fragment, { children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx(LoaderCircle, { className: "w-4 h-4 mr-2 animate-spin" }),
          "Sending..."
        ] }) : /* @__PURE__ */ jsxRuntimeExports.jsxs(jsxRuntimeExports.Fragment, { children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx(Send, { className: "w-4 h-4 mr-2" }),
          "Send Email"
        ] }) })
      ] })
    ] }) })
  ] }) });
};
const SuccessModal = ({
  isOpen: externalIsOpen,
  onClose,
  message = "Login successful!",
  duration = 8e3
}) => {
  const [internalIsOpen, setInternalIsOpen] = reactExports.useState(true);
  const isOpen = externalIsOpen !== void 0 ? externalIsOpen : internalIsOpen;
  const handleClose = () => {
    setInternalIsOpen(false);
    onClose == null ? void 0 : onClose();
  };
  reactExports.useEffect(() => {
    if (isOpen) {
      const timer = setTimeout(() => {
        handleClose();
      }, duration);
      return () => clearTimeout(timer);
    }
  }, [isOpen, duration]);
  if (!isOpen) return null;
  return /* @__PURE__ */ jsxRuntimeExports.jsx(Modal, { isOpen, onClose: handleClose, children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex flex-col items-center py-4", children: [
    /* @__PURE__ */ jsxRuntimeExports.jsx(CircleCheckBig, { size: 64, className: "text-flashcore-green mb-4" }),
    /* @__PURE__ */ jsxRuntimeExports.jsx("h2", { className: "text-xl font-semibold mb-2", children: message }),
    /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-sm text-muted-foreground", children: "Welcome back to your FLASHCORE dashboard" })
  ] }) });
};
const useUserData = () => {
  return useQuery({
    queryKey: ["dashboardData"],
    queryFn: fetchDashboardData,
    staleTime: 3e4,
    // 30 seconds before refetching
    refetchInterval: 6e4
    // Refetch every minute
  });
};
const ReferralPopup = ({ isOpen, onClose }) => {
  const { data } = useUserData();
  const { toast } = useToast();
  const [copied, setCopied] = reactExports.useState(false);
  const referralLink = (data == null ? void 0 : data.user.referralLink) || "https://flashcore.app/ref/user";
  const copyToClipboard = () => {
    navigator.clipboard.writeText(referralLink);
    setCopied(true);
    toast({
      title: "Link copied",
      description: "Referral link copied to clipboard",
      duration: 3e3
    });
    setTimeout(() => setCopied(false), 2e3);
  };
  return /* @__PURE__ */ jsxRuntimeExports.jsx(Modal, { isOpen, onClose, title: "Refer & Earn", children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex flex-col items-center", children: [
    /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "w-12 h-12 rounded-full bg-flashcore-purple/20 flex items-center justify-center mb-4", children: /* @__PURE__ */ jsxRuntimeExports.jsx(Gift, { size: 24, className: "text-flashcore-purple" }) }),
    /* @__PURE__ */ jsxRuntimeExports.jsx("h3", { className: "text-xl font-semibold mb-1", children: "Invite Friends, Earn Rewards" }),
    /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-sm text-muted-foreground mb-6 text-center", children: "Share your unique link and earn $20 for each friend who signs up" }),
    /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "relative w-full mb-6", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsx(
        "input",
        {
          type: "text",
          value: referralLink,
          readOnly: true,
          className: "w-full px-3 py-2 bg-secondary rounded-lg pr-10 focus:outline-none focus:ring-1 focus:ring-flashcore-purple"
        }
      ),
      /* @__PURE__ */ jsxRuntimeExports.jsx(
        "button",
        {
          onClick: copyToClipboard,
          className: "absolute right-2 top-1/2 -translate-y-1/2 p-1 hover:bg-muted rounded-md transition-colors",
          "aria-label": "Copy referral link",
          children: copied ? /* @__PURE__ */ jsxRuntimeExports.jsx(Check, { size: 18, className: "text-flashcore-green" }) : /* @__PURE__ */ jsxRuntimeExports.jsx(Copy, { size: 18 })
        }
      )
    ] }),
    /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "grid grid-cols-2 gap-4 w-full mb-6", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "bg-secondary rounded-lg p-3 text-center", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-2xl font-bold text-flashcore-purple", children: (data == null ? void 0 : data.user.referralCount) || 0 }),
        /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-xs text-muted-foreground", children: "Friends Invited" })
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "bg-secondary rounded-lg p-3 text-center", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsxs("p", { className: "text-2xl font-bold text-flashcore-green", children: [
          "$",
          (data == null ? void 0 : data.user.referralEarnings) || 0
        ] }),
        /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-xs text-muted-foreground", children: "Total Earned" })
      ] })
    ] }),
    /* @__PURE__ */ jsxRuntimeExports.jsxs(
      "button",
      {
        className: "w-full py-3 bg-gradient-to-r from-flashcore-purple to-flashcore-green rounded-lg font-medium hover:opacity-90 transition-opacity flex items-center justify-center gap-2",
        onClick: onClose,
        children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx(ExternalLink, { size: 18 }),
          "Start Earning Now"
        ]
      }
    )
  ] }) });
};
const TelegramPopup = ({ isOpen, onClose }) => {
  return /* @__PURE__ */ jsxRuntimeExports.jsx(Modal, { isOpen, onClose, title: "Join Our Community", children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex flex-col items-center", children: [
    /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "w-12 h-12 rounded-full bg-blue-500/20 flex items-center justify-center mb-4", children: /* @__PURE__ */ jsxRuntimeExports.jsx(MessageCircle, { size: 24, className: "text-blue-500" }) }),
    /* @__PURE__ */ jsxRuntimeExports.jsx("h3", { className: "text-xl font-semibold mb-1", children: "Join Our Telegram Channel" }),
    /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-sm text-muted-foreground mb-6 text-center", children: "Get exclusive tips, updates, and connect with other FLASHCORE users" }),
    /* @__PURE__ */ jsxRuntimeExports.jsxs(
      "a",
      {
        href: "https://t.me/flashcore",
        target: "_blank",
        rel: "noopener noreferrer",
        className: "w-full py-3 bg-gradient-to-r from-blue-500 to-blue-600 rounded-lg font-medium hover:opacity-90 transition-opacity flex items-center justify-center gap-2",
        children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx(ExternalLink, { size: 18 }),
          "Join Telegram Channel"
        ]
      }
    ),
    /* @__PURE__ */ jsxRuntimeExports.jsx(
      "button",
      {
        onClick: onClose,
        className: "mt-4 text-sm text-muted-foreground hover:text-foreground transition-colors",
        children: "Maybe later"
      }
    )
  ] }) });
};
const Dashboard = () => {
  var _a, _b, _c, _d, _e, _f, _g, _h, _i, _j, _k, _l, _m, _n, _o, _p, _q, _r, _s, _t, _u, _v, _w;
  const { user, loading: authLoading } = useAuthPhp();
  const { data: realData, isLoading, error, refetch } = useRealDashboardDataPhp();
  const { isActivated, refreshStatus } = useSubscriptionStatusPhp();
  const { logActivity } = useDashboardLoggerPhp();
  const { toast } = useToast();
  const { data: analyticsData, refetch: refetchAnalytics } = useAnalyticsData();
  const [showEmailComposer, setShowEmailComposer] = reactExports.useState(false);
  const [showSuccessModal, setShowSuccessModal] = reactExports.useState(false);
  const [showMotivationPopup, setShowMotivationPopup] = reactExports.useState(false);
  const [showReferralPopup, setShowReferralPopup] = reactExports.useState(false);
  const [showTelegramPopup, setShowTelegramPopup] = reactExports.useState(false);
  const [activeTab, setActiveTab] = reactExports.useState("overview");
  const [isRefreshing, setIsRefreshing] = reactExports.useState(false);
  const data = realData;
  const analytics = analyticsData;
  const dashboardData = {
    overview: {
      totalSubscribers: ((_a = data == null ? void 0 : data.overview) == null ? void 0 : _a.total_subscribers) || ((_b = data == null ? void 0 : data.user) == null ? void 0 : _b.referralCount) || 0,
      activeCampaigns: ((_c = data == null ? void 0 : data.overview) == null ? void 0 : _c.active_campaigns) || ((_d = analytics == null ? void 0 : analytics.overview) == null ? void 0 : _d.active_clients) || 0,
      totalEmailsSent: (data == null ? void 0 : data.totalMails) || ((_e = data == null ? void 0 : data.overview) == null ? void 0 : _e.total_emails_sent) || 0,
      openRate: ((_f = data == null ? void 0 : data.overview) == null ? void 0 : _f.open_rate) || ((_g = analytics == null ? void 0 : analytics.overview) == null ? void 0 : _g.open_rate) || 0,
      clickRate: ((_h = data == null ? void 0 : data.overview) == null ? void 0 : _h.click_rate) || ((_i = analytics == null ? void 0 : analytics.overview) == null ? void 0 : _i.click_rate) || 0,
      conversionRate: ((_j = data == null ? void 0 : data.overview) == null ? void 0 : _j.conversion_rate) || 0,
      revenue: ((_k = data == null ? void 0 : data.overview) == null ? void 0 : _k.revenue) || ((_l = analytics == null ? void 0 : analytics.overview) == null ? void 0 : _l.revenue) || 0,
      growth: ((_m = data == null ? void 0 : data.overview) == null ? void 0 : _m.growth) || ((_n = analytics == null ? void 0 : analytics.overview) == null ? void 0 : _n.revenue_growth) || 0
    },
    campaigns: (data == null ? void 0 : data.campaigns) || [],
    subscribers: {
      total: ((_o = data == null ? void 0 : data.overview) == null ? void 0 : _o.total_subscribers) || 0,
      segments: ((_p = data == null ? void 0 : data.subscribers) == null ? void 0 : _p.segments) || [
        { name: "Total Reach", count: ((_q = data == null ? void 0 : data.overview) == null ? void 0 : _q.total_subscribers) || 0, percentage: 100 },
        { name: "Direct Referrals", count: ((_r = data == null ? void 0 : data.user) == null ? void 0 : _r.referralCount) || 0, percentage: ((_s = data == null ? void 0 : data.overview) == null ? void 0 : _s.total_subscribers) && data.overview.total_subscribers > 0 ? Math.round((((_t = data == null ? void 0 : data.user) == null ? void 0 : _t.referralCount) || 0) / data.overview.total_subscribers * 100) : 0 }
      ]
    }
  };
  reactExports.useEffect(() => {
    if (user) {
      logActivity("dashboard_accessed");
    }
  }, [user, logActivity]);
  reactExports.useEffect(() => {
    const lastReferralPopup = localStorage.getItem("lastReferralPopup");
    const lastTelegramPopup = localStorage.getItem("lastTelegramPopup");
    if (!localStorage.getItem("dashboardFirstLoad")) {
      setShowSuccessModal(true);
      localStorage.setItem("dashboardFirstLoad", "true");
    }
    if (!lastReferralPopup || Date.now() - parseInt(lastReferralPopup) > 24 * 60 * 60 * 1e3) {
      const timer = setTimeout(() => {
        setShowReferralPopup(true);
        localStorage.setItem("lastReferralPopup", Date.now().toString());
      }, 3e4);
      return () => clearTimeout(timer);
    }
    if (!lastTelegramPopup || Date.now() - parseInt(lastTelegramPopup) > 48 * 60 * 60 * 1e3) {
      const timer = setTimeout(() => {
        setShowTelegramPopup(true);
        localStorage.setItem("lastTelegramPopup", Date.now().toString());
      }, 6e4);
      return () => clearTimeout(timer);
    }
  }, []);
  const handleOpenEmailComposer = () => {
    if (!isActivated) {
      toast({
        title: "Account Activation Required",
        description: "Please activate your account to access email features.",
        variant: "destructive"
      });
      return;
    }
    setShowEmailComposer(true);
  };
  const handleCloseEmailComposer = () => {
    setShowEmailComposer(false);
  };
  const handleRefresh = async () => {
    setIsRefreshing(true);
    try {
      await Promise.all([
        refetch(),
        refetchAnalytics(),
        refreshStatus()
      ]);
      toast({
        title: "Dashboard Refreshed",
        description: "Latest data has been loaded successfully."
      });
    } catch (error2) {
      toast({
        title: "Refresh Failed",
        description: "Could not load latest data.",
        variant: "destructive"
      });
    } finally {
      setIsRefreshing(false);
    }
  };
  const handleExportData = () => {
    toast({
      title: "Export Started",
      description: "Your dashboard data is being prepared for download."
    });
  };
  const handleImportSubscribers = () => {
    toast({
      title: "Import Feature",
      description: "Subscriber import functionality coming soon."
    });
  };
  const handleCreateAutomation = () => {
    setActiveTab("automation");
  };
  const handleDesignTemplate = () => {
    toast({
      title: "Template Designer",
      description: "Template designer is under development."
    });
  };
  if (authLoading || isLoading) {
    return /* @__PURE__ */ jsxRuntimeExports.jsx(Layout, { children: /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "flex items-center justify-center min-h-[calc(100vh-4rem)] bg-background", children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex flex-col items-center", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "w-16 h-16 border-4 border-flashcore-purple border-t-transparent rounded-full animate-spin" }),
      /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "mt-4 text-xl font-semibold", children: "Loading dashboard..." }),
      /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "mt-2 text-sm text-muted-foreground", children: "Preparing your data" })
    ] }) }) });
  }
  if (error) {
    console.error("Dashboard error:", error);
    return /* @__PURE__ */ jsxRuntimeExports.jsx(Layout, { children: /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "flex items-center justify-center min-h-[calc(100vh-4rem)] bg-background", children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "p-6 bg-card rounded-xl border border-destructive max-w-md mx-auto text-center", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsx(CircleAlert, { className: "w-16 h-16 text-destructive mx-auto mb-4" }),
      /* @__PURE__ */ jsxRuntimeExports.jsx("h2", { className: "text-2xl font-bold text-destructive mb-2", children: "Error Loading Dashboard" }),
      /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-muted-foreground mb-4", children: error instanceof Error ? error.message : "Please try refreshing the page" }),
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex gap-2 justify-center", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx(
          Button,
          {
            onClick: handleRefresh,
            disabled: isRefreshing,
            className: "bg-destructive text-destructive-foreground hover:bg-destructive/90",
            children: isRefreshing ? /* @__PURE__ */ jsxRuntimeExports.jsxs(jsxRuntimeExports.Fragment, { children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx(RefreshCw, { className: "w-4 h-4 mr-2 animate-spin" }),
              "Retrying..."
            ] }) : /* @__PURE__ */ jsxRuntimeExports.jsxs(jsxRuntimeExports.Fragment, { children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx(RefreshCw, { className: "w-4 h-4 mr-2" }),
              "Retry"
            ] })
          }
        ),
        /* @__PURE__ */ jsxRuntimeExports.jsx(
          Button,
          {
            variant: "outline",
            onClick: () => window.location.reload(),
            children: "Refresh Page"
          }
        )
      ] })
    ] }) }) });
  }
  return /* @__PURE__ */ jsxRuntimeExports.jsxs(Layout, { children: [
    /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "space-y-6", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex flex-col sm:flex-row sm:items-center sm:justify-between gap-4", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx("h1", { className: "text-3xl font-bold", children: "Dashboard" }),
          /* @__PURE__ */ jsxRuntimeExports.jsxs("p", { className: "text-muted-foreground", children: [
            "Welcome back, ",
            ((_u = data == null ? void 0 : data.user) == null ? void 0 : _u.firstName) || ((_v = data == null ? void 0 : data.user) == null ? void 0 : _v.username) || "User",
            "!",
            data && ` You've sent ${data.totalMails} emails.`
          ] })
        ] }),
        /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center gap-2", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsxs(
            Button,
            {
              variant: "outline",
              onClick: handleRefresh,
              disabled: isRefreshing,
              children: [
                /* @__PURE__ */ jsxRuntimeExports.jsx(RefreshCw, { className: `w-4 h-4 mr-2 ${isRefreshing ? "animate-spin" : ""}` }),
                "Refresh"
              ]
            }
          ),
          /* @__PURE__ */ jsxRuntimeExports.jsxs(Button, { variant: "outline", onClick: handleExportData, children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx(Download, { className: "w-4 h-4 mr-2" }),
            "Export"
          ] })
        ] })
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx(Card, { className: "hover:shadow-lg transition-shadow", children: /* @__PURE__ */ jsxRuntimeExports.jsx(CardContent, { className: "p-6", children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center justify-between", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-sm font-medium text-muted-foreground", children: "Total Subscribers" }),
            /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-2xl font-bold", children: dashboardData.overview.totalSubscribers.toLocaleString() }),
            /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center mt-2", children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx(TrendingUp, { className: "w-4 h-4 text-green-500 mr-1" }),
              /* @__PURE__ */ jsxRuntimeExports.jsxs("span", { className: "text-sm text-green-500", children: [
                "+",
                dashboardData.overview.growth,
                "%"
              ] })
            ] })
          ] }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(Users, { className: "w-8 h-8 text-flashcore-purple" })
        ] }) }) }),
        /* @__PURE__ */ jsxRuntimeExports.jsx(Card, { className: "hover:shadow-lg transition-shadow", children: /* @__PURE__ */ jsxRuntimeExports.jsx(CardContent, { className: "p-6", children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center justify-between", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-sm font-medium text-muted-foreground", children: "Active Campaigns" }),
            /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-2xl font-bold", children: dashboardData.overview.activeCampaigns }),
            /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-sm text-muted-foreground mt-2", children: "Running now" })
          ] }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(Target, { className: "w-8 h-8 text-flashcore-green" })
        ] }) }) }),
        /* @__PURE__ */ jsxRuntimeExports.jsx(Card, { className: "hover:shadow-lg transition-shadow", children: /* @__PURE__ */ jsxRuntimeExports.jsx(CardContent, { className: "p-6", children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center justify-between", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-sm font-medium text-muted-foreground", children: "Open Rate" }),
            /* @__PURE__ */ jsxRuntimeExports.jsxs("p", { className: "text-2xl font-bold", children: [
              dashboardData.overview.openRate,
              "%"
            ] }),
            /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center mt-2", children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx(Eye, { className: "w-4 h-4 text-blue-500 mr-1" }),
              /* @__PURE__ */ jsxRuntimeExports.jsx("span", { className: "text-sm text-blue-500", children: "+2.1%" })
            ] })
          ] }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(Eye, { className: "w-8 h-8 text-blue-500" })
        ] }) }) }),
        /* @__PURE__ */ jsxRuntimeExports.jsx(Card, { className: "hover:shadow-lg transition-shadow", children: /* @__PURE__ */ jsxRuntimeExports.jsx(CardContent, { className: "p-6", children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center justify-between", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-sm font-medium text-muted-foreground", children: "Revenue" }),
            /* @__PURE__ */ jsxRuntimeExports.jsxs("p", { className: "text-2xl font-bold", children: [
              "$",
              dashboardData.overview.revenue.toLocaleString()
            ] }),
            /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center mt-2", children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx(TrendingUp, { className: "w-4 h-4 text-green-500 mr-1" }),
              /* @__PURE__ */ jsxRuntimeExports.jsxs("span", { className: "text-sm text-green-500", children: [
                "+",
                dashboardData.overview.growth,
                "%"
              ] })
            ] })
          ] }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(ChartColumn, { className: "w-8 h-8 text-flashcore-orange" })
        ] }) }) })
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsxs(Tabs, { value: activeTab, onValueChange: setActiveTab, className: "space-y-6", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsxs(TabsList, { className: "grid w-full grid-cols-2 sm:grid-cols-3 lg:grid-cols-5", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx(TabsTrigger, { value: "overview", children: "Overview" }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(TabsTrigger, { value: "campaigns", children: "Campaigns" }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(TabsTrigger, { value: "subscribers", children: "Subscribers" }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(TabsTrigger, { value: "automation", children: "Automation" }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(TabsTrigger, { value: "analytics", children: "Analytics" })
        ] }),
        /* @__PURE__ */ jsxRuntimeExports.jsx(TabsContent, { value: "overview", className: "space-y-6", children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "grid grid-cols-1 lg:grid-cols-2 gap-6", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsxs(Card, { children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx(CardHeader, { children: /* @__PURE__ */ jsxRuntimeExports.jsxs(CardTitle, { className: "flex items-center justify-between", children: [
              "Recent Performance",
              /* @__PURE__ */ jsxRuntimeExports.jsxs(Button, { variant: "outline", size: "sm", onClick: handleExportData, children: [
                /* @__PURE__ */ jsxRuntimeExports.jsx(Download, { className: "w-4 h-4 mr-2" }),
                "Export"
              ] })
            ] }) }),
            /* @__PURE__ */ jsxRuntimeExports.jsx(CardContent, { children: /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "space-y-4", children: ((_w = analyticsData == null ? void 0 : analyticsData.recent_activity) == null ? void 0 : _w.length) && analyticsData.recent_activity.length > 0 ? analyticsData.recent_activity.slice(0, 5).map((item, index) => {
              const activity = {
                type: item.category || "Activity",
                category: item.category,
                description: item.description,
                timestamp: item.timestamp
              };
              return /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center justify-between p-3 bg-muted/50 rounded-lg", children: [
                /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center space-x-4", children: [
                  /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "text-sm font-medium", children: activity.type }),
                  /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "text-sm text-muted-foreground", children: activity.timestamp ? new Date(activity.timestamp).toLocaleDateString() : "Just now" })
                ] }),
                /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "flex items-center space-x-4 text-sm", children: /* @__PURE__ */ jsxRuntimeExports.jsx("span", { className: "text-muted-foreground", children: activity.description || "-" }) })
              ] }, index);
            }) : /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "text-center py-4 text-muted-foreground", children: "No recent activity" }) }) })
          ] }),
          /* @__PURE__ */ jsxRuntimeExports.jsxs(Card, { children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx(CardHeader, { children: /* @__PURE__ */ jsxRuntimeExports.jsx(CardTitle, { children: "Quick Actions" }) }),
            /* @__PURE__ */ jsxRuntimeExports.jsx(CardContent, { children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "grid grid-cols-2 gap-4", children: [
              /* @__PURE__ */ jsxRuntimeExports.jsxs(
                Button,
                {
                  onClick: handleOpenEmailComposer,
                  className: "h-20 flex flex-col items-center justify-center",
                  disabled: !isActivated,
                  children: [
                    /* @__PURE__ */ jsxRuntimeExports.jsx(Plus, { className: "w-6 h-6 mb-2" }),
                    /* @__PURE__ */ jsxRuntimeExports.jsx("span", { children: "New Campaign" })
                  ]
                }
              ),
              /* @__PURE__ */ jsxRuntimeExports.jsxs(Button, { variant: "outline", onClick: handleImportSubscribers, className: "h-20 flex flex-col items-center justify-center", children: [
                /* @__PURE__ */ jsxRuntimeExports.jsx(Users, { className: "w-6 h-6 mb-2" }),
                /* @__PURE__ */ jsxRuntimeExports.jsx("span", { children: "Import Subscribers" })
              ] }),
              /* @__PURE__ */ jsxRuntimeExports.jsxs(Button, { variant: "outline", onClick: handleCreateAutomation, className: "h-20 flex flex-col items-center justify-center", children: [
                /* @__PURE__ */ jsxRuntimeExports.jsx(Zap, { className: "w-6 h-6 mb-2" }),
                /* @__PURE__ */ jsxRuntimeExports.jsx("span", { children: "Create Automation" })
              ] }),
              /* @__PURE__ */ jsxRuntimeExports.jsxs(Button, { variant: "outline", onClick: handleDesignTemplate, className: "h-20 flex flex-col items-center justify-center", children: [
                /* @__PURE__ */ jsxRuntimeExports.jsx(Palette, { className: "w-6 h-6 mb-2" }),
                /* @__PURE__ */ jsxRuntimeExports.jsx("span", { children: "Design Template" })
              ] })
            ] }) })
          ] })
        ] }) }),
        /* @__PURE__ */ jsxRuntimeExports.jsxs(TabsContent, { value: "campaigns", className: "space-y-6", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex flex-col sm:flex-row sm:items-center sm:justify-between gap-4", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx("h2", { className: "text-2xl font-bold", children: "Campaigns" }),
            /* @__PURE__ */ jsxRuntimeExports.jsxs(Button, { onClick: handleOpenEmailComposer, disabled: !isActivated, children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx(Plus, { className: "w-4 h-4 mr-2" }),
              "New Campaign"
            ] })
          ] }),
          /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "grid grid-cols-1 gap-4", children: dashboardData.campaigns.length > 0 ? dashboardData.campaigns.map((campaign) => /* @__PURE__ */ jsxRuntimeExports.jsx(Card, { className: "hover:shadow-md transition-shadow", children: /* @__PURE__ */ jsxRuntimeExports.jsx(CardContent, { className: "p-6", children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex flex-col sm:flex-row sm:items-center sm:justify-between gap-4", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex-1", children: [
              /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center gap-3 mb-2", children: [
                /* @__PURE__ */ jsxRuntimeExports.jsx("h3", { className: "text-lg font-semibold", children: campaign.name }),
                /* @__PURE__ */ jsxRuntimeExports.jsx(Badge, { variant: campaign.status === "active" ? "default" : "secondary", children: campaign.status }),
                /* @__PURE__ */ jsxRuntimeExports.jsx(Badge, { variant: "outline", children: campaign.type || "Email" })
              ] }),
              /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "grid grid-cols-2 sm:grid-cols-4 gap-4 text-sm", children: [
                /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { children: [
                  /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-muted-foreground", children: "Sent" }),
                  /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "font-semibold", children: (campaign.sent || 0).toLocaleString() })
                ] }),
                /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { children: [
                  /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-muted-foreground", children: "Open Rate" }),
                  /* @__PURE__ */ jsxRuntimeExports.jsxs("p", { className: "font-semibold", children: [
                    campaign.openRate || 0,
                    "%"
                  ] })
                ] }),
                /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { children: [
                  /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-muted-foreground", children: "Click Rate" }),
                  /* @__PURE__ */ jsxRuntimeExports.jsxs("p", { className: "font-semibold", children: [
                    campaign.clickRate || 0,
                    "%"
                  ] })
                ] }),
                /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { children: [
                  /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-muted-foreground", children: "Revenue" }),
                  /* @__PURE__ */ jsxRuntimeExports.jsxs("p", { className: "font-semibold", children: [
                    "$",
                    (campaign.revenue || 0).toLocaleString()
                  ] })
                ] })
              ] })
            ] }),
            /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center gap-2", children: [
              /* @__PURE__ */ jsxRuntimeExports.jsxs(Button, { variant: "outline", size: "sm", children: [
                /* @__PURE__ */ jsxRuntimeExports.jsx(SquarePen, { className: "w-4 h-4 mr-2" }),
                "Edit"
              ] }),
              /* @__PURE__ */ jsxRuntimeExports.jsx(Button, { variant: "outline", size: "sm", children: /* @__PURE__ */ jsxRuntimeExports.jsx(Ellipsis, { className: "w-4 h-4" }) })
            ] })
          ] }) }) }, campaign.id)) : /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "text-center py-8 text-muted-foreground bg-muted/20 rounded-lg", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx("p", { children: "No active campaigns found." }),
            /* @__PURE__ */ jsxRuntimeExports.jsx(Button, { variant: "link", onClick: handleOpenEmailComposer, children: "Create your first campaign" })
          ] }) })
        ] }),
        /* @__PURE__ */ jsxRuntimeExports.jsxs(TabsContent, { value: "subscribers", className: "space-y-6", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex flex-col sm:flex-row sm:items-center sm:justify-between gap-4", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx("h2", { className: "text-2xl font-bold", children: "Subscribers" }),
            /* @__PURE__ */ jsxRuntimeExports.jsxs(Button, { variant: "outline", children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx(Users, { className: "w-4 h-4 mr-2" }),
              "Import Subscribers"
            ] })
          ] }),
          /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "grid grid-cols-1 md:grid-cols-3 gap-6", children: dashboardData.subscribers.segments.map((segment, index) => /* @__PURE__ */ jsxRuntimeExports.jsxs(Card, { children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx(CardHeader, { children: /* @__PURE__ */ jsxRuntimeExports.jsx(CardTitle, { className: "text-lg", children: segment.name }) }),
            /* @__PURE__ */ jsxRuntimeExports.jsx(CardContent, { children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "text-center", children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-3xl font-bold", children: segment.count.toLocaleString() }),
              /* @__PURE__ */ jsxRuntimeExports.jsxs("p", { className: "text-sm text-muted-foreground", children: [
                segment.percentage,
                "% of total"
              ] }),
              /* @__PURE__ */ jsxRuntimeExports.jsx(Progress, { value: segment.percentage, className: "mt-4" })
            ] }) })
          ] }, index)) })
        ] }),
        /* @__PURE__ */ jsxRuntimeExports.jsxs(TabsContent, { value: "automation", className: "space-y-6", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex flex-col sm:flex-row sm:items-center sm:justify-between gap-4", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx("h2", { className: "text-2xl font-bold", children: "Automation" }),
            /* @__PURE__ */ jsxRuntimeExports.jsxs(Button, { variant: "outline", children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx(Zap, { className: "w-4 h-4 mr-2" }),
              "Create Workflow"
            ] })
          ] }),
          /* @__PURE__ */ jsxRuntimeExports.jsxs(Card, { children: [
            /* @__PURE__ */ jsxRuntimeExports.jsxs(CardHeader, { children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx(CardTitle, { children: "Automations" }),
              /* @__PURE__ */ jsxRuntimeExports.jsx(CardDescription, { children: "Manage your automated workflows" })
            ] }),
            /* @__PURE__ */ jsxRuntimeExports.jsx(CardContent, { children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex flex-col items-center justify-center py-8 text-center text-muted-foreground", children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx(Zap, { className: "w-12 h-12 mb-4 opacity-20" }),
              /* @__PURE__ */ jsxRuntimeExports.jsx("p", { children: "No active automations." }),
              /* @__PURE__ */ jsxRuntimeExports.jsx(Button, { variant: "link", onClick: handleCreateAutomation, children: "Create your first workflow" })
            ] }) })
          ] })
        ] }),
        /* @__PURE__ */ jsxRuntimeExports.jsxs(TabsContent, { value: "analytics", className: "space-y-6", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex flex-col sm:flex-row sm:items-center sm:justify-between gap-4", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx("h2", { className: "text-2xl font-bold", children: "Analytics" }),
            /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "flex items-center space-x-2", children: /* @__PURE__ */ jsxRuntimeExports.jsxs(Button, { variant: "outline", onClick: handleExportData, children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx(Download, { className: "w-4 h-4 mr-2" }),
              "Export"
            ] }) })
          ] }),
          /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "grid grid-cols-1 lg:grid-cols-2 gap-6", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsxs(Card, { children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx(CardHeader, { children: /* @__PURE__ */ jsxRuntimeExports.jsx(CardTitle, { children: "Performance Metrics" }) }),
              /* @__PURE__ */ jsxRuntimeExports.jsx(CardContent, { children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "space-y-6", children: [
                /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center justify-between", children: [
                  /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { children: [
                    /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-sm text-muted-foreground", children: "Open Rate" }),
                    /* @__PURE__ */ jsxRuntimeExports.jsxs("p", { className: "text-2xl font-bold", children: [
                      dashboardData.overview.openRate,
                      "%"
                    ] })
                  ] }),
                  /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "text-right", children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center text-green-500", children: [
                    /* @__PURE__ */ jsxRuntimeExports.jsx(ArrowUpRight, { className: "w-4 h-4 mr-1" }),
                    /* @__PURE__ */ jsxRuntimeExports.jsx("span", { className: "text-sm", children: "+2.1%" })
                  ] }) })
                ] }),
                /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center justify-between", children: [
                  /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { children: [
                    /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-sm text-muted-foreground", children: "Click Rate" }),
                    /* @__PURE__ */ jsxRuntimeExports.jsxs("p", { className: "text-2xl font-bold", children: [
                      dashboardData.overview.clickRate,
                      "%"
                    ] })
                  ] }),
                  /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "text-right", children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center text-green-500", children: [
                    /* @__PURE__ */ jsxRuntimeExports.jsx(ArrowUpRight, { className: "w-4 h-4 mr-1" }),
                    /* @__PURE__ */ jsxRuntimeExports.jsx("span", { className: "text-sm", children: "+0.8%" })
                  ] }) })
                ] })
              ] }) })
            ] }),
            /* @__PURE__ */ jsxRuntimeExports.jsxs(Card, { children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx(CardHeader, { children: /* @__PURE__ */ jsxRuntimeExports.jsx(CardTitle, { children: "Device Analytics" }) }),
              /* @__PURE__ */ jsxRuntimeExports.jsx(CardContent, { children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex flex-col items-center justify-center py-8 text-center text-muted-foreground", children: [
                /* @__PURE__ */ jsxRuntimeExports.jsx(Smartphone, { className: "w-12 h-12 mb-4 opacity-20" }),
                /* @__PURE__ */ jsxRuntimeExports.jsx("p", { children: "No device data available yet." }),
                /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-sm", children: "Device tracking will appear here once you send campaigns." })
              ] }) })
            ] })
          ] })
        ] })
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsx(
        "button",
        {
          onClick: handleOpenEmailComposer,
          className: "fixed bottom-6 right-6 bg-gradient-to-r from-flashcore-purple to-flashcore-green text-white p-4 rounded-full shadow-lg hover:shadow-xl transition-all duration-300 z-50 group",
          title: "Compose Email",
          children: /* @__PURE__ */ jsxRuntimeExports.jsx(Mail, { className: "w-6 h-6 group-hover:scale-110 transition-transform" })
        }
      )
    ] }),
    /* @__PURE__ */ jsxRuntimeExports.jsx(
      EmailComposer,
      {
        isOpen: showEmailComposer,
        onClose: handleCloseEmailComposer
      }
    ),
    /* @__PURE__ */ jsxRuntimeExports.jsx(
      SuccessModal,
      {
        isOpen: showSuccessModal,
        onClose: () => setShowSuccessModal(false)
      }
    ),
    /* @__PURE__ */ jsxRuntimeExports.jsx(
      MotivationPopup,
      {
        isOpen: showMotivationPopup,
        onClose: () => setShowMotivationPopup(false)
      }
    ),
    /* @__PURE__ */ jsxRuntimeExports.jsx(
      ReferralPopup,
      {
        isOpen: showReferralPopup,
        onClose: () => setShowReferralPopup(false)
      }
    ),
    /* @__PURE__ */ jsxRuntimeExports.jsx(
      TelegramPopup,
      {
        isOpen: showTelegramPopup,
        onClose: () => setShowTelegramPopup(false)
      }
    )
  ] });
};
export {
  Dashboard as default
};
//# sourceMappingURL=Dashboard-BRZlRIPD.js.map
