import { c as createLucideIcon, r as reactExports, j as jsxRuntimeExports, I as Input, B as Button, d as Card, g as CardHeader, h as CardTitle, i as CardDescription, e as CardContent, A as ArrowRight, T as TrendingUp, a3 as Globe, a6 as House, S as Shield } from "./index-D2CUDDtA.js";
import { B as Badge } from "./badge-CnK8C-4m.js";
import { B as Briefcase } from "./briefcase-OQxmu2ow.js";
import { S as Search } from "./search-C-0aFC71.js";
import { F as Filter } from "./filter-CflmyIzB.js";
import { M as MapPin } from "./map-pin-DcRDV7uy.js";
import { C as Clock } from "./clock-DUn2OqpW.js";
import { C as CircleCheckBig } from "./circle-check-big-CzDEsGWP.js";
import { S as Star } from "./star-CoBm8OrW.js";
import { U as Users } from "./users-Ck38nNzE.js";
import { M as Mail } from "./mail-Gt8-jms6.js";
import { E as ExternalLink } from "./external-link-D_ERIYGV.js";
import { C as Code } from "./code-p0LkS3Wr.js";
import { P as Palette } from "./palette-BE8yGJU-.js";
import { T as Target } from "./target-C_KDyvs8.js";
import { C as ChartColumn } from "./chart-column-DXBqOlZl.js";
import { M as MessageSquare } from "./message-square-DOx4mOnU.js";
import { H as Heart } from "./heart-Dq7mPDgy.js";
import { Z as Zap } from "./zap-B7w9_awj.js";
import { D as DollarSign } from "./dollar-sign-eFa3PbGn.js";
import { B as BookOpen } from "./book-open-DBBPIN8r.js";
import { A as Award } from "./award-iwop5FS4.js";
/**
 * @license lucide-react v0.462.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */
const Coffee = createLucideIcon("Coffee", [
  ["path", { d: "M10 2v2", key: "7u0qdc" }],
  ["path", { d: "M14 2v2", key: "6buw04" }],
  [
    "path",
    {
      d: "M16 8a1 1 0 0 1 1 1v8a4 4 0 0 1-4 4H7a4 4 0 0 1-4-4V9a1 1 0 0 1 1-1h14a4 4 0 1 1 0 8h-1",
      key: "pwadti"
    }
  ],
  ["path", { d: "M6 2v2", key: "colzsn" }]
]);
const CareersPage = () => {
  const [searchQuery, setSearchQuery] = reactExports.useState("");
  const [selectedDepartment, setSelectedDepartment] = reactExports.useState("all");
  const [selectedLocation, setSelectedLocation] = reactExports.useState("all");
  const departments = [
    { id: "all", name: "All Departments", icon: Briefcase },
    { id: "engineering", name: "Engineering", icon: Code },
    { id: "design", name: "Design", icon: Palette },
    { id: "marketing", name: "Marketing", icon: Target },
    { id: "sales", name: "Sales", icon: TrendingUp },
    { id: "product", name: "Product", icon: ChartColumn },
    { id: "support", name: "Support", icon: MessageSquare }
  ];
  const locations = [
    { id: "all", name: "All Locations", icon: Globe },
    { id: "remote", name: "Remote", icon: House },
    { id: "san-francisco", name: "San Francisco", icon: MapPin },
    { id: "new-york", name: "New York", icon: MapPin },
    { id: "london", name: "London", icon: MapPin },
    { id: "berlin", name: "Berlin", icon: MapPin }
  ];
  const jobOpenings = [
    {
      id: 1,
      title: "Senior Frontend Engineer",
      department: "engineering",
      location: "remote",
      type: "Full-time",
      experience: "3-5 years",
      description: "Join our engineering team to build the next generation of email marketing tools. You'll work with React, TypeScript, and modern web technologies.",
      requirements: [
        "Strong experience with React, TypeScript, and modern JavaScript",
        "Experience with state management (Redux, Zustand, etc.)",
        "Knowledge of CSS frameworks (Tailwind CSS, styled-components)",
        "Experience with testing frameworks (Jest, React Testing Library)",
        "Understanding of web performance and optimization"
      ],
      benefits: ["Competitive salary", "Remote work", "Health insurance", "401k matching"],
      salary: "$120,000 - $160,000",
      postedDate: "2024-03-20"
    },
    {
      id: 2,
      title: "Product Designer",
      department: "design",
      location: "san-francisco",
      type: "Full-time",
      experience: "2-4 years",
      description: "Help shape the user experience of our email marketing platform. You'll work closely with product managers and engineers to create intuitive, beautiful interfaces.",
      requirements: [
        "Portfolio demonstrating strong UI/UX design skills",
        "Experience with design tools (Figma, Sketch, Adobe Creative Suite)",
        "Understanding of user-centered design principles",
        "Experience with design systems and component libraries",
        "Ability to work in a fast-paced, collaborative environment"
      ],
      benefits: ["Competitive salary", "Flexible work arrangements", "Professional development", "Stock options"],
      salary: "$90,000 - $130,000",
      postedDate: "2024-03-18"
    },
    {
      id: 3,
      title: "Marketing Manager",
      department: "marketing",
      location: "new-york",
      type: "Full-time",
      experience: "4-6 years",
      description: "Lead our marketing efforts to grow FlashCore's presence in the email marketing space. You'll develop and execute marketing strategies across multiple channels.",
      requirements: [
        "Experience in B2B SaaS marketing",
        "Strong analytical skills and data-driven approach",
        "Experience with marketing automation tools",
        "Excellent written and verbal communication skills",
        "Experience managing marketing campaigns and budgets"
      ],
      benefits: ["Competitive salary", "Performance bonuses", "Health benefits", "Professional development"],
      salary: "$100,000 - $140,000",
      postedDate: "2024-03-15"
    },
    {
      id: 4,
      title: "Customer Success Manager",
      department: "support",
      location: "remote",
      type: "Full-time",
      experience: "2-3 years",
      description: "Help our customers succeed with FlashCore by providing exceptional support and guidance. You'll be the bridge between our customers and our product team.",
      requirements: [
        "Experience in customer success or account management",
        "Strong problem-solving and communication skills",
        "Experience with CRM systems (Salesforce, HubSpot)",
        "Understanding of email marketing concepts",
        "Ability to manage multiple customer relationships"
      ],
      benefits: ["Competitive salary", "Remote work", "Health insurance", "Flexible PTO"],
      salary: "$70,000 - $90,000",
      postedDate: "2024-03-12"
    },
    {
      id: 5,
      title: "Sales Development Representative",
      department: "sales",
      location: "london",
      type: "Full-time",
      experience: "1-2 years",
      description: "Join our sales team to help grow FlashCore's customer base. You'll be responsible for prospecting, qualifying leads, and setting up sales meetings.",
      requirements: [
        "Strong communication and interpersonal skills",
        "Experience in B2B sales or lead generation",
        "Familiarity with CRM systems and sales tools",
        "Goal-oriented and results-driven mindset",
        "Understanding of the SaaS industry"
      ],
      benefits: ["Competitive base salary", "Uncapped commission", "Health benefits", "Career growth opportunities"],
      salary: "£35,000 - £45,000 + commission",
      postedDate: "2024-03-10"
    },
    {
      id: 6,
      title: "Product Manager",
      department: "product",
      location: "berlin",
      type: "Full-time",
      experience: "3-5 years",
      description: "Drive product strategy and execution for FlashCore's email marketing platform. You'll work with cross-functional teams to deliver exceptional user experiences.",
      requirements: [
        "Experience in product management for SaaS products",
        "Strong analytical and strategic thinking skills",
        "Experience with product analytics and user research",
        "Excellent communication and collaboration skills",
        "Understanding of email marketing and automation"
      ],
      benefits: ["Competitive salary", "Stock options", "Health insurance", "Professional development"],
      salary: "€80,000 - €110,000",
      postedDate: "2024-03-08"
    }
  ];
  const filteredJobs = jobOpenings.filter((job) => {
    const matchesSearch = job.title.toLowerCase().includes(searchQuery.toLowerCase()) || job.description.toLowerCase().includes(searchQuery.toLowerCase());
    const matchesDepartment = selectedDepartment === "all" || job.department === selectedDepartment;
    const matchesLocation = selectedLocation === "all" || job.location === selectedLocation;
    return matchesSearch && matchesDepartment && matchesLocation;
  });
  const companyValues = [
    {
      icon: Heart,
      title: "Customer First",
      description: "Everything we do is centered around helping our customers succeed."
    },
    {
      icon: Zap,
      title: "Innovation",
      description: "We constantly push boundaries to deliver cutting-edge email marketing solutions."
    },
    {
      icon: Users,
      title: "Collaboration",
      description: "We believe the best results come from working together as a team."
    },
    {
      icon: Shield,
      title: "Integrity",
      description: "We operate with honesty, transparency, and ethical business practices."
    }
  ];
  const benefits = [
    {
      icon: House,
      title: "Remote Work",
      description: "Work from anywhere in the world with our flexible remote policy."
    },
    {
      icon: DollarSign,
      title: "Competitive Pay",
      description: "We offer competitive salaries and comprehensive benefits packages."
    },
    {
      icon: BookOpen,
      title: "Learning & Development",
      description: "Continuous learning opportunities and professional development support."
    },
    {
      icon: Coffee,
      title: "Flexible Hours",
      description: "Work when you're most productive with flexible scheduling options."
    },
    {
      icon: Award,
      title: "Stock Options",
      description: "Own a piece of FlashCore with our employee stock option program."
    },
    {
      icon: Globe,
      title: "Global Team",
      description: "Join a diverse, international team with colleagues from around the world."
    }
  ];
  return /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex flex-col", children: [
    /* @__PURE__ */ jsxRuntimeExports.jsx("section", { className: "container mx-auto px-4 py-12 md:py-20", children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "max-w-4xl mx-auto text-center", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsxs(Badge, { variant: "secondary", className: "mb-4", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx(Briefcase, { className: "w-3 h-3 mr-1" }),
        "Join Our Team"
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsx("h1", { className: "text-3xl md:text-4xl lg:text-5xl font-bold mb-6 bg-gradient-to-r from-flashcore-purple to-flashcore-green bg-clip-text text-transparent", children: "Build the Future of Email Marketing" }),
      /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-lg md:text-xl text-muted-foreground mb-8 max-w-2xl mx-auto", children: "Join our mission to revolutionize email marketing with cutting-edge technology, innovative design, and exceptional user experiences." }),
      /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "max-w-2xl mx-auto mb-8", children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "relative", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx(Search, { className: "absolute left-3 top-1/2 transform -translate-y-1/2 text-muted-foreground w-5 h-5" }),
        /* @__PURE__ */ jsxRuntimeExports.jsx(
          Input,
          {
            type: "text",
            placeholder: "Search jobs by title, skills, or keywords...",
            value: searchQuery,
            onChange: (e) => setSearchQuery(e.target.value),
            className: "pl-10 pr-4 py-3 text-lg"
          }
        )
      ] }) })
    ] }) }),
    /* @__PURE__ */ jsxRuntimeExports.jsx("section", { className: "container mx-auto px-4 py-8", children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "max-w-6xl mx-auto", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "flex flex-wrap gap-4 justify-center mb-8", children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex flex-wrap gap-2", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsxs("span", { className: "text-sm font-medium text-muted-foreground flex items-center", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx(Filter, { className: "w-4 h-4 mr-1" }),
          "Department:"
        ] }),
        departments.map((dept) => /* @__PURE__ */ jsxRuntimeExports.jsxs(
          Button,
          {
            variant: selectedDepartment === dept.id ? "default" : "outline",
            size: "sm",
            onClick: () => setSelectedDepartment(dept.id),
            className: "flex items-center space-x-2",
            children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx(dept.icon, { className: "w-4 h-4" }),
              /* @__PURE__ */ jsxRuntimeExports.jsx("span", { children: dept.name })
            ]
          },
          dept.id
        ))
      ] }) }),
      /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "flex flex-wrap gap-4 justify-center", children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex flex-wrap gap-2", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsxs("span", { className: "text-sm font-medium text-muted-foreground flex items-center", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx(MapPin, { className: "w-4 h-4 mr-1" }),
          "Location:"
        ] }),
        locations.map((location) => /* @__PURE__ */ jsxRuntimeExports.jsxs(
          Button,
          {
            variant: selectedLocation === location.id ? "default" : "outline",
            size: "sm",
            onClick: () => setSelectedLocation(location.id),
            className: "flex items-center space-x-2",
            children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx(location.icon, { className: "w-4 h-4" }),
              /* @__PURE__ */ jsxRuntimeExports.jsx("span", { children: location.name })
            ]
          },
          location.id
        ))
      ] }) })
    ] }) }),
    /* @__PURE__ */ jsxRuntimeExports.jsx("section", { className: "container mx-auto px-4 py-12 md:py-20", children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "max-w-6xl mx-auto", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "text-center mb-12", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx("h2", { className: "text-2xl md:text-3xl font-bold mb-4", children: "Open Positions" }),
        /* @__PURE__ */ jsxRuntimeExports.jsxs("p", { className: "text-muted-foreground", children: [
          filteredJobs.length,
          " position",
          filteredJobs.length !== 1 ? "s" : "",
          " available"
        ] })
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "grid grid-cols-1 lg:grid-cols-2 gap-6 md:gap-8", children: filteredJobs.map((job) => {
        var _a, _b;
        return /* @__PURE__ */ jsxRuntimeExports.jsxs(Card, { className: "hover:shadow-lg transition-shadow group", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsxs(CardHeader, { children: [
            /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center justify-between mb-4", children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx(Badge, { variant: "secondary", className: "text-xs", children: (_a = departments.find((d) => d.id === job.department)) == null ? void 0 : _a.name }),
              /* @__PURE__ */ jsxRuntimeExports.jsx(Badge, { variant: "outline", className: "text-xs", children: job.type })
            ] }),
            /* @__PURE__ */ jsxRuntimeExports.jsx(CardTitle, { className: "text-xl group-hover:text-flashcore-purple transition-colors", children: job.title }),
            /* @__PURE__ */ jsxRuntimeExports.jsx(CardDescription, { className: "text-sm", children: job.description })
          ] }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(CardContent, { children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "space-y-4", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center justify-between text-sm", children: [
              /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center space-x-4", children: [
                /* @__PURE__ */ jsxRuntimeExports.jsxs("span", { className: "flex items-center", children: [
                  /* @__PURE__ */ jsxRuntimeExports.jsx(MapPin, { className: "w-4 h-4 mr-1" }),
                  (_b = locations.find((l) => l.id === job.location)) == null ? void 0 : _b.name
                ] }),
                /* @__PURE__ */ jsxRuntimeExports.jsxs("span", { className: "flex items-center", children: [
                  /* @__PURE__ */ jsxRuntimeExports.jsx(Clock, { className: "w-4 h-4 mr-1" }),
                  job.experience
                ] })
              ] }),
              /* @__PURE__ */ jsxRuntimeExports.jsx("span", { className: "font-semibold text-flashcore-purple", children: job.salary })
            ] }),
            /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx("h4", { className: "font-semibold text-sm mb-2", children: "Key Requirements:" }),
              /* @__PURE__ */ jsxRuntimeExports.jsxs("ul", { className: "text-sm text-muted-foreground space-y-1", children: [
                job.requirements.slice(0, 3).map((req, index) => /* @__PURE__ */ jsxRuntimeExports.jsxs("li", { className: "flex items-start", children: [
                  /* @__PURE__ */ jsxRuntimeExports.jsx(CircleCheckBig, { className: "w-3 h-3 mr-2 mt-0.5 text-green-500 flex-shrink-0" }),
                  req
                ] }, index)),
                job.requirements.length > 3 && /* @__PURE__ */ jsxRuntimeExports.jsxs("li", { className: "text-flashcore-purple text-xs", children: [
                  "+",
                  job.requirements.length - 3,
                  " more requirements"
                ] })
              ] })
            ] }),
            /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "flex flex-wrap gap-1", children: job.benefits.slice(0, 3).map((benefit, index) => /* @__PURE__ */ jsxRuntimeExports.jsx(Badge, { variant: "outline", className: "text-xs", children: benefit }, index)) }),
            /* @__PURE__ */ jsxRuntimeExports.jsxs(Button, { className: "w-full bg-flashcore-purple hover:bg-flashcore-purple/90", children: [
              "Apply Now",
              /* @__PURE__ */ jsxRuntimeExports.jsx(ArrowRight, { className: "w-4 h-4 ml-2" })
            ] })
          ] }) })
        ] }, job.id);
      }) }),
      filteredJobs.length === 0 && /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "text-center py-12", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx(Briefcase, { className: "w-16 h-16 text-muted-foreground mx-auto mb-4" }),
        /* @__PURE__ */ jsxRuntimeExports.jsx("h3", { className: "text-xl font-semibold mb-2", children: "No positions found" }),
        /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-muted-foreground mb-4", children: "Try adjusting your search criteria or check back later for new opportunities." }),
        /* @__PURE__ */ jsxRuntimeExports.jsx(
          Button,
          {
            variant: "outline",
            onClick: () => {
              setSearchQuery("");
              setSelectedDepartment("all");
              setSelectedLocation("all");
            },
            children: "Clear Filters"
          }
        )
      ] })
    ] }) }),
    /* @__PURE__ */ jsxRuntimeExports.jsx("section", { className: "container mx-auto px-4 py-12 md:py-20 bg-muted/20", children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "max-w-6xl mx-auto", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "text-center mb-12", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx("h2", { className: "text-2xl md:text-3xl font-bold mb-4", children: "Our Values" }),
        /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-muted-foreground", children: "The principles that guide everything we do at FlashCore" })
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 md:gap-8", children: companyValues.map((value, index) => /* @__PURE__ */ jsxRuntimeExports.jsx(Card, { className: "text-center hover:shadow-lg transition-shadow", children: /* @__PURE__ */ jsxRuntimeExports.jsxs(CardContent, { className: "p-6", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "w-12 h-12 bg-gradient-to-r from-flashcore-purple to-flashcore-green rounded-lg flex items-center justify-center mx-auto mb-4", children: /* @__PURE__ */ jsxRuntimeExports.jsx(value.icon, { className: "w-6 h-6 text-white" }) }),
        /* @__PURE__ */ jsxRuntimeExports.jsx("h3", { className: "text-lg font-semibold mb-2", children: value.title }),
        /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-sm text-muted-foreground", children: value.description })
      ] }) }, index)) })
    ] }) }),
    /* @__PURE__ */ jsxRuntimeExports.jsx("section", { className: "container mx-auto px-4 py-12 md:py-20", children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "max-w-6xl mx-auto", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "text-center mb-12", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx("h2", { className: "text-2xl md:text-3xl font-bold mb-4", children: "Why Work at FlashCore?" }),
        /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-muted-foreground", children: "We offer comprehensive benefits and a supportive work environment" })
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6 md:gap-8", children: benefits.map((benefit, index) => /* @__PURE__ */ jsxRuntimeExports.jsx(Card, { className: "hover:shadow-lg transition-shadow", children: /* @__PURE__ */ jsxRuntimeExports.jsxs(CardContent, { className: "p-6", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "w-12 h-12 bg-gradient-to-r from-flashcore-purple to-flashcore-green rounded-lg flex items-center justify-center mb-4", children: /* @__PURE__ */ jsxRuntimeExports.jsx(benefit.icon, { className: "w-6 h-6 text-white" }) }),
        /* @__PURE__ */ jsxRuntimeExports.jsx("h3", { className: "text-lg font-semibold mb-2", children: benefit.title }),
        /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-sm text-muted-foreground", children: benefit.description })
      ] }) }, index)) })
    ] }) }),
    /* @__PURE__ */ jsxRuntimeExports.jsx("section", { className: "container mx-auto px-4 py-12 md:py-20 bg-muted/20", children: /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "max-w-6xl mx-auto", children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "grid grid-cols-1 lg:grid-cols-2 gap-12 items-center", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx("h2", { className: "text-2xl md:text-3xl font-bold mb-6", children: "Our Culture" }),
        /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-muted-foreground mb-6", children: "At FlashCore, we believe in fostering a culture of innovation, collaboration, and continuous learning. Our team members are passionate about technology and committed to delivering exceptional value to our customers." }),
        /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "space-y-4", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-start space-x-3", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx(Star, { className: "w-5 h-5 text-yellow-500 mt-0.5" }),
            /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx("h4", { className: "font-semibold", children: "Excellence" }),
              /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-sm text-muted-foreground", children: "We strive for excellence in everything we do" })
            ] })
          ] }),
          /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-start space-x-3", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx(Users, { className: "w-5 h-5 text-blue-500 mt-0.5" }),
            /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx("h4", { className: "font-semibold", children: "Teamwork" }),
              /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-sm text-muted-foreground", children: "Collaboration is at the heart of our success" })
            ] })
          ] }),
          /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-start space-x-3", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx(TrendingUp, { className: "w-5 h-5 text-green-500 mt-0.5" }),
            /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx("h4", { className: "font-semibold", children: "Growth" }),
              /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-sm text-muted-foreground", children: "We invest in your professional development" })
            ] })
          ] })
        ] })
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "bg-gradient-to-r from-flashcore-purple to-flashcore-green rounded-lg p-8 text-white", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx("h3", { className: "text-xl font-bold mb-4", children: "Join Our Mission" }),
        /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "mb-6 opacity-90", children: "Help us revolutionize email marketing and empower businesses to connect with their customers in meaningful ways." }),
        /* @__PURE__ */ jsxRuntimeExports.jsxs(Button, { variant: "secondary", className: "bg-white text-flashcore-purple hover:bg-gray-100", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx(Mail, { className: "w-4 h-4 mr-2" }),
          "Contact Us"
        ] })
      ] })
    ] }) }) }),
    /* @__PURE__ */ jsxRuntimeExports.jsx("section", { className: "container mx-auto px-4 py-12 md:py-20", children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "max-w-4xl mx-auto text-center", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsx("h2", { className: "text-2xl md:text-3xl font-bold mb-6", children: "Application Process" }),
      /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-muted-foreground mb-12", children: "Here's what you can expect when applying to join our team" }),
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "grid grid-cols-1 md:grid-cols-4 gap-6", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "text-center", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "w-12 h-12 bg-gradient-to-r from-flashcore-purple to-flashcore-green rounded-full flex items-center justify-center mx-auto mb-4", children: /* @__PURE__ */ jsxRuntimeExports.jsx("span", { className: "text-white font-bold", children: "1" }) }),
          /* @__PURE__ */ jsxRuntimeExports.jsx("h3", { className: "font-semibold mb-2", children: "Apply" }),
          /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-sm text-muted-foreground", children: "Submit your application and resume" })
        ] }),
        /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "text-center", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "w-12 h-12 bg-gradient-to-r from-flashcore-purple to-flashcore-green rounded-full flex items-center justify-center mx-auto mb-4", children: /* @__PURE__ */ jsxRuntimeExports.jsx("span", { className: "text-white font-bold", children: "2" }) }),
          /* @__PURE__ */ jsxRuntimeExports.jsx("h3", { className: "font-semibold mb-2", children: "Review" }),
          /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-sm text-muted-foreground", children: "Our team reviews your application" })
        ] }),
        /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "text-center", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "w-12 h-12 bg-gradient-to-r from-flashcore-purple to-flashcore-green rounded-full flex items-center justify-center mx-auto mb-4", children: /* @__PURE__ */ jsxRuntimeExports.jsx("span", { className: "text-white font-bold", children: "3" }) }),
          /* @__PURE__ */ jsxRuntimeExports.jsx("h3", { className: "font-semibold mb-2", children: "Interview" }),
          /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-sm text-muted-foreground", children: "Meet with our team members" })
        ] }),
        /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "text-center", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "w-12 h-12 bg-gradient-to-r from-flashcore-purple to-flashcore-green rounded-full flex items-center justify-center mx-auto mb-4", children: /* @__PURE__ */ jsxRuntimeExports.jsx("span", { className: "text-white font-bold", children: "4" }) }),
          /* @__PURE__ */ jsxRuntimeExports.jsx("h3", { className: "font-semibold mb-2", children: "Offer" }),
          /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-sm text-muted-foreground", children: "Join the FlashCore team!" })
        ] })
      ] })
    ] }) }),
    /* @__PURE__ */ jsxRuntimeExports.jsx("section", { className: "container mx-auto px-4 py-12 md:py-20 bg-muted/20", children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "max-w-4xl mx-auto text-center", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsx("h2", { className: "text-2xl md:text-3xl font-bold mb-4", children: "Don't See the Right Fit?" }),
      /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-muted-foreground mb-8", children: "We're always looking for talented individuals to join our team. Send us your resume and we'll keep you in mind for future opportunities." }),
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex flex-col sm:flex-row gap-4 justify-center", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsxs(Button, { className: "bg-flashcore-purple hover:bg-flashcore-purple/90", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx(Mail, { className: "w-4 h-4 mr-2" }),
          "Send Resume"
        ] }),
        /* @__PURE__ */ jsxRuntimeExports.jsxs(Button, { variant: "outline", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx(ExternalLink, { className: "w-4 h-4 mr-2" }),
          "Contact HR"
        ] })
      ] })
    ] }) })
  ] });
};
export {
  CareersPage as default
};
//# sourceMappingURL=CareersPage-DN6A57dQ.js.map
