var __defProp = Object.defineProperty;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __publicField = (obj, key, value) => __defNormalProp(obj, typeof key !== "symbol" ? key + "" : key, value);
import { c as createLucideIcon, x as createContextScope, aR as createDialogScope, r as reactExports, j as jsxRuntimeExports, ay as Trigger, as as Overlay, y as useComposedRefs, aS as WarningProvider, at as Content, D as composeEventHandlers, aT as Slottable, av as Title, aw as Description, au as Close, ax as Root$1, az as Portal, v as cn, aU as buttonVariants, P as Primitive, Q as toast, L as Layout, B as Button, I as Input, aV as formatBytes, d as Card, e as CardContent, aW as formatDate, a6 as TooltipProvider, a2 as Tooltip, a3 as TooltipTrigger, a4 as TooltipContent, g as CardHeader, h as CardTitle, i as CardDescription } from "./index-BzIW3X45.js";
import { L as Label } from "./label-DzbGhz1M.js";
import { T as Textarea } from "./textarea-Wj7Xmk2Q.js";
import { B as Badge } from "./badge-BVgALWId.js";
import { D as Dialog, d as DialogTrigger, a as DialogContent, b as DialogHeader, c as DialogTitle, e as DialogDescription, f as DialogFooter } from "./dialog-DyCLBmSZ.js";
import { S as Select, a as SelectTrigger, b as SelectValue, c as SelectContent, d as SelectItem } from "./select-w8ZeLTbl.js";
import { T as Tabs, a as TabsList, b as TabsTrigger, c as TabsContent } from "./tabs-BRScWHyX.js";
import { P as Progress } from "./progress-Ni67bzFM.js";
import { Z as Zap } from "./zap-FPHo0ZvJ.js";
import { P as Plus } from "./plus-COb7WQzk.js";
import { U as Upload } from "./upload-BSNZYRHJ.js";
import { C as Clock } from "./clock-DrKnsXgy.js";
import { D as Download } from "./download-DH_73wIG.js";
import { T as Trash2 } from "./trash-2-CkKhRHD1.js";
import { C as CircleX } from "./circle-x-BxSP16_U.js";
import { C as CircleCheckBig } from "./circle-check-big-D_f41xG5.js";
import { S as Settings } from "./settings-g5ScwIYW.js";
import { F as FileText } from "./file-text-Cyvb-s8D.js";
import "./index-mp7H-WG2.js";
/**
 * @license lucide-react v0.462.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */
const HardDrive = createLucideIcon("HardDrive", [
  ["line", { x1: "22", x2: "2", y1: "12", y2: "12", key: "1y58io" }],
  [
    "path",
    {
      d: "M5.45 5.11 2 12v6a2 2 0 0 0 2 2h16a2 2 0 0 0 2-2v-6l-3.45-6.89A2 2 0 0 0 16.76 4H7.24a2 2 0 0 0-1.79 1.11z",
      key: "oot6mr"
    }
  ],
  ["line", { x1: "6", x2: "6.01", y1: "16", y2: "16", key: "sgf278" }],
  ["line", { x1: "10", x2: "10.01", y1: "16", y2: "16", key: "1l4acy" }]
]);
/**
 * @license lucide-react v0.462.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */
const Info = createLucideIcon("Info", [
  ["circle", { cx: "12", cy: "12", r: "10", key: "1mglay" }],
  ["path", { d: "M12 16v-4", key: "1dtifu" }],
  ["path", { d: "M12 8h.01", key: "e9boi3" }]
]);
/**
 * @license lucide-react v0.462.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */
const RotateCcw = createLucideIcon("RotateCcw", [
  ["path", { d: "M3 12a9 9 0 1 0 9-9 9.75 9.75 0 0 0-6.74 2.74L3 8", key: "1357e3" }],
  ["path", { d: "M3 3v5h5", key: "1xhq8a" }]
]);
var ROOT_NAME = "AlertDialog";
var [createAlertDialogContext, createAlertDialogScope] = createContextScope(ROOT_NAME, [
  createDialogScope
]);
var useDialogScope = createDialogScope();
var AlertDialog$1 = (props) => {
  const { __scopeAlertDialog, ...alertDialogProps } = props;
  const dialogScope = useDialogScope(__scopeAlertDialog);
  return /* @__PURE__ */ jsxRuntimeExports.jsx(Root$1, { ...dialogScope, ...alertDialogProps, modal: true });
};
AlertDialog$1.displayName = ROOT_NAME;
var TRIGGER_NAME = "AlertDialogTrigger";
var AlertDialogTrigger$1 = reactExports.forwardRef(
  (props, forwardedRef) => {
    const { __scopeAlertDialog, ...triggerProps } = props;
    const dialogScope = useDialogScope(__scopeAlertDialog);
    return /* @__PURE__ */ jsxRuntimeExports.jsx(Trigger, { ...dialogScope, ...triggerProps, ref: forwardedRef });
  }
);
AlertDialogTrigger$1.displayName = TRIGGER_NAME;
var PORTAL_NAME = "AlertDialogPortal";
var AlertDialogPortal$1 = (props) => {
  const { __scopeAlertDialog, ...portalProps } = props;
  const dialogScope = useDialogScope(__scopeAlertDialog);
  return /* @__PURE__ */ jsxRuntimeExports.jsx(Portal, { ...dialogScope, ...portalProps });
};
AlertDialogPortal$1.displayName = PORTAL_NAME;
var OVERLAY_NAME = "AlertDialogOverlay";
var AlertDialogOverlay$1 = reactExports.forwardRef(
  (props, forwardedRef) => {
    const { __scopeAlertDialog, ...overlayProps } = props;
    const dialogScope = useDialogScope(__scopeAlertDialog);
    return /* @__PURE__ */ jsxRuntimeExports.jsx(Overlay, { ...dialogScope, ...overlayProps, ref: forwardedRef });
  }
);
AlertDialogOverlay$1.displayName = OVERLAY_NAME;
var CONTENT_NAME = "AlertDialogContent";
var [AlertDialogContentProvider, useAlertDialogContentContext] = createAlertDialogContext(CONTENT_NAME);
var AlertDialogContent$1 = reactExports.forwardRef(
  (props, forwardedRef) => {
    const { __scopeAlertDialog, children, ...contentProps } = props;
    const dialogScope = useDialogScope(__scopeAlertDialog);
    const contentRef = reactExports.useRef(null);
    const composedRefs = useComposedRefs(forwardedRef, contentRef);
    const cancelRef = reactExports.useRef(null);
    return /* @__PURE__ */ jsxRuntimeExports.jsx(
      WarningProvider,
      {
        contentName: CONTENT_NAME,
        titleName: TITLE_NAME,
        docsSlug: "alert-dialog",
        children: /* @__PURE__ */ jsxRuntimeExports.jsx(AlertDialogContentProvider, { scope: __scopeAlertDialog, cancelRef, children: /* @__PURE__ */ jsxRuntimeExports.jsxs(
          Content,
          {
            role: "alertdialog",
            ...dialogScope,
            ...contentProps,
            ref: composedRefs,
            onOpenAutoFocus: composeEventHandlers(contentProps.onOpenAutoFocus, (event) => {
              var _a;
              event.preventDefault();
              (_a = cancelRef.current) == null ? void 0 : _a.focus({ preventScroll: true });
            }),
            onPointerDownOutside: (event) => event.preventDefault(),
            onInteractOutside: (event) => event.preventDefault(),
            children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx(Slottable, { children }),
              /* @__PURE__ */ jsxRuntimeExports.jsx(DescriptionWarning, { contentRef })
            ]
          }
        ) })
      }
    );
  }
);
AlertDialogContent$1.displayName = CONTENT_NAME;
var TITLE_NAME = "AlertDialogTitle";
var AlertDialogTitle$1 = reactExports.forwardRef(
  (props, forwardedRef) => {
    const { __scopeAlertDialog, ...titleProps } = props;
    const dialogScope = useDialogScope(__scopeAlertDialog);
    return /* @__PURE__ */ jsxRuntimeExports.jsx(Title, { ...dialogScope, ...titleProps, ref: forwardedRef });
  }
);
AlertDialogTitle$1.displayName = TITLE_NAME;
var DESCRIPTION_NAME = "AlertDialogDescription";
var AlertDialogDescription$1 = reactExports.forwardRef((props, forwardedRef) => {
  const { __scopeAlertDialog, ...descriptionProps } = props;
  const dialogScope = useDialogScope(__scopeAlertDialog);
  return /* @__PURE__ */ jsxRuntimeExports.jsx(Description, { ...dialogScope, ...descriptionProps, ref: forwardedRef });
});
AlertDialogDescription$1.displayName = DESCRIPTION_NAME;
var ACTION_NAME = "AlertDialogAction";
var AlertDialogAction$1 = reactExports.forwardRef(
  (props, forwardedRef) => {
    const { __scopeAlertDialog, ...actionProps } = props;
    const dialogScope = useDialogScope(__scopeAlertDialog);
    return /* @__PURE__ */ jsxRuntimeExports.jsx(Close, { ...dialogScope, ...actionProps, ref: forwardedRef });
  }
);
AlertDialogAction$1.displayName = ACTION_NAME;
var CANCEL_NAME = "AlertDialogCancel";
var AlertDialogCancel$1 = reactExports.forwardRef(
  (props, forwardedRef) => {
    const { __scopeAlertDialog, ...cancelProps } = props;
    const { cancelRef } = useAlertDialogContentContext(CANCEL_NAME, __scopeAlertDialog);
    const dialogScope = useDialogScope(__scopeAlertDialog);
    const ref = useComposedRefs(forwardedRef, cancelRef);
    return /* @__PURE__ */ jsxRuntimeExports.jsx(Close, { ...dialogScope, ...cancelProps, ref });
  }
);
AlertDialogCancel$1.displayName = CANCEL_NAME;
var DescriptionWarning = ({ contentRef }) => {
  const MESSAGE = `\`${CONTENT_NAME}\` requires a description for the component to be accessible for screen reader users.

You can add a description to the \`${CONTENT_NAME}\` by passing a \`${DESCRIPTION_NAME}\` component as a child, which also benefits sighted users by adding visible context to the dialog.

Alternatively, you can use your own component as a description by assigning it an \`id\` and passing the same value to the \`aria-describedby\` prop in \`${CONTENT_NAME}\`. If the description is confusing or duplicative for sighted users, you can use the \`@radix-ui/react-visually-hidden\` primitive as a wrapper around your description component.

For more information, see https://radix-ui.com/primitives/docs/components/alert-dialog`;
  reactExports.useEffect(() => {
    var _a;
    const hasDescription = document.getElementById(
      (_a = contentRef.current) == null ? void 0 : _a.getAttribute("aria-describedby")
    );
    if (!hasDescription) console.warn(MESSAGE);
  }, [MESSAGE, contentRef]);
  return null;
};
var Root2 = AlertDialog$1;
var Trigger2 = AlertDialogTrigger$1;
var Portal2 = AlertDialogPortal$1;
var Overlay2 = AlertDialogOverlay$1;
var Content2 = AlertDialogContent$1;
var Action = AlertDialogAction$1;
var Cancel = AlertDialogCancel$1;
var Title2 = AlertDialogTitle$1;
var Description2 = AlertDialogDescription$1;
const AlertDialog = Root2;
const AlertDialogTrigger = Trigger2;
const AlertDialogPortal = Portal2;
const AlertDialogOverlay = reactExports.forwardRef(({ className, ...props }, ref) => /* @__PURE__ */ jsxRuntimeExports.jsx(
  Overlay2,
  {
    className: cn(
      "fixed inset-0 z-50 bg-black/80  data-[state=open]:animate-in data-[state=closed]:animate-out data-[state=closed]:fade-out-0 data-[state=open]:fade-in-0",
      className
    ),
    ...props,
    ref
  }
));
AlertDialogOverlay.displayName = Overlay2.displayName;
const AlertDialogContent = reactExports.forwardRef(({ className, ...props }, ref) => /* @__PURE__ */ jsxRuntimeExports.jsxs(AlertDialogPortal, { children: [
  /* @__PURE__ */ jsxRuntimeExports.jsx(AlertDialogOverlay, {}),
  /* @__PURE__ */ jsxRuntimeExports.jsx(
    Content2,
    {
      ref,
      className: cn(
        "fixed left-[50%] top-[50%] z-50 grid w-full max-w-lg translate-x-[-50%] translate-y-[-50%] gap-4 border bg-background p-6 shadow-lg duration-200 data-[state=open]:animate-in data-[state=closed]:animate-out data-[state=closed]:fade-out-0 data-[state=open]:fade-in-0 data-[state=closed]:zoom-out-95 data-[state=open]:zoom-in-95 data-[state=closed]:slide-out-to-left-1/2 data-[state=closed]:slide-out-to-top-[48%] data-[state=open]:slide-in-from-left-1/2 data-[state=open]:slide-in-from-top-[48%] sm:rounded-lg",
        className
      ),
      ...props
    }
  )
] }));
AlertDialogContent.displayName = Content2.displayName;
const AlertDialogHeader = ({
  className,
  ...props
}) => /* @__PURE__ */ jsxRuntimeExports.jsx(
  "div",
  {
    className: cn(
      "flex flex-col space-y-2 text-center sm:text-left",
      className
    ),
    ...props
  }
);
AlertDialogHeader.displayName = "AlertDialogHeader";
const AlertDialogFooter = ({
  className,
  ...props
}) => /* @__PURE__ */ jsxRuntimeExports.jsx(
  "div",
  {
    className: cn(
      "flex flex-col-reverse sm:flex-row sm:justify-end sm:space-x-2",
      className
    ),
    ...props
  }
);
AlertDialogFooter.displayName = "AlertDialogFooter";
const AlertDialogTitle = reactExports.forwardRef(({ className, ...props }, ref) => /* @__PURE__ */ jsxRuntimeExports.jsx(
  Title2,
  {
    ref,
    className: cn("text-lg font-semibold", className),
    ...props
  }
));
AlertDialogTitle.displayName = Title2.displayName;
const AlertDialogDescription = reactExports.forwardRef(({ className, ...props }, ref) => /* @__PURE__ */ jsxRuntimeExports.jsx(
  Description2,
  {
    ref,
    className: cn("text-sm text-muted-foreground", className),
    ...props
  }
));
AlertDialogDescription.displayName = Description2.displayName;
const AlertDialogAction = reactExports.forwardRef(({ className, ...props }, ref) => /* @__PURE__ */ jsxRuntimeExports.jsx(
  Action,
  {
    ref,
    className: cn(buttonVariants(), className),
    ...props
  }
));
AlertDialogAction.displayName = Action.displayName;
const AlertDialogCancel = reactExports.forwardRef(({ className, ...props }, ref) => /* @__PURE__ */ jsxRuntimeExports.jsx(
  Cancel,
  {
    ref,
    className: cn(
      buttonVariants({ variant: "outline" }),
      "mt-2 sm:mt-0",
      className
    ),
    ...props
  }
));
AlertDialogCancel.displayName = Cancel.displayName;
var NAME = "Separator";
var DEFAULT_ORIENTATION = "horizontal";
var ORIENTATIONS = ["horizontal", "vertical"];
var Separator$1 = reactExports.forwardRef((props, forwardedRef) => {
  const { decorative, orientation: orientationProp = DEFAULT_ORIENTATION, ...domProps } = props;
  const orientation = isValidOrientation(orientationProp) ? orientationProp : DEFAULT_ORIENTATION;
  const ariaOrientation = orientation === "vertical" ? orientation : void 0;
  const semanticProps = decorative ? { role: "none" } : { "aria-orientation": ariaOrientation, role: "separator" };
  return /* @__PURE__ */ jsxRuntimeExports.jsx(
    Primitive.div,
    {
      "data-orientation": orientation,
      ...semanticProps,
      ...domProps,
      ref: forwardedRef
    }
  );
});
Separator$1.displayName = NAME;
function isValidOrientation(orientation) {
  return ORIENTATIONS.includes(orientation);
}
var Root = Separator$1;
const Separator = reactExports.forwardRef(
  ({ className, orientation = "horizontal", decorative = true, ...props }, ref) => /* @__PURE__ */ jsxRuntimeExports.jsx(
    Root,
    {
      ref,
      decorative,
      orientation,
      className: cn(
        "shrink-0 bg-border",
        orientation === "horizontal" ? "h-[1px] w-full" : "h-full w-[1px]",
        className
      ),
      ...props
    }
  )
);
Separator.displayName = Root.displayName;
class BackupService {
  constructor() {
    __publicField(this, "STORAGE_KEY", "flashcore_backups");
    __publicField(this, "MAX_BACKUPS", 10);
    __publicField(this, "BACKUP_VERSION", "1.0.0");
  }
  /**
   * Create a new backup of user data
   */
  async createBackup(name, description) {
    try {
      const backupData = {
        version: this.BACKUP_VERSION,
        timestamp: (/* @__PURE__ */ new Date()).toISOString(),
        user: await this.getUserData(),
        dashboard: await this.getDashboardData(),
        analytics: await this.getAnalyticsData(),
        integrations: await this.getIntegrationsData(),
        templates: await this.getTemplatesData(),
        customizations: await this.getCustomizationsData()
      };
      const backup = {
        id: this.generateBackupId(),
        name,
        description,
        timestamp: backupData.timestamp,
        size: JSON.stringify(backupData).length,
        version: this.BACKUP_VERSION,
        type: "manual",
        status: "completed"
      };
      await this.storeBackup(backup.id, backupData);
      await this.addBackupMetadata(backup);
      toast({
        title: "Backup Created",
        description: `Backup "${name}" has been created successfully.`
      });
      return backup;
    } catch (error) {
      console.error("Backup creation failed:", error);
      toast({
        title: "Backup Failed",
        description: "Failed to create backup. Please try again.",
        variant: "destructive"
      });
      throw error;
    }
  }
  /**
   * Restore data from a backup
   */
  async restoreBackup(backupId) {
    try {
      const backupData = await this.getBackupData(backupId);
      if (!backupData) {
        throw new Error("Backup not found");
      }
      this.validateBackupData(backupData);
      await this.restoreUserData(backupData.user);
      await this.restoreDashboardData(backupData.dashboard);
      await this.restoreAnalyticsData(backupData.analytics);
      await this.restoreIntegrationsData(backupData.integrations);
      await this.restoreTemplatesData(backupData.templates);
      await this.restoreCustomizationsData(backupData.customizations);
      toast({
        title: "Restore Completed",
        description: "Your data has been restored successfully."
      });
    } catch (error) {
      console.error("Restore failed:", error);
      toast({
        title: "Restore Failed",
        description: "Failed to restore backup. Please try again.",
        variant: "destructive"
      });
      throw error;
    }
  }
  /**
   * Export backup to file
   */
  async exportBackup(backupId) {
    try {
      const backupData = await this.getBackupData(backupId);
      const metadata = await this.getBackupMetadata(backupId);
      if (!backupData || !metadata) {
        throw new Error("Backup not found");
      }
      const exportData = {
        metadata,
        data: backupData
      };
      const blob = new Blob([JSON.stringify(exportData, null, 2)], {
        type: "application/json"
      });
      const url = URL.createObjectURL(blob);
      const a = document.createElement("a");
      a.href = url;
      a.download = `flashcore-backup-${metadata.name}-${(/* @__PURE__ */ new Date()).toISOString().split("T")[0]}.json`;
      document.body.appendChild(a);
      a.click();
      document.body.removeChild(a);
      URL.revokeObjectURL(url);
      toast({
        title: "Export Successful",
        description: "Backup has been exported to your device."
      });
    } catch (error) {
      console.error("Export failed:", error);
      toast({
        title: "Export Failed",
        description: "Failed to export backup. Please try again.",
        variant: "destructive"
      });
      throw error;
    }
  }
  /**
   * Import backup from file
   */
  async importBackup(file) {
    try {
      const content = await this.readFileAsText(file);
      const importData = JSON.parse(content);
      if (!importData.metadata || !importData.data) {
        throw new Error("Invalid backup file format");
      }
      this.validateBackupData(importData.data);
      const newBackupId = this.generateBackupId();
      const metadata = {
        ...importData.metadata,
        id: newBackupId,
        timestamp: (/* @__PURE__ */ new Date()).toISOString(),
        type: "manual",
        status: "completed"
      };
      await this.storeBackup(newBackupId, importData.data);
      await this.addBackupMetadata(metadata);
      toast({
        title: "Import Successful",
        description: `Backup "${metadata.name}" has been imported successfully.`
      });
      return metadata;
    } catch (error) {
      console.error("Import failed:", error);
      toast({
        title: "Import Failed",
        description: "Failed to import backup. Please check the file format.",
        variant: "destructive"
      });
      throw error;
    }
  }
  /**
   * Get all backup metadata
   */
  async getBackups() {
    try {
      const backups = localStorage.getItem(this.STORAGE_KEY);
      return backups ? JSON.parse(backups) : [];
    } catch (error) {
      console.error("Failed to get backups:", error);
      return [];
    }
  }
  /**
   * Delete a backup
   */
  async deleteBackup(backupId) {
    try {
      localStorage.removeItem(`${this.STORAGE_KEY}_${backupId}`);
      const backups = await this.getBackups();
      const filteredBackups = backups.filter((b) => b.id !== backupId);
      localStorage.setItem(this.STORAGE_KEY, JSON.stringify(filteredBackups));
      toast({
        title: "Backup Deleted",
        description: "Backup has been deleted successfully."
      });
    } catch (error) {
      console.error("Delete failed:", error);
      toast({
        title: "Delete Failed",
        description: "Failed to delete backup. Please try again.",
        variant: "destructive"
      });
      throw error;
    }
  }
  /**
   * Schedule automatic backups
   */
  async scheduleBackup(frequency) {
    try {
      const schedule = {
        frequency,
        lastBackup: null,
        enabled: true
      };
      localStorage.setItem("flashcore_backup_schedule", JSON.stringify(schedule));
      toast({
        title: "Backup Scheduled",
        description: `Automatic backups have been scheduled for ${frequency} intervals.`
      });
    } catch (error) {
      console.error("Schedule backup failed:", error);
      toast({
        title: "Schedule Failed",
        description: "Failed to schedule automatic backups.",
        variant: "destructive"
      });
      throw error;
    }
  }
  // Private helper methods
  generateBackupId() {
    return `backup_${Date.now()}_${Math.random().toString(36).substr(2, 9)}`;
  }
  async getUserData() {
    const userData = localStorage.getItem("flashcore_user");
    return userData ? JSON.parse(userData) : {};
  }
  async getDashboardData() {
    const dashboardData = localStorage.getItem("flashcore_dashboard");
    return dashboardData ? JSON.parse(dashboardData) : {};
  }
  async getAnalyticsData() {
    const analyticsData = localStorage.getItem("flashcore_analytics");
    return analyticsData ? JSON.parse(analyticsData) : {};
  }
  async getIntegrationsData() {
    const integrationsData = localStorage.getItem("flashcore_integrations");
    return integrationsData ? JSON.parse(integrationsData) : {};
  }
  async getTemplatesData() {
    const templatesData = localStorage.getItem("flashcore_templates");
    return templatesData ? JSON.parse(templatesData) : [];
  }
  async getCustomizationsData() {
    const customizationsData = localStorage.getItem("flashcore_customizations");
    return customizationsData ? JSON.parse(customizationsData) : [];
  }
  async storeBackup(backupId, data) {
    localStorage.setItem(`${this.STORAGE_KEY}_${backupId}`, JSON.stringify(data));
  }
  async getBackupData(backupId) {
    const data = localStorage.getItem(`${this.STORAGE_KEY}_${backupId}`);
    return data ? JSON.parse(data) : null;
  }
  async addBackupMetadata(metadata) {
    const backups = await this.getBackups();
    backups.unshift(metadata);
    if (backups.length > this.MAX_BACKUPS) {
      backups.splice(this.MAX_BACKUPS);
    }
    localStorage.setItem(this.STORAGE_KEY, JSON.stringify(backups));
  }
  async getBackupMetadata(backupId) {
    const backups = await this.getBackups();
    return backups.find((b) => b.id === backupId) || null;
  }
  validateBackupData(data) {
    if (!data.version || !data.timestamp || !data.user) {
      throw new Error("Invalid backup data structure");
    }
  }
  async restoreUserData(userData) {
    localStorage.setItem("flashcore_user", JSON.stringify(userData));
  }
  async restoreDashboardData(dashboardData) {
    localStorage.setItem("flashcore_dashboard", JSON.stringify(dashboardData));
  }
  async restoreAnalyticsData(analyticsData) {
    localStorage.setItem("flashcore_analytics", JSON.stringify(analyticsData));
  }
  async restoreIntegrationsData(integrationsData) {
    localStorage.setItem("flashcore_integrations", JSON.stringify(integrationsData));
  }
  async restoreTemplatesData(templatesData) {
    localStorage.setItem("flashcore_templates", JSON.stringify(templatesData));
  }
  async restoreCustomizationsData(customizationsData) {
    localStorage.setItem("flashcore_customizations", JSON.stringify(customizationsData));
  }
  readFileAsText(file) {
    return new Promise((resolve, reject) => {
      const reader = new FileReader();
      reader.onload = (e) => {
        var _a;
        return resolve((_a = e.target) == null ? void 0 : _a.result);
      };
      reader.onerror = reject;
      reader.readAsText(file);
    });
  }
}
const backupService = new BackupService();
const BackupPage = () => {
  const [backups, setBackups] = reactExports.useState([]);
  const [loading, setLoading] = reactExports.useState(false);
  reactExports.useState(null);
  const [createDialogOpen, setCreateDialogOpen] = reactExports.useState(false);
  const [importDialogOpen, setImportDialogOpen] = reactExports.useState(false);
  const [scheduleDialogOpen, setScheduleDialogOpen] = reactExports.useState(false);
  const [backupName, setBackupName] = reactExports.useState("");
  const [backupDescription, setBackupDescription] = reactExports.useState("");
  const [selectedFile, setSelectedFile] = reactExports.useState(null);
  const [scheduleFrequency, setScheduleFrequency] = reactExports.useState("weekly");
  reactExports.useEffect(() => {
    loadBackups();
  }, []);
  const loadBackups = async () => {
    try {
      setLoading(true);
      const backupList = await backupService.getBackups();
      setBackups(backupList);
    } catch (error) {
      console.error("Failed to load backups:", error);
    } finally {
      setLoading(false);
    }
  };
  const handleCreateBackup = async () => {
    if (!backupName.trim()) return;
    try {
      setLoading(true);
      await backupService.createBackup(backupName, backupDescription);
      setBackupName("");
      setBackupDescription("");
      setCreateDialogOpen(false);
      await loadBackups();
    } catch (error) {
      console.error("Failed to create backup:", error);
    } finally {
      setLoading(false);
    }
  };
  const handleRestoreBackup = async (backupId) => {
    try {
      setLoading(true);
      await backupService.restoreBackup(backupId);
      await loadBackups();
    } catch (error) {
      console.error("Failed to restore backup:", error);
    } finally {
      setLoading(false);
    }
  };
  const handleExportBackup = async (backupId) => {
    try {
      await backupService.exportBackup(backupId);
    } catch (error) {
      console.error("Failed to export backup:", error);
    }
  };
  const handleDeleteBackup = async (backupId) => {
    try {
      setLoading(true);
      await backupService.deleteBackup(backupId);
      await loadBackups();
    } catch (error) {
      console.error("Failed to delete backup:", error);
    } finally {
      setLoading(false);
    }
  };
  const handleImportBackup = async () => {
    if (!selectedFile) return;
    try {
      setLoading(true);
      await backupService.importBackup(selectedFile);
      setSelectedFile(null);
      setImportDialogOpen(false);
      await loadBackups();
    } catch (error) {
      console.error("Failed to import backup:", error);
    } finally {
      setLoading(false);
    }
  };
  const handleScheduleBackup = async () => {
    try {
      setLoading(true);
      await backupService.scheduleBackup(scheduleFrequency);
      setScheduleDialogOpen(false);
    } catch (error) {
      console.error("Failed to schedule backup:", error);
    } finally {
      setLoading(false);
    }
  };
  const handleFileSelect = (event) => {
    var _a;
    const file = (_a = event.target.files) == null ? void 0 : _a[0];
    if (file && file.type === "application/json") {
      setSelectedFile(file);
    }
  };
  const getStatusIcon = (status) => {
    switch (status) {
      case "completed":
        return /* @__PURE__ */ jsxRuntimeExports.jsx(CircleCheckBig, { className: "w-4 h-4 text-green-500" });
      case "failed":
        return /* @__PURE__ */ jsxRuntimeExports.jsx(CircleX, { className: "w-4 h-4 text-red-500" });
      case "in_progress":
        return /* @__PURE__ */ jsxRuntimeExports.jsx(Progress, { className: "w-4 h-4 text-blue-500" });
      default:
        return /* @__PURE__ */ jsxRuntimeExports.jsx(Info, { className: "w-4 h-4 text-gray-500" });
    }
  };
  const getTypeIcon = (type) => {
    switch (type) {
      case "manual":
        return /* @__PURE__ */ jsxRuntimeExports.jsx(FileText, { className: "w-4 h-4" });
      case "auto":
        return /* @__PURE__ */ jsxRuntimeExports.jsx(Settings, { className: "w-4 h-4" });
      case "scheduled":
        return /* @__PURE__ */ jsxRuntimeExports.jsx(Clock, { className: "w-4 h-4" });
      default:
        return /* @__PURE__ */ jsxRuntimeExports.jsx(HardDrive, { className: "w-4 h-4" });
    }
  };
  return /* @__PURE__ */ jsxRuntimeExports.jsx(Layout, { children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "space-y-6", children: [
    /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center justify-between", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center gap-3", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "w-8 h-8 bg-gradient-to-r from-flashcore-purple to-flashcore-green rounded-lg flex items-center justify-center", children: /* @__PURE__ */ jsxRuntimeExports.jsx(Zap, { className: "w-5 h-5 text-white" }) }),
        /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx("h1", { className: "text-3xl font-bold", children: "Backup & Restore" }),
          /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-muted-foreground", children: "Manage your data backups and restore points" })
        ] })
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex gap-2", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsxs(Dialog, { open: createDialogOpen, onOpenChange: setCreateDialogOpen, children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx(DialogTrigger, { asChild: true, children: /* @__PURE__ */ jsxRuntimeExports.jsxs(Button, { className: "bg-gradient-to-r from-flashcore-purple to-flashcore-green", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx(Plus, { className: "w-4 h-4 mr-2" }),
            "Create Backup"
          ] }) }),
          /* @__PURE__ */ jsxRuntimeExports.jsxs(DialogContent, { children: [
            /* @__PURE__ */ jsxRuntimeExports.jsxs(DialogHeader, { children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx(DialogTitle, { children: "Create New Backup" }),
              /* @__PURE__ */ jsxRuntimeExports.jsx(DialogDescription, { children: "Create a new backup of your current data and settings." })
            ] }),
            /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "space-y-4", children: [
              /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { children: [
                /* @__PURE__ */ jsxRuntimeExports.jsx(Label, { htmlFor: "backup-name", children: "Backup Name" }),
                /* @__PURE__ */ jsxRuntimeExports.jsx(
                  Input,
                  {
                    id: "backup-name",
                    value: backupName,
                    onChange: (e) => setBackupName(e.target.value),
                    placeholder: "Enter backup name"
                  }
                )
              ] }),
              /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { children: [
                /* @__PURE__ */ jsxRuntimeExports.jsx(Label, { htmlFor: "backup-description", children: "Description (Optional)" }),
                /* @__PURE__ */ jsxRuntimeExports.jsx(
                  Textarea,
                  {
                    id: "backup-description",
                    value: backupDescription,
                    onChange: (e) => setBackupDescription(e.target.value),
                    placeholder: "Enter backup description",
                    rows: 3
                  }
                )
              ] })
            ] }),
            /* @__PURE__ */ jsxRuntimeExports.jsxs(DialogFooter, { children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx(Button, { variant: "outline", onClick: () => setCreateDialogOpen(false), children: "Cancel" }),
              /* @__PURE__ */ jsxRuntimeExports.jsx(Button, { onClick: handleCreateBackup, disabled: !backupName.trim() || loading, children: loading ? "Creating..." : "Create Backup" })
            ] })
          ] })
        ] }),
        /* @__PURE__ */ jsxRuntimeExports.jsxs(Dialog, { open: importDialogOpen, onOpenChange: setImportDialogOpen, children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx(DialogTrigger, { asChild: true, children: /* @__PURE__ */ jsxRuntimeExports.jsxs(Button, { variant: "outline", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx(Upload, { className: "w-4 h-4 mr-2" }),
            "Import"
          ] }) }),
          /* @__PURE__ */ jsxRuntimeExports.jsxs(DialogContent, { children: [
            /* @__PURE__ */ jsxRuntimeExports.jsxs(DialogHeader, { children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx(DialogTitle, { children: "Import Backup" }),
              /* @__PURE__ */ jsxRuntimeExports.jsx(DialogDescription, { children: "Import a backup file from your device." })
            ] }),
            /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "space-y-4", children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx(Label, { htmlFor: "backup-file", children: "Select Backup File" }),
              /* @__PURE__ */ jsxRuntimeExports.jsx(
                Input,
                {
                  id: "backup-file",
                  type: "file",
                  accept: ".json",
                  onChange: handleFileSelect
                }
              ),
              selectedFile && /* @__PURE__ */ jsxRuntimeExports.jsxs("p", { className: "text-sm text-gray-600 mt-2", children: [
                "Selected: ",
                selectedFile.name,
                " (",
                formatBytes(selectedFile.size),
                ")"
              ] })
            ] }) }),
            /* @__PURE__ */ jsxRuntimeExports.jsxs(DialogFooter, { children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx(Button, { variant: "outline", onClick: () => setImportDialogOpen(false), children: "Cancel" }),
              /* @__PURE__ */ jsxRuntimeExports.jsx(Button, { onClick: handleImportBackup, disabled: !selectedFile || loading, children: loading ? "Importing..." : "Import Backup" })
            ] })
          ] })
        ] }),
        /* @__PURE__ */ jsxRuntimeExports.jsxs(Dialog, { open: scheduleDialogOpen, onOpenChange: setScheduleDialogOpen, children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx(DialogTrigger, { asChild: true, children: /* @__PURE__ */ jsxRuntimeExports.jsxs(Button, { variant: "outline", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx(Clock, { className: "w-4 h-4 mr-2" }),
            "Schedule"
          ] }) }),
          /* @__PURE__ */ jsxRuntimeExports.jsxs(DialogContent, { children: [
            /* @__PURE__ */ jsxRuntimeExports.jsxs(DialogHeader, { children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx(DialogTitle, { children: "Schedule Automatic Backups" }),
              /* @__PURE__ */ jsxRuntimeExports.jsx(DialogDescription, { children: "Set up automatic backups to run at regular intervals." })
            ] }),
            /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "space-y-4", children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx(Label, { htmlFor: "schedule-frequency", children: "Backup Frequency" }),
              /* @__PURE__ */ jsxRuntimeExports.jsxs(Select, { value: scheduleFrequency, onValueChange: (value) => setScheduleFrequency(value), children: [
                /* @__PURE__ */ jsxRuntimeExports.jsx(SelectTrigger, { children: /* @__PURE__ */ jsxRuntimeExports.jsx(SelectValue, {}) }),
                /* @__PURE__ */ jsxRuntimeExports.jsxs(SelectContent, { children: [
                  /* @__PURE__ */ jsxRuntimeExports.jsx(SelectItem, { value: "daily", children: "Daily" }),
                  /* @__PURE__ */ jsxRuntimeExports.jsx(SelectItem, { value: "weekly", children: "Weekly" }),
                  /* @__PURE__ */ jsxRuntimeExports.jsx(SelectItem, { value: "monthly", children: "Monthly" })
                ] })
              ] })
            ] }) }),
            /* @__PURE__ */ jsxRuntimeExports.jsxs(DialogFooter, { children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx(Button, { variant: "outline", onClick: () => setScheduleDialogOpen(false), children: "Cancel" }),
              /* @__PURE__ */ jsxRuntimeExports.jsx(Button, { onClick: handleScheduleBackup, disabled: loading, children: loading ? "Scheduling..." : "Schedule Backups" })
            ] })
          ] })
        ] })
      ] })
    ] }),
    /* @__PURE__ */ jsxRuntimeExports.jsxs(Tabs, { defaultValue: "backups", className: "space-y-4", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsxs(TabsList, { children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx(TabsTrigger, { value: "backups", children: "Backups" }),
        /* @__PURE__ */ jsxRuntimeExports.jsx(TabsTrigger, { value: "settings", children: "Settings" })
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsx(TabsContent, { value: "backups", className: "space-y-4", children: loading && backups.length === 0 ? /* @__PURE__ */ jsxRuntimeExports.jsx(Card, { children: /* @__PURE__ */ jsxRuntimeExports.jsx(CardContent, { className: "flex items-center justify-center py-8", children: /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "w-8 h-8 border-4 border-flashcore-purple border-t-transparent rounded-full animate-spin" }) }) }) : backups.length === 0 ? /* @__PURE__ */ jsxRuntimeExports.jsx(Card, { children: /* @__PURE__ */ jsxRuntimeExports.jsxs(CardContent, { className: "flex flex-col items-center justify-center py-12 text-center", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx(HardDrive, { className: "w-12 h-12 text-gray-400 mb-4" }),
        /* @__PURE__ */ jsxRuntimeExports.jsx("h3", { className: "text-lg font-semibold mb-2", children: "No backups found" }),
        /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-muted-foreground mb-4", children: "Create your first backup to get started" }),
        /* @__PURE__ */ jsxRuntimeExports.jsxs(Button, { onClick: () => setCreateDialogOpen(true), children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx(Plus, { className: "w-4 h-4 mr-2" }),
          "Create First Backup"
        ] })
      ] }) }) : /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "grid gap-4", children: backups.map((backup) => /* @__PURE__ */ jsxRuntimeExports.jsx(Card, { className: "hover:shadow-md transition-shadow", children: /* @__PURE__ */ jsxRuntimeExports.jsx(CardContent, { className: "p-6", children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-start justify-between", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-start space-x-4", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center space-x-2", children: [
            getTypeIcon(backup.type),
            getStatusIcon(backup.status)
          ] }),
          /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "space-y-1", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center space-x-2", children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx("h3", { className: "font-semibold", children: backup.name }),
              /* @__PURE__ */ jsxRuntimeExports.jsx(Badge, { variant: backup.type === "manual" ? "default" : "secondary", children: backup.type }),
              /* @__PURE__ */ jsxRuntimeExports.jsx(Badge, { variant: backup.status === "completed" ? "default" : "destructive", children: backup.status })
            ] }),
            backup.description && /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-sm text-muted-foreground", children: backup.description }),
            /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center space-x-4 text-sm text-muted-foreground", children: [
              /* @__PURE__ */ jsxRuntimeExports.jsxs("span", { children: [
                "Created: ",
                formatDate(backup.timestamp)
              ] }),
              /* @__PURE__ */ jsxRuntimeExports.jsxs("span", { children: [
                "Size: ",
                formatBytes(backup.size)
              ] }),
              /* @__PURE__ */ jsxRuntimeExports.jsxs("span", { children: [
                "Version: ",
                backup.version
              ] })
            ] })
          ] })
        ] }),
        /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center space-x-2", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx(TooltipProvider, { children: /* @__PURE__ */ jsxRuntimeExports.jsxs(Tooltip, { children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx(TooltipTrigger, { asChild: true, children: /* @__PURE__ */ jsxRuntimeExports.jsx(
              Button,
              {
                variant: "outline",
                size: "sm",
                onClick: () => handleExportBackup(backup.id),
                children: /* @__PURE__ */ jsxRuntimeExports.jsx(Download, { className: "w-4 h-4" })
              }
            ) }),
            /* @__PURE__ */ jsxRuntimeExports.jsx(TooltipContent, { children: "Export backup" })
          ] }) }),
          /* @__PURE__ */ jsxRuntimeExports.jsxs(AlertDialog, { children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx(AlertDialogTrigger, { asChild: true, children: /* @__PURE__ */ jsxRuntimeExports.jsx(Button, { variant: "outline", size: "sm", children: /* @__PURE__ */ jsxRuntimeExports.jsx(RotateCcw, { className: "w-4 h-4" }) }) }),
            /* @__PURE__ */ jsxRuntimeExports.jsxs(AlertDialogContent, { children: [
              /* @__PURE__ */ jsxRuntimeExports.jsxs(AlertDialogHeader, { children: [
                /* @__PURE__ */ jsxRuntimeExports.jsx(AlertDialogTitle, { children: "Restore Backup" }),
                /* @__PURE__ */ jsxRuntimeExports.jsx(AlertDialogDescription, { children: "This will restore your data to the state it was in when this backup was created. This action cannot be undone." })
              ] }),
              /* @__PURE__ */ jsxRuntimeExports.jsxs(AlertDialogFooter, { children: [
                /* @__PURE__ */ jsxRuntimeExports.jsx(AlertDialogCancel, { children: "Cancel" }),
                /* @__PURE__ */ jsxRuntimeExports.jsx(
                  AlertDialogAction,
                  {
                    onClick: () => handleRestoreBackup(backup.id),
                    className: "bg-red-600 hover:bg-red-700",
                    children: "Restore"
                  }
                )
              ] })
            ] })
          ] }),
          /* @__PURE__ */ jsxRuntimeExports.jsxs(AlertDialog, { children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx(AlertDialogTrigger, { asChild: true, children: /* @__PURE__ */ jsxRuntimeExports.jsx(Button, { variant: "outline", size: "sm", children: /* @__PURE__ */ jsxRuntimeExports.jsx(Trash2, { className: "w-4 h-4" }) }) }),
            /* @__PURE__ */ jsxRuntimeExports.jsxs(AlertDialogContent, { children: [
              /* @__PURE__ */ jsxRuntimeExports.jsxs(AlertDialogHeader, { children: [
                /* @__PURE__ */ jsxRuntimeExports.jsx(AlertDialogTitle, { children: "Delete Backup" }),
                /* @__PURE__ */ jsxRuntimeExports.jsx(AlertDialogDescription, { children: "This will permanently delete this backup. This action cannot be undone." })
              ] }),
              /* @__PURE__ */ jsxRuntimeExports.jsxs(AlertDialogFooter, { children: [
                /* @__PURE__ */ jsxRuntimeExports.jsx(AlertDialogCancel, { children: "Cancel" }),
                /* @__PURE__ */ jsxRuntimeExports.jsx(
                  AlertDialogAction,
                  {
                    onClick: () => handleDeleteBackup(backup.id),
                    className: "bg-red-600 hover:bg-red-700",
                    children: "Delete"
                  }
                )
              ] })
            ] })
          ] })
        ] })
      ] }) }) }, backup.id)) }) }),
      /* @__PURE__ */ jsxRuntimeExports.jsxs(TabsContent, { value: "settings", className: "space-y-4", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsxs(Card, { children: [
          /* @__PURE__ */ jsxRuntimeExports.jsxs(CardHeader, { children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx(CardTitle, { children: "Backup Settings" }),
            /* @__PURE__ */ jsxRuntimeExports.jsx(CardDescription, { children: "Configure your backup preferences and automation settings" })
          ] }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(CardContent, { className: "space-y-6", children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "space-y-4", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center justify-between", children: [
              /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { children: [
                /* @__PURE__ */ jsxRuntimeExports.jsx("h4", { className: "font-medium", children: "Automatic Backups" }),
                /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-sm text-muted-foreground", children: "Enable automatic backups to run at scheduled intervals" })
              ] }),
              /* @__PURE__ */ jsxRuntimeExports.jsx(Button, { variant: "outline", onClick: () => setScheduleDialogOpen(true), children: "Configure" })
            ] }),
            /* @__PURE__ */ jsxRuntimeExports.jsx(Separator, {}),
            /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center justify-between", children: [
              /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { children: [
                /* @__PURE__ */ jsxRuntimeExports.jsx("h4", { className: "font-medium", children: "Backup Storage" }),
                /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-sm text-muted-foreground", children: "Manage storage space and retention policies" })
              ] }),
              /* @__PURE__ */ jsxRuntimeExports.jsx(Badge, { variant: "outline", children: "10 backups max" })
            ] }),
            /* @__PURE__ */ jsxRuntimeExports.jsx(Separator, {}),
            /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center justify-between", children: [
              /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { children: [
                /* @__PURE__ */ jsxRuntimeExports.jsx("h4", { className: "font-medium", children: "Data Encryption" }),
                /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-sm text-muted-foreground", children: "Secure your backup data with encryption" })
              ] }),
              /* @__PURE__ */ jsxRuntimeExports.jsx(Badge, { variant: "default", children: "Enabled" })
            ] })
          ] }) })
        ] }),
        /* @__PURE__ */ jsxRuntimeExports.jsxs(Card, { children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx(CardHeader, { children: /* @__PURE__ */ jsxRuntimeExports.jsx(CardTitle, { children: "Backup Information" }) }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(CardContent, { className: "space-y-4", children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "grid grid-cols-2 gap-4 text-sm", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx("span", { className: "font-medium", children: "Total Backups:" }),
              /* @__PURE__ */ jsxRuntimeExports.jsx("span", { className: "ml-2", children: backups.length })
            ] }),
            /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx("span", { className: "font-medium", children: "Total Size:" }),
              /* @__PURE__ */ jsxRuntimeExports.jsx("span", { className: "ml-2", children: formatBytes(backups.reduce((sum, backup) => sum + backup.size, 0)) })
            ] }),
            /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx("span", { className: "font-medium", children: "Latest Backup:" }),
              /* @__PURE__ */ jsxRuntimeExports.jsx("span", { className: "ml-2", children: backups.length > 0 ? formatDate(backups[0].timestamp) : "None" })
            ] }),
            /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx("span", { className: "font-medium", children: "Backup Version:" }),
              /* @__PURE__ */ jsxRuntimeExports.jsx("span", { className: "ml-2", children: "1.0.0" })
            ] })
          ] }) })
        ] })
      ] })
    ] })
  ] }) });
};
export {
  BackupPage as default
};
//# sourceMappingURL=BackupPage-CXHb7I8y.js.map
