import { c as createLucideIcon, r as reactExports, j as jsxRuntimeExports, B as Button, d as Card, g as CardHeader, h as CardTitle, i as CardDescription, e as CardContent, C as Check, S as Shield, o as Lock, m as Link, A as ArrowRight } from "./index-D2CUDDtA.js";
import { B as Badge } from "./badge-CnK8C-4m.js";
import { T as Tabs, a as TabsList, b as TabsTrigger, c as TabsContent } from "./tabs-clwVusLv.js";
import { C as Code } from "./code-p0LkS3Wr.js";
import { K as Key } from "./key-Dx94WcYC.js";
import { B as BookOpen } from "./book-open-DBBPIN8r.js";
import { C as Copy } from "./copy-YVPGj6bk.js";
import { Z as Zap } from "./zap-B7w9_awj.js";
import { D as Database } from "./database-D_G6YwOX.js";
import { E as ExternalLink } from "./external-link-D_ERIYGV.js";
/**
 * @license lucide-react v0.462.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */
const Terminal = createLucideIcon("Terminal", [
  ["polyline", { points: "4 17 10 11 4 5", key: "akl6gq" }],
  ["line", { x1: "12", x2: "20", y1: "19", y2: "19", key: "q2wloq" }]
]);
const ApiPage = () => {
  const [copiedCode, setCopiedCode] = reactExports.useState(null);
  const copyToClipboard = (code, id) => {
    navigator.clipboard.writeText(code);
    setCopiedCode(id);
    setTimeout(() => setCopiedCode(null), 2e3);
  };
  const endpoints = [
    {
      method: "GET",
      path: "/api/v1/emails",
      description: "Retrieve all emails",
      auth: "Required",
      params: ["page", "limit", "status"]
    },
    {
      method: "POST",
      path: "/api/v1/emails",
      description: "Send a new email",
      auth: "Required",
      params: ["to", "subject", "body", "template_id"]
    },
    {
      method: "GET",
      path: "/api/v1/emails/{id}",
      description: "Get email details",
      auth: "Required",
      params: ["id"]
    },
    {
      method: "PUT",
      path: "/api/v1/emails/{id}",
      description: "Update email",
      auth: "Required",
      params: ["id", "subject", "body"]
    },
    {
      method: "DELETE",
      path: "/api/v1/emails/{id}",
      description: "Delete email",
      auth: "Required",
      params: ["id"]
    },
    {
      method: "GET",
      path: "/api/v1/templates",
      description: "List email templates",
      auth: "Required",
      params: ["category", "page", "limit"]
    },
    {
      method: "POST",
      path: "/api/v1/templates",
      description: "Create new template",
      auth: "Required",
      params: ["name", "subject", "body", "category"]
    },
    {
      method: "GET",
      path: "/api/v1/analytics",
      description: "Get email analytics",
      auth: "Required",
      params: ["start_date", "end_date", "metrics"]
    }
  ];
  const codeExamples = {
    authentication: `// Get your API key from the dashboard
const API_KEY = 'your_api_key_here';

// Include in headers
const headers = {
  'Authorization': 'Bearer ' + API_KEY,
  'Content-Type': 'application/json'
};`,
    sendEmail: `// Send a simple email
const response = await fetch('https://api.flashcore.com/v1/emails', {
  method: 'POST',
  headers: {
    'Authorization': 'Bearer ' + API_KEY,
    'Content-Type': 'application/json'
  },
  body: JSON.stringify({
    to: 'recipient@example.com',
    subject: 'Hello from FlashCore',
    body: '<h1>Welcome!</h1><p>This is a test email.</p>',
    template_id: 'welcome_template'
  })
});

const result = await response.json();
console.log(result);`,
    getEmails: `// Retrieve emails with pagination
const response = await fetch('https://api.flashcore.com/v1/emails?page=1&limit=10&status=sent', {
  headers: {
    'Authorization': 'Bearer ' + API_KEY
  }
});

const emails = await response.json();
console.log(emails.data);`,
    webhooks: `// Set up webhook endpoint
app.post('/webhook', (req, res) => {
  const { event, data } = req.body;
  
  switch(event) {
    case 'email.sent':
      console.log('Email sent:', data);
      break;
    case 'email.delivered':
      console.log('Email delivered:', data);
      break;
    case 'email.opened':
      console.log('Email opened:', data);
      break;
  }
  
  res.status(200).json({ received: true });
});`
  };
  const sdks = [
    {
      name: "JavaScript/Node.js",
      version: "v2.1.0",
      install: "npm install @flashcore/api",
      color: "from-yellow-500 to-orange-500"
    },
    {
      name: "Python",
      version: "v1.8.0",
      install: "pip install flashcore-api",
      color: "from-blue-500 to-purple-500"
    },
    {
      name: "PHP",
      version: "v1.5.0",
      install: "composer require flashcore/api",
      color: "from-purple-500 to-pink-500"
    },
    {
      name: "Ruby",
      version: "v1.3.0",
      install: "gem install flashcore-api",
      color: "from-red-500 to-pink-500"
    }
  ];
  return /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex flex-col", children: [
    /* @__PURE__ */ jsxRuntimeExports.jsx("section", { className: "container mx-auto px-4 py-12 md:py-20 text-center", children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "max-w-4xl mx-auto", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsxs(Badge, { variant: "secondary", className: "mb-4", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx(Code, { className: "w-3 h-3 mr-1" }),
        "API Documentation"
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsx("h1", { className: "text-3xl md:text-4xl lg:text-5xl font-bold mb-6 bg-gradient-to-r from-flashcore-purple to-flashcore-green bg-clip-text text-transparent", children: "API Reference" }),
      /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-lg md:text-xl text-muted-foreground mb-8 max-w-2xl mx-auto", children: "Integrate FlashCore into your applications with our powerful REST API. Send emails, manage templates, and track analytics programmatically." }),
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex flex-col sm:flex-row gap-4 justify-center", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsxs(Button, { size: "lg", className: "bg-gradient-to-r from-flashcore-purple to-flashcore-green", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx(Key, { className: "w-4 h-4 mr-2" }),
          "Get API Key"
        ] }),
        /* @__PURE__ */ jsxRuntimeExports.jsxs(Button, { size: "lg", variant: "outline", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx(BookOpen, { className: "w-4 h-4 mr-2" }),
          "View SDKs"
        ] })
      ] })
    ] }) }),
    /* @__PURE__ */ jsxRuntimeExports.jsx("section", { className: "container mx-auto px-4 py-12 md:py-20", children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "max-w-4xl mx-auto", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "text-center mb-12", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx("h2", { className: "text-2xl md:text-3xl font-bold mb-4", children: "Quick Start" }),
        /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-muted-foreground", children: "Get up and running with FlashCore API in minutes." })
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsxs(Tabs, { defaultValue: "authentication", className: "w-full", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsxs(TabsList, { className: "grid w-full grid-cols-4", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx(TabsTrigger, { value: "authentication", children: "Authentication" }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(TabsTrigger, { value: "send-email", children: "Send Email" }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(TabsTrigger, { value: "get-emails", children: "Get Emails" }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(TabsTrigger, { value: "webhooks", children: "Webhooks" })
        ] }),
        /* @__PURE__ */ jsxRuntimeExports.jsx(TabsContent, { value: "authentication", className: "mt-6", children: /* @__PURE__ */ jsxRuntimeExports.jsxs(Card, { children: [
          /* @__PURE__ */ jsxRuntimeExports.jsxs(CardHeader, { children: [
            /* @__PURE__ */ jsxRuntimeExports.jsxs(CardTitle, { className: "flex items-center", children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx(Key, { className: "w-5 h-5 mr-2" }),
              "API Authentication"
            ] }),
            /* @__PURE__ */ jsxRuntimeExports.jsx(CardDescription, { children: "All API requests require authentication using your API key." })
          ] }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(CardContent, { children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "relative", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx("pre", { className: "bg-muted p-4 rounded-lg overflow-x-auto", children: /* @__PURE__ */ jsxRuntimeExports.jsx("code", { className: "text-sm", children: codeExamples.authentication }) }),
            /* @__PURE__ */ jsxRuntimeExports.jsx(
              Button,
              {
                size: "sm",
                variant: "outline",
                className: "absolute top-2 right-2",
                onClick: () => copyToClipboard(codeExamples.authentication, "auth"),
                children: copiedCode === "auth" ? /* @__PURE__ */ jsxRuntimeExports.jsx(Check, { className: "w-4 h-4" }) : /* @__PURE__ */ jsxRuntimeExports.jsx(Copy, { className: "w-4 h-4" })
              }
            )
          ] }) })
        ] }) }),
        /* @__PURE__ */ jsxRuntimeExports.jsx(TabsContent, { value: "send-email", className: "mt-6", children: /* @__PURE__ */ jsxRuntimeExports.jsxs(Card, { children: [
          /* @__PURE__ */ jsxRuntimeExports.jsxs(CardHeader, { children: [
            /* @__PURE__ */ jsxRuntimeExports.jsxs(CardTitle, { className: "flex items-center", children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx(Zap, { className: "w-5 h-5 mr-2" }),
              "Send an Email"
            ] }),
            /* @__PURE__ */ jsxRuntimeExports.jsx(CardDescription, { children: "Send emails using the API with support for templates and custom content." })
          ] }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(CardContent, { children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "relative", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx("pre", { className: "bg-muted p-4 rounded-lg overflow-x-auto", children: /* @__PURE__ */ jsxRuntimeExports.jsx("code", { className: "text-sm", children: codeExamples.sendEmail }) }),
            /* @__PURE__ */ jsxRuntimeExports.jsx(
              Button,
              {
                size: "sm",
                variant: "outline",
                className: "absolute top-2 right-2",
                onClick: () => copyToClipboard(codeExamples.sendEmail, "send"),
                children: copiedCode === "send" ? /* @__PURE__ */ jsxRuntimeExports.jsx(Check, { className: "w-4 h-4" }) : /* @__PURE__ */ jsxRuntimeExports.jsx(Copy, { className: "w-4 h-4" })
              }
            )
          ] }) })
        ] }) }),
        /* @__PURE__ */ jsxRuntimeExports.jsx(TabsContent, { value: "get-emails", className: "mt-6", children: /* @__PURE__ */ jsxRuntimeExports.jsxs(Card, { children: [
          /* @__PURE__ */ jsxRuntimeExports.jsxs(CardHeader, { children: [
            /* @__PURE__ */ jsxRuntimeExports.jsxs(CardTitle, { className: "flex items-center", children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx(Database, { className: "w-5 h-5 mr-2" }),
              "Retrieve Emails"
            ] }),
            /* @__PURE__ */ jsxRuntimeExports.jsx(CardDescription, { children: "Fetch emails with pagination and filtering options." })
          ] }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(CardContent, { children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "relative", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx("pre", { className: "bg-muted p-4 rounded-lg overflow-x-auto", children: /* @__PURE__ */ jsxRuntimeExports.jsx("code", { className: "text-sm", children: codeExamples.getEmails }) }),
            /* @__PURE__ */ jsxRuntimeExports.jsx(
              Button,
              {
                size: "sm",
                variant: "outline",
                className: "absolute top-2 right-2",
                onClick: () => copyToClipboard(codeExamples.getEmails, "get"),
                children: copiedCode === "get" ? /* @__PURE__ */ jsxRuntimeExports.jsx(Check, { className: "w-4 h-4" }) : /* @__PURE__ */ jsxRuntimeExports.jsx(Copy, { className: "w-4 h-4" })
              }
            )
          ] }) })
        ] }) }),
        /* @__PURE__ */ jsxRuntimeExports.jsx(TabsContent, { value: "webhooks", className: "mt-6", children: /* @__PURE__ */ jsxRuntimeExports.jsxs(Card, { children: [
          /* @__PURE__ */ jsxRuntimeExports.jsxs(CardHeader, { children: [
            /* @__PURE__ */ jsxRuntimeExports.jsxs(CardTitle, { className: "flex items-center", children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx(Shield, { className: "w-5 h-5 mr-2" }),
              "Webhooks"
            ] }),
            /* @__PURE__ */ jsxRuntimeExports.jsx(CardDescription, { children: "Receive real-time notifications about email events." })
          ] }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(CardContent, { children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "relative", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx("pre", { className: "bg-muted p-4 rounded-lg overflow-x-auto", children: /* @__PURE__ */ jsxRuntimeExports.jsx("code", { className: "text-sm", children: codeExamples.webhooks }) }),
            /* @__PURE__ */ jsxRuntimeExports.jsx(
              Button,
              {
                size: "sm",
                variant: "outline",
                className: "absolute top-2 right-2",
                onClick: () => copyToClipboard(codeExamples.webhooks, "webhook"),
                children: copiedCode === "webhook" ? /* @__PURE__ */ jsxRuntimeExports.jsx(Check, { className: "w-4 h-4" }) : /* @__PURE__ */ jsxRuntimeExports.jsx(Copy, { className: "w-4 h-4" })
              }
            )
          ] }) })
        ] }) })
      ] })
    ] }) }),
    /* @__PURE__ */ jsxRuntimeExports.jsx("section", { className: "container mx-auto px-4 py-12 md:py-20 bg-muted/20", children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "max-w-6xl mx-auto", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "text-center mb-12", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx("h2", { className: "text-2xl md:text-3xl font-bold mb-4", children: "Official SDKs" }),
        /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-muted-foreground", children: "Use our official SDKs for faster integration and better developer experience." })
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6", children: sdks.map((sdk) => /* @__PURE__ */ jsxRuntimeExports.jsxs(Card, { className: "hover:shadow-lg transition-shadow", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsxs(CardHeader, { children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: `w-12 h-12 bg-gradient-to-r ${sdk.color} rounded-lg flex items-center justify-center mb-4`, children: /* @__PURE__ */ jsxRuntimeExports.jsx(Terminal, { className: "w-6 h-6 text-white" }) }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(CardTitle, { className: "text-lg", children: sdk.name }),
          /* @__PURE__ */ jsxRuntimeExports.jsxs(CardDescription, { children: [
            "Version ",
            sdk.version
          ] })
        ] }),
        /* @__PURE__ */ jsxRuntimeExports.jsx(CardContent, { children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "space-y-3", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "relative", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx("pre", { className: "bg-background p-3 rounded text-xs overflow-x-auto", children: /* @__PURE__ */ jsxRuntimeExports.jsx("code", { children: sdk.install }) }),
            /* @__PURE__ */ jsxRuntimeExports.jsx(
              Button,
              {
                size: "sm",
                variant: "outline",
                className: "absolute top-1 right-1 h-6 w-6 p-0",
                onClick: () => copyToClipboard(sdk.install, sdk.name),
                children: copiedCode === sdk.name ? /* @__PURE__ */ jsxRuntimeExports.jsx(Check, { className: "w-3 h-3" }) : /* @__PURE__ */ jsxRuntimeExports.jsx(Copy, { className: "w-3 h-3" })
              }
            )
          ] }),
          /* @__PURE__ */ jsxRuntimeExports.jsxs(Button, { variant: "outline", size: "sm", className: "w-full", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx(ExternalLink, { className: "w-4 h-4 mr-2" }),
            "Documentation"
          ] })
        ] }) })
      ] }, sdk.name)) })
    ] }) }),
    /* @__PURE__ */ jsxRuntimeExports.jsx("section", { className: "container mx-auto px-4 py-12 md:py-20", children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "max-w-6xl mx-auto", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "text-center mb-12", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx("h2", { className: "text-2xl md:text-3xl font-bold mb-4", children: "API Endpoints" }),
        /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-muted-foreground", children: "Complete reference of all available API endpoints." })
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "space-y-4", children: endpoints.map((endpoint, index) => /* @__PURE__ */ jsxRuntimeExports.jsx(Card, { className: "hover:shadow-md transition-shadow", children: /* @__PURE__ */ jsxRuntimeExports.jsxs(CardContent, { className: "p-6", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex flex-col md:flex-row md:items-center justify-between gap-4", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center gap-4", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx(
              Badge,
              {
                variant: endpoint.method === "GET" ? "default" : endpoint.method === "POST" ? "secondary" : endpoint.method === "PUT" ? "outline" : "destructive",
                className: "w-16 text-center",
                children: endpoint.method
              }
            ),
            /* @__PURE__ */ jsxRuntimeExports.jsx("div", { children: /* @__PURE__ */ jsxRuntimeExports.jsx("code", { className: "text-sm md:text-base font-mono bg-muted px-2 py-1 rounded", children: endpoint.path }) })
          ] }),
          /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center gap-4", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "text-sm text-muted-foreground", children: endpoint.description }),
            /* @__PURE__ */ jsxRuntimeExports.jsx(Badge, { variant: "outline", className: "text-xs", children: endpoint.auth })
          ] })
        ] }),
        endpoint.params.length > 0 && /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "mt-4 pt-4 border-t", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "text-sm text-muted-foreground mb-2", children: "Parameters:" }),
          /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "flex flex-wrap gap-2", children: endpoint.params.map((param) => /* @__PURE__ */ jsxRuntimeExports.jsx(Badge, { variant: "secondary", className: "text-xs", children: param }, param)) })
        ] })
      ] }) }, index)) })
    ] }) }),
    /* @__PURE__ */ jsxRuntimeExports.jsx("section", { className: "container mx-auto px-4 py-12 md:py-20 bg-muted/20", children: /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "max-w-4xl mx-auto", children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "grid grid-cols-1 lg:grid-cols-2 gap-8 md:gap-12", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx("h2", { className: "text-2xl md:text-3xl font-bold mb-4 md:mb-6", children: "Rate Limits" }),
        /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-base md:text-lg text-muted-foreground mb-4 md:mb-6", children: "We implement rate limiting to ensure fair usage and system stability." }),
        /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "space-y-4", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center justify-between p-4 bg-background rounded-lg", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx("span", { className: "font-medium", children: "Free Plan" }),
            /* @__PURE__ */ jsxRuntimeExports.jsx("span", { className: "text-sm text-muted-foreground", children: "1,000 requests/hour" })
          ] }),
          /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center justify-between p-4 bg-background rounded-lg", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx("span", { className: "font-medium", children: "Pro Plan" }),
            /* @__PURE__ */ jsxRuntimeExports.jsx("span", { className: "text-sm text-muted-foreground", children: "10,000 requests/hour" })
          ] }),
          /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center justify-between p-4 bg-background rounded-lg", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx("span", { className: "font-medium", children: "Enterprise" }),
            /* @__PURE__ */ jsxRuntimeExports.jsx("span", { className: "text-sm text-muted-foreground", children: "100,000 requests/hour" })
          ] })
        ] })
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx("h2", { className: "text-2xl md:text-3xl font-bold mb-4 md:mb-6", children: "Security" }),
        /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-base md:text-lg text-muted-foreground mb-4 md:mb-6", children: "Your data security is our top priority. All API communications are encrypted and secure." }),
        /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "space-y-4", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx(Lock, { className: "w-5 h-5 text-green-500 mr-3" }),
            /* @__PURE__ */ jsxRuntimeExports.jsx("span", { className: "text-sm md:text-base", children: "HTTPS encryption for all requests" })
          ] }),
          /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx(Shield, { className: "w-5 h-5 text-green-500 mr-3" }),
            /* @__PURE__ */ jsxRuntimeExports.jsx("span", { className: "text-sm md:text-base", children: "API keys are encrypted and secure" })
          ] }),
          /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx(Check, { className: "w-5 h-5 text-green-500 mr-3" }),
            /* @__PURE__ */ jsxRuntimeExports.jsx("span", { className: "text-sm md:text-base", children: "SOC 2 Type II compliance" })
          ] }),
          /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx(Database, { className: "w-5 h-5 text-green-500 mr-3" }),
            /* @__PURE__ */ jsxRuntimeExports.jsx("span", { className: "text-sm md:text-base", children: "GDPR compliant data handling" })
          ] })
        ] })
      ] })
    ] }) }) }),
    /* @__PURE__ */ jsxRuntimeExports.jsx("section", { className: "container mx-auto px-4 py-12 md:py-20", children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "bg-gradient-to-r from-flashcore-purple to-flashcore-green rounded-2xl p-6 md:p-8 lg:p-12 text-center text-white", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsx("h2", { className: "text-2xl md:text-3xl font-bold mb-4", children: "Ready to Get Started?" }),
      /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-lg md:text-xl mb-6 md:mb-8 opacity-90", children: "Start building with FlashCore API today and transform your email automation." }),
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex flex-col sm:flex-row gap-4 justify-center", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx(Link, { to: "/register", children: /* @__PURE__ */ jsxRuntimeExports.jsxs(Button, { size: "lg", variant: "secondary", className: "bg-white text-flashcore-purple hover:bg-gray-100", children: [
          "Get API Key",
          /* @__PURE__ */ jsxRuntimeExports.jsx(ArrowRight, { className: "w-4 h-4 ml-2" })
        ] }) }),
        /* @__PURE__ */ jsxRuntimeExports.jsx(Link, { to: "/contact", children: /* @__PURE__ */ jsxRuntimeExports.jsx(Button, { size: "lg", variant: "outline", className: "border-white text-white hover:bg-white hover:text-flashcore-purple", children: "Contact Support" }) })
      ] })
    ] }) })
  ] });
};
export {
  ApiPage as default
};
//# sourceMappingURL=ApiPage-ZdtEGvcl.js.map
