import { r as reactExports, u as useToast, j as jsxRuntimeExports, B as Button, d as Card, g as CardHeader, h as CardTitle, e as CardContent, I as Input, a as apiService } from "./index-Jllr8cp4.js";
import { A as AdminLayout } from "./AdminLayout-Nvzb_sDg.js";
import { T as Textarea } from "./textarea-6zwxPSQN.js";
import { D as Dialog, a as DialogContent, b as DialogHeader, c as DialogTitle } from "./dialog-CnCi7ZHh.js";
import { L as Label } from "./label-CufxHMmh.js";
import { S as Switch, a as Save } from "./switch-DZljC9az.js";
import { P as Plus } from "./plus-CTFc3oFU.js";
import { S as SquarePen } from "./square-pen-DWhnpd-V.js";
import { T as Trash2 } from "./trash-2-DcCAForZ.js";
import "./search-Dez-rO7p.js";
import "./log-out-DHIDgsyx.js";
import "./key-B1j9dYIT.js";
import "./users-CHFclgGF.js";
import "./mail-J5LXSCDJ.js";
import "./credit-card-Dhy07o36.js";
import "./dollar-sign-BfS9uGDY.js";
import "./settings-CDdGlwbq.js";
import "./index-De08y5kx.js";
const AdminPricingPage = () => {
  const [plans, setPlans] = reactExports.useState([]);
  const [loading, setLoading] = reactExports.useState(true);
  const [isDialogOpen, setIsDialogOpen] = reactExports.useState(false);
  const [currentPlan, setCurrentPlan] = reactExports.useState(null);
  const { toast } = useToast();
  const defaultPlan = {
    name: "",
    price: "",
    description: "",
    features: [],
    notIncluded: [],
    popular: false,
    color: "from-flashcore-purple to-flashcore-green",
    buttonText: "Get Started",
    order_index: 0
  };
  const fetchPlans = async () => {
    try {
      const response = await apiService.getPricingPlans();
      if (response.data) {
        setPlans(response.data);
      }
    } catch (error) {
      console.error(error);
      toast({ title: "Error", description: "Failed to load pricing plans", variant: "destructive" });
    } finally {
      setLoading(false);
    }
  };
  reactExports.useEffect(() => {
    fetchPlans();
  }, []);
  const handleSave = async (e) => {
    var _a;
    e.preventDefault();
    if (!currentPlan) return;
    try {
      const action = currentPlan.id ? "update" : "create";
      const response = await apiService.adminManagePricing(action, currentPlan);
      if ((_a = response.data) == null ? void 0 : _a.success) {
        toast({ title: "Success", description: response.data.message });
        setIsDialogOpen(false);
        fetchPlans();
      } else {
        toast({ title: "Error", description: response.error || "Operation failed", variant: "destructive" });
      }
    } catch (error) {
      toast({ title: "Error", description: "An unexpected error occurred", variant: "destructive" });
    }
  };
  const handleDelete = async (id) => {
    var _a;
    if (!confirm("Are you sure you want to delete this plan?")) return;
    try {
      const response = await apiService.adminManagePricing("delete", { id });
      if ((_a = response.data) == null ? void 0 : _a.success) {
        toast({ title: "Success", description: "Plan deleted" });
        fetchPlans();
      }
    } catch (error) {
      toast({ title: "Error", description: "Failed to delete plan", variant: "destructive" });
    }
  };
  const handleFeatureChange = (value, type) => {
    if (currentPlan) {
      setCurrentPlan({
        ...currentPlan,
        [type]: value.split("\n").filter((line) => line.trim() !== "")
      });
    }
  };
  return /* @__PURE__ */ jsxRuntimeExports.jsxs(AdminLayout, { children: [
    /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex justify-between items-center mb-6", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsx("h1", { className: "text-3xl font-bold", children: "Pricing Plans Management" }),
      /* @__PURE__ */ jsxRuntimeExports.jsxs(Button, { onClick: () => {
        setCurrentPlan(defaultPlan);
        setIsDialogOpen(true);
      }, children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx(Plus, { className: "w-4 h-4 mr-2" }),
        " Add New Plan"
      ] })
    ] }),
    /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6", children: loading ? /* @__PURE__ */ jsxRuntimeExports.jsx("p", { children: "Loading..." }) : plans.map((plan) => /* @__PURE__ */ jsxRuntimeExports.jsxs(Card, { className: "relative", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsxs(CardHeader, { children: [
        /* @__PURE__ */ jsxRuntimeExports.jsxs(CardTitle, { className: "flex justify-between items-center", children: [
          plan.name,
          /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex gap-2", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx(Button, { variant: "ghost", size: "sm", onClick: () => {
              setCurrentPlan(plan);
              setIsDialogOpen(true);
            }, children: /* @__PURE__ */ jsxRuntimeExports.jsx(SquarePen, { className: "w-4 h-4 text-blue-500" }) }),
            /* @__PURE__ */ jsxRuntimeExports.jsx(Button, { variant: "ghost", size: "sm", onClick: () => plan.id && handleDelete(plan.id), children: /* @__PURE__ */ jsxRuntimeExports.jsx(Trash2, { className: "w-4 h-4 text-red-500" }) })
          ] })
        ] }),
        /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-2xl font-bold", children: plan.price })
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsxs(CardContent, { children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-sm text-gray-500 mb-4", children: plan.description }),
        /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "space-y-2", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "font-semibold", children: "Features:" }),
          /* @__PURE__ */ jsxRuntimeExports.jsxs("ul", { className: "list-disc list-inside text-sm", children: [
            plan.features.slice(0, 3).map((f, i) => /* @__PURE__ */ jsxRuntimeExports.jsx("li", { children: f }, i)),
            plan.features.length > 3 && /* @__PURE__ */ jsxRuntimeExports.jsx("li", { children: "...and more" })
          ] })
        ] })
      ] })
    ] }, plan.id)) }),
    /* @__PURE__ */ jsxRuntimeExports.jsx(Dialog, { open: isDialogOpen, onOpenChange: setIsDialogOpen, children: /* @__PURE__ */ jsxRuntimeExports.jsxs(DialogContent, { className: "max-w-2xl max-h-[90vh] overflow-y-auto", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsx(DialogHeader, { children: /* @__PURE__ */ jsxRuntimeExports.jsx(DialogTitle, { children: (currentPlan == null ? void 0 : currentPlan.id) ? "Edit Plan" : "Create New Plan" }) }),
      currentPlan && /* @__PURE__ */ jsxRuntimeExports.jsxs("form", { onSubmit: handleSave, className: "space-y-4", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "grid grid-cols-2 gap-4", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx(Label, { children: "Plan Name" }),
            /* @__PURE__ */ jsxRuntimeExports.jsx(
              Input,
              {
                value: currentPlan.name,
                onChange: (e) => setCurrentPlan({ ...currentPlan, name: e.target.value }),
                required: true
              }
            )
          ] }),
          /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx(Label, { children: "Price (e.g. $9.99)" }),
            /* @__PURE__ */ jsxRuntimeExports.jsx(
              Input,
              {
                value: currentPlan.price,
                onChange: (e) => setCurrentPlan({ ...currentPlan, price: e.target.value }),
                required: true
              }
            )
          ] })
        ] }),
        /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx(Label, { children: "Description" }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(
            Input,
            {
              value: currentPlan.description,
              onChange: (e) => setCurrentPlan({ ...currentPlan, description: e.target.value })
            }
          )
        ] }),
        /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "grid grid-cols-2 gap-4", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx(Label, { children: "Features (One per line)" }),
            /* @__PURE__ */ jsxRuntimeExports.jsx(
              Textarea,
              {
                value: currentPlan.features.join("\n"),
                onChange: (e) => handleFeatureChange(e.target.value, "features"),
                rows: 5
              }
            )
          ] }),
          /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx(Label, { children: "Not Included (One per line)" }),
            /* @__PURE__ */ jsxRuntimeExports.jsx(
              Textarea,
              {
                value: currentPlan.notIncluded.join("\n"),
                onChange: (e) => handleFeatureChange(e.target.value, "notIncluded"),
                rows: 5
              }
            )
          ] })
        ] }),
        /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "grid grid-cols-2 gap-4", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx(Label, { children: "Button Text" }),
            /* @__PURE__ */ jsxRuntimeExports.jsx(
              Input,
              {
                value: currentPlan.buttonText,
                onChange: (e) => setCurrentPlan({ ...currentPlan, buttonText: e.target.value })
              }
            )
          ] }),
          /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx(Label, { children: "Gradient Class" }),
            /* @__PURE__ */ jsxRuntimeExports.jsx(
              Input,
              {
                value: currentPlan.color,
                onChange: (e) => setCurrentPlan({ ...currentPlan, color: e.target.value }),
                placeholder: "from-blue-500 to-green-500"
              }
            )
          ] })
        ] }),
        /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center space-x-2", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx(
            Switch,
            {
              checked: currentPlan.popular,
              onCheckedChange: (c) => setCurrentPlan({ ...currentPlan, popular: c })
            }
          ),
          /* @__PURE__ */ jsxRuntimeExports.jsx(Label, { children: "Mark as Popular / Recommended" })
        ] }),
        /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center space-x-2", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx(Label, { children: "Order Index " }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(
            Input,
            {
              type: "number",
              value: currentPlan.order_index,
              onChange: (e) => setCurrentPlan({ ...currentPlan, order_index: parseInt(e.target.value) || 0 })
            }
          )
        ] }),
        /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex justify-end gap-2 pt-4", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx(Button, { type: "button", variant: "outline", onClick: () => setIsDialogOpen(false), children: "Cancel" }),
          /* @__PURE__ */ jsxRuntimeExports.jsxs(Button, { type: "submit", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx(Save, { className: "w-4 h-4 mr-2" }),
            " Save Plan"
          ] })
        ] })
      ] })
    ] }) })
  ] });
};
export {
  AdminPricingPage as default
};
//# sourceMappingURL=AdminPricingPage-CjasVj8z.js.map
