import { c as createLucideIcon, r as reactExports, l as useNavigate, u as useToast, b as useAuthPhp, j as jsxRuntimeExports, m as Link, n as Logo, d as Card, g as CardHeader, S as Shield, h as CardTitle, e as CardContent, I as Input, o as Lock, B as Button, A as ArrowRight, p as CardFooter } from "./index-lF0PjX8A.js";
import { L as Label } from "./label-DlbB9OQ3.js";
import { S as Sparkles } from "./sparkles-CI8wD0yV.js";
import { M as Mail } from "./mail-CiX6a04S.js";
import { E as EyeOff } from "./eye-off-Dp5Xm-V_.js";
import { E as Eye } from "./eye-9xkahhb0.js";
import { L as LogIn } from "./log-in-BR4wvwhC.js";
import { U as User } from "./user-Dn054T1A.js";
/**
 * @license lucide-react v0.462.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */
const OctagonAlert = createLucideIcon("OctagonAlert", [
  ["path", { d: "M12 16h.01", key: "1drbdi" }],
  ["path", { d: "M12 8v4", key: "1got3b" }],
  [
    "path",
    {
      d: "M15.312 2a2 2 0 0 1 1.414.586l4.688 4.688A2 2 0 0 1 22 8.688v6.624a2 2 0 0 1-.586 1.414l-4.688 4.688a2 2 0 0 1-1.414.586H8.688a2 2 0 0 1-1.414-.586l-4.688-4.688A2 2 0 0 1 2 15.312V8.688a2 2 0 0 1 .586-1.414l4.688-4.688A2 2 0 0 1 8.688 2z",
      key: "1fd625"
    }
  ]
]);
/**
 * @license lucide-react v0.462.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */
const ShieldCheck = createLucideIcon("ShieldCheck", [
  [
    "path",
    {
      d: "M20 13c0 5-3.5 7.5-7.66 8.95a1 1 0 0 1-.67-.01C7.5 20.5 4 18 4 13V6a1 1 0 0 1 1-1c2 0 4.5-1.2 6.24-2.72a1.17 1.17 0 0 1 1.52 0C14.51 3.81 17 5 19 5a1 1 0 0 1 1 1z",
      key: "oel41y"
    }
  ],
  ["path", { d: "m9 12 2 2 4-4", key: "dzmm74" }]
]);
const tips = [
  "Secure your account with a strong password",
  "Enable two-factor authentication for extra security",
  "Never share your admin credentials",
  "Monitor login activity regularly",
  "Keep your browser up to date"
];
const AdminLoginPage = () => {
  const [email, setEmail] = reactExports.useState("");
  const [password, setPassword] = reactExports.useState("");
  const [showPassword, setShowPassword] = reactExports.useState(false);
  const [loading, setLoading] = reactExports.useState(false);
  const [tipIndex, setTipIndex] = reactExports.useState(0);
  const navigate = useNavigate();
  const { toast } = useToast();
  const { login } = useAuthPhp();
  reactExports.useEffect(() => {
    const interval = setInterval(() => {
      setTipIndex((prev) => (prev + 1) % tips.length);
    }, 4e3);
    return () => clearInterval(interval);
  }, []);
  const handleSubmit = async (e) => {
    e.preventDefault();
    setLoading(true);
    try {
      const response = await login(email, password);
      if (!response.success) {
        toast({
          title: "Login Error",
          description: response.error,
          variant: "destructive"
        });
        return;
      }
      const userProfile = localStorage.getItem("authProfile");
      const profile = userProfile ? JSON.parse(userProfile) : null;
      const isAdmin = (profile == null ? void 0 : profile.role) === "admin";
      if (!isAdmin) {
        toast({
          title: "Access Denied",
          description: "This login is restricted to administrators only.",
          variant: "destructive"
        });
        return;
      }
      toast({
        title: "Admin Access Granted",
        description: "Welcome, Administrator."
      });
      navigate("/admin");
    } catch (error) {
      toast({
        title: "Login Error",
        description: "An unexpected error occurred during login.",
        variant: "destructive"
      });
    } finally {
      setLoading(false);
    }
  };
  return /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "min-h-screen flex overflow-hidden bg-background", children: [
    /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "hidden lg:flex lg:w-1/2 relative bg-gradient-to-br from-zinc-900 via-zinc-800 to-black p-12 flex-col justify-between overflow-hidden", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "absolute inset-0 opacity-20 pointer-events-none", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "absolute inset-0", style: {
          backgroundImage: "radial-gradient(circle at 2px 2px, rgba(161, 107, 247, 0.15) 1px, transparent 0)",
          backgroundSize: "40px 40px"
        } }),
        /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "absolute top-0 left-0 w-full h-full bg-gradient-to-b from-transparent via-flashcore-purple/5 to-transparent animate-pulse-glow", style: { animationDuration: "8s" } })
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "relative z-10", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsxs(Link, { to: "/", className: "flex items-center gap-3 group", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx(Logo, { className: "w-16 h-16 drop-shadow-2xl transition-transform group-hover:scale-110 duration-300" }),
          /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex flex-col", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx("h1", { className: "text-4xl font-bold text-white drop-shadow-lg leading-tight uppercase tracking-tighter", children: "FLASHCORE" }),
            /* @__PURE__ */ jsxRuntimeExports.jsx("span", { className: "text-flashcore-purple font-bold tracking-[0.2em] text-xs -mt-1 ml-1 opacity-80 uppercase", children: "Admin Console" })
          ] })
        ] }),
        /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-zinc-400 text-lg mt-8 max-w-md leading-relaxed", children: "Restricted access portal for system administrators and security officers. All activity is logged and monitored." })
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "relative z-10 space-y-6", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "bg-flashcore-purple/10 backdrop-blur-md border border-flashcore-purple/20 rounded-2xl p-6 transition-all duration-500 hover:bg-flashcore-purple/15", children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-start gap-4", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "bg-flashcore-purple/20 p-3 rounded-xl", children: /* @__PURE__ */ jsxRuntimeExports.jsx(ShieldCheck, { className: "w-6 h-6 text-flashcore-purple" }) }),
          /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex-1", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx("h3", { className: "text-white font-semibold text-lg mb-2", children: "Security Advisory" }),
            /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-zinc-400 text-sm leading-relaxed transition-opacity duration-500", children: tips[tipIndex] })
          ] })
        ] }) }),
        /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center gap-4 bg-red-950/20 border border-red-900/30 rounded-xl p-4", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx(OctagonAlert, { className: "w-6 h-6 text-red-500 flex-shrink-0" }),
          /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-red-200/70 text-xs font-mono", children: "SECURE_ENV: PROD_GATEWAY_ACTIVE" })
        ] })
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "relative z-10 flex items-center gap-6 text-xs text-zinc-500 font-mono", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx("span", { children: "© 2024 FLASHCORE SYSTEMS" }),
        /* @__PURE__ */ jsxRuntimeExports.jsx("span", { className: "h-1 w-1 bg-zinc-700 rounded-full" }),
        /* @__PURE__ */ jsxRuntimeExports.jsx("span", { children: "V 2.4.0 ENCRYPTION ACTIVE" })
      ] })
    ] }),
    /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex-1 flex items-center justify-center p-4 lg:p-12 relative", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "absolute inset-0 bg-secondary/30 pointer-events-none" }),
      /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "absolute top-6 left-6 lg:hidden", children: /* @__PURE__ */ jsxRuntimeExports.jsxs(Link, { to: "/", className: "flex items-center gap-2", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx(Logo, { className: "w-10 h-10" }),
        /* @__PURE__ */ jsxRuntimeExports.jsxs("h1", { className: "text-xl font-bold tracking-tight text-foreground", children: [
          "FLASHCORE ",
          /* @__PURE__ */ jsxRuntimeExports.jsx("span", { className: "text-flashcore-purple", children: "ADMIN" })
        ] })
      ] }) }),
      /* @__PURE__ */ jsxRuntimeExports.jsxs(Card, { className: "w-full max-w-md border border-border/50 shadow-2xl bg-card/80 backdrop-blur-md", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsxs(CardHeader, { className: "space-y-4 pb-8 border-b border-border/10 mb-6", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "flex items-center justify-center", children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "bg-zinc-900 border border-flashcore-purple/30 p-4 rounded-full shadow-inner relative group", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "absolute inset-0 bg-flashcore-purple/20 blur-xl rounded-full opacity-0 group-hover:opacity-100 transition-opacity" }),
            /* @__PURE__ */ jsxRuntimeExports.jsx(Shield, { className: "w-8 h-8 text-flashcore-purple relative z-10" })
          ] }) }),
          /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "space-y-1 text-center", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx(CardTitle, { className: "text-3xl font-bold", children: "Admin Portal" }),
            /* @__PURE__ */ jsxRuntimeExports.jsxs("p", { className: "text-muted-foreground text-sm uppercase tracking-widest font-semibold flex items-center justify-center gap-2", children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx(Sparkles, { className: "w-3 h-3 text-flashcore-green" }),
              "Auth Required",
              /* @__PURE__ */ jsxRuntimeExports.jsx(Sparkles, { className: "w-3 h-3 text-flashcore-green" })
            ] })
          ] })
        ] }),
        /* @__PURE__ */ jsxRuntimeExports.jsx(CardContent, { className: "space-y-6 pt-0", children: /* @__PURE__ */ jsxRuntimeExports.jsxs("form", { onSubmit: handleSubmit, className: "space-y-5", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "space-y-2", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx(Label, { htmlFor: "admin-email", className: "text-sm font-semibold text-zinc-400", children: "ADMIN IDENTIFIER" }),
            /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "relative group", children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx(Mail, { className: "absolute left-3 top-1/2 -translate-y-1/2 w-4 h-4 text-muted-foreground group-focus-within:text-flashcore-purple transition-colors" }),
              /* @__PURE__ */ jsxRuntimeExports.jsx(
                Input,
                {
                  id: "admin-email",
                  type: "email",
                  placeholder: "admin@flashcore.io",
                  required: true,
                  value: email,
                  onChange: (e) => setEmail(e.target.value),
                  autoFocus: true,
                  autoComplete: "username",
                  className: "pl-10 h-12 bg-background/50 border-border/50 focus:border-flashcore-purple focus:ring-flashcore-purple/10 transition-all font-mono text-sm"
                }
              )
            ] })
          ] }),
          /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "space-y-2", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx(Label, { htmlFor: "admin-password", className: "text-sm font-semibold text-zinc-400", children: "SECURITY KEY" }),
            /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "relative group", children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx(Lock, { className: "absolute left-3 top-1/2 -translate-y-1/2 w-4 h-4 text-muted-foreground group-focus-within:text-flashcore-purple transition-colors" }),
              /* @__PURE__ */ jsxRuntimeExports.jsx(
                Input,
                {
                  id: "admin-password",
                  type: showPassword ? "text" : "password",
                  placeholder: "••••••••",
                  required: true,
                  value: password,
                  onChange: (e) => setPassword(e.target.value),
                  autoComplete: "current-password",
                  className: "pl-10 pr-12 h-12 bg-background/50 border-border/50 focus:border-flashcore-purple focus:ring-flashcore-purple/10 transition-all font-mono text-sm"
                }
              ),
              /* @__PURE__ */ jsxRuntimeExports.jsx(
                "button",
                {
                  type: "button",
                  tabIndex: -1,
                  className: "absolute right-3 top-1/2 -translate-y-1/2 text-muted-foreground hover:text-flashcore-purple transition-colors p-1",
                  onClick: () => setShowPassword((v) => !v),
                  children: showPassword ? /* @__PURE__ */ jsxRuntimeExports.jsx(EyeOff, { className: "w-4 h-4" }) : /* @__PURE__ */ jsxRuntimeExports.jsx(Eye, { className: "w-4 h-4" })
                }
              )
            ] })
          ] }),
          /* @__PURE__ */ jsxRuntimeExports.jsxs(
            Button,
            {
              type: "submit",
              className: "w-full h-12 bg-zinc-900 border border-flashcore-purple/50 text-white hover:bg-flashcore-purple hover:text-white transition-all duration-500 shadow-[0_0_15px_rgba(161,107,247,0.1)] group overflow-hidden relative font-bold tracking-widest",
              disabled: loading,
              children: [
                /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "absolute inset-0 bg-flashcore-purple translate-y-full group-hover:translate-y-0 transition-transform duration-300 -z-10" }),
                loading ? /* @__PURE__ */ jsxRuntimeExports.jsxs("span", { className: "flex items-center gap-2", children: [
                  /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "w-4 h-4 border-2 border-white/30 border-t-white rounded-full animate-spin" }),
                  "AUTHORIZING..."
                ] }) : /* @__PURE__ */ jsxRuntimeExports.jsxs("span", { className: "flex items-center justify-center gap-2", children: [
                  /* @__PURE__ */ jsxRuntimeExports.jsx(LogIn, { className: "w-4 h-4" }),
                  "ACCESS CONSOLE",
                  /* @__PURE__ */ jsxRuntimeExports.jsx(ArrowRight, { className: "w-4 h-4 group-hover:translate-x-1 transition-transform" })
                ] })
              ]
            }
          )
        ] }) }),
        /* @__PURE__ */ jsxRuntimeExports.jsxs(CardFooter, { className: "flex flex-col gap-4 border-t border-border/10 pt-6", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-xs text-center text-muted-foreground uppercase tracking-wider", children: "System access restricted to authorized personnel." }),
          /* @__PURE__ */ jsxRuntimeExports.jsxs(
            Link,
            {
              to: "/login",
              className: "text-sm font-semibold text-flashcore-green hover:text-flashcore-purple transition-colors flex items-center justify-center gap-2 group",
              children: [
                /* @__PURE__ */ jsxRuntimeExports.jsx(User, { className: "w-4 h-4" }),
                "Standard Login Gateway",
                /* @__PURE__ */ jsxRuntimeExports.jsx(ArrowRight, { className: "w-3 h-3 opacity-0 group-hover:opacity-100 -translate-x-2 group-hover:translate-x-0 transition-all" })
              ]
            }
          )
        ] })
      ] })
    ] }),
    /* @__PURE__ */ jsxRuntimeExports.jsx("style", { children: `
        @keyframes pulse-glow {
          0%, 100% { 
            opacity: 1;
            transform: translateY(-50%) scaleX(1);
          }
          50% { 
            opacity: 0.5;
            transform: translateY(-50%) scaleX(1.1);
          }
        }
      ` })
  ] });
};
export {
  AdminLoginPage as default
};
//# sourceMappingURL=AdminLoginPage-167S9dlM.js.map
