import { c as createLucideIcon, b as useAuthPhp, r as reactExports, Y as useTheme, j as jsxRuntimeExports, Z as DropdownMenu, _ as DropdownMenuTrigger, B as Button, $ as DropdownMenuContent, a0 as DropdownMenuItem, a1 as Menu, a2 as Tooltip, a3 as TooltipTrigger, a4 as TooltipContent, v as cn, C as Check, a5 as useIsMobile, l as useNavigate, a6 as TooltipProvider, S as Shield, X, m as Link, a7 as ChevronRight } from "./index-Jllr8cp4.js";
import { S as Search } from "./search-Dez-rO7p.js";
import { B as Bell } from "./switch-DZljC9az.js";
import { L as LogOut } from "./log-out-DHIDgsyx.js";
import { K as Key } from "./key-B1j9dYIT.js";
import { U as Users } from "./users-CHFclgGF.js";
import { M as Mail } from "./mail-J5LXSCDJ.js";
import { C as CreditCard } from "./credit-card-Dhy07o36.js";
import { D as DollarSign } from "./dollar-sign-BfS9uGDY.js";
import { S as Settings } from "./settings-CDdGlwbq.js";
/**
 * @license lucide-react v0.462.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */
const LayoutDashboard = createLucideIcon("LayoutDashboard", [
  ["rect", { width: "7", height: "9", x: "3", y: "3", rx: "1", key: "10lvy0" }],
  ["rect", { width: "7", height: "5", x: "14", y: "3", rx: "1", key: "16une8" }],
  ["rect", { width: "7", height: "9", x: "14", y: "12", rx: "1", key: "1hutg5" }],
  ["rect", { width: "7", height: "5", x: "3", y: "16", rx: "1", key: "ldoo1y" }]
]);
/**
 * @license lucide-react v0.462.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */
const Monitor = createLucideIcon("Monitor", [
  ["rect", { width: "20", height: "14", x: "2", y: "3", rx: "2", key: "48i651" }],
  ["line", { x1: "8", x2: "16", y1: "21", y2: "21", key: "1svkeh" }],
  ["line", { x1: "12", x2: "12", y1: "17", y2: "21", key: "vw1qmm" }]
]);
/**
 * @license lucide-react v0.462.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */
const Moon = createLucideIcon("Moon", [
  ["path", { d: "M12 3a6 6 0 0 0 9 9 9 9 0 1 1-9-9Z", key: "a7tn18" }]
]);
/**
 * @license lucide-react v0.462.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */
const Package = createLucideIcon("Package", [
  [
    "path",
    {
      d: "M11 21.73a2 2 0 0 0 2 0l7-4A2 2 0 0 0 21 16V8a2 2 0 0 0-1-1.73l-7-4a2 2 0 0 0-2 0l-7 4A2 2 0 0 0 3 8v8a2 2 0 0 0 1 1.73z",
      key: "1a0edw"
    }
  ],
  ["path", { d: "M12 22V12", key: "d0xqtd" }],
  ["path", { d: "m3.3 7 7.703 4.734a2 2 0 0 0 1.994 0L20.7 7", key: "yx3hmr" }],
  ["path", { d: "m7.5 4.27 9 5.15", key: "1c824w" }]
]);
/**
 * @license lucide-react v0.462.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */
const Sun = createLucideIcon("Sun", [
  ["circle", { cx: "12", cy: "12", r: "4", key: "4exip2" }],
  ["path", { d: "M12 2v2", key: "tus03m" }],
  ["path", { d: "M12 20v2", key: "1lh1kg" }],
  ["path", { d: "m4.93 4.93 1.41 1.41", key: "149t6j" }],
  ["path", { d: "m17.66 17.66 1.41 1.41", key: "ptbguv" }],
  ["path", { d: "M2 12h2", key: "1t8f8n" }],
  ["path", { d: "M20 12h2", key: "1q8mjw" }],
  ["path", { d: "m6.34 17.66-1.41 1.41", key: "1m8zz5" }],
  ["path", { d: "m19.07 4.93-1.41 1.41", key: "1shlcs" }]
]);
function useNotifications() {
  const { user } = useAuthPhp();
  const [notifications, setNotifications] = reactExports.useState([]);
  const [unreadCount, setUnreadCount] = reactExports.useState(0);
  const [loading, setLoading] = reactExports.useState(false);
  const fetchNotifications = async () => {
    if (!user) return;
    try {
      setLoading(true);
      const response = await fetch("http://localhost:8080/api/notifications.php?action=list", {
        headers: {
          "Authorization": `Bearer ${localStorage.getItem("auth_token")}`
        }
      });
      const data = await response.json();
      if (data.notifications) {
        setNotifications(data.notifications);
        setUnreadCount(data.unread_count);
      }
    } catch (error) {
      console.error("Failed to fetch notifications", error);
    } finally {
      setLoading(false);
    }
  };
  const markAsRead = async (id) => {
    try {
      await fetch("http://localhost:8080/api/notifications.php", {
        method: "POST",
        headers: {
          "Content-Type": "application/json",
          "Authorization": `Bearer ${localStorage.getItem("auth_token")}`
        },
        body: JSON.stringify({ action: "mark_read", id })
      });
      if (id) {
        setNotifications((prev) => prev.map((n) => n.id === id ? { ...n, is_read: 1 } : n));
        setUnreadCount((prev) => Math.max(0, prev - 1));
      } else {
        setNotifications((prev) => prev.map((n) => ({ ...n, is_read: 1 })));
        setUnreadCount(0);
      }
    } catch (error) {
      console.error("Failed to mark notifications read", error);
    }
  };
  const createNotification = async (type, message) => {
    try {
      await fetch("http://localhost:8080/api/notifications.php", {
        method: "POST",
        headers: {
          "Content-Type": "application/json",
          "Authorization": `Bearer ${localStorage.getItem("auth_token")}`
        },
        body: JSON.stringify({ action: "create", type, message })
      });
      fetchNotifications();
    } catch (error) {
      console.error("Failed to create notification", error);
    }
  };
  reactExports.useEffect(() => {
    fetchNotifications();
    const interval = setInterval(fetchNotifications, 3e4);
    return () => clearInterval(interval);
  }, [user]);
  return { notifications, unreadCount, loading, markAsRead, refresh: fetchNotifications, createNotification };
}
const ThemeToggle = () => {
  const { theme, setTheme } = useTheme();
  return /* @__PURE__ */ jsxRuntimeExports.jsxs(DropdownMenu, { children: [
    /* @__PURE__ */ jsxRuntimeExports.jsx(DropdownMenuTrigger, { asChild: true, children: /* @__PURE__ */ jsxRuntimeExports.jsxs(Button, { variant: "ghost", size: "icon", className: "h-9 w-9", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsx(Sun, { className: "h-4 w-4 rotate-0 scale-100 transition-all dark:-rotate-90 dark:scale-0" }),
      /* @__PURE__ */ jsxRuntimeExports.jsx(Moon, { className: "absolute h-4 w-4 rotate-90 scale-0 transition-all dark:rotate-0 dark:scale-100" }),
      /* @__PURE__ */ jsxRuntimeExports.jsx("span", { className: "sr-only", children: "Toggle theme" })
    ] }) }),
    /* @__PURE__ */ jsxRuntimeExports.jsxs(DropdownMenuContent, { align: "end", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsxs(DropdownMenuItem, { onClick: () => setTheme("light"), children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx(Sun, { className: "mr-2 h-4 w-4" }),
        /* @__PURE__ */ jsxRuntimeExports.jsx("span", { children: "Light" })
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsxs(DropdownMenuItem, { onClick: () => setTheme("dark"), children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx(Moon, { className: "mr-2 h-4 w-4" }),
        /* @__PURE__ */ jsxRuntimeExports.jsx("span", { children: "Dark" })
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsxs(DropdownMenuItem, { onClick: () => setTheme("system"), children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx(Monitor, { className: "mr-2 h-4 w-4" }),
        /* @__PURE__ */ jsxRuntimeExports.jsx("span", { children: "System" })
      ] })
    ] })
  ] });
};
const AdminHeader = ({ toggleSidebar }) => {
  var _a;
  const { user } = useAuthPhp();
  const { notifications, unreadCount, markAsRead, loading } = useNotifications();
  const [isNotificationsOpen, setIsNotificationsOpen] = reactExports.useState(false);
  return /* @__PURE__ */ jsxRuntimeExports.jsx("header", { className: "glass-card shadow-sm z-20 sticky top-0 border-b border-border/50", children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center justify-between p-4", children: [
    /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center gap-4", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsx(
        Button,
        {
          variant: "ghost",
          size: "icon",
          className: "md:hidden hover:bg-accent/50",
          onClick: toggleSidebar,
          children: /* @__PURE__ */ jsxRuntimeExports.jsx(Menu, { className: "h-6 w-6" })
        }
      ),
      /* @__PURE__ */ jsxRuntimeExports.jsx(
        Button,
        {
          variant: "ghost",
          size: "icon",
          className: "hidden md:flex hover:bg-accent/50",
          onClick: toggleSidebar,
          children: /* @__PURE__ */ jsxRuntimeExports.jsx(Menu, { className: "h-5 w-5" })
        }
      )
    ] }),
    /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "flex-1 max-w-md mx-4 hidden md:block", children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "relative group", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsx(Search, { className: "absolute left-3 top-1/2 transform -translate-y-1/2 text-muted-foreground h-4 w-4 group-focus-within:text-blue-500 transition-colors" }),
      /* @__PURE__ */ jsxRuntimeExports.jsx(
        "input",
        {
          type: "text",
          placeholder: "Search dashboard...",
          className: "w-full pl-10 pr-4 py-2.5 bg-accent/50 dark:bg-accent/30 rounded-xl focus:outline-none focus:ring-2 focus:ring-blue-500/50 text-sm transition-all shadow-inner focus:shadow-md border border-border/50"
        }
      )
    ] }) }),
    /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center space-x-2", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsx(ThemeToggle, {}),
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "relative", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsxs(Tooltip, { children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx(TooltipTrigger, { asChild: true, children: /* @__PURE__ */ jsxRuntimeExports.jsxs(
            Button,
            {
              variant: "ghost",
              size: "icon",
              className: "relative hover:bg-accent/50 transition-all hover:scale-110",
              onClick: () => setIsNotificationsOpen(!isNotificationsOpen),
              children: [
                /* @__PURE__ */ jsxRuntimeExports.jsx(Bell, { className: "h-5 w-5" }),
                unreadCount > 0 && /* @__PURE__ */ jsxRuntimeExports.jsxs("span", { className: "absolute top-1 right-1 flex h-2 w-2", children: [
                  /* @__PURE__ */ jsxRuntimeExports.jsx("span", { className: "animate-ping absolute inline-flex h-full w-full rounded-full bg-red-400 opacity-75" }),
                  /* @__PURE__ */ jsxRuntimeExports.jsx("span", { className: "relative inline-flex rounded-full h-2 w-2 bg-red-500" })
                ] })
              ]
            }
          ) }),
          /* @__PURE__ */ jsxRuntimeExports.jsxs(TooltipContent, { children: [
            "Notifications ",
            unreadCount > 0 && `(${unreadCount})`
          ] })
        ] }),
        isNotificationsOpen && /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "absolute right-0 mt-2 w-80 bg-background border border-border shadow-lg rounded-xl overflow-hidden z-50 animate-in fade-in zoom-in-95 duration-200", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "p-3 border-b border-border flex justify-between items-center bg-muted/50", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx("h3", { className: "font-semibold text-sm", children: "Notifications" }),
            unreadCount > 0 && /* @__PURE__ */ jsxRuntimeExports.jsx(Button, { variant: "ghost", size: "xs", onClick: () => markAsRead(), className: "text-xs h-6 px-2", children: "Mark all read" })
          ] }),
          /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "max-h-[300px] overflow-y-auto", children: loading ? /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "p-4 text-center text-sm text-muted-foreground", children: "Loading..." }) : notifications.length === 0 ? /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "p-4 text-center text-sm text-muted-foreground", children: "No notifications" }) : /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "divide-y divide-border/50", children: notifications.map((notif) => /* @__PURE__ */ jsxRuntimeExports.jsxs(
            "div",
            {
              className: cn(
                "p-3 hover:bg-accent/30 transition-colors flex gap-3 text-left",
                !notif.is_read && "bg-blue-500/5 dark:bg-blue-500/10"
              ),
              children: [
                /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: cn(
                  "mt-1 h-2 w-2 rounded-full flex-shrink-0",
                  notif.type === "error" ? "bg-red-500" : notif.type === "success" ? "bg-green-500" : notif.type === "warning" ? "bg-yellow-500" : "bg-blue-500"
                ) }),
                /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex-1 min-w-0", children: [
                  /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: cn("text-sm", !notif.is_read && "font-medium"), children: notif.message }),
                  /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-xs text-muted-foreground mt-1", children: new Date(notif.created_at).toLocaleDateString() })
                ] }),
                !notif.is_read && /* @__PURE__ */ jsxRuntimeExports.jsx(
                  Button,
                  {
                    variant: "ghost",
                    size: "icon",
                    className: "h-6 w-6 opacity-0 group-hover:opacity-100 transition-opacity",
                    onClick: (e) => {
                      e.stopPropagation();
                      markAsRead(notif.id);
                    },
                    children: /* @__PURE__ */ jsxRuntimeExports.jsx(Check, { className: "h-3 w-3" })
                  }
                )
              ]
            },
            notif.id
          )) }) })
        ] })
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "hidden md:flex items-center space-x-3 ml-2 pl-2 border-l border-border/50", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "relative", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "absolute inset-0 bg-gradient-to-br from-blue-500 to-purple-600 rounded-full blur-sm opacity-30" }),
          /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "relative bg-gradient-to-br from-blue-500 to-purple-600 rounded-full w-9 h-9 flex items-center justify-center shadow-md", children: /* @__PURE__ */ jsxRuntimeExports.jsx("span", { className: "text-xs font-bold text-white", children: ((_a = user == null ? void 0 : user.email) == null ? void 0 : _a.charAt(0).toUpperCase()) || "A" }) })
        ] }),
        /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "hidden lg:block", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-sm font-semibold text-foreground", children: "Admin" }),
          /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-xs text-muted-foreground truncate max-w-[150px]", children: user == null ? void 0 : user.email })
        ] })
      ] })
    ] })
  ] }) });
};
const AdminLayout = ({ children }) => {
  var _a;
  const isMobile = useIsMobile();
  const [isSidebarOpen, setIsSidebarOpen] = reactExports.useState(!isMobile);
  const { user, logout } = useAuthPhp();
  const navigate = useNavigate();
  reactExports.useEffect(() => {
    setIsSidebarOpen(!isMobile);
  }, [isMobile]);
  const toggleSidebar = () => {
    setIsSidebarOpen(!isSidebarOpen);
  };
  const handleLogout = async () => {
    await logout();
    navigate("/admin-login");
  };
  const sidebarItems = [
    { icon: LayoutDashboard, label: "Dashboard", path: "/admin", group: "Main" },
    { icon: Key, label: "Licenses", path: "/admin?tab=licenses", group: "Management" },
    { icon: Users, label: "Users", path: "/admin?tab=users", group: "Management" },
    { icon: Mail, label: "Subscribers", path: "/admin?tab=subscribers", group: "Management" },
    { icon: Package, label: "Orders", path: "/admin?tab=orders", group: "Management" },
    { icon: CreditCard, label: "Wallet Manager", path: "/admin?tab=wallet", group: "Management" },
    { icon: DollarSign, label: "Pricing Plans", path: "/admin/pricing", group: "Management" },
    // Added Pricing Plans
    { icon: Mail, label: "Email Templates", path: "/admin?tab=templates", group: "Settings" },
    { icon: Settings, label: "SMTP Settings", path: "/admin?tab=settings", group: "Settings" }
  ];
  const groupedItems = sidebarItems.reduce((acc, item) => {
    if (!acc[item.group]) acc[item.group] = [];
    acc[item.group].push(item);
    return acc;
  }, {});
  return /* @__PURE__ */ jsxRuntimeExports.jsx(TooltipProvider, { delayDuration: 0, children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex h-screen bg-gradient-to-br from-gray-50 via-gray-50 to-blue-50/30 dark:from-gray-950 dark:via-gray-900 dark:to-blue-950/20 transition-colors duration-300", children: [
    /* @__PURE__ */ jsxRuntimeExports.jsx(
      "aside",
      {
        className: cn(
          "glass-card fixed md:relative h-full border-r border-border/50 transform transition-all duration-300 ease-in-out z-30",
          isSidebarOpen ? "translate-x-0 w-64" : "-translate-x-full md:translate-x-0 md:w-20"
        ),
        children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex flex-col h-full", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center justify-between p-4 border-b border-border/50", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center space-x-3", children: [
              /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "relative", children: [
                /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "absolute inset-0 bg-gradient-to-br from-blue-500 via-indigo-500 to-purple-600 rounded-xl blur-md opacity-50 animate-pulse-glow" }),
                /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "relative bg-gradient-to-br from-blue-600 via-indigo-600 to-purple-700 p-2.5 rounded-xl shadow-lg", children: /* @__PURE__ */ jsxRuntimeExports.jsx(Shield, { className: "h-6 w-6 text-white" }) })
              ] }),
              isSidebarOpen && /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "animate-in fade-in slide-in-from-left-2 duration-300", children: [
                /* @__PURE__ */ jsxRuntimeExports.jsx("h1", { className: "text-xl font-bold bg-gradient-to-r from-blue-600 via-indigo-600 to-purple-600 dark:from-blue-400 dark:via-indigo-400 dark:to-purple-400 bg-clip-text text-transparent", children: "Admin Panel" }),
                /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-xs text-muted-foreground", children: "Enterprise Dashboard" })
              ] })
            ] }),
            /* @__PURE__ */ jsxRuntimeExports.jsx(
              Button,
              {
                variant: "ghost",
                size: "icon",
                className: "md:hidden hover:bg-accent/50",
                onClick: toggleSidebar,
                children: /* @__PURE__ */ jsxRuntimeExports.jsx(X, { className: "h-5 w-5" })
              }
            )
          ] }),
          /* @__PURE__ */ jsxRuntimeExports.jsx("nav", { className: "flex-1 overflow-y-auto py-4 px-2 space-y-6", children: Object.entries(groupedItems).map(([group, items]) => /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { children: [
            isSidebarOpen && /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "px-3 mb-2", children: /* @__PURE__ */ jsxRuntimeExports.jsx("span", { className: "text-xs font-semibold text-muted-foreground uppercase tracking-wider", children: group }) }),
            /* @__PURE__ */ jsxRuntimeExports.jsx("ul", { className: "space-y-1", children: items.map((item, index) => {
              const Icon = item.icon;
              const isActive = location.pathname === item.path.split("?")[0] && (!item.path.includes("?") || location.search === item.path.split("?")[1]);
              const NavItem = /* @__PURE__ */ jsxRuntimeExports.jsx(Link, { to: item.path, children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: cn(
                "flex items-center gap-3 p-3 rounded-xl transition-all duration-200 group relative",
                "hover:bg-gradient-to-r hover:from-blue-500/10 hover:to-purple-500/10",
                "hover:scale-[1.02] hover:shadow-md",
                isActive ? "bg-gradient-to-r from-blue-500/20 to-purple-500/20 shadow-lg shadow-blue-500/10 dark:shadow-blue-500/5" : "hover:bg-accent/50"
              ), children: [
                isActive && /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "absolute left-0 top-1/2 -translate-y-1/2 w-1 h-8 bg-gradient-to-b from-blue-500 to-purple-600 rounded-r-full" }),
                /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: cn(
                  "p-2 rounded-lg transition-all duration-200",
                  isActive ? "bg-gradient-to-br from-blue-500 to-purple-600 text-white shadow-lg" : "bg-accent/50 text-muted-foreground group-hover:bg-gradient-to-br group-hover:from-blue-500 group-hover:to-purple-600 group-hover:text-white"
                ), children: /* @__PURE__ */ jsxRuntimeExports.jsx(Icon, { className: "h-5 w-5 flex-shrink-0" }) }),
                isSidebarOpen && /* @__PURE__ */ jsxRuntimeExports.jsx("span", { className: cn(
                  "font-medium text-sm transition-colors",
                  isActive ? "text-foreground" : "text-muted-foreground group-hover:text-foreground"
                ), children: item.label }),
                isSidebarOpen && /* @__PURE__ */ jsxRuntimeExports.jsx(ChevronRight, { className: cn(
                  "h-4 w-4 ml-auto transition-all opacity-0 group-hover:opacity-100 group-hover:translate-x-1",
                  isActive && "opacity-100"
                ) })
              ] }) });
              return /* @__PURE__ */ jsxRuntimeExports.jsx("li", { children: !isSidebarOpen ? /* @__PURE__ */ jsxRuntimeExports.jsxs(Tooltip, { children: [
                /* @__PURE__ */ jsxRuntimeExports.jsx(TooltipTrigger, { asChild: true, children: NavItem }),
                /* @__PURE__ */ jsxRuntimeExports.jsx(TooltipContent, { side: "right", className: "font-medium", children: item.label })
              ] }) : NavItem }, index);
            }) })
          ] }, group)) }),
          /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "p-4 border-t border-border/50 bg-accent/20", children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center justify-between", children: [
            isSidebarOpen && /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center space-x-3 min-w-0 flex-1", children: [
              /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "relative", children: [
                /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "absolute inset-0 bg-gradient-to-br from-blue-500 to-purple-600 rounded-full blur-sm opacity-50" }),
                /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "relative bg-gradient-to-br from-blue-500 to-purple-600 rounded-full w-10 h-10 flex items-center justify-center shadow-lg", children: /* @__PURE__ */ jsxRuntimeExports.jsx("span", { className: "text-sm font-bold text-white", children: ((_a = user == null ? void 0 : user.email) == null ? void 0 : _a.charAt(0).toUpperCase()) || "A" }) })
              ] }),
              /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "hidden md:block min-w-0 flex-1", children: [
                /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-sm font-semibold text-foreground", children: "Admin" }),
                /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-xs text-muted-foreground truncate", children: user == null ? void 0 : user.email })
              ] })
            ] }),
            /* @__PURE__ */ jsxRuntimeExports.jsxs(Tooltip, { children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx(TooltipTrigger, { asChild: true, children: /* @__PURE__ */ jsxRuntimeExports.jsx(
                Button,
                {
                  variant: "ghost",
                  size: "icon",
                  onClick: handleLogout,
                  className: "text-muted-foreground hover:text-red-500 dark:hover:text-red-400 hover:bg-red-500/10 transition-all",
                  children: /* @__PURE__ */ jsxRuntimeExports.jsx(LogOut, { className: "h-5 w-5" })
                }
              ) }),
              /* @__PURE__ */ jsxRuntimeExports.jsx(TooltipContent, { side: isSidebarOpen ? "top" : "right", children: "Logout" })
            ] })
          ] }) })
        ] })
      }
    ),
    /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex-1 flex flex-col overflow-hidden relative", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsx(AdminHeader, { toggleSidebar }),
      /* @__PURE__ */ jsxRuntimeExports.jsx("main", { className: "flex-1 overflow-y-auto p-4 md:p-6 scroll-smooth", children: /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "max-w-7xl mx-auto animate-in fade-in slide-in-from-bottom-4 duration-500", children }) })
    ] })
  ] }) });
};
export {
  AdminLayout as A,
  Package as P
};
//# sourceMappingURL=AdminLayout-Nvzb_sDg.js.map
