import { j as jsxRuntimeExports, S as Shield, T as TrendingUp, a3 as Globe, d as Card, g as CardHeader, h as CardTitle, e as CardContent, i as CardDescription, m as Link, B as Button, A as ArrowRight, a5 as Lightbulb } from "./index-1cza7qiv.js";
import { B as Badge } from "./badge-C3TB_ojI.js";
import { U as Users } from "./users-ry-FvBVN.js";
import { Z as Zap } from "./zap-DJzuSPNM.js";
import { A as Award } from "./award-DNa-YQw4.js";
import { S as Star } from "./star-CGWIDMe6.js";
import { T as Target } from "./target-CXwQgime.js";
import { H as Heart } from "./heart-DF6_885F.js";
const AboutPage = () => {
  const team = [
    {
      name: "Sarah Johnson",
      role: "CEO & Founder",
      bio: "Former VP of Product at TechCorp with 15+ years in SaaS",
      avatar: "S",
      color: "from-flashcore-purple to-flashcore-green"
    },
    {
      name: "Mike Chen",
      role: "CTO",
      bio: "Ex-Google engineer with expertise in scalable systems",
      avatar: "M",
      color: "from-flashcore-green to-flashcore-purple"
    },
    {
      name: "Emily Rodriguez",
      role: "Head of Product",
      bio: "Product leader with experience at Stripe and Shopify",
      avatar: "E",
      color: "from-flashcore-orange to-flashcore-purple"
    },
    {
      name: "David Kim",
      role: "Head of Engineering",
      bio: "Full-stack expert with 10+ years building web applications",
      avatar: "D",
      color: "from-blue-500 to-purple-500"
    }
  ];
  const values = [
    {
      icon: Heart,
      title: "Customer First",
      description: "Every decision we make starts with our customers' needs and success."
    },
    {
      icon: Lightbulb,
      title: "Innovation",
      description: "We constantly push boundaries to deliver cutting-edge solutions."
    },
    {
      icon: Shield,
      title: "Security",
      description: "Enterprise-grade security is built into everything we do."
    },
    {
      icon: Users,
      title: "Collaboration",
      description: "We believe the best solutions come from working together."
    }
  ];
  const milestones = [
    {
      year: "2020",
      title: "Founded",
      description: "FlashCore was born from a vision to simplify business communications."
    },
    {
      year: "2021",
      title: "First 1,000 Users",
      description: "Reached our first major milestone with 1,000 active users."
    },
    {
      year: "2022",
      title: "Series A Funding",
      description: "Raised $10M to scale our platform and team."
    },
    {
      year: "2023",
      title: "10,000+ Users",
      description: "Helped over 10,000 businesses automate their communications."
    },
    {
      year: "2024",
      title: "Global Expansion",
      description: "Expanded to serve customers in 50+ countries worldwide."
    }
  ];
  return /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex flex-col", children: [
    /* @__PURE__ */ jsxRuntimeExports.jsx("section", { className: "container mx-auto px-4 py-12 md:py-20 text-center", children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "max-w-4xl mx-auto", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsxs(Badge, { variant: "secondary", className: "mb-4", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx(Users, { className: "w-3 h-3 mr-1" }),
        "Our Story"
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsx("h1", { className: "text-3xl md:text-4xl lg:text-5xl font-bold mb-6 bg-gradient-to-r from-flashcore-purple to-flashcore-green bg-clip-text text-transparent", children: "About FlashCore" }),
      /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-lg md:text-xl text-muted-foreground mb-8 max-w-3xl mx-auto", children: "We're on a mission to revolutionize how businesses communicate. FlashCore was built by a team passionate about automation, efficiency, and helping companies grow." })
    ] }) }),
    /* @__PURE__ */ jsxRuntimeExports.jsx("section", { className: "container mx-auto px-4 py-12 md:py-20", children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "grid grid-cols-1 lg:grid-cols-2 gap-8 md:gap-12 items-center", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx("h2", { className: "text-2xl md:text-3xl font-bold mb-4 md:mb-6", children: "Our Mission" }),
        /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-base md:text-lg text-muted-foreground mb-4 md:mb-6", children: "To empower businesses of all sizes with professional, automated communication tools that drive growth and efficiency." }),
        /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-muted-foreground mb-6 md:mb-8", children: "We believe that every business deserves access to enterprise-grade email automation and communication tools. That's why we've built FlashCore to be powerful yet simple, scalable yet affordable." }),
        /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "grid grid-cols-2 gap-4 md:gap-6", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "text-center", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "text-2xl md:text-3xl font-bold text-flashcore-purple mb-2", children: "10K+" }),
            /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "text-xs md:text-sm text-muted-foreground", children: "Happy Customers" })
          ] }),
          /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "text-center", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "text-2xl md:text-3xl font-bold text-flashcore-green mb-2", children: "1M+" }),
            /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "text-xs md:text-sm text-muted-foreground", children: "Emails Sent" })
          ] })
        ] })
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "relative", children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "bg-gradient-to-r from-flashcore-purple to-flashcore-green rounded-2xl p-6 md:p-8 text-white", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx("h3", { className: "text-xl md:text-2xl font-bold mb-4", children: "Why FlashCore?" }),
        /* @__PURE__ */ jsxRuntimeExports.jsxs("ul", { className: "space-y-3", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsxs("li", { className: "flex items-center", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx(Zap, { className: "w-4 h-4 md:w-5 md:h-5 mr-3" }),
            /* @__PURE__ */ jsxRuntimeExports.jsx("span", { className: "text-sm md:text-base", children: "Built for modern businesses" })
          ] }),
          /* @__PURE__ */ jsxRuntimeExports.jsxs("li", { className: "flex items-center", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx(Shield, { className: "w-4 h-4 md:w-5 md:h-5 mr-3" }),
            /* @__PURE__ */ jsxRuntimeExports.jsx("span", { className: "text-sm md:text-base", children: "Enterprise-grade security" })
          ] }),
          /* @__PURE__ */ jsxRuntimeExports.jsxs("li", { className: "flex items-center", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx(TrendingUp, { className: "w-4 h-4 md:w-5 md:h-5 mr-3" }),
            /* @__PURE__ */ jsxRuntimeExports.jsx("span", { className: "text-sm md:text-base", children: "Proven to increase revenue" })
          ] }),
          /* @__PURE__ */ jsxRuntimeExports.jsxs("li", { className: "flex items-center", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx(Globe, { className: "w-4 h-4 md:w-5 md:h-5 mr-3" }),
            /* @__PURE__ */ jsxRuntimeExports.jsx("span", { className: "text-sm md:text-base", children: "Global reach and support" })
          ] })
        ] })
      ] }) })
    ] }) }),
    /* @__PURE__ */ jsxRuntimeExports.jsxs("section", { className: "container mx-auto px-4 py-12 md:py-20 bg-muted/20", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "text-center mb-12 md:mb-16", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx("h2", { className: "text-2xl md:text-3xl font-bold mb-4", children: "Our Values" }),
        /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-muted-foreground max-w-2xl mx-auto", children: "These core values guide everything we do and every decision we make." })
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 md:gap-8", children: values.map((value, index) => /* @__PURE__ */ jsxRuntimeExports.jsxs(Card, { className: "text-center hover:shadow-lg transition-shadow", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsxs(CardHeader, { children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "w-10 h-10 md:w-12 md:h-12 bg-gradient-to-r from-flashcore-purple to-flashcore-green rounded-lg flex items-center justify-center mx-auto mb-4", children: /* @__PURE__ */ jsxRuntimeExports.jsx(value.icon, { className: "w-5 h-5 md:w-6 md:h-6 text-white" }) }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(CardTitle, { className: "text-base md:text-lg", children: value.title })
        ] }),
        /* @__PURE__ */ jsxRuntimeExports.jsx(CardContent, { children: /* @__PURE__ */ jsxRuntimeExports.jsx(CardDescription, { className: "text-sm md:text-base", children: value.description }) })
      ] }, index)) })
    ] }),
    /* @__PURE__ */ jsxRuntimeExports.jsxs("section", { className: "container mx-auto px-4 py-12 md:py-20", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "text-center mb-12 md:mb-16", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx("h2", { className: "text-2xl md:text-3xl font-bold mb-4", children: "Meet Our Team" }),
        /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-muted-foreground max-w-2xl mx-auto", children: "The passionate people behind FlashCore who are dedicated to your success." })
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 md:gap-8", children: team.map((member, index) => /* @__PURE__ */ jsxRuntimeExports.jsxs(Card, { className: "text-center hover:shadow-lg transition-shadow", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsxs(CardHeader, { children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: `w-12 h-12 md:w-16 md:h-16 bg-gradient-to-r ${member.color} rounded-full flex items-center justify-center mx-auto mb-4`, children: /* @__PURE__ */ jsxRuntimeExports.jsx("span", { className: "text-white font-bold text-lg md:text-xl", children: member.avatar }) }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(CardTitle, { className: "text-base md:text-lg", children: member.name }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(CardDescription, { className: "font-semibold text-flashcore-purple text-sm md:text-base", children: member.role })
        ] }),
        /* @__PURE__ */ jsxRuntimeExports.jsx(CardContent, { children: /* @__PURE__ */ jsxRuntimeExports.jsx(CardDescription, { className: "text-sm md:text-base", children: member.bio }) })
      ] }, index)) })
    ] }),
    /* @__PURE__ */ jsxRuntimeExports.jsxs("section", { className: "container mx-auto px-4 py-12 md:py-20 bg-muted/20", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "text-center mb-12 md:mb-16", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx("h2", { className: "text-2xl md:text-3xl font-bold mb-4", children: "Our Journey" }),
        /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-muted-foreground max-w-2xl mx-auto", children: "From startup to industry leader - here's how we got here." })
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "max-w-4xl mx-auto", children: /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "space-y-6 md:space-y-8", children: milestones.map((milestone, index) => /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-start space-x-4 md:space-x-6", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "w-12 h-12 md:w-16 md:h-16 bg-gradient-to-r from-flashcore-purple to-flashcore-green rounded-full flex items-center justify-center flex-shrink-0", children: /* @__PURE__ */ jsxRuntimeExports.jsx("span", { className: "text-white font-bold text-sm md:text-base", children: milestone.year }) }),
        /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex-1", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx("h3", { className: "text-lg md:text-xl font-semibold mb-2", children: milestone.title }),
          /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-sm md:text-base text-muted-foreground", children: milestone.description })
        ] })
      ] }, index)) }) })
    ] }),
    /* @__PURE__ */ jsxRuntimeExports.jsxs("section", { className: "container mx-auto px-4 py-12 md:py-20", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "text-center mb-12 md:mb-16", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx("h2", { className: "text-2xl md:text-3xl font-bold mb-4", children: "Recognition & Awards" }),
        /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-muted-foreground max-w-2xl mx-auto", children: "Our commitment to excellence has been recognized by industry leaders." })
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "grid grid-cols-1 md:grid-cols-3 gap-6 md:gap-8", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsxs(Card, { className: "text-center p-4 md:p-6", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "w-10 h-10 md:w-12 md:h-12 bg-gradient-to-r from-yellow-400 to-orange-500 rounded-lg flex items-center justify-center mx-auto mb-4", children: /* @__PURE__ */ jsxRuntimeExports.jsx(Award, { className: "w-5 h-5 md:w-6 md:h-6 text-white" }) }),
          /* @__PURE__ */ jsxRuntimeExports.jsx("h3", { className: "text-base md:text-lg font-semibold mb-2", children: "Best Email Platform 2024" }),
          /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-xs md:text-sm text-muted-foreground", children: "TechCrunch Startup Awards" })
        ] }),
        /* @__PURE__ */ jsxRuntimeExports.jsxs(Card, { className: "text-center p-4 md:p-6", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "w-10 h-10 md:w-12 md:h-12 bg-gradient-to-r from-blue-500 to-purple-500 rounded-lg flex items-center justify-center mx-auto mb-4", children: /* @__PURE__ */ jsxRuntimeExports.jsx(Star, { className: "w-5 h-5 md:w-6 md:h-6 text-white" }) }),
          /* @__PURE__ */ jsxRuntimeExports.jsx("h3", { className: "text-base md:text-lg font-semibold mb-2", children: "Customer Choice Award" }),
          /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-xs md:text-sm text-muted-foreground", children: "G2 Crowd 2024" })
        ] }),
        /* @__PURE__ */ jsxRuntimeExports.jsxs(Card, { className: "text-center p-4 md:p-6", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "w-10 h-10 md:w-12 md:h-12 bg-gradient-to-r from-green-500 to-blue-500 rounded-lg flex items-center justify-center mx-auto mb-4", children: /* @__PURE__ */ jsxRuntimeExports.jsx(Target, { className: "w-5 h-5 md:w-6 md:h-6 text-white" }) }),
          /* @__PURE__ */ jsxRuntimeExports.jsx("h3", { className: "text-base md:text-lg font-semibold mb-2", children: "Fastest Growing SaaS" }),
          /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-xs md:text-sm text-muted-foreground", children: "Inc. 5000 2024" })
        ] })
      ] })
    ] }),
    /* @__PURE__ */ jsxRuntimeExports.jsx("section", { className: "container mx-auto px-4 py-12 md:py-20", children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "bg-gradient-to-r from-flashcore-purple to-flashcore-green rounded-2xl p-6 md:p-8 lg:p-12 text-center text-white", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsx("h2", { className: "text-2xl md:text-3xl font-bold mb-4", children: "Join Our Mission" }),
      /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-lg md:text-xl mb-6 md:mb-8 opacity-90", children: "Be part of the revolution in business communications. Start your journey with FlashCore today." }),
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex flex-col sm:flex-row gap-4 justify-center", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx(Link, { to: "/register", children: /* @__PURE__ */ jsxRuntimeExports.jsxs(Button, { size: "lg", variant: "secondary", className: "bg-white text-flashcore-purple hover:bg-gray-100", children: [
          "Start Free Trial",
          /* @__PURE__ */ jsxRuntimeExports.jsx(ArrowRight, { className: "w-4 h-4 ml-2" })
        ] }) }),
        /* @__PURE__ */ jsxRuntimeExports.jsx(Link, { to: "/contact", children: /* @__PURE__ */ jsxRuntimeExports.jsx(Button, { size: "lg", variant: "outline", className: "border-white text-white hover:bg-white hover:text-flashcore-purple", children: "Get In Touch" }) })
      ] })
    ] }) })
  ] });
};
export {
  AboutPage as default
};
//# sourceMappingURL=AboutPage-jSNuJG0D.js.map
