<?php
/**
 * .env.detection.php
 * Auto-environment detection system.
 * This file is intended to be loaded via auto_prepend_file in php.ini.
 */

// 1. Detection Logic
function detectEnvironment() {
    // Check for hardcoded env override
    if (getenv('APP_ENV')) {
        return getenv('APP_ENV');
    }

    $host = isset($_SERVER['HTTP_HOST']) ? $_SERVER['HTTP_HOST'] : '';
    $isLocal = ($host === 'localhost' || $host === '127.0.0.1' || strpos($host, '192.168.') === 0 || strpos($host, '.local') !== false);

    if ($isLocal) {
        return 'development';
    }

    return 'production';
}

$detectedEnv = detectEnvironment();
if (!getenv('APP_ENV')) {
    putenv("APP_ENV=$detectedEnv");
    $_ENV['APP_ENV'] = $detectedEnv;
    $_SERVER['APP_ENV'] = $detectedEnv;
}

// 2. Load Environment Variables if .env exists
$envFile = __DIR__ . '/.env';
if (file_exists($envFile)) {
    // Simple loader to avoid dependencies
    $lines = file($envFile, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
    foreach ($lines as $line) {
        if (strpos(trim($line), '#') === 0) continue;
        $parts = explode('=', $line, 2);
        if (count($parts) === 2) {
            $key = trim($parts[0]);
            $val = trim($parts[1]);
            // Only set if not already set by system env
            if (!getenv($key)) {
                putenv("$key=$val");
                $_ENV[$key] = $val;
                $_SERVER[$key] = $val;
            }
        }
    }
}

// 3. Load CORS Middleware
require_once __DIR__ . '/auto-cors-middleware.php';
